/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.validation;

import org.jreleaser.model.Gitea;
import org.jreleaser.model.JReleaserContext;
import org.jreleaser.model.validation.GitServiceValidator;
import org.jreleaser.util.Errors;
import org.jreleaser.util.StringUtils;

public abstract class GiteaValidator
extends GitServiceValidator {
    public static boolean validateGitea(JReleaserContext context, JReleaserContext.Mode mode, Gitea gitea, Errors errors) {
        if (null == gitea) {
            return false;
        }
        context.getLogger().debug("release.gitea");
        GiteaValidator.validateGitService(context, mode, gitea, errors);
        if (StringUtils.isBlank((String)gitea.getApiEndpoint())) {
            errors.configuration("gitea.apiEndpoint must not be blank");
        }
        if (context.getModel().getProject().isSnapshot()) {
            gitea.getPrerelease().setEnabled(true);
        }
        gitea.getPrerelease().setPattern(GiteaValidator.checkProperty(context, "PRERELEASE_PATTERN", "release.gitea.prerelease.pattern", gitea.getPrerelease().getPattern(), ""));
        gitea.getPrerelease().isPrerelease(context.getModel().getProject().getResolvedVersion());
        if (!gitea.isDraftSet()) {
            gitea.setDraft(GiteaValidator.checkProperty(context, "DRAFT", "gitea.draft", null, false));
        }
        if (gitea.isDraft()) {
            gitea.getMilestone().setClose(false);
        }
        return gitea.isEnabled();
    }
}

