/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.validation;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import org.jreleaser.model.Gitter;
import org.jreleaser.model.JReleaserContext;
import org.jreleaser.model.validation.Validator;
import org.jreleaser.util.Errors;
import org.jreleaser.util.StringUtils;

public abstract class GitterValidator
extends Validator {
    private static final String DEFAULT_GITTER_TPL = "src/jreleaser/templates/gitter.tpl";

    public static void validateGitter(JReleaserContext context, Gitter gitter, Errors errors) {
        if (!gitter.resolveEnabled(context.getModel().getProject())) {
            return;
        }
        context.getLogger().debug("announce.gitter");
        gitter.setWebhook(GitterValidator.checkProperty(context, "GITTER_WEBHOOK", "gitter.webhook", gitter.getWebhook(), errors, context.isDryrun()));
        if (StringUtils.isBlank((String)gitter.getMessage()) && StringUtils.isBlank((String)gitter.getMessageTemplate())) {
            if (Files.exists(context.getBasedir().resolve(DEFAULT_GITTER_TPL), new LinkOption[0])) {
                gitter.setMessageTemplate(DEFAULT_GITTER_TPL);
            } else {
                gitter.setMessage("\ud83d\ude80 {{projectNameCapitalized}} {{projectVersion}} has been released! {{releaseNotesUrl}}");
            }
        }
        if (StringUtils.isNotBlank((String)gitter.getMessageTemplate()) && !Files.exists(context.getBasedir().resolve(gitter.getMessageTemplate().trim()), new LinkOption[0])) {
            errors.configuration("gitter.messageTemplate does not exist. " + gitter.getMessageTemplate());
        }
        GitterValidator.validateTimeout(gitter);
    }
}

