/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.validation;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import org.jreleaser.model.GoogleChat;
import org.jreleaser.model.JReleaserContext;
import org.jreleaser.model.validation.Validator;
import org.jreleaser.util.Errors;
import org.jreleaser.util.StringUtils;

public abstract class GoogleChatValidator
extends Validator {
    private static final String DEFAULT_GOOGLE_CHAT_TPL = "src/jreleaser/templates/googleChat.tpl";

    public static void validateGoogleChat(JReleaserContext context, GoogleChat googleChat, Errors errors) {
        if (!googleChat.resolveEnabled(context.getModel().getProject())) {
            return;
        }
        context.getLogger().debug("announce.googleChat");
        googleChat.setWebhook(GoogleChatValidator.checkProperty(context, "GOOGLE_CHAT_WEBHOOK", "googleChat.webhook", googleChat.getWebhook(), errors, context.isDryrun()));
        if (StringUtils.isBlank((String)googleChat.getMessage()) && StringUtils.isBlank((String)googleChat.getMessageTemplate())) {
            if (Files.exists(context.getBasedir().resolve(DEFAULT_GOOGLE_CHAT_TPL), new LinkOption[0])) {
                googleChat.setMessageTemplate(DEFAULT_GOOGLE_CHAT_TPL);
            } else {
                googleChat.setMessage("\ud83d\ude80 {{projectNameCapitalized}} {{projectVersion}} has been released! {{releaseNotesUrl}}");
            }
        }
        if (StringUtils.isNotBlank((String)googleChat.getMessageTemplate()) && !Files.exists(context.getBasedir().resolve(googleChat.getMessageTemplate().trim()), new LinkOption[0])) {
            errors.configuration("googleChat.messageTemplate does not exist. " + googleChat.getMessageTemplate());
        }
        GoogleChatValidator.validateTimeout(googleChat);
    }
}

