/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.validation;

import java.util.Map;
import org.jreleaser.model.Active;
import org.jreleaser.model.HttpUploader;
import org.jreleaser.model.JReleaserContext;
import org.jreleaser.model.Uploader;
import org.jreleaser.model.validation.Validator;
import org.jreleaser.util.Env;
import org.jreleaser.util.Errors;
import org.jreleaser.util.StringUtils;

public abstract class HttpUploaderValidator
extends Validator {
    public static void validateHttp(JReleaserContext context, JReleaserContext.Mode mode, Errors errors) {
        context.getLogger().debug("http");
        Map<String, HttpUploader> http = context.getModel().getUpload().getHttp();
        for (Map.Entry<String, HttpUploader> e : http.entrySet()) {
            HttpUploader h = e.getValue();
            if (StringUtils.isBlank((String)h.getName())) {
                h.setName(e.getKey());
            }
            HttpUploaderValidator.validateHttpUploader(context, mode, h, errors);
        }
    }

    private static void validateHttpUploader(JReleaserContext context, JReleaserContext.Mode mode, HttpUploader http, Errors errors) {
        context.getLogger().debug("http.{}", new Object[]{http.getName()});
        if (!http.isActiveSet()) {
            http.setActive(Active.NEVER);
        }
        if (!http.resolveEnabled(context.getModel().getProject())) {
            return;
        }
        if (!(http.isArtifacts().booleanValue() || http.isFiles().booleanValue() || http.isSignatures().booleanValue())) {
            http.disable();
            return;
        }
        if (StringUtils.isBlank((String)http.getUploadUrl())) {
            errors.configuration("http." + http.getName() + ".uploadUrl must not be blank.");
        }
        if (StringUtils.isBlank((String)http.getDownloadUrl())) {
            http.setDownloadUrl(http.getUploadUrl());
        }
        if (null == http.getMethod()) {
            http.setMethod(Uploader.Method.PUT);
        }
        switch (http.resolveAuthorization()) {
            case BEARER: {
                http.setPassword(HttpUploaderValidator.checkProperty(context, "HTTP_" + Env.toVar((String)http.getName()) + "_PASSWORD", "http.password", http.getPassword(), errors, context.isDryrun()));
                break;
            }
            case BASIC: {
                http.setUsername(HttpUploaderValidator.checkProperty(context, "HTTP_" + Env.toVar((String)http.getName()) + "_USERNAME", "http.username", http.getUsername(), errors, context.isDryrun()));
                http.setPassword(HttpUploaderValidator.checkProperty(context, "HTTP_" + Env.toVar((String)http.getName()) + "_PASSWORD", "http.password", http.getPassword(), errors, context.isDryrun()));
                break;
            }
        }
        HttpUploaderValidator.validateTimeout(http);
    }
}

