/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.validation;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jreleaser.model.Distribution;
import org.jreleaser.model.GitService;
import org.jreleaser.model.JReleaserContext;
import org.jreleaser.model.JReleaserModel;
import org.jreleaser.model.Jbang;
import org.jreleaser.model.JbangCatalog;
import org.jreleaser.model.validation.ExtraPropertiesValidator;
import org.jreleaser.model.validation.TemplateValidator;
import org.jreleaser.model.validation.Validator;
import org.jreleaser.util.Errors;
import org.jreleaser.util.StringUtils;

public abstract class JbangValidator
extends Validator {
    public static void validateJbang(JReleaserContext context, Distribution distribution, Jbang tool, Errors errors) {
        JReleaserModel model = context.getModel();
        Jbang parentTool = model.getPackagers().getJbang();
        if (!tool.isActiveSet() && parentTool.isActiveSet()) {
            tool.setActive(parentTool.getActive());
        }
        if (!tool.resolveEnabled(context.getModel().getProject(), distribution)) {
            return;
        }
        GitService service = model.getRelease().getGitService();
        if (!service.isReleaseSupported()) {
            tool.disable();
            return;
        }
        context.getLogger().debug("distribution.{}.jbang", new Object[]{distribution.getName()});
        JbangValidator.validateCommitAuthor(tool, parentTool);
        JbangCatalog catalog = tool.getCatalog();
        JbangValidator.validateOwner(catalog, parentTool.getCatalog());
        if (StringUtils.isBlank((String)catalog.getBranch())) {
            catalog.setBranch(parentTool.getCatalog().getBranch());
        }
        TemplateValidator.validateTemplate(context, distribution, tool, parentTool, errors);
        ExtraPropertiesValidator.mergeExtraProperties(tool, parentTool);
        JbangValidator.validateContinueOnError(tool, parentTool);
        if (StringUtils.isBlank((String)tool.getAlias())) {
            tool.setAlias(distribution.getExecutable());
        }
        if (StringUtils.isBlank((String)catalog.getName())) {
            catalog.setName(parentTool.getCatalog().getName());
        }
        if (StringUtils.isBlank((String)catalog.getUsername())) {
            catalog.setUsername(parentTool.getCatalog().getUsername());
        }
        if (StringUtils.isBlank((String)catalog.getToken())) {
            catalog.setToken(parentTool.getCatalog().getToken());
        }
        JbangValidator.validateTap(context, distribution, catalog, "jbang.catalog");
        if (model.getProject().getExtraProperties().containsKey("reverseRepoHost") && !parentTool.getExtraProperties().containsKey("reverseRepoHost")) {
            parentTool.getExtraProperties().put("reverseRepoHost", model.getProject().getExtraProperties().get("reverseRepoHost"));
        }
        if (parentTool.getExtraProperties().containsKey("reverseRepoHost") && !distribution.getExtraProperties().containsKey("reverseRepoHost")) {
            distribution.getExtraProperties().put("reverseRepoHost", parentTool.getExtraProperties().get("reverseRepoHost"));
        }
        if (distribution.getExtraProperties().containsKey("reverseRepoHost") && !tool.getExtraProperties().containsKey("reverseRepoHost")) {
            tool.getExtraProperties().put("reverseRepoHost", distribution.getExtraProperties().get("reverseRepoHost"));
        }
        if (StringUtils.isBlank((String)service.getReverseRepoHost()) && !tool.getExtraProperties().containsKey("reverseRepoHost")) {
            errors.configuration("distribution." + distribution.getName() + ".jbang must define an extra property named '" + "reverseRepoHost" + "'");
        }
        if (StringUtils.isBlank((String)distribution.getJava().getMainClass())) {
            errors.configuration("distribution." + distribution.getName() + ".java.mainClass must not be blank, required by jbang");
        }
    }

    public static void postValidateJBang(JReleaserContext context, Errors errors) {
        Map<String, List<Distribution>> map = context.getModel().getDistributions().values().stream().filter(d -> d.isEnabled() && d.getJbang().isEnabled()).collect(Collectors.groupingBy(d -> d.getJbang().getAlias()));
        map.forEach((alias, distributions) -> {
            if (distributions.size() > 1) {
                errors.configuration("jbang.alias '" + alias + "' is defined for more than one distribution: " + distributions.stream().map(Distribution::getName).collect(Collectors.joining(", ")));
            }
        });
    }
}

