/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.validation;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import org.jreleaser.model.Artifact;
import org.jreleaser.model.JReleaserContext;
import org.jreleaser.model.Jlink;
import org.jreleaser.model.validation.Validator;
import org.jreleaser.util.Errors;
import org.jreleaser.util.StringUtils;

public abstract class JlinkResolver
extends Validator {
    public static void resolveJlinkOutputs(JReleaserContext context, Errors errors) {
        context.getLogger().debug("jlink");
        for (Jlink jlink : context.getModel().getAssemble().getActiveJlinks()) {
            if (!jlink.isExported()) continue;
            JlinkResolver.resolveJlinkOutputs(context, jlink, errors);
        }
    }

    private static void resolveJlinkOutputs(JReleaserContext context, Jlink jlink, Errors errors) {
        Path baseOutputDirectory = context.getAssembleDirectory().resolve(jlink.getName()).resolve(jlink.getType());
        String imageName = jlink.getResolvedImageName(context);
        for (Artifact targetJdk : jlink.getTargetJdks()) {
            if (!context.isPlatformSelected(targetJdk)) continue;
            Path image = baseOutputDirectory.resolve(imageName + "-" + targetJdk.getPlatform() + ".zip").toAbsolutePath();
            if (!Files.exists(image, new LinkOption[0])) {
                errors.assembly("Missing outputs for " + jlink.getType() + "." + jlink.getName() + ". Distribution " + jlink.getName() + " has not been assembled.");
                continue;
            }
            Artifact artifact = Artifact.of(image, targetJdk.getPlatform());
            artifact.activate();
            if (StringUtils.isNotBlank((String)jlink.getImageNameTransform())) {
                artifact.setTransform(jlink.getResolvedImageNameTransform(context) + "-" + targetJdk.getPlatform() + ".zip");
                artifact.getEffectivePath(context);
            }
            jlink.addOutput(artifact);
        }
    }
}

