/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.validation;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import org.jreleaser.model.JReleaserContext;
import org.jreleaser.model.Mail;
import org.jreleaser.model.validation.Validator;
import org.jreleaser.util.Errors;
import org.jreleaser.util.StringUtils;

public abstract class MailValidator
extends Validator {
    public static void validateMail(JReleaserContext context, Mail mail, Errors errors) {
        if (!mail.resolveEnabled(context.getModel().getProject())) {
            return;
        }
        context.getLogger().debug("announce.mail");
        if (null == mail.getTransport()) {
            mail.setTransport(Mail.Transport.SMTP);
        }
        if (StringUtils.isBlank((String)mail.getHost())) {
            errors.configuration("mail.host must not be blank.");
        }
        if (null == mail.getPort()) {
            mail.setPort(25);
        }
        if (!mail.isAuthSet()) {
            mail.setAuth(true);
        }
        if (StringUtils.isBlank((String)mail.getUsername())) {
            errors.configuration("mail.username must not be blank.");
        }
        mail.setPassword(MailValidator.checkProperty(context, "MAIL_PASSWORD", "mail.password", mail.getPassword(), errors, context.isDryrun()));
        if (StringUtils.isBlank((String)mail.getFrom())) {
            errors.configuration("mail.from must not be blank.");
        }
        boolean to = StringUtils.isBlank((String)mail.getTo());
        boolean cc = StringUtils.isBlank((String)mail.getCc());
        boolean bcc = StringUtils.isBlank((String)mail.getBcc());
        if (!(to || cc || bcc)) {
            errors.configuration("mail.to, mail.cc, or mail.bcc must not be blank.");
        }
        if (StringUtils.isBlank((String)mail.getSubject())) {
            mail.setSubject("{{projectNameCapitalized}} {{projectVersion}} released!");
        }
        if (null == mail.getMimeType()) {
            mail.setMimeType(Mail.MimeType.TEXT);
        }
        if (StringUtils.isBlank((String)mail.getMessage()) && StringUtils.isBlank((String)mail.getMessageTemplate())) {
            mail.setMessageTemplate("src/jreleaser/templates/mail.tpl");
        }
        if (StringUtils.isNotBlank((String)mail.getMessageTemplate()) && !Files.exists(context.getBasedir().resolve(mail.getMessageTemplate().trim()), new LinkOption[0])) {
            errors.configuration("mail.messageTemplate does not exist. " + mail.getMessageTemplate());
        }
    }
}

