/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.validation;

import org.jreleaser.model.JReleaserContext;
import org.jreleaser.model.Mastodon;
import org.jreleaser.model.validation.Validator;
import org.jreleaser.util.Errors;
import org.jreleaser.util.StringUtils;

public abstract class MastodonValidator
extends Validator {
    public static void validateMastodon(JReleaserContext context, Mastodon mastodon, Errors errors) {
        if (!mastodon.resolveEnabled(context.getModel().getProject())) {
            return;
        }
        context.getLogger().debug("announce.mastodon");
        if (StringUtils.isBlank((String)mastodon.getHost())) {
            errors.configuration("mastodon.host must not be blank.");
        }
        mastodon.setAccessToken(MastodonValidator.checkProperty(context, "MASTODON_ACCESS_TOKEN", "mastodon.accessToken", mastodon.getAccessToken(), errors, context.isDryrun()));
        if (StringUtils.isBlank((String)mastodon.getStatus())) {
            mastodon.setStatus("\ud83d\ude80 {{projectNameCapitalized}} {{projectVersion}} has been released! {{releaseNotesUrl}}");
        }
        MastodonValidator.validateTimeout(mastodon);
    }
}

