/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.validation;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import org.jreleaser.model.Artifact;
import org.jreleaser.model.JReleaserContext;
import org.jreleaser.model.NativeImage;
import org.jreleaser.model.validation.Validator;
import org.jreleaser.util.Errors;
import org.jreleaser.util.StringUtils;

public abstract class NativeImageResolver
extends Validator {
    public static void resolveNativeImageOutputs(JReleaserContext context, Errors errors) {
        context.getLogger().debug("nativeImage");
        for (NativeImage nativeImage : context.getModel().getAssemble().getActiveNativeImages()) {
            if (!nativeImage.isExported()) continue;
            NativeImageResolver.resolveNativeImageOutputs(context, nativeImage, errors);
        }
    }

    private static void resolveNativeImageOutputs(JReleaserContext context, NativeImage nativeImage, Errors errors) {
        if (!context.isPlatformSelected(nativeImage.getGraal())) {
            return;
        }
        String platform = nativeImage.getGraal().getPlatform();
        Path image = context.getAssembleDirectory().resolve(nativeImage.getName()).resolve(nativeImage.getType()).resolve(nativeImage.getResolvedImageName(context) + "-" + platform + ".zip");
        if (!Files.exists(image, new LinkOption[0])) {
            errors.assembly("Missing outputs for " + nativeImage.getType() + "." + nativeImage.getName() + ". Distribution " + nativeImage.getName() + " has not been assembled.");
        } else {
            Artifact artifact = Artifact.of(image, platform);
            artifact.activate();
            if (StringUtils.isNotBlank((String)nativeImage.getImageNameTransform())) {
                artifact.setTransform(nativeImage.getResolvedImageNameTransform(context) + "-" + platform + ".zip");
                artifact.getEffectivePath(context);
            }
            nativeImage.addOutput(artifact);
        }
    }
}

