/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.validation;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jreleaser.model.Distribution;
import org.jreleaser.model.GitService;
import org.jreleaser.model.JReleaserContext;
import org.jreleaser.model.JReleaserModel;
import org.jreleaser.model.Sdkman;
import org.jreleaser.model.validation.DistributionsValidator;
import org.jreleaser.model.validation.ExtraPropertiesValidator;
import org.jreleaser.model.validation.Validator;
import org.jreleaser.util.Errors;
import org.jreleaser.util.StringUtils;

public abstract class SdkmanValidator
extends Validator {
    public static void validateSdkman(JReleaserContext context, Distribution distribution, Sdkman tool, Errors errors) {
        JReleaserModel model = context.getModel();
        Sdkman parentTool = model.getPackagers().getSdkman();
        boolean toolSet = tool.isActiveSet();
        boolean parentToolSet = parentTool.isActiveSet();
        tool.getExtraProperties().put("__MAGIC_SET__", toolSet || parentToolSet);
        if (!tool.isActiveSet() && parentTool.isActiveSet()) {
            tool.setActive(parentTool.getActive());
        }
        if (!tool.resolveEnabled(context.getModel().getProject(), distribution)) {
            return;
        }
        GitService service = model.getRelease().getGitService();
        if (!service.isReleaseSupported()) {
            tool.disable();
            return;
        }
        context.getLogger().debug("distribution.{}.sdkman", new Object[]{distribution.getName()});
        ExtraPropertiesValidator.mergeExtraProperties(tool, parentTool);
        SdkmanValidator.validateContinueOnError(tool, parentTool);
        if (null == tool.getCommand()) {
            tool.setCommand(parentTool.getCommand());
            if (null == tool.getCommand()) {
                tool.setCommand(Sdkman.Command.MAJOR);
            }
        }
        if (StringUtils.isBlank((String)tool.getCandidate())) {
            tool.setCandidate(parentTool.getCandidate());
            if (StringUtils.isBlank((String)tool.getCandidate())) {
                tool.setCandidate(distribution.getName());
            }
        }
        if (StringUtils.isBlank((String)tool.getReleaseNotesUrl())) {
            tool.setReleaseNotesUrl(parentTool.getReleaseNotesUrl());
            if (StringUtils.isBlank((String)tool.getReleaseNotesUrl())) {
                tool.setReleaseNotesUrl(service.getReleaseNotesUrl());
            }
        }
        tool.setConsumerKey(SdkmanValidator.checkProperty(context, "SDKMAN_CONSUMER_KEY", "sdkman.consumerKey", tool.getConsumerKey(), errors, context.isDryrun()));
        tool.setConsumerToken(SdkmanValidator.checkProperty(context, "SDKMAN_CONSUMER_TOKEN", "sdkman.consumerToken", tool.getConsumerToken(), errors, context.isDryrun()));
        SdkmanValidator.validateTimeout(tool);
        DistributionsValidator.validateArtifactPlatforms(context, distribution, tool, errors);
    }

    public static void postValidateSdkman(JReleaserContext context, Errors errors) {
        Map<String, List<Distribution>> map = context.getModel().getDistributions().values().stream().peek(distribution -> {
            boolean set;
            if (distribution.getSdkman().getExtraProperties().containsKey("__MAGIC_SET__") && (set = ((Boolean)distribution.getSdkman().getExtraProperties().remove("__MAGIC_SET__")).booleanValue())) {
                context.getModel().getAnnounce().getSdkman().getExtraProperties().put("__MAGIC_SET__", set);
            }
        }).filter(d -> d.isEnabled() && d.getSdkman().isEnabled()).collect(Collectors.groupingBy(d -> d.getSdkman().getCandidate()));
        map.forEach((candidate, distributions) -> {
            if (distributions.size() > 1) {
                errors.configuration("sdkman.candidate '" + candidate + "' is defined for more than one distribution: " + distributions.stream().map(Distribution::getName).collect(Collectors.joining(", ")));
            }
        });
    }
}

