/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.validation;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import org.jreleaser.model.JReleaserContext;
import org.jreleaser.model.Slack;
import org.jreleaser.model.validation.Validator;
import org.jreleaser.util.Errors;
import org.jreleaser.util.StringUtils;

public abstract class SlackValidator
extends Validator {
    private static final String DEFAULT_SLACK_TPL = "src/jreleaser/templates/slack.tpl";

    public static void validateSlack(JReleaserContext context, Slack slack, Errors errors) {
        if (!slack.resolveEnabled(context.getModel().getProject())) {
            return;
        }
        context.getLogger().debug("announce.slack");
        Errors ignored = new Errors();
        slack.setToken(SlackValidator.checkProperty(context, "SLACK_TOKEN", "slack.token", slack.getToken(), ignored, context.isDryrun()));
        slack.setWebhook(SlackValidator.checkProperty(context, "SLACK_WEBHOOK", "slack.webhook", slack.getWebhook(), ignored, context.isDryrun()));
        String token = slack.getResolvedToken();
        String webhook = slack.getResolvedWebhook();
        if (!context.isDryrun() && StringUtils.isBlank((String)token) && StringUtils.isBlank((String)webhook)) {
            errors.configuration("slack.token or slack.webhook must be provided");
            return;
        }
        if (StringUtils.isBlank((String)slack.getChannel())) {
            slack.setChannel("#announce");
        }
        if (StringUtils.isBlank((String)slack.getMessage()) && StringUtils.isBlank((String)slack.getMessageTemplate())) {
            if (Files.exists(context.getBasedir().resolve(DEFAULT_SLACK_TPL), new LinkOption[0])) {
                slack.setMessageTemplate(DEFAULT_SLACK_TPL);
            } else {
                slack.setMessage("\ud83d\ude80 {{projectNameCapitalized}} {{projectVersion}} has been released! {{releaseNotesUrl}}");
            }
        }
        if (StringUtils.isNotBlank((String)slack.getMessageTemplate()) && !Files.exists(context.getBasedir().resolve(slack.getMessageTemplate().trim()), new LinkOption[0])) {
            errors.configuration("slack.messageTemplate does not exist. " + slack.getMessageTemplate());
        }
        SlackValidator.validateTimeout(slack);
    }
}

