/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.validation;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import org.jreleaser.model.JReleaserContext;
import org.jreleaser.model.Teams;
import org.jreleaser.model.validation.Validator;
import org.jreleaser.util.Errors;
import org.jreleaser.util.StringUtils;

public abstract class TeamsValidator
extends Validator {
    private static final String DEFAULT_TEAMS_TPL = "src/jreleaser/templates/teams.tpl";

    public static void validateTeams(JReleaserContext context, Teams teams, Errors errors) {
        if (!teams.resolveEnabled(context.getModel().getProject())) {
            return;
        }
        context.getLogger().debug("announce.teams");
        teams.setWebhook(TeamsValidator.checkProperty(context, "TEAMS_WEBHOOK", "teams.webhook", teams.getWebhook(), errors, context.isDryrun()));
        if (StringUtils.isBlank((String)teams.getMessageTemplate())) {
            teams.setMessageTemplate(DEFAULT_TEAMS_TPL);
        }
        if (StringUtils.isNotBlank((String)teams.getMessageTemplate()) && !Files.exists(context.getBasedir().resolve(teams.getMessageTemplate().trim()), new LinkOption[0])) {
            errors.configuration("teams.messageTemplate does not exist. " + teams.getMessageTemplate());
        }
        TeamsValidator.validateTimeout(teams);
    }
}

