/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.validation;

import org.jreleaser.model.JReleaserContext;
import org.jreleaser.model.Twitter;
import org.jreleaser.model.validation.Validator;
import org.jreleaser.util.Errors;
import org.jreleaser.util.StringUtils;

public abstract class TwitterValidator
extends Validator {
    public static void validateTwitter(JReleaserContext context, Twitter twitter, Errors errors) {
        if (!twitter.resolveEnabled(context.getModel().getProject())) {
            return;
        }
        context.getLogger().debug("announce.twitter");
        twitter.setConsumerKey(TwitterValidator.checkProperty(context, "TWITTER_CONSUMER_KEY", "twitter.consumerKey", twitter.getConsumerKey(), errors, context.isDryrun()));
        twitter.setConsumerSecret(TwitterValidator.checkProperty(context, "TWITTER_CONSUMER_SECRET", "twitter.consumerSecret", twitter.getConsumerSecret(), errors, context.isDryrun()));
        twitter.setAccessToken(TwitterValidator.checkProperty(context, "TWITTER_ACCESS_TOKEN", "twitter.accessToken", twitter.getAccessToken(), errors, context.isDryrun()));
        twitter.setAccessTokenSecret(TwitterValidator.checkProperty(context, "TWITTER_ACCESS_TOKEN_SECRET", "twitter.accessTokenSecret", twitter.getAccessTokenSecret(), errors, context.isDryrun()));
        if (StringUtils.isBlank((String)twitter.getStatus())) {
            twitter.setStatus("\ud83d\ude80 {{projectNameCapitalized}} {{projectVersion}} has been released! {{releaseNotesUrl}}");
        }
        TwitterValidator.validateTimeout(twitter);
    }
}

