/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.validation;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import org.jreleaser.model.JReleaserContext;
import org.jreleaser.model.Zulip;
import org.jreleaser.model.validation.Validator;
import org.jreleaser.util.Errors;
import org.jreleaser.util.StringUtils;

public abstract class ZulipValidator
extends Validator {
    private static final String DEFAULT_ZULIP_TPL = "src/jreleaser/templates/zulip.tpl";

    public static void validateZulip(JReleaserContext context, Zulip zulip, Errors errors) {
        if (!zulip.resolveEnabled(context.getModel().getProject())) {
            return;
        }
        context.getLogger().debug("announce.zulip");
        if (StringUtils.isBlank((String)zulip.getAccount())) {
            errors.configuration("zulip.account must not be blank.");
        }
        zulip.setApiKey(ZulipValidator.checkProperty(context, "ZULIP_API_KEY", "zulip.apiKey", zulip.getApiKey(), errors, context.isDryrun()));
        if (StringUtils.isBlank((String)zulip.getApiHost())) {
            errors.configuration("zulip.apiHost must not be blank.");
        }
        if (StringUtils.isBlank((String)zulip.getSubject())) {
            zulip.setSubject("{{projectNameCapitalized}} {{projectVersion}} released!");
        }
        if (StringUtils.isBlank((String)zulip.getChannel())) {
            zulip.setChannel("announce");
        }
        if (StringUtils.isBlank((String)zulip.getMessage()) && StringUtils.isBlank((String)zulip.getMessageTemplate())) {
            if (Files.exists(context.getBasedir().resolve(DEFAULT_ZULIP_TPL), new LinkOption[0])) {
                zulip.setMessageTemplate(DEFAULT_ZULIP_TPL);
            } else {
                zulip.setMessage("\ud83d\ude80 {{projectNameCapitalized}} {{projectVersion}} has been released! {{releaseNotesUrl}}");
            }
        }
        if (StringUtils.isNotBlank((String)zulip.getMessageTemplate()) && !Files.exists(context.getBasedir().resolve(zulip.getMessageTemplate().trim()), new LinkOption[0])) {
            errors.configuration("zulip.messageTemplate does not exist. " + zulip.getMessageTemplate());
        }
        ZulipValidator.validateTimeout(zulip);
    }
}

