/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.Artifact;
import org.jreleaser.model.Domain;
import org.jreleaser.model.ExtraProperties;
import org.jreleaser.model.JReleaserContext;
import org.jreleaser.model.JReleaserException;
import org.jreleaser.model.util.Artifacts;
import org.jreleaser.util.MustacheUtils;
import org.jreleaser.util.StringUtils;

public class Glob
implements Domain,
ExtraProperties {
    private static final String GLOB_PREFIX = "glob:";
    private static final String REGEX_PREFIX = "regex:";
    private final Map<String, Object> extraProperties = new LinkedHashMap<String, Object>();
    private String pattern;
    private Set<Artifact> artifacts;
    private String directory;
    private String include;
    private String exclude;
    private Boolean recursive;

    void setAll(Glob glob) {
        this.pattern = glob.pattern;
        this.setExtraProperties(glob.extraProperties);
    }

    @Override
    public String getPrefix() {
        return "artifact";
    }

    @Override
    public Map<String, Object> getExtraProperties() {
        return this.extraProperties;
    }

    @Override
    public void setExtraProperties(Map<String, Object> extraProperties) {
        this.extraProperties.clear();
        this.extraProperties.putAll(extraProperties);
    }

    @Override
    public void addExtraProperties(Map<String, Object> extraProperties) {
        this.extraProperties.putAll(extraProperties);
    }

    public Set<Artifact> getResolvedArtifacts(JReleaserContext context) {
        return StringUtils.isNotBlank((String)this.pattern) ? this.getResolvedArtifactsPattern(context) : this.getResolvedArtifactsLegacy(context);
    }

    public Set<Artifact> getResolvedArtifactsPattern(JReleaserContext context) {
        if (null == this.artifacts) {
            this.artifacts = Artifacts.resolveFiles(context, Collections.singletonList(this.pattern));
            this.artifacts.forEach(artifact -> {
                if (context.isPlatformSelected((Artifact)artifact)) {
                    artifact.activate();
                }
                artifact.setExtraProperties(this.getExtraProperties());
            });
        }
        return this.artifacts;
    }

    @Deprecated
    public Set<Artifact> getResolvedArtifactsLegacy(JReleaserContext context) {
        if (null == this.artifacts) {
            Path path = context.getBasedir();
            if (StringUtils.isNotBlank((String)this.directory)) {
                if (this.directory.contains("{{")) {
                    this.directory = MustacheUtils.applyTemplate((String)this.directory, context.props());
                }
                if (!Files.exists(path = context.getBasedir().resolve(Paths.get(this.directory, new String[0])).normalize(), new LinkOption[0])) {
                    throw new JReleaserException(RB.$((String)"ERROR_path_does_not_exist", (Object[])new Object[]{context.relativizeToBasedir(path)}));
                }
            }
            FileCollector fileCollector = new FileCollector(context, this.include, this.exclude, path, this.isRecursive());
            try {
                Files.walkFileTree(path, fileCollector);
            }
            catch (IOException e) {
                throw new JReleaserException(RB.$((String)"ERROR_unexpected_glob_resolve", (Object[])new Object[]{this.asMap(true)}));
            }
            if (fileCollector.failed) {
                throw new JReleaserException(RB.$((String)"ERROR_glob_resolve", (Object[])new Object[]{this.asMap(true)}));
            }
            this.artifacts = fileCollector.getFiles().stream().map(p -> Artifact.of(p, this.getExtraProperties())).peek(a -> {
                if (context.isPlatformSelected((Artifact)a)) {
                    a.activate();
                }
            }).collect(Collectors.toSet());
            Artifact.sortArtifacts(this.artifacts);
        }
        return this.artifacts;
    }

    public String getPattern() {
        return this.pattern;
    }

    public void setPattern(String pattern) {
        if (StringUtils.isBlank((String)pattern)) {
            return;
        }
        this.pattern = pattern.startsWith(GLOB_PREFIX) || pattern.startsWith(REGEX_PREFIX) ? pattern.trim() : GLOB_PREFIX + pattern.trim();
        if (this.pattern.startsWith(GLOB_PREFIX)) {
            String path = this.pattern.substring(GLOB_PREFIX.length());
            if (!Paths.get(path, new String[0]).isAbsolute()) {
                this.pattern = "glob:**" + File.separator + path;
            }
        } else {
            String path = this.pattern.substring(REGEX_PREFIX.length());
            if (!Paths.get(path, new String[0]).isAbsolute()) {
                this.pattern = "regex:.*" + File.separator + path;
            }
        }
    }

    public String getDirectory() {
        return this.directory;
    }

    @Deprecated
    public void setDirectory(String directory) {
        System.out.println("glob.directory has been deprecated since 0.6.0 and will be removed in the future. Use glob.pattern instead");
        this.directory = directory;
    }

    public String getInclude() {
        return this.include;
    }

    @Deprecated
    public void setInclude(String include) {
        System.out.println("glob.include has been deprecated since 0.6.0 and will be removed in the future. Use glob.pattern instead");
        this.include = include;
    }

    public String getExclude() {
        return this.exclude;
    }

    @Deprecated
    public void setExclude(String exclude) {
        System.out.println("glob.exclude has been deprecated since 0.6.0 and will be removed in the future. Use glob.pattern instead");
        this.exclude = exclude;
    }

    public Boolean isRecursive() {
        return this.recursive != null && this.recursive != false;
    }

    @Deprecated
    public void setRecursive(Boolean recursive) {
        System.out.println("glob.recursive has been deprecated since 0.6.0 and will be removed in the future. Use glob.pattern instead");
        this.recursive = recursive;
    }

    public boolean isRecursiveSet() {
        return this.recursive != null;
    }

    @Override
    public Map<String, Object> asMap(boolean full) {
        LinkedHashMap<String, Object> props = new LinkedHashMap<String, Object>();
        props.put("pattern", this.pattern);
        props.put("extraProperties", this.getResolvedExtraProperties());
        props.put("directory", this.directory);
        props.put("include", this.include);
        props.put("exclude", this.exclude);
        if (StringUtils.isBlank((String)this.pattern)) {
            props.put("recursive", this.isRecursive());
        }
        return props;
    }

    public static class FileCollector
    extends SimpleFileVisitor<Path> {
        private final PathMatcher includeMatcher;
        private final Set<Path> files = new LinkedHashSet<Path>();
        private final JReleaserContext context;
        private final boolean recursive;
        private final Path start;
        private PathMatcher excludeMatcher;
        private boolean failed;

        FileCollector(JReleaserContext context, String include, String exclude, Path start, boolean recursive) {
            this.context = context;
            this.start = start;
            this.recursive = recursive;
            this.includeMatcher = include.startsWith(Glob.REGEX_PREFIX) || include.startsWith(Glob.GLOB_PREFIX) ? FileSystems.getDefault().getPathMatcher(include) : FileSystems.getDefault().getPathMatcher(Glob.GLOB_PREFIX + include);
            if (StringUtils.isNotBlank((String)exclude)) {
                this.excludeMatcher = exclude.startsWith(Glob.REGEX_PREFIX) || exclude.startsWith(Glob.GLOB_PREFIX) ? FileSystems.getDefault().getPathMatcher(exclude) : FileSystems.getDefault().getPathMatcher(Glob.GLOB_PREFIX + exclude);
            }
        }

        private boolean match(Path file) {
            Path fileName = file.getFileName();
            if (null != fileName && this.includeMatcher.matches(fileName)) {
                if (null != this.excludeMatcher && this.excludeMatcher.matches(fileName)) {
                    return false;
                }
                if (Files.isRegularFile(file, new LinkOption[0])) {
                    this.files.add(file);
                }
            }
            return null == this.excludeMatcher || !this.excludeMatcher.matches(fileName);
        }

        public Set<Path> getFiles() {
            return Collections.unmodifiableSet(this.files);
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
            this.match(file);
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) {
            if (this.recursive || dir.equals(this.start)) {
                return this.match(dir) ? FileVisitResult.CONTINUE : FileVisitResult.SKIP_SUBTREE;
            }
            return FileVisitResult.SKIP_SUBTREE;
        }

        @Override
        public FileVisitResult visitFileFailed(Path file, IOException e) {
            this.failed = true;
            this.context.getLogger().error(RB.$((String)"ERROR_artifacts_unexpected_error_path", (Object[])new Object[]{this.context.relativizeToBasedir(file)}), (Throwable)e);
            return FileVisitResult.CONTINUE;
        }
    }
}

