/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model;

import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.net.URL;
import java.util.Enumeration;
import java.util.ResourceBundle;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.jreleaser.util.StringUtils;

public class JReleaserVersion {
    private static final ResourceBundle bundle = ResourceBundle.getBundle(JReleaserVersion.class.getName());
    private static final String JRELEASER_VERSION = bundle.getString("jreleaser_version");

    public static String getPlainVersion() {
        return JRELEASER_VERSION;
    }

    public static void banner(PrintStream out) {
        JReleaserVersion.banner(out, true);
    }

    public static void banner(PrintStream out, boolean full) {
        Manifest manifest = JReleaserVersion.findMyManifest();
        if (null != manifest) {
            boolean additionalInfo;
            String version = manifest.getMainAttributes().getValue(Attributes.Name.SPECIFICATION_VERSION);
            String buildDate = manifest.getMainAttributes().getValue("Build-Date");
            String buildTime = manifest.getMainAttributes().getValue("Build-Time");
            String buildRevision = manifest.getMainAttributes().getValue("Build-Revision");
            boolean bl = additionalInfo = StringUtils.isNotBlank((String)buildDate) || StringUtils.isNotBlank((String)buildTime) || StringUtils.isNotBlank((String)buildRevision);
            if (full) {
                out.printf("------------------------------------------------------------%n", new Object[0]);
                out.printf("jreleaser %s%n", version);
            }
            out.printf("------------------------------------------------------------%n", new Object[0]);
            if (additionalInfo) {
                if (StringUtils.isNotBlank((String)buildDate) && StringUtils.isNotBlank((String)buildTime)) {
                    out.printf("Build time:   %s %s%n", buildDate, buildTime);
                }
                if (StringUtils.isNotBlank((String)buildRevision)) {
                    out.println("Revision:     " + buildRevision);
                }
                out.printf("------------------------------------------------------------%n", new Object[0]);
            }
        } else {
            out.printf("jreleaser %s%n", JRELEASER_VERSION);
        }
    }

    public static void banner(PrintWriter out) {
        JReleaserVersion.banner(out, true);
    }

    public static void banner(PrintWriter out, boolean full) {
        Manifest manifest = JReleaserVersion.findMyManifest();
        if (null != manifest) {
            boolean additionalInfo;
            String version = manifest.getMainAttributes().getValue(Attributes.Name.SPECIFICATION_VERSION);
            String buildDate = manifest.getMainAttributes().getValue("Build-Date");
            String buildTime = manifest.getMainAttributes().getValue("Build-Time");
            String buildRevision = manifest.getMainAttributes().getValue("Build-Revision");
            boolean bl = additionalInfo = StringUtils.isNotBlank((String)buildDate) || StringUtils.isNotBlank((String)buildTime) || StringUtils.isNotBlank((String)buildRevision);
            if (full) {
                out.printf("------------------------------------------------------------%n", new Object[0]);
                out.printf("jreleaser %s%n", version);
            }
            out.printf("------------------------------------------------------------%n", new Object[0]);
            if (additionalInfo) {
                if (StringUtils.isNotBlank((String)buildDate) && StringUtils.isNotBlank((String)buildTime)) {
                    out.printf("Build time:   %s %s%n", buildDate, buildTime);
                }
                if (StringUtils.isNotBlank((String)buildRevision)) {
                    out.println("Revision:     " + buildRevision);
                }
                out.printf("------------------------------------------------------------%n", new Object[0]);
            }
        } else {
            out.printf("jreleaser %s%n", JRELEASER_VERSION);
        }
    }

    private static Manifest findMyManifest() {
        try {
            Enumeration<URL> urls = JReleaserVersion.class.getClassLoader().getResources("META-INF/MANIFEST.MF");
            while (urls.hasMoreElements()) {
                String specificationTitle;
                URL url = urls.nextElement();
                Manifest manifest = new Manifest(url.openStream());
                if (!manifest.getMainAttributes().containsKey(Attributes.Name.SPECIFICATION_TITLE) || !"jreleaser".equals(specificationTitle = manifest.getMainAttributes().getValue(Attributes.Name.SPECIFICATION_TITLE))) continue;
                return manifest;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }
}

