/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.jreleaser.model.AbstractModelObject;
import org.jreleaser.model.Active;
import org.jreleaser.model.Changelog;
import org.jreleaser.model.CommitAuthor;
import org.jreleaser.model.CommitAuthorAware;
import org.jreleaser.model.Domain;
import org.jreleaser.model.JReleaserModel;
import org.jreleaser.model.OwnerAware;
import org.jreleaser.model.Project;
import org.jreleaser.model.Releaser;
import org.jreleaser.model.TimeoutAware;
import org.jreleaser.model.UpdateSection;
import org.jreleaser.util.Env;
import org.jreleaser.util.MustacheUtils;
import org.jreleaser.util.PlatformUtils;
import org.jreleaser.util.SemVer;
import org.jreleaser.util.StringUtils;
import org.jreleaser.util.Templates;

public abstract class GitService<S extends GitService<S>>
extends AbstractModelObject<S>
implements Releaser,
CommitAuthorAware,
OwnerAware,
TimeoutAware {
    public static final String KEY_SKIP_RELEASE = "skipRelease";
    public static final String KEY_SKIP_RELEASE_SIGNATURES = "skipReleaseSignatures";
    public static final String TAG_NAME = "TAG_NAME";
    public static final String PREVIOUS_TAG_NAME = "PREVIOUS_TAG_NAME";
    public static final String RELEASE_NAME = "RELEASE_NAME";
    public static final String OVERWRITE = "OVERWRITE";
    public static final String UPDATE = "UPDATE";
    public static final String PRERELEASE = "PRERELEASE";
    public static final String DRAFT = "DRAFT";
    public static final String SKIP_TAG = "SKIP_TAG";
    public static final String SKIP_RELEASE = "SKIP_RELEASE";
    public static final String BRANCH = "BRANCH";
    public static final String PRERELEASE_PATTERN = "PRERELEASE_PATTERN";
    @JsonIgnore
    protected final String serviceName;
    protected final Changelog changelog = new Changelog();
    protected final Milestone milestone = new Milestone();
    protected final CommitAuthor commitAuthor = new CommitAuthor();
    protected final Update update = new Update();
    protected final Prerelease prerelease = new Prerelease();
    @JsonIgnore
    protected final boolean releaseSupported;
    @JsonIgnore
    protected boolean match = true;
    protected Boolean enabled;
    protected String host;
    protected String owner;
    protected String name;
    protected String repoUrl;
    protected String repoCloneUrl;
    protected String commitUrl;
    protected String srcUrl;
    protected String downloadUrl;
    protected String releaseNotesUrl;
    protected String latestReleaseUrl;
    protected String issueTrackerUrl;
    protected String username;
    protected String token;
    protected String tagName;
    protected String previousTagName;
    protected String releaseName;
    protected String branch;
    protected Boolean sign;
    protected Boolean skipTag;
    protected Boolean skipRelease;
    protected Boolean overwrite;
    protected String apiEndpoint;
    protected int connectTimeout;
    protected int readTimeout;
    protected Boolean artifacts;
    protected Boolean files;
    protected Boolean checksums;
    protected Boolean signatures;
    protected Active uploadAssets;
    protected Boolean uploadAssetsEnabled;
    @JsonIgnore
    protected String cachedTagName;
    @JsonIgnore
    protected String cachedReleaseName;

    protected GitService(String serviceName, boolean releaseSupported) {
        this.serviceName = serviceName;
        this.releaseSupported = releaseSupported;
    }

    @Override
    public boolean isReleaseSupported() {
        return this.releaseSupported;
    }

    @Override
    public String getServiceName() {
        return this.serviceName;
    }

    @Override
    public void freeze() {
        super.freeze();
        this.changelog.freeze();
        this.milestone.freeze();
        this.commitAuthor.freeze();
        this.update.freeze();
        this.prerelease.freeze();
    }

    @Override
    public void merge(S service) {
        this.freezeCheck();
        this.match = ((GitService)service).match;
        this.enabled = this.merge(this.enabled, ((GitService)service).enabled);
        this.host = this.merge(this.host, ((GitService)service).host);
        this.owner = this.merge(this.owner, ((GitService)service).owner);
        this.name = this.merge(this.name, ((GitService)service).name);
        this.repoUrl = this.merge(this.repoUrl, ((GitService)service).repoUrl);
        this.repoCloneUrl = this.merge(this.repoCloneUrl, ((GitService)service).repoCloneUrl);
        this.commitUrl = this.merge(this.commitUrl, ((GitService)service).commitUrl);
        this.srcUrl = this.merge(this.srcUrl, ((GitService)service).srcUrl);
        this.downloadUrl = this.merge(this.downloadUrl, ((GitService)service).downloadUrl);
        this.releaseNotesUrl = this.merge(this.releaseNotesUrl, ((GitService)service).releaseNotesUrl);
        this.latestReleaseUrl = this.merge(this.latestReleaseUrl, ((GitService)service).latestReleaseUrl);
        this.issueTrackerUrl = this.merge(this.issueTrackerUrl, ((GitService)service).issueTrackerUrl);
        this.username = this.merge(this.username, ((GitService)service).username);
        this.token = this.merge(this.token, ((GitService)service).token);
        this.tagName = this.merge(this.tagName, ((GitService)service).tagName);
        this.previousTagName = this.merge(this.previousTagName, ((GitService)service).previousTagName);
        this.releaseName = this.merge(this.releaseName, ((GitService)service).releaseName);
        this.branch = this.merge(this.branch, ((GitService)service).branch);
        this.sign = this.merge(this.sign, ((GitService)service).sign);
        this.skipTag = this.merge(this.skipTag, ((GitService)service).skipTag);
        this.skipRelease = this.merge(this.skipRelease, ((GitService)service).skipRelease);
        this.overwrite = this.merge(this.overwrite, ((GitService)service).overwrite);
        this.apiEndpoint = this.merge(this.apiEndpoint, ((GitService)service).apiEndpoint);
        this.connectTimeout = this.merge(this.connectTimeout, ((GitService)service).connectTimeout);
        this.readTimeout = this.merge(this.readTimeout, ((GitService)service).readTimeout);
        this.artifacts = this.merge(this.artifacts, ((GitService)service).artifacts);
        this.files = this.merge(this.files, ((GitService)service).files);
        this.checksums = this.merge(this.checksums, ((GitService)service).checksums);
        this.signatures = this.merge(this.signatures, ((GitService)service).signatures);
        this.uploadAssets = this.merge(this.uploadAssets, ((GitService)service).uploadAssets);
        this.uploadAssetsEnabled = this.merge(this.uploadAssetsEnabled, ((GitService)service).uploadAssetsEnabled);
        this.setCommitAuthor(((GitService)service).commitAuthor);
        this.setUpdate(((GitService)service).update);
        this.setPrerelease(((GitService)service).prerelease);
        this.setChangelog(((GitService)service).changelog);
        this.setMilestone(((GitService)service).milestone);
    }

    public String getCanonicalRepoName() {
        if (StringUtils.isNotBlank((String)this.owner)) {
            return this.owner + "/" + this.name;
        }
        return this.name;
    }

    public abstract String getReverseRepoHost();

    public String getConfiguredTagName() {
        return Env.env((String)TAG_NAME, (String)this.tagName);
    }

    public String getConfiguredPreviousTagName() {
        return Env.env((String)PREVIOUS_TAG_NAME, (String)this.previousTagName);
    }

    public String getResolvedTagName(JReleaserModel model) {
        if (StringUtils.isBlank((String)this.cachedTagName)) {
            this.cachedTagName = this.getConfiguredTagName();
        }
        if (StringUtils.isBlank((String)this.cachedTagName)) {
            this.cachedTagName = Templates.resolveTemplate((String)this.tagName, this.props(model));
        } else if (this.cachedTagName.contains("{{")) {
            this.cachedTagName = Templates.resolveTemplate((String)this.cachedTagName, this.props(model));
        }
        return this.cachedTagName;
    }

    public String getEffectiveTagName(JReleaserModel model) {
        if (model.getProject().isSnapshot()) {
            return model.getProject().getSnapshot().getResolvedLabel(model);
        }
        return this.cachedTagName;
    }

    public String getConfiguredReleaseName() {
        return Env.env((String)RELEASE_NAME, (String)this.cachedReleaseName);
    }

    public String getResolvedReleaseName(JReleaserModel model) {
        if (StringUtils.isBlank((String)this.cachedReleaseName)) {
            this.cachedReleaseName = this.getConfiguredReleaseName();
        }
        if (StringUtils.isBlank((String)this.cachedReleaseName)) {
            this.cachedReleaseName = Templates.resolveTemplate((String)this.releaseName, this.props(model));
        } else if (this.cachedReleaseName.contains("{{")) {
            this.cachedReleaseName = Templates.resolveTemplate((String)this.cachedReleaseName, this.props(model));
        }
        return this.cachedReleaseName;
    }

    public String getEffectiveReleaseName() {
        return this.cachedReleaseName;
    }

    public String getResolvedRepoUrl(JReleaserModel model) {
        if (!this.releaseSupported) {
            return "";
        }
        return Templates.resolveTemplate((String)this.repoUrl, this.props(model));
    }

    public String getResolvedRepoCloneUrl(JReleaserModel model) {
        if (!this.releaseSupported) {
            return "";
        }
        return Templates.resolveTemplate((String)this.repoCloneUrl, this.props(model));
    }

    public String getResolvedRepoUrl(JReleaserModel model, String repoOwner, String repoName) {
        if (!this.releaseSupported) {
            return "";
        }
        Map<String, Object> props = this.props(model);
        props.put("repoOwner", repoOwner);
        props.put("repoName", repoName);
        return Templates.resolveTemplate((String)this.repoUrl, props);
    }

    public String getResolvedRepoCloneUrl(JReleaserModel model, String repoOwner, String repoName) {
        if (!this.releaseSupported) {
            return "";
        }
        Map<String, Object> props = this.props(model);
        props.put("repoOwner", repoOwner);
        props.put("repoName", repoName);
        return Templates.resolveTemplate((String)this.repoCloneUrl, props);
    }

    public String getResolvedCommitUrl(JReleaserModel model) {
        if (!this.releaseSupported) {
            return "";
        }
        return Templates.resolveTemplate((String)this.commitUrl, this.props(model));
    }

    public String getResolvedSrcUrl(JReleaserModel model) {
        if (!this.releaseSupported) {
            return "";
        }
        return Templates.resolveTemplate((String)this.srcUrl, this.props(model));
    }

    public String getResolvedDownloadUrl(JReleaserModel model) {
        if (!this.releaseSupported) {
            return "";
        }
        return Templates.resolveTemplate((String)this.downloadUrl, this.props(model));
    }

    public String getResolvedReleaseNotesUrl(JReleaserModel model) {
        if (!this.releaseSupported) {
            return "";
        }
        return Templates.resolveTemplate((String)this.releaseNotesUrl, this.props(model));
    }

    public String getResolvedLatestReleaseUrl(JReleaserModel model) {
        if (!this.releaseSupported) {
            return "";
        }
        return Templates.resolveTemplate((String)this.latestReleaseUrl, this.props(model));
    }

    public String getResolvedIssueTrackerUrl(JReleaserModel model) {
        if (!this.releaseSupported) {
            return "";
        }
        return Templates.resolveTemplate((String)this.issueTrackerUrl, this.props(model));
    }

    public boolean resolveUploadAssetsEnabled(Project project) {
        if (null == this.uploadAssets) {
            this.uploadAssets = Active.ALWAYS;
        }
        this.uploadAssetsEnabled = this.uploadAssets.check(project, this);
        return this.uploadAssetsEnabled;
    }

    public boolean isMatch() {
        return this.match;
    }

    public void setMatch(boolean match) {
        this.freezeCheck();
        this.match = match;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled != null && this.enabled != false;
    }

    @Override
    public void setEnabled(Boolean enabled) {
        this.freezeCheck();
        this.enabled = enabled;
    }

    @Override
    public boolean isEnabledSet() {
        return this.enabled != null;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.freezeCheck();
        this.host = host;
    }

    @Override
    public String getOwner() {
        return this.owner;
    }

    @Override
    public void setOwner(String owner) {
        this.freezeCheck();
        this.owner = owner;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.freezeCheck();
        this.name = name;
    }

    public String getRepoUrl() {
        return this.repoUrl;
    }

    public void setRepoUrl(String repoUrl) {
        this.freezeCheck();
        this.repoUrl = repoUrl;
    }

    public String getRepoCloneUrl() {
        return this.repoCloneUrl;
    }

    public void setRepoCloneUrl(String repoCloneUrl) {
        this.freezeCheck();
        this.repoCloneUrl = repoCloneUrl;
    }

    public String getCommitUrl() {
        return this.commitUrl;
    }

    public void setCommitUrl(String commitUrl) {
        this.freezeCheck();
        this.commitUrl = commitUrl;
    }

    public String getSrcUrl() {
        return this.srcUrl;
    }

    public void setSrcUrl(String srcUrl) {
        this.freezeCheck();
        this.srcUrl = srcUrl;
    }

    public String getDownloadUrl() {
        return this.downloadUrl;
    }

    public void setDownloadUrl(String downloadUrl) {
        this.freezeCheck();
        this.downloadUrl = downloadUrl;
    }

    public String getReleaseNotesUrl() {
        return this.releaseNotesUrl;
    }

    public void setReleaseNotesUrl(String releaseNotesUrl) {
        this.freezeCheck();
        this.releaseNotesUrl = releaseNotesUrl;
    }

    public String getLatestReleaseUrl() {
        return this.latestReleaseUrl;
    }

    public void setLatestReleaseUrl(String latestReleaseUrl) {
        this.freezeCheck();
        this.latestReleaseUrl = latestReleaseUrl;
    }

    public String getIssueTrackerUrl() {
        return this.issueTrackerUrl;
    }

    public void setIssueTrackerUrl(String issueTrackerUrl) {
        this.freezeCheck();
        this.issueTrackerUrl = issueTrackerUrl;
    }

    public String getResolvedToken() {
        return Env.env((String)(Env.toVar((String)this.getServiceName()) + "_TOKEN"), (String)this.token);
    }

    public String getResolvedUsername() {
        return Env.env((String)(Env.toVar((String)this.getServiceName()) + "_USERNAME"), (String)this.username);
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.freezeCheck();
        this.username = username;
    }

    public String getToken() {
        return this.token;
    }

    public void setToken(String token) {
        this.freezeCheck();
        this.token = token;
    }

    public String getTagName() {
        return this.tagName;
    }

    public void setTagName(String tagName) {
        this.freezeCheck();
        this.tagName = tagName;
    }

    public String getPreviousTagName() {
        return this.previousTagName;
    }

    public void setPreviousTagName(String previousTagName) {
        this.freezeCheck();
        this.previousTagName = previousTagName;
    }

    public String getReleaseName() {
        return this.releaseName;
    }

    public void setReleaseName(String releaseName) {
        this.freezeCheck();
        this.releaseName = releaseName;
    }

    public String getBranch() {
        return this.branch;
    }

    public void setBranch(String branch) {
        this.freezeCheck();
        this.branch = branch;
    }

    @Override
    public CommitAuthor getCommitAuthor() {
        return this.commitAuthor;
    }

    @Override
    public void setCommitAuthor(CommitAuthor commitAuthor) {
        this.commitAuthor.merge(commitAuthor);
    }

    public Prerelease getPrerelease() {
        return this.prerelease;
    }

    public void setPrerelease(Prerelease prerelease) {
        this.prerelease.merge(prerelease);
    }

    public boolean isSign() {
        return this.sign != null && this.sign != false;
    }

    public void setSign(Boolean sign) {
        this.freezeCheck();
        this.sign = sign;
    }

    public Changelog getChangelog() {
        return this.changelog;
    }

    public void setChangelog(Changelog changelog) {
        this.changelog.merge(changelog);
    }

    public Milestone getMilestone() {
        return this.milestone;
    }

    public void setMilestone(Milestone milestone) {
        this.milestone.merge(milestone);
    }

    public boolean isSkipTag() {
        return this.skipTag != null && this.skipTag != false;
    }

    public void setSkipTag(Boolean skipTag) {
        this.freezeCheck();
        this.skipTag = skipTag;
    }

    public boolean isSkipTagSet() {
        return this.skipTag != null;
    }

    public boolean isSkipRelease() {
        return this.skipRelease != null && this.skipRelease != false;
    }

    public void setSkipRelease(Boolean skipRelease) {
        this.freezeCheck();
        this.skipRelease = skipRelease;
    }

    public boolean isSkipReleaseSet() {
        return this.skipRelease != null;
    }

    public boolean isOverwrite() {
        return this.overwrite != null && this.overwrite != false;
    }

    public void setOverwrite(Boolean overwrite) {
        this.freezeCheck();
        this.overwrite = overwrite;
    }

    public boolean isOverwriteSet() {
        return this.overwrite != null;
    }

    public Update getUpdate() {
        return this.update;
    }

    public void setUpdate(Update update) {
        this.update.merge(update);
    }

    public String getApiEndpoint() {
        return this.apiEndpoint;
    }

    public void setApiEndpoint(String apiEndpoint) {
        this.freezeCheck();
        this.apiEndpoint = apiEndpoint;
    }

    @Override
    public Integer getConnectTimeout() {
        return this.connectTimeout;
    }

    @Override
    public void setConnectTimeout(Integer connectTimeout) {
        this.freezeCheck();
        this.connectTimeout = connectTimeout;
    }

    @Override
    public Integer getReadTimeout() {
        return this.readTimeout;
    }

    @Override
    public void setReadTimeout(Integer readTimeout) {
        this.freezeCheck();
        this.readTimeout = readTimeout;
    }

    public boolean isArtifactsSet() {
        return this.artifacts != null;
    }

    public Boolean isArtifacts() {
        return this.artifacts == null || this.artifacts != false;
    }

    public void setArtifacts(Boolean artifacts) {
        this.freezeCheck();
        this.artifacts = artifacts;
    }

    public Boolean isFiles() {
        return this.files == null || this.files != false;
    }

    public boolean isFilesSet() {
        return this.files != null;
    }

    public void setFiles(Boolean files) {
        this.freezeCheck();
        this.files = files;
    }

    public boolean isChecksumsSet() {
        return this.checksums != null;
    }

    public Boolean isChecksums() {
        return this.checksums == null || this.checksums != false;
    }

    public void setChecksums(Boolean checksums) {
        this.freezeCheck();
        this.checksums = checksums;
    }

    public boolean isSignaturesSet() {
        return this.signatures != null;
    }

    public Boolean isSignatures() {
        return this.signatures == null || this.signatures != false;
    }

    public void setSignatures(Boolean signatures) {
        this.freezeCheck();
        this.signatures = signatures;
    }

    public Active getUploadAssets() {
        return this.uploadAssets;
    }

    public void setUploadAssets(Active uploadAssets) {
        this.freezeCheck();
        this.uploadAssets = uploadAssets;
    }

    public void setUploadAssets(String str) {
        this.setUploadAssets(Active.of(str));
    }

    public boolean isUploadAssetsSet() {
        return this.uploadAssets != null;
    }

    @Override
    public Map<String, Object> asMap(boolean full) {
        LinkedHashMap<String, Object> props = new LinkedHashMap<String, Object>();
        props.put("enabled", this.isEnabled());
        props.put("host", this.host);
        props.put("owner", this.owner);
        props.put("name", this.name);
        props.put("username", this.username);
        props.put("token", StringUtils.isNotBlank((String)this.getResolvedToken()) ? "************" : "**unset**");
        if (this.releaseSupported) {
            props.put("uploadAssets", (Object)this.uploadAssets);
            props.put("artifacts", this.isArtifacts());
            props.put("files", this.isFiles());
            props.put("checksums", this.isChecksums());
            props.put("signatures", this.isSignatures());
            props.put("repoUrl", this.repoUrl);
            props.put("repoCloneUrl", this.repoCloneUrl);
            props.put("commitUrl", this.commitUrl);
            props.put("srcUrl", this.srcUrl);
            props.put("downloadUrl", this.downloadUrl);
            props.put("releaseNotesUrl", this.releaseNotesUrl);
            props.put("latestReleaseUrl", this.latestReleaseUrl);
            props.put("issueTrackerUrl", this.issueTrackerUrl);
        }
        props.put("tagName", this.tagName);
        if (this.releaseSupported) {
            props.put("releaseName", this.releaseName);
        }
        props.put("branch", this.branch);
        props.put("commitAuthor", this.commitAuthor.asMap(full));
        props.put("sign", this.isSign());
        props.put("skipTag", this.isSkipTag());
        props.put(KEY_SKIP_RELEASE, this.isSkipRelease());
        props.put("overwrite", this.isOverwrite());
        if (this.releaseSupported) {
            props.put("update", this.update.asMap(full));
            props.put("apiEndpoint", this.apiEndpoint);
            props.put("connectTimeout", this.connectTimeout);
            props.put("readTimeout", this.readTimeout);
        }
        props.put("changelog", this.changelog.asMap(full));
        if (this.releaseSupported) {
            props.put("milestone", this.milestone.asMap(full));
        }
        props.put("prerelease", this.prerelease.asMap(full));
        return props;
    }

    public Map<String, Object> props(JReleaserModel model) {
        LinkedHashMap<String, Object> props = new LinkedHashMap<String, Object>();
        Project project = model.getProject();
        props.putAll(model.getEnvironment().getProperties());
        props.putAll(model.getEnvironment().getSourcedProperties());
        props.put("projectName", project.getName());
        props.put("projectNameCapitalized", StringUtils.getClassNameForLowerCaseHyphenSeparatedName((String)project.getName()));
        props.put("projectVersion", project.getVersion());
        props.put("projectStereotype", (Object)project.getStereotype());
        props.put("projectEffectiveVersion", project.getEffectiveVersion());
        props.put("projectSnapshot", String.valueOf(project.isSnapshot()));
        if (StringUtils.isNotBlank((String)project.getDescription())) {
            props.put("projectDescription", MustacheUtils.passThrough((String)project.getDescription()));
        }
        if (StringUtils.isNotBlank((String)project.getLongDescription())) {
            props.put("projectLongDescription", MustacheUtils.passThrough((String)project.getLongDescription()));
        }
        if (StringUtils.isNotBlank((String)project.getLicense())) {
            props.put("projectLicense", project.getLicense());
        }
        if (null != project.getInceptionYear()) {
            props.put("projectInceptionYear", project.getInceptionYear());
        }
        if (StringUtils.isNotBlank((String)project.getCopyright())) {
            props.put("projectCopyright", project.getCopyright());
        }
        if (StringUtils.isNotBlank((String)project.getVendor())) {
            props.put("projectVendor", project.getVendor());
        }
        project.getLinks().fillProps(props);
        if (project.getJava().isEnabled()) {
            props.putAll(project.getJava().getResolvedExtraProperties());
            props.put("projectJavaGroupId", project.getJava().getGroupId());
            props.put("projectJavaArtifactId", project.getJava().getArtifactId());
            props.put("projectJavaVersion", project.getJava().getVersion());
            props.put("projectJavaMainClass", project.getJava().getMainClass());
            SemVer jv = SemVer.of((String)project.getJava().getVersion());
            props.put("projectJavaVersionMajor", jv.getMajor());
            if (jv.hasMinor()) {
                props.put("projectJavaVersionMinor", jv.getMinor());
            }
            if (jv.hasPatch()) {
                props.put("projectJavaVersionPatch", jv.getPatch());
            }
            if (jv.hasTag()) {
                props.put("projectJavaVersionTag", jv.getTag());
            }
            if (jv.hasBuild()) {
                props.put("projectJavaVersionBuild", jv.getBuild());
            }
        }
        project.parseVersion();
        props.putAll(project.getResolvedExtraProperties());
        String osName = PlatformUtils.getDetectedOs();
        String osArch = PlatformUtils.getDetectedArch();
        props.put("osName", osName);
        props.put("osArch", osArch);
        props.put("osVersion", PlatformUtils.getDetectedVersion());
        props.put("osPlatform", PlatformUtils.getCurrentFull());
        props.put("osPlatformReplaced", model.getPlatform().applyReplacements(PlatformUtils.getCurrentFull()));
        props.put("repoHost", this.host);
        props.put("repoOwner", this.owner);
        props.put("repoName", this.name);
        props.put("repoBranch", this.branch);
        props.put("reverseRepoHost", this.getReverseRepoHost());
        props.put("repoCanonicalName", this.getCanonicalRepoName());
        props.put("tagName", project.isSnapshot() ? project.getSnapshot().getResolvedLabel(model) : this.cachedTagName);
        props.put("releaseName", this.cachedReleaseName);
        props.put("milestoneName", this.milestone.getEffectiveName());
        MustacheUtils.applyTemplates(props, project.getResolvedExtraProperties());
        props.put("__ZonedDateTime_now__", model.getNow());
        MustacheUtils.applyFunctions(props);
        return props;
    }

    public void fillProps(Map<String, Object> props, JReleaserModel model) {
        props.put("repoHost", this.host);
        props.put("repoOwner", this.owner);
        props.put("repoName", this.name);
        props.put("repoBranch", this.branch);
        props.put("reverseRepoHost", this.getReverseRepoHost());
        props.put("repoCanonicalName", this.getCanonicalRepoName());
        props.put("tagName", this.getEffectiveTagName(model));
        props.put("releaseName", this.getEffectiveReleaseName());
        props.put("milestoneName", this.milestone.getEffectiveName());
        props.put("repoUrl", this.getResolvedRepoUrl(model));
        props.put("repoCloneUrl", this.getResolvedRepoCloneUrl(model));
        props.put("commitsUrl", this.getResolvedCommitUrl(model));
        props.put("srcUrl", this.getResolvedSrcUrl(model));
        props.put("releaseNotesUrl", this.getResolvedReleaseNotesUrl(model));
        props.put("latestReleaseUrl", this.getResolvedLatestReleaseUrl(model));
        props.put("issueTrackerUrl", this.getResolvedIssueTrackerUrl(model));
    }

    public static class Milestone
    extends AbstractModelObject<Milestone>
    implements Domain {
        public static final String MILESTONE_NAME = "MILESTONE_NAME";
        private Boolean close;
        private String name;
        @JsonIgnore
        private String cachedName;

        @Override
        public void merge(Milestone milestone) {
            this.freezeCheck();
            this.close = this.merge(this.close, milestone.close);
            this.name = this.merge(this.name, milestone.name);
        }

        public String getConfiguredName() {
            return Env.env((String)MILESTONE_NAME, (String)this.cachedName);
        }

        public String getResolvedName(Map<String, Object> props) {
            if (StringUtils.isBlank((String)this.cachedName)) {
                this.cachedName = this.getConfiguredName();
            }
            if (StringUtils.isBlank((String)this.cachedName)) {
                this.cachedName = Templates.resolveTemplate((String)this.name, props);
            } else if (this.cachedName.contains("{{")) {
                this.cachedName = Templates.resolveTemplate((String)this.cachedName, props);
            }
            return this.cachedName;
        }

        public String getEffectiveName() {
            return this.cachedName;
        }

        public Boolean isClose() {
            return this.close == null || this.close != false;
        }

        public void setClose(Boolean close) {
            this.freezeCheck();
            this.close = close;
        }

        public boolean isCloseSet() {
            return this.close != null;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.freezeCheck();
            this.name = name;
        }

        @Override
        public Map<String, Object> asMap(boolean full) {
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            map.put("name", this.name);
            map.put("close", this.isClose());
            return map;
        }
    }

    public static class Prerelease
    extends AbstractModelObject<Prerelease>
    implements Domain {
        private Boolean enabled;
        private String pattern;

        @Override
        public void merge(Prerelease prerelease) {
            this.freezeCheck();
            this.enabled = this.merge(this.enabled, prerelease.enabled);
            this.pattern = this.merge(this.pattern, prerelease.pattern);
        }

        public void disable() {
            this.enabled = false;
        }

        public boolean isEnabled() {
            return this.enabled != null && this.enabled != false;
        }

        public void setEnabled(Boolean enabled) {
            this.freezeCheck();
            this.enabled = enabled;
        }

        public boolean isPrerelease(String version) {
            if (null == this.enabled) {
                String configuredPattern = this.getConfiguredPattern();
                this.enabled = StringUtils.isNotBlank((String)configuredPattern) ? Boolean.valueOf(version.matches(configuredPattern)) : Boolean.valueOf(false);
            }
            return this.enabled;
        }

        public String getConfiguredPattern() {
            return Env.env((String)GitService.PRERELEASE_PATTERN, (String)this.pattern);
        }

        public String getPattern() {
            return this.pattern;
        }

        public void setPattern(String pattern) {
            this.freezeCheck();
            this.pattern = pattern;
        }

        @Override
        public Map<String, Object> asMap(boolean full) {
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            map.put("enabled", this.isEnabled());
            map.put("pattern", this.getConfiguredPattern());
            return map;
        }
    }

    public static class Update
    extends AbstractModelObject<Update>
    implements Domain {
        private final Set<UpdateSection> sections = new LinkedHashSet<UpdateSection>();
        private Boolean enabled;

        @Override
        public void merge(Update update) {
            this.freezeCheck();
            this.enabled = this.merge(this.enabled, update.enabled);
            this.setSections(this.merge(this.sections, update.sections));
        }

        public boolean isEnabled() {
            return this.enabled != null && this.enabled != false;
        }

        public void setEnabled(Boolean enabled) {
            this.freezeCheck();
            this.enabled = enabled;
        }

        public boolean isEnabledSet() {
            return this.enabled != null;
        }

        public Set<UpdateSection> getSections() {
            return this.freezeWrap(this.sections);
        }

        public void setSections(Set<UpdateSection> sections) {
            this.freezeCheck();
            this.sections.clear();
            this.sections.addAll(sections);
        }

        @Override
        public Map<String, Object> asMap(boolean full) {
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            map.put("enabled", this.isEnabled());
            map.put("sections", this.sections);
            return map;
        }
    }
}

