/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.tools;

import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.Scanner;
import org.jreleaser.model.Distribution;
import org.jreleaser.model.JReleaserContext;
import org.jreleaser.model.Project;
import org.jreleaser.model.TemplateTool;
import org.jreleaser.model.tool.spi.ToolProcessingException;
import org.jreleaser.templates.TemplateUtils;
import org.jreleaser.tools.AbstractToolProcessor;
import org.jreleaser.util.FileUtils;
import org.jreleaser.util.JReleaserLogger;
import org.jreleaser.util.MustacheUtils;

abstract class AbstractTemplateToolProcessor<T extends TemplateTool>
extends AbstractToolProcessor<T> {
    protected AbstractTemplateToolProcessor(JReleaserContext context) {
        super(context);
    }

    @Override
    protected void doPrepareDistribution(Distribution distribution, Map<String, Object> props) throws ToolProcessingException {
        try {
            this.doPrepareDistribution(distribution, props, distribution.getName(), this.getPrepareDirectory(props), ((TemplateTool)this.getTool()).getTemplateDirectory(), this.getToolName());
        }
        catch (IOException e) {
            throw new ToolProcessingException((Throwable)e);
        }
    }

    protected void doPrepareDistribution(Distribution distribution, Map<String, Object> props, String distributionName, Path prepareDirectory, String templateDirectory, String toolName) throws IOException, ToolProcessingException {
        FileUtils.deleteFiles((Path)prepareDirectory);
        Files.createDirectories(prepareDirectory, new FileAttribute[0]);
        this.context.getLogger().debug("resolving templates for {}/{}", new Object[]{distributionName, toolName});
        Map templates = TemplateUtils.resolveAndMergeTemplates((JReleaserLogger)this.context.getLogger(), (String)distribution.getType().name(), (String)this.getToolName(), (boolean)this.context.getModel().getProject().isSnapshot(), (Path)this.context.getBasedir().resolve(templateDirectory));
        for (Map.Entry entry : templates.entrySet()) {
            String filename = (String)entry.getKey();
            if (filename.endsWith(".tpl")) {
                this.context.getLogger().debug("evaluating template {} for {}/{}", new Object[]{filename, distributionName, toolName});
                String content = MustacheUtils.applyTemplate((Reader)((Reader)entry.getValue()), props);
                this.context.getLogger().debug("writing template {} for {}/{}", new Object[]{filename, distributionName, toolName});
                this.writeFile(this.context.getModel().getProject(), distribution, content, props, prepareDirectory, filename);
                continue;
            }
            this.context.getLogger().debug("writing file {} for {}/{}", new Object[]{filename, distributionName, toolName});
            this.writeFile((Reader)entry.getValue(), prepareDirectory.resolve(filename));
        }
        this.context.getLogger().debug("copying license files");
        FileUtils.copyFiles((JReleaserLogger)this.context.getLogger(), (Path)this.context.getBasedir(), (Path)prepareDirectory, path -> path.getFileName().startsWith("LICENSE"));
    }

    @Override
    protected void doPackageDistribution(Distribution distribution, Map<String, Object> props) throws ToolProcessingException {
        this.doPackageDistribution(distribution, props, this.getPackageDirectory(props));
    }

    protected void doPackageDistribution(Distribution distribution, Map<String, Object> props, Path packageDirectory) throws ToolProcessingException {
        try {
            FileUtils.deleteFiles((Path)packageDirectory);
            Files.createDirectories(packageDirectory, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new ToolProcessingException((Throwable)e);
        }
    }

    protected abstract void writeFile(Project var1, Distribution var2, String var3, Map<String, Object> var4, Path var5, String var6) throws ToolProcessingException;

    protected void writeFile(Reader reader, Path outputFile) throws ToolProcessingException {
        try {
            FileUtils.createDirectoriesWithFullAccess((Path)outputFile.getParent());
            Scanner scanner = new Scanner(reader);
            scanner.useDelimiter("\\Z");
            Files.write(outputFile, scanner.next().getBytes(), StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING);
            scanner.close();
            FileUtils.grantFullAccess((Path)outputFile);
        }
        catch (IOException e) {
            throw new ToolProcessingException("Unexpected error when writing to " + outputFile.toAbsolutePath(), (Throwable)e);
        }
    }

    protected void writeFile(String content, Path outputFile) throws ToolProcessingException {
        try {
            FileUtils.createDirectoriesWithFullAccess((Path)outputFile.getParent());
            Files.write(outputFile, content.getBytes(), StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING);
            FileUtils.grantFullAccess((Path)outputFile);
        }
        catch (IOException e) {
            throw new ToolProcessingException("Unexpected error when writing to " + outputFile.toAbsolutePath(), (Throwable)e);
        }
    }
}

