/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.tools;

import java.io.IOException;
import java.nio.file.Path;
import java.util.Map;
import org.jreleaser.model.Chocolatey;
import org.jreleaser.model.Distribution;
import org.jreleaser.model.GitService;
import org.jreleaser.model.JReleaserContext;
import org.jreleaser.model.Project;
import org.jreleaser.model.tool.spi.ToolProcessingException;
import org.jreleaser.templates.TemplateUtils;
import org.jreleaser.tools.AbstractRepositoryToolProcessor;
import org.jreleaser.util.PlatformUtils;

public class ChocolateyToolProcessor
extends AbstractRepositoryToolProcessor<Chocolatey> {
    public ChocolateyToolProcessor(JReleaserContext context) {
        super(context);
    }

    @Override
    protected void doPackageDistribution(Distribution distribution, Map<String, Object> props, Path packageDirectory) throws ToolProcessingException {
        super.doPackageDistribution(distribution, props, packageDirectory);
        if (((Chocolatey)this.tool).isRemoteBuild().booleanValue()) {
            this.copyPreparedFiles(distribution, props);
            return;
        }
        if (!PlatformUtils.isWindows()) {
            this.context.getLogger().debug("must run on Windows", new Object[]{this.getToolName()});
            return;
        }
        this.copyPreparedFiles(distribution, props);
        this.createChocolateyPackage(distribution, props);
    }

    @Override
    protected void prepareWorkingCopy(Map<String, Object> props, Path directory, Distribution distribution) throws ToolProcessingException, IOException {
        super.prepareWorkingCopy(props, directory.resolve(distribution.getName()), distribution);
    }

    @Override
    protected void doPublishDistribution(Distribution distribution, Map<String, Object> props) throws ToolProcessingException {
        if (((Chocolatey)this.tool).isRemoteBuild().booleanValue()) {
            super.doPublishDistribution(distribution, props);
            return;
        }
        this.publishChocolateyPackage(distribution, props);
    }

    @Override
    protected void fillToolProperties(Map<String, Object> props, Distribution distribution) throws ToolProcessingException {
        GitService gitService = this.context.getModel().getRelease().getGitService();
        props.put("chocolateyBucketRepoUrl", gitService.getResolvedRepoUrl(this.context.getModel(), ((Chocolatey)this.tool).getBucket().getOwner(), ((Chocolatey)this.tool).getBucket().getName()));
        props.put("chocolateyBucketRepoCloneUrl", gitService.getResolvedRepoCloneUrl(this.context.getModel(), ((Chocolatey)this.tool).getBucket().getOwner(), ((Chocolatey)this.tool).getBucket().getName()));
        props.put("chocolateyUsername", ((Chocolatey)this.getTool()).getUsername());
    }

    @Override
    protected void writeFile(Project project, Distribution distribution, String content, Map<String, Object> props, Path outputDirectory, String fileName) throws ToolProcessingException {
        Path outputFile = "binary.nuspec".equals(fileName = TemplateUtils.trimTplExtension((String)fileName)) ? outputDirectory.resolve(distribution.getExecutable().concat(".nuspec")) : outputDirectory.resolve(fileName);
        this.writeFile(content, outputFile);
    }

    private void createChocolateyPackage(Distribution distribution, Map<String, Object> props) {
        this.context.getLogger().warn("local build is not yet supported.");
    }

    private void publishChocolateyPackage(Distribution distribution, Map<String, Object> props) {
        this.context.getLogger().warn("local publication is not yet supported.");
    }
}

