/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.packagers;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.Artifact;
import org.jreleaser.model.Distribution;
import org.jreleaser.model.JReleaserContext;
import org.jreleaser.model.Packager;
import org.jreleaser.model.packager.spi.PackagerProcessingException;
import org.jreleaser.model.packager.spi.PackagerProcessor;
import org.jreleaser.model.util.Artifacts;
import org.jreleaser.util.Algorithm;
import org.jreleaser.util.FileType;
import org.jreleaser.util.FileUtils;
import org.jreleaser.util.JReleaserLogger;
import org.jreleaser.util.MustacheUtils;
import org.jreleaser.util.StringUtils;
import org.jreleaser.util.command.Command;
import org.jreleaser.util.command.CommandException;
import org.jreleaser.util.command.CommandExecutor;

abstract class AbstractPackagerProcessor<T extends Packager>
implements PackagerProcessor<T> {
    private static final String ARTIFACT = "artifact";
    private static final String DISTRIBUTION = "distribution";
    private static final String NAME = "Name";
    private static final String VERSION = "Version";
    private static final String OS = "Os";
    private static final String ARCH = "Arch";
    private static final String FILE = "File";
    private static final String SIZE = "Size";
    private static final String FILE_NAME = "FileName";
    private static final String FILE_EXTENSION = "FileExtension";
    private static final String FILE_FORMAT = "FileFormat";
    private static final String CHECKSUM = "Checksum";
    private static final String URL = "Url";
    protected final JReleaserContext context;
    protected T packager;

    protected AbstractPackagerProcessor(JReleaserContext context) {
        this.context = context;
    }

    public T getPackager() {
        return this.packager;
    }

    public void setPackager(T packager) {
        this.packager = packager;
    }

    public String getPackagerName() {
        return this.packager.getType();
    }

    public boolean supportsDistribution(Distribution distribution) {
        return true;
    }

    public void prepareDistribution(Distribution distribution, Map<String, Object> props) throws PackagerProcessingException {
        try {
            String distributionName = distribution.getName();
            this.context.getLogger().debug(RB.$((String)"packager.create.properties", (Object[])new Object[0]), new Object[]{distributionName, this.getPackagerName()});
            Map<String, Object> newProps = this.fillProps(distribution, props);
            if (newProps.isEmpty()) {
                this.context.getLogger().warn(RB.$((String)"packager.skip.distribution", (Object[])new Object[0]), new Object[]{distributionName});
                return;
            }
            this.doPrepareDistribution(distribution, newProps);
        }
        catch (RuntimeException e) {
            throw new PackagerProcessingException((Throwable)e);
        }
    }

    protected abstract void doPrepareDistribution(Distribution var1, Map<String, Object> var2) throws PackagerProcessingException;

    public void packageDistribution(Distribution distribution, Map<String, Object> props) throws PackagerProcessingException {
        try {
            String distributionName = distribution.getName();
            this.context.getLogger().debug(RB.$((String)"packager.create.properties", (Object[])new Object[0]), new Object[]{distributionName, this.getPackagerName()});
            Map<String, Object> newProps = this.fillProps(distribution, props);
            if (newProps.isEmpty()) {
                this.context.getLogger().warn(RB.$((String)"packager.skip.distribution", (Object[])new Object[0]), new Object[]{distributionName});
                return;
            }
            this.doPackageDistribution(distribution, newProps);
        }
        catch (IllegalArgumentException e) {
            throw new PackagerProcessingException((Throwable)e);
        }
    }

    public void publishDistribution(Distribution distribution, Map<String, Object> props) throws PackagerProcessingException {
        if (this.context.getModel().getProject().isSnapshot() && !this.packager.isSnapshotSupported()) {
            this.context.getLogger().info(RB.$((String)"packager.publish.snapshot.not.supported", (Object[])new Object[0]));
            return;
        }
        try {
            String distributionName = distribution.getName();
            this.context.getLogger().debug(RB.$((String)"packager.create.properties", (Object[])new Object[0]), new Object[]{distributionName, this.getPackagerName()});
            Map<String, Object> newProps = this.fillProps(distribution, props);
            if (newProps.isEmpty()) {
                this.context.getLogger().warn(RB.$((String)"packager.skip.distribution", (Object[])new Object[0]), new Object[]{distributionName});
                return;
            }
            this.doPublishDistribution(distribution, newProps);
        }
        catch (IllegalArgumentException e) {
            throw new PackagerProcessingException((Throwable)e);
        }
    }

    protected abstract void doPackageDistribution(Distribution var1, Map<String, Object> var2) throws PackagerProcessingException;

    protected abstract void doPublishDistribution(Distribution var1, Map<String, Object> var2) throws PackagerProcessingException;

    protected Map<String, Object> fillProps(Distribution distribution, Map<String, Object> props) throws PackagerProcessingException {
        LinkedHashMap<String, Object> newProps = new LinkedHashMap<String, Object>(props);
        this.context.getLogger().debug(RB.$((String)"packager.fill.distribution.properties", (Object[])new Object[0]));
        this.fillDistributionProperties(newProps, distribution);
        this.context.getLogger().debug(RB.$((String)"packager.fill.git.properties", (Object[])new Object[0]));
        this.context.getModel().getRelease().getGitService().fillProps(newProps, this.context.getModel());
        this.context.getLogger().debug(RB.$((String)"packager.fill.artifact.properties", (Object[])new Object[0]));
        if (!this.verifyAndAddArtifacts(newProps, distribution)) {
            return Collections.emptyMap();
        }
        this.context.getLogger().debug(RB.$((String)"packager.fill.packager.properties", (Object[])new Object[0]));
        this.fillPackagerProperties(newProps, distribution);
        MustacheUtils.applyTemplates(newProps, (Map)this.packager.getResolvedExtraProperties());
        if (StringUtils.isBlank((String)this.context.getModel().getRelease().getGitService().getReverseRepoHost())) {
            newProps.put("reverseRepoHost", this.packager.getExtraProperties().get("reverseRepoHost"));
        }
        MustacheUtils.applyTemplates(newProps, newProps);
        return newProps;
    }

    protected void fillDistributionProperties(Map<String, Object> props, Distribution distribution) {
        props.putAll(distribution.props());
    }

    protected abstract void fillPackagerProperties(Map<String, Object> var1, Distribution var2) throws PackagerProcessingException;

    protected void executeCommand(Path directory, Command command) throws PackagerProcessingException {
        try {
            int exitValue = new CommandExecutor(this.context.getLogger()).executeCommand(directory, command);
            if (exitValue != 0) {
                throw new CommandException(RB.$((String)"ERROR_command_execution_exit_value", (Object[])new Object[]{exitValue}));
            }
        }
        catch (CommandException e) {
            throw new PackagerProcessingException(RB.$((String)"ERROR_unexpected_error", (Object[])new Object[0]), (Throwable)e);
        }
    }

    protected void executeCommand(Command command) throws PackagerProcessingException {
        try {
            int exitValue = new CommandExecutor(this.context.getLogger()).executeCommand(command);
            if (exitValue != 0) {
                throw new CommandException(RB.$((String)"ERROR_command_execution_exit_value", (Object[])new Object[]{exitValue}));
            }
        }
        catch (CommandException e) {
            throw new PackagerProcessingException(RB.$((String)"ERROR_unexpected_error", (Object[])new Object[0]), (Throwable)e);
        }
    }

    protected void executeCommandCapturing(Command command, OutputStream out) throws PackagerProcessingException {
        try {
            int exitValue = new CommandExecutor(this.context.getLogger()).executeCommandCapturing(command, out);
            if (exitValue != 0) {
                this.context.getLogger().error(out.toString().trim());
                throw new CommandException(RB.$((String)"ERROR_command_execution_exit_value", (Object[])new Object[]{exitValue}));
            }
        }
        catch (CommandException e) {
            throw new PackagerProcessingException(RB.$((String)"ERROR_unexpected_error", (Object[])new Object[0]), (Throwable)e);
        }
    }

    protected void executeCommandWithInput(Command command, InputStream in) throws PackagerProcessingException {
        try {
            int exitValue = new CommandExecutor(this.context.getLogger()).executeCommandWithInput(command, in);
            if (exitValue != 0) {
                throw new CommandException(RB.$((String)"ERROR_command_execution_exit_value", (Object[])new Object[]{exitValue}));
            }
        }
        catch (CommandException e) {
            throw new PackagerProcessingException(RB.$((String)"ERROR_unexpected_error", (Object[])new Object[0]), (Throwable)e);
        }
    }

    protected void copyPreparedFiles(Distribution distribution, Map<String, Object> props) throws PackagerProcessingException {
        Path prepareDirectory = this.getPrepareDirectory(props);
        Path packageDirectory = this.getPackageDirectory(props);
        this.copyFiles(prepareDirectory, packageDirectory);
    }

    protected void copyFiles(Path src, Path dest) throws PackagerProcessingException {
        try {
            if (!Files.exists(dest, new LinkOption[0])) {
                Files.createDirectories(dest, new FileAttribute[0]);
            }
            if (!FileUtils.copyFilesRecursive((JReleaserLogger)this.context.getLogger(), (Path)src, (Path)dest)) {
                throw new PackagerProcessingException(RB.$((String)"ERROR_copy_files_from_to", (Object[])new Object[]{this.context.relativizeToBasedir(src), this.context.relativizeToBasedir(dest)}));
            }
        }
        catch (IOException e) {
            throw new PackagerProcessingException(RB.$((String)"ERROR_unexpected_copy_files_from_to", (Object[])new Object[]{this.context.relativizeToBasedir(src), this.context.relativizeToBasedir(dest)}), (Throwable)e);
        }
    }

    protected boolean verifyAndAddArtifacts(Map<String, Object> props, Distribution distribution) throws PackagerProcessingException {
        return this.verifyAndAddArtifacts(props, distribution, this.collectArtifacts(distribution));
    }

    protected boolean verifyAndAddArtifacts(Map<String, Object> props, Distribution distribution, List<Artifact> artifacts) throws PackagerProcessingException {
        List activeArtifacts = artifacts.stream().filter(Artifact::isActive).collect(Collectors.toList());
        if (activeArtifacts.size() == 0) {
            this.context.getLogger().warn(RB.$((String)"packager.no.matching.artifacts", (Object[])new Object[0]), new Object[]{distribution.getName(), StringUtils.capitalize((String)this.packager.getType())});
            return false;
        }
        int count = 0;
        for (Artifact artifact : activeArtifacts) {
            String artifactUrl = Artifacts.resolveDownloadUrl((JReleaserContext)this.context, (String)this.packager.getType(), (Distribution)distribution, (Artifact)artifact);
            if (StringUtils.isBlank((String)artifactUrl)) continue;
            ++count;
            String platform = artifact.getPlatform();
            String artifactPlatform = StringUtils.isNotBlank((String)platform) ? StringUtils.capitalize((String)platform) : "";
            String platformReplaced = distribution.getPlatform().applyReplacements(platform);
            String artifactPlatformReplaced = StringUtils.isNotBlank((String)platformReplaced) ? StringUtils.capitalize((String)platformReplaced) : "";
            Map artifactProps = artifact.getResolvedExtraProperties(ARTIFACT + artifactPlatform);
            artifactProps.keySet().stream().filter(k -> !props.containsKey(k)).forEach(k -> props.put((String)k, artifactProps.get(k)));
            Path artifactPath = artifact.getEffectivePath(this.context, distribution);
            long artifactSize = 0L;
            try {
                artifactSize = Files.size(artifactPath);
            }
            catch (IOException ignored) {
                this.context.getLogger().trace((Throwable)ignored);
            }
            String artifactFile = artifact.getEffectivePath().getFileName().toString();
            String artifactFileName = StringUtils.getFilename((String)artifactFile, (Collection)FileType.getSupportedExtensions());
            String artifactFileExtension = artifactFile.substring(artifactFileName.length());
            String artifactFileFormat = artifactFileExtension.substring(1);
            String artifactName = "";
            String artifactVersion = "";
            String projectVersion = this.context.getModel().getProject().getEffectiveVersion();
            if (StringUtils.isNotBlank((String)projectVersion) && artifactFileName.contains(projectVersion)) {
                artifactName = artifactFileName.substring(0, artifactFileName.indexOf(projectVersion));
                if (artifactName.endsWith("-")) {
                    artifactName = artifactName.substring(0, artifactName.length() - 1);
                }
                artifactVersion = projectVersion;
            }
            projectVersion = this.context.getModel().getProject().getVersion();
            if (StringUtils.isBlank((String)artifactName) && StringUtils.isNotBlank((String)projectVersion) && artifactFileName.contains(projectVersion)) {
                artifactName = artifactFileName.substring(0, artifactFileName.indexOf(projectVersion));
                if (artifactName.endsWith("-")) {
                    artifactName = artifactName.substring(0, artifactName.length() - 1);
                }
                artifactVersion = projectVersion;
            }
            String artifactOs = "";
            String artifactArch = "";
            if (StringUtils.isNotBlank((String)platform) && platform.contains("-")) {
                String[] parts = platform.split("-");
                artifactOs = parts[0];
                artifactArch = parts[1];
            }
            this.safePut(props, ARTIFACT + artifactPlatform + NAME, artifactName);
            this.safePut(props, ARTIFACT + artifactPlatform + VERSION, artifactVersion);
            this.safePut(props, ARTIFACT + artifactPlatform + OS, artifactOs);
            this.safePut(props, ARTIFACT + artifactPlatform + ARCH, artifactArch);
            this.safePut(props, ARTIFACT + artifactPlatform + FILE, artifactFile);
            this.safePut(props, ARTIFACT + artifactPlatform + SIZE, artifactSize);
            this.safePut(props, ARTIFACT + artifactPlatform + FILE_NAME, artifactFileName);
            this.safePut(props, ARTIFACT + artifactPlatform + FILE_EXTENSION, artifactFileExtension);
            this.safePut(props, ARTIFACT + artifactPlatform + FILE_FORMAT, artifactFileFormat);
            this.safePut(props, ARTIFACT + artifactPlatformReplaced + NAME, artifactName);
            this.safePut(props, ARTIFACT + artifactPlatformReplaced + VERSION, artifactVersion);
            this.safePut(props, ARTIFACT + artifactPlatformReplaced + OS, artifactOs);
            this.safePut(props, ARTIFACT + artifactPlatformReplaced + ARCH, artifactArch);
            this.safePut(props, ARTIFACT + artifactPlatformReplaced + FILE, artifactFile);
            this.safePut(props, ARTIFACT + artifactPlatformReplaced + SIZE, artifactSize);
            this.safePut(props, ARTIFACT + artifactPlatformReplaced + FILE_NAME, artifactFileName);
            this.safePut(props, ARTIFACT + artifactPlatformReplaced + FILE_EXTENSION, artifactFileExtension);
            this.safePut(props, ARTIFACT + artifactPlatformReplaced + FILE_FORMAT, artifactFileFormat);
            for (Algorithm algorithm : this.context.getModel().getChecksum().getAlgorithms()) {
                this.safePut(props, ARTIFACT + artifactPlatform + CHECKSUM + StringUtils.capitalize((String)algorithm.formatted()), artifact.getHash(algorithm));
                this.safePut(props, ARTIFACT + artifactPlatformReplaced + CHECKSUM + StringUtils.capitalize((String)algorithm.formatted()), artifact.getHash(algorithm));
            }
            this.safePut(props, ARTIFACT + artifactPlatform + URL, artifactUrl);
            this.safePut(props, ARTIFACT + artifactPlatformReplaced + URL, artifactUrl);
            props.putAll(this.context.getModel().getUpload().resolveDownloadUrls(this.context, distribution, artifact, ARTIFACT + artifactPlatform));
            props.putAll(this.context.getModel().getUpload().resolveDownloadUrls(this.context, distribution, artifact, ARTIFACT + artifactPlatformReplaced));
            if (count != 1) continue;
            props.putAll(this.context.getModel().getUpload().resolveDownloadUrls(this.context, distribution, artifact, DISTRIBUTION));
            this.safePut(props, "distributionArtifact", artifact);
            this.safePut(props, "distributionUrl", artifactUrl);
            this.safePut(props, "distributionSize", artifactSize);
            this.safePut(props, "distributionSha256", artifact.getHash(Algorithm.SHA_256));
            for (Algorithm algorithm : this.context.getModel().getChecksum().getAlgorithms()) {
                this.safePut(props, "distributionChecksum" + StringUtils.capitalize((String)algorithm.formatted()), artifact.getHash(algorithm));
            }
            this.safePut(props, "distributionArtifactPlatform", platform);
            this.safePut(props, "distributionArtifactPlatformReplaced", platformReplaced);
            this.safePut(props, "distributionArtifactName", artifactName);
            this.safePut(props, "distributionArtifactVersion", artifactVersion);
            this.safePut(props, "distributionArtifactOs", artifactOs);
            this.safePut(props, "distributionArtifactArch", artifactArch);
            this.safePut(props, "distributionArtifactSize", artifactSize);
            this.safePut(props, "distributionArtifactFile", artifactFile);
            this.safePut(props, "distributionArtifactFileName", artifactFileName);
            this.safePut(props, "distributionArtifactFileExtension", artifactFileExtension);
            this.safePut(props, "distributionArtifactFileFormat", artifactFileFormat);
            this.safePut(props, "artifactPlatform", platform);
            this.safePut(props, "artifactPlatformReplaced", platformReplaced);
            this.safePut(props, "artifactName", artifactName);
            this.safePut(props, "artifactVersion", artifactVersion);
            this.safePut(props, "artifactOs", artifactOs);
            this.safePut(props, "artifactArch", artifactArch);
            this.safePut(props, "artifactSize", artifactSize);
            this.safePut(props, "artifactFile", artifactFile);
            this.safePut(props, "artifactFileName", artifactFileName);
            this.safePut(props, "artifactFileExtension", artifactFileExtension);
            this.safePut(props, "artifactFileFormat", artifactFileFormat);
            Map aprops = artifact.getResolvedExtraProperties();
            LinkedHashMap bprops = new LinkedHashMap(aprops);
            MustacheUtils.applyTemplates((Map)aprops, bprops);
            aprops.keySet().stream().filter(k -> !props.containsKey(k)).forEach(k -> props.put((String)k, aprops.get(k)));
        }
        return count > 0;
    }

    protected List<Artifact> collectArtifacts(Distribution distribution) {
        return this.packager.resolveCandidateArtifacts(this.context, distribution);
    }

    protected void info(ByteArrayOutputStream out) {
        this.log(out, arg_0 -> ((JReleaserLogger)this.context.getLogger()).info(arg_0));
    }

    protected void error(ByteArrayOutputStream err) {
        this.log(err, arg_0 -> ((JReleaserLogger)this.context.getLogger()).error(arg_0));
    }

    private void log(ByteArrayOutputStream stream, Consumer<? super String> consumer) {
        String str = stream.toString();
        if (StringUtils.isBlank((String)str)) {
            return;
        }
        Arrays.stream(str.split(System.lineSeparator())).forEach(consumer);
    }

    protected Path getPrepareDirectory(Map<String, Object> props) {
        return (Path)props.get("distributionPrepareDirectory");
    }

    protected Path getPackageDirectory(Map<String, Object> props) {
        return (Path)props.get("distributionPackageDirectory");
    }

    protected void safePut(Map<String, Object> dest, String key, Object value) {
        if (value instanceof CharSequence && StringUtils.isNotBlank((String)String.valueOf(value))) {
            dest.put(key, value);
        } else if (value != null) {
            dest.put(key, value);
        }
    }
}

