/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.util;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.CopyOption;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileSystemLoopException;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.Comparator;
import java.util.Set;
import java.util.function.Predicate;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveException;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.ArchiveStreamFactory;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.apache.commons.compress.utils.IOUtils;
import org.jreleaser.util.Env;
import org.jreleaser.util.JReleaserLogger;
import org.jreleaser.util.StringUtils;

public final class FileUtils {
    private FileUtils() {
    }

    public static Path resolveOutputDirectory(Path basedir, Path outputdir, String baseOutput) {
        String od = Env.resolve("OUTPUT_DIRECTORY", "");
        if (StringUtils.isNotBlank(od)) {
            return basedir.resolve(od).resolve("jreleaser");
        }
        if (null != outputdir) {
            return basedir.resolve(outputdir).resolve("jreleaser");
        }
        return basedir.resolve(baseOutput).resolve("jreleaser");
    }

    public static void zip(final Path src, Path dest) throws IOException {
        try (final ZipArchiveOutputStream out = new ZipArchiveOutputStream(dest.toFile());){
            out.setMethod(8);
            Files.walkFileTree(src, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    String entryName = src.relativize(file).toString();
                    ZipArchiveEntry archiveEntry = new ZipArchiveEntry(file.toFile(), entryName);
                    archiveEntry.setMethod(8);
                    out.putArchiveEntry((ArchiveEntry)archiveEntry);
                    if (file.toFile().isFile()) {
                        if (Files.isExecutable(file)) {
                            archiveEntry.setUnixMode(33272);
                        }
                        out.write(Files.readAllBytes(file));
                    }
                    out.closeArchiveEntry();
                    return FileVisitResult.CONTINUE;
                }
            });
        }
    }

    public static void unpack(Path src, Path dest) throws IOException {
        File destinationDir = dest.toFile();
        try (InputStream fi = Files.newInputStream(src, new OpenOption[0]);
             BufferedInputStream bi = new BufferedInputStream(fi);
             ArchiveInputStream in = new ArchiveStreamFactory().createArchiveInputStream((InputStream)bi);){
            String filename = src.getFileName().toString();
            filename = filename.substring(0, filename.length() - 4);
            FileUtils.unpack(filename + "/", destinationDir, in);
        }
        catch (ArchiveException e) {
            throw new IOException(e.getMessage(), e);
        }
    }

    public static void unpackCompressed(Path src, Path dest) throws IOException {
        File destinationDir = dest.toFile();
        try (InputStream fi = Files.newInputStream(src, new OpenOption[0]);
             BufferedInputStream bi = new BufferedInputStream(fi);
             GzipCompressorInputStream gzi = new GzipCompressorInputStream((InputStream)bi);
             TarArchiveInputStream in = new TarArchiveInputStream((InputStream)gzi);){
            String filename = src.getFileName().toString();
            filename = filename.substring(0, filename.length() - 7);
            FileUtils.unpack(filename + "/", destinationDir, (ArchiveInputStream)in);
        }
    }

    private static void unpack(String basename, File destinationDir, ArchiveInputStream in) throws IOException {
        ArchiveEntry entry = null;
        while ((entry = in.getNextEntry()) != null) {
            if (!in.canReadEntryData(entry)) continue;
            String entryName = entry.getName();
            if (entryName.startsWith(basename) && entryName.length() > basename.length() + 1) {
                entryName = entryName.substring(basename.length());
            }
            File file = new File(destinationDir, entryName);
            String destDirPath = destinationDir.getCanonicalPath();
            String destFilePath = file.getCanonicalPath();
            if (!destFilePath.startsWith(destDirPath + File.separator)) {
                throw new IOException("Entry is outside of the target dir: " + entry.getName());
            }
            if (entry.isDirectory()) {
                if (file.isDirectory() || file.mkdirs()) continue;
                throw new IOException("failed to create directory " + file);
            }
            File parent = file.getParentFile();
            if (!parent.isDirectory() && !parent.mkdirs()) {
                throw new IOException("failed to create directory " + parent);
            }
            OutputStream o = Files.newOutputStream(file.toPath(), new OpenOption[0]);
            try {
                IOUtils.copy((InputStream)in, (OutputStream)o);
                if (!"bin".equalsIgnoreCase(file.getParentFile().getName())) continue;
                FileUtils.grantExecutableAccess(file.toPath());
            }
            finally {
                if (o == null) continue;
                o.close();
            }
        }
    }

    public static void deleteFiles(Path path) throws IOException {
        if (Files.exists(path, new LinkOption[0])) {
            Files.walk(path, new FileVisitOption[0]).sorted(Comparator.reverseOrder()).map(Path::toFile).forEach(File::delete);
            Files.deleteIfExists(path);
        }
    }

    public static void createDirectoriesWithFullAccess(Path path) throws IOException {
        FileUtils.createDirectories(path, "rwxrwxrwx");
    }

    public static void createDirectories(Path path, String accessRights) throws IOException {
        Set<PosixFilePermission> perms = PosixFilePermissions.fromString(accessRights);
        FileAttribute<Set<PosixFilePermission>> attr = PosixFilePermissions.asFileAttribute(perms);
        Files.createDirectories(path, attr);
    }

    public static void grantFullAccess(Path path) throws IOException {
        FileUtils.grantAccess(path, "rwxrwxrwx");
    }

    public static void grantExecutableAccess(Path path) throws IOException {
        FileUtils.grantAccess(path, "r-xr-xr-x");
    }

    public static void grantAccess(Path path, String accessRights) throws IOException {
        Set<PosixFilePermission> perms = PosixFilePermissions.fromString(accessRights);
        Files.setPosixFilePermissions(path, perms);
    }

    public static void copyFiles(JReleaserLogger logger, Path source, Path target) throws IOException {
        FileUtils.copyFiles(logger, source, target, null);
    }

    public static void copyFiles(JReleaserLogger logger, Path source, Path target, Predicate<Path> filter) throws IOException {
        Predicate<Path> actualFilter = filter != null ? filter : path -> true;
        IOException[] thrown = new IOException[1];
        Files.list(source).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(actualFilter).forEach(child -> {
            block2: {
                try {
                    Files.copy(child, target.resolve(child.getFileName()), StandardCopyOption.REPLACE_EXISTING);
                }
                catch (IOException e) {
                    logger.error("Unable to copy: {}", child, e);
                    if (null != thrown[0]) break block2;
                    thrown[0] = e;
                }
            }
        });
        if (thrown[0] != null) {
            throw thrown[0];
        }
    }

    public static boolean copyFilesRecursive(JReleaserLogger logger, Path source, Path target) throws IOException {
        return FileUtils.copyFilesRecursive(logger, source, target, null);
    }

    public static boolean copyFilesRecursive(JReleaserLogger logger, Path source, Path target, Predicate<Path> filter) throws IOException {
        FileTreeCopy copier = new FileTreeCopy(logger, source, target, filter);
        Files.walkFileTree(source, copier);
        return copier.isSuccessful();
    }

    private static class FileTreeCopy
    implements FileVisitor<Path> {
        private final JReleaserLogger logger;
        private final Path source;
        private final Path target;
        private final Predicate<Path> filter;
        private boolean success = true;

        FileTreeCopy(JReleaserLogger logger, Path source, Path target, Predicate<Path> filter) {
            this.logger = logger;
            this.source = source;
            this.target = target;
            this.filter = filter;
        }

        private boolean filtered(Path path) {
            if (null != this.filter) {
                return this.filter.test(path);
            }
            return false;
        }

        public boolean isSuccessful() {
            return this.success;
        }

        @Override
        public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) {
            if (this.filtered(dir)) {
                return FileVisitResult.SKIP_SUBTREE;
            }
            Path newdir = this.target.resolve(this.source.relativize(dir));
            try {
                Files.copy(dir, newdir, new CopyOption[0]);
                FileUtils.grantFullAccess(newdir);
            }
            catch (FileAlreadyExistsException fileAlreadyExistsException) {
            }
            catch (IOException e) {
                this.logger.error("Unable to create: {}", newdir, e);
                this.success = false;
                return FileVisitResult.SKIP_SUBTREE;
            }
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
            if (this.filtered(file)) {
                return FileVisitResult.CONTINUE;
            }
            try {
                Path newfile = this.target.resolve(this.source.relativize(file));
                Files.copy(file, newfile, StandardCopyOption.REPLACE_EXISTING);
                FileUtils.grantFullAccess(newfile);
            }
            catch (IOException e) {
                this.logger.error("Unable to copy: {}", this.source, e);
                this.success = false;
            }
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult postVisitDirectory(Path dir, IOException exc) {
            if (this.filtered(dir)) {
                return FileVisitResult.CONTINUE;
            }
            if (exc == null) {
                Path newdir = this.target.resolve(this.source.relativize(dir));
                try {
                    FileTime time = Files.getLastModifiedTime(dir, new LinkOption[0]);
                    Files.setLastModifiedTime(newdir, time);
                }
                catch (IOException e) {
                    this.logger.warn("Unable to copy all attributes to: {}", newdir, e);
                }
            }
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFileFailed(Path file, IOException e) {
            if (e instanceof FileSystemLoopException) {
                this.logger.error("cycle detected: {}", file);
            } else {
                this.logger.error("Unable to copy: {}", file, e);
            }
            this.success = false;
            return FileVisitResult.CONTINUE;
        }
    }
}

