/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.util;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Iterator;

public final class JsonUtils {
    private JsonUtils() {
    }

    public static JsonNode merge(JsonNode inputNode, JsonNode updateNode) {
        if (null == updateNode) {
            return inputNode;
        }
        Iterator fieldNames = updateNode.fieldNames();
        while (fieldNames.hasNext()) {
            String fieldName = (String)fieldNames.next();
            JsonNode inputValue = inputNode.get(fieldName);
            JsonNode updateValue = updateNode.get(fieldName);
            if (null != inputValue && inputValue.isArray() && null != updateValue && updateValue.isArray()) {
                for (int i = 0; i < updateValue.size(); ++i) {
                    JsonNode updatedChildNode = updateValue.get(i);
                    if (inputValue.size() <= i) {
                        ((ArrayNode)inputValue).add(updatedChildNode);
                    }
                    JsonNode childNodeToBeUpdated = inputValue.get(i);
                    JsonUtils.merge(childNodeToBeUpdated, updatedChildNode);
                }
                continue;
            }
            if (null != inputValue && inputValue.isObject()) {
                JsonUtils.merge(inputValue, updateValue);
                continue;
            }
            if (!(inputNode instanceof ObjectNode)) continue;
            ((ObjectNode)inputNode).replace(fieldName, updateValue);
        }
        return inputNode;
    }
}

