/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.sdk.twitter;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.JReleaserContext;
import org.jreleaser.model.Twitter;
import org.jreleaser.model.announcer.spi.AnnounceException;
import org.jreleaser.model.announcer.spi.Announcer;
import org.jreleaser.sdk.twitter.TwitterException;
import org.jreleaser.sdk.twitter.UpdateStatusTwitterCommand;
import org.jreleaser.util.MustacheUtils;
import org.jreleaser.util.StringUtils;
import org.jreleaser.util.Templates;

public class TwitterAnnouncer
implements Announcer {
    private final JReleaserContext context;

    TwitterAnnouncer(JReleaserContext context) {
        this.context = context;
    }

    public String getName() {
        return "twitter";
    }

    public boolean isEnabled() {
        return this.context.getModel().getAnnounce().getTwitter().isEnabled();
    }

    public void announce() throws AnnounceException {
        Twitter twitter = this.context.getModel().getAnnounce().getTwitter();
        ArrayList<String> statuses = new ArrayList<String>();
        if (StringUtils.isNotBlank((String)twitter.getStatusTemplate())) {
            LinkedHashMap<String, String> props = new LinkedHashMap<String, String>();
            props.put("changelog", MustacheUtils.passThrough((String)this.context.getChangelog()));
            this.context.getModel().getRelease().getGitService().fillProps(props, this.context.getModel());
            Arrays.stream(twitter.getResolvedStatusTemplate(this.context, props).split(System.lineSeparator())).filter(StringUtils::isNotBlank).map(String::trim).forEach(statuses::add);
        }
        if (statuses.isEmpty() && !twitter.getStatuses().isEmpty()) {
            statuses.addAll(twitter.getStatuses());
            twitter.getStatuses().stream().filter(StringUtils::isNotBlank).map(String::trim).forEach(statuses::add);
        }
        if (statuses.isEmpty()) {
            statuses.add(twitter.getStatus());
        }
        for (int i = 0; i < statuses.size(); ++i) {
            String status = this.getResolvedMessage(this.context, (String)statuses.get(i));
            this.context.getLogger().info(RB.$((String)"twitter.tweet", (Object[])new Object[0]), new Object[]{status});
            this.context.getLogger().debug(RB.$((String)"twitter.tweet.size", (Object[])new Object[0]), new Object[]{status.length()});
            statuses.set(i, status);
        }
        try {
            ((UpdateStatusTwitterCommand.Builder)((UpdateStatusTwitterCommand.Builder)((UpdateStatusTwitterCommand.Builder)((UpdateStatusTwitterCommand.Builder)((UpdateStatusTwitterCommand.Builder)((UpdateStatusTwitterCommand.Builder)((UpdateStatusTwitterCommand.Builder)UpdateStatusTwitterCommand.builder(this.context.getLogger()).connectTimeout(twitter.getConnectTimeout())).readTimeout(twitter.getReadTimeout())).consumerKey(this.context.isDryrun() ? "**UNDEFINED**" : twitter.getResolvedConsumerKey())).consumerToken(this.context.isDryrun() ? "**UNDEFINED**" : twitter.getResolvedConsumerSecret())).accessToken(this.context.isDryrun() ? "**UNDEFINED**" : twitter.getResolvedAccessToken())).accessTokenSecret(this.context.isDryrun() ? "**UNDEFINED**" : twitter.getResolvedAccessTokenSecret())).statuses(statuses).dryrun(this.context.isDryrun())).build().execute();
        }
        catch (TwitterException e) {
            throw new AnnounceException((Throwable)e);
        }
    }

    private String getResolvedMessage(JReleaserContext context, String message) {
        Map props = context.fullProps();
        MustacheUtils.applyTemplates((Map)props, (Map)context.getModel().getAnnounce().getTwitter().getResolvedExtraProperties());
        props.put("tagName", context.getModel().getRelease().getGitService().getEffectiveTagName(context.getModel()));
        return Templates.resolveTemplate((String)message, (Map)props);
    }
}

