/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.instructions;

import org.jruby.ir.Operation;
import org.jruby.ir.instructions.BranchInstr;
import org.jruby.ir.operands.Label;
import org.jruby.ir.operands.Operand;
import org.jruby.ir.persistence.IRWriterEncoder;

public abstract class TwoOperandBranchInstr
extends BranchInstr {
    private Label jumpTarget;
    private Operand arg1;
    private Operand arg2;

    public TwoOperandBranchInstr(Operation op, Label jumpTarget, Operand arg1, Operand arg2) {
        super(op);
        this.jumpTarget = jumpTarget;
        this.arg1 = arg1;
        this.arg2 = arg2;
    }

    @Override
    public Operand[] getOperands() {
        return new Operand[]{this.jumpTarget, this.arg1, this.arg2};
    }

    @Override
    public void setOperand(int i2, Operand operand) {
        switch (i2) {
            case 0: {
                this.jumpTarget = (Label)operand;
                break;
            }
            case 1: {
                this.arg1 = operand;
                break;
            }
            case 2: {
                this.arg2 = operand;
                break;
            }
            default: {
                throw new IllegalArgumentException("No such operand to set at index: " + i2);
            }
        }
    }

    @Override
    public void setJumpTarget(Label target2) {
        this.jumpTarget = target2;
    }

    @Override
    public Label getJumpTarget() {
        return this.jumpTarget;
    }

    public Operand getArg1() {
        return this.arg1;
    }

    public Operand getArg2() {
        return this.arg2;
    }

    @Override
    public void encode(IRWriterEncoder e) {
        super.encode(e);
        e.encode(this.getJumpTarget());
        e.encode(this.getArg1());
        e.encode(this.getArg2());
    }
}

