/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.ffi.io;

import java.nio.channels.Channel;
import jnr.enxio.channels.NativeDeviceChannel;
import jnr.enxio.channels.NativeSocketChannel;
import jnr.posix.FileStat;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyIO;
import org.jruby.RubyModule;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.api.Access;
import org.jruby.api.Convert;
import org.jruby.ext.ffi.io.FileDescriptorByteChannel;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.io.ModeFlags;

@JRubyClass(name={"FFI::FileDescriptorIO"}, parent="IO")
public class FileDescriptorIO
extends RubyIO {
    public static final String CLASS_NAME = "FileDescriptorIO";

    public FileDescriptorIO(Ruby runtime2, RubyClass klass) {
        super(runtime2, klass);
        this.MakeOpenFile();
    }

    public FileDescriptorIO(Ruby runtime2, IRubyObject fd) {
        this(runtime2.getCurrentContext(), fd);
    }

    public FileDescriptorIO(ThreadContext context, IRubyObject fd) {
        super(context.runtime, Access.getClass(context, "FFI", CLASS_NAME));
        this.MakeOpenFile();
        ModeFlags modes = FileDescriptorIO.newModeFlags(context.runtime, ModeFlags.RDWR);
        int fileno2 = Convert.toInt(context, fd);
        FileStat stat2 = context.runtime.getPosix().fstat(fileno2);
        Object channel = stat2.isSocket() ? new NativeSocketChannel(fileno2) : (stat2.isBlockDev() || stat2.isCharDev() ? new NativeDeviceChannel(fileno2) : new FileDescriptorByteChannel(context.runtime, fileno2));
        this.openFile.setChannel((Channel)channel);
        this.openFile.setMode(modes.getOpenFileFlags());
        this.openFile.setMode(modes.getOpenFileFlags());
        this.openFile.setSync(true);
    }

    public static RubyClass createFileDescriptorIOClass(ThreadContext context, RubyModule FFI2, RubyClass IO) {
        return (RubyClass)((RubyModule)((RubyModule)FFI2.defineClassUnder(context, CLASS_NAME, IO, FileDescriptorIO::new)).defineMethods(context, FileDescriptorIO.class)).defineConstants(context, FileDescriptorIO.class);
    }

    @JRubyMethod(name={"new"}, meta=true)
    public static FileDescriptorIO newInstance(ThreadContext context, IRubyObject recv2, IRubyObject fd) {
        return new FileDescriptorIO(context, fd);
    }

    @JRubyMethod(name={"wrap"}, meta=true)
    public static RubyIO wrap(ThreadContext context, IRubyObject recv2, IRubyObject fd) {
        return new FileDescriptorIO(context, fd);
    }
}

