/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.targets.indy;

import com.headius.invokebinder.Binder;
import java.lang.invoke.CallSite;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.invoke.MutableCallSite;
import java.util.Arrays;
import org.jcodings.Encoding;
import org.jruby.Appendable;
import org.jruby.RubyString;
import org.jruby.ir.targets.indy.StringBootstrap;
import org.jruby.ir.targets.simple.NormalInvokeSite;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;
import org.jruby.util.CodegenUtils;
import org.jruby.util.cli.Options;
import org.jruby.util.log.Logger;
import org.jruby.util.log.LoggerFactory;
import org.objectweb.asm.Handle;

public class BuildDynamicStringSite
extends MutableCallSite {
    private static final Logger LOG = LoggerFactory.getLogger(BuildDynamicStringSite.class);
    public static final Handle BUILD_DSTRING_BOOTSTRAP = new Handle(6, CodegenUtils.p(BuildDynamicStringSite.class), "buildDString", CodegenUtils.sig(CallSite.class, MethodHandles.Lookup.class, String.class, MethodType.class, Object[].class), false);
    private static final int MAX_ELEMENTS_FOR_SPECIALIZE1 = 4;
    private static final int MAX_DYNAMIC_ARGS_FOR_SPECIALIZE2 = 5;
    final int initialSize;
    final Encoding encoding;
    final long descriptor;
    final boolean frozen;
    final boolean chilled;
    final int elementCount;
    final ByteListAndCodeRange[] strings;

    public static CallSite buildDString(MethodHandles.Lookup lookup, String name2, MethodType type2, Object[] args2) {
        return new BuildDynamicStringSite(type2, args2);
    }

    public BuildDynamicStringSite(MethodType type2, Object[] stringArgs) {
        super(type2);
        int i2;
        this.initialSize = (Integer)stringArgs[stringArgs.length - 6];
        this.encoding = StringBootstrap.encodingFromName((String)stringArgs[stringArgs.length - 5]);
        this.chilled = (Integer)stringArgs[stringArgs.length - 4] != 0;
        this.frozen = (Integer)stringArgs[stringArgs.length - 3] != 0;
        this.descriptor = (Long)stringArgs[stringArgs.length - 2];
        this.elementCount = (Integer)stringArgs[stringArgs.length - 1];
        ByteListAndCodeRange[] strings = new ByteListAndCodeRange[this.elementCount];
        int stringArgsIdx = 0;
        Binder binder = Binder.from((MethodType)type2);
        int dynamicArgs = type2.parameterCount() - 1;
        int[] permute = new int[3 * dynamicArgs + 1];
        permute[0] = 0;
        for (i2 = 0; i2 < dynamicArgs; ++i2) {
            int base = i2 * 3 + 1;
            permute[base] = 0;
            permute[base + 1] = i2 + 1;
            permute[base + 2] = i2 + 1;
        }
        binder = binder.permute(permute);
        for (i2 = 0; i2 < dynamicArgs; ++i2) {
            binder = binder.collect(i2 + 1, 3, IRubyObject.class, BuildDynamicStringSite.constructGuardedToStringFilter());
        }
        boolean specialize = this.elementCount <= 4;
        for (int i3 = 0; i3 < this.elementCount; ++i3) {
            ByteListAndCodeRange blcr;
            if ((this.descriptor & (long)(1 << i3)) == 0L) continue;
            strings[i3] = blcr = new ByteListAndCodeRange(StringBootstrap.bytelist((String)stringArgs[stringArgsIdx * 3], (String)stringArgs[stringArgsIdx * 3 + 1]), (Integer)stringArgs[stringArgsIdx * 3 + 2]);
            if (specialize) {
                binder = binder.insert(i3 + 1, new Object[]{blcr});
            }
            ++stringArgsIdx;
        }
        this.strings = strings;
        if (specialize) {
            if (((Boolean)Options.INVOKEDYNAMIC_LOG_BINDING.load()).booleanValue()) {
                LOG.info("dstring(" + Long.toBinaryString(this.descriptor) + ")\tbound directly", new Object[0]);
            }
            binder = binder.append(Helpers.arrayOf(Encoding.class, Integer.TYPE), new Object[]{this.encoding, this.initialSize});
            this.setTarget(binder.invokeStaticQuiet(BuildDynamicStringSite.class, "buildString"));
        } else if (dynamicArgs <= 5) {
            if (((Boolean)Options.INVOKEDYNAMIC_LOG_BINDING.load()).booleanValue()) {
                LOG.info("dstring(" + Long.toBinaryString(this.descriptor) + ")\tbound to unrolled loop", new Object[0]);
            }
            binder = binder.prepend(new Object[]{this}).append(Helpers.arrayOf(Encoding.class, Integer.TYPE), new Object[]{this.encoding, this.initialSize});
            this.setTarget(binder.invokeVirtualQuiet("buildString2"));
        } else {
            if (((Boolean)Options.INVOKEDYNAMIC_LOG_BINDING.load()).booleanValue()) {
                LOG.info("dstring(" + Long.toBinaryString(this.descriptor) + ")\tbound to loop", new Object[0]);
            }
            binder = binder.prepend(new Object[]{this}).collect(2, IRubyObject[].class);
            this.setTarget(binder.invokeVirtualQuiet("buildString"));
        }
    }

    private static MethodHandle constructGuardedToStringFilter() {
        MethodType toSType = MethodType.methodType(IRubyObject.class, ThreadContext.class, IRubyObject.class, IRubyObject.class);
        CallSite toS = NormalInvokeSite.bootstrap(MethodHandles.lookup(), "invokeOther:to_s", toSType, 0, 0, "", -1);
        MethodHandle toS_handle = toS.dynamicInvoker();
        MethodHandle checkcast = Binder.from((MethodType)toSType.changeReturnType(Boolean.TYPE)).permute(new int[]{2}).cast(Boolean.TYPE, new Class[]{Object.class}).prepend(new Object[]{Appendable.class}).invokeVirtualQuiet("isInstance");
        MethodHandle guardedToS = MethodHandles.guardWithTest(checkcast, Binder.from((MethodType)toSType).permute(new int[]{2}).identity(), toS_handle);
        return guardedToS;
    }

    public static RubyString buildString(ThreadContext context, IRubyObject a, Encoding encoding2, int initialSize) {
        RubyString buffer = StringBootstrap.bufferString(context, encoding2, initialSize, 16);
        buffer.appendAsStringOrAny(a);
        return buffer;
    }

    public static RubyString buildString(ThreadContext context, ByteListAndCodeRange a, Encoding encoding2, int initialSize) {
        RubyString buffer = BuildDynamicStringSite.createBufferFromStaticString(context, initialSize, a);
        return buffer;
    }

    public static RubyString buildString(ThreadContext context, IRubyObject a, IRubyObject b2, Encoding encoding2, int initialSize) {
        RubyString buffer = StringBootstrap.bufferString(context, encoding2, initialSize, 16);
        buffer.appendAsStringOrAny(a);
        buffer.appendAsStringOrAny(b2);
        return buffer;
    }

    public static RubyString buildString(ThreadContext context, IRubyObject a, ByteListAndCodeRange b2, Encoding encoding2, int initialSize) {
        RubyString buffer = StringBootstrap.bufferString(context, encoding2, initialSize, 16);
        buffer.appendAsStringOrAny(a);
        buffer.catWithCodeRange(b2.bl, b2.cr);
        return buffer;
    }

    public static RubyString buildString(ThreadContext context, ByteListAndCodeRange a, IRubyObject b2, Encoding encoding2, int initialSize) {
        RubyString buffer = BuildDynamicStringSite.createBufferFromStaticString(context, initialSize, a);
        buffer.appendAsStringOrAny(b2);
        return buffer;
    }

    public static RubyString buildString(ThreadContext context, ByteListAndCodeRange a, ByteListAndCodeRange b2, Encoding encoding2, int initialSize) {
        RubyString buffer = BuildDynamicStringSite.createBufferFromStaticString(context, initialSize, a);
        buffer.catWithCodeRange(b2.bl, b2.cr);
        return buffer;
    }

    public static RubyString buildString(ThreadContext context, IRubyObject a, IRubyObject b2, IRubyObject c, Encoding encoding2, int initialSize) {
        RubyString buffer = StringBootstrap.bufferString(context, encoding2, initialSize, 16);
        buffer.appendAsStringOrAny(a);
        buffer.appendAsStringOrAny(b2);
        buffer.appendAsStringOrAny(c);
        return buffer;
    }

    public static RubyString buildString(ThreadContext context, IRubyObject a, IRubyObject b2, ByteListAndCodeRange c, Encoding encoding2, int initialSize) {
        RubyString buffer = StringBootstrap.bufferString(context, encoding2, initialSize, 16);
        buffer.appendAsStringOrAny(a);
        buffer.appendAsStringOrAny(b2);
        buffer.catWithCodeRange(c.bl, c.cr);
        return buffer;
    }

    public static RubyString buildString(ThreadContext context, IRubyObject a, ByteListAndCodeRange b2, IRubyObject c, Encoding encoding2, int initialSize) {
        RubyString buffer = StringBootstrap.bufferString(context, encoding2, initialSize, 16);
        buffer.appendAsStringOrAny(a);
        buffer.catWithCodeRange(b2.bl, b2.cr);
        buffer.appendAsStringOrAny(c);
        return buffer;
    }

    public static RubyString buildString(ThreadContext context, IRubyObject a, ByteListAndCodeRange b2, ByteListAndCodeRange c, Encoding encoding2, int initialSize) {
        RubyString buffer = StringBootstrap.bufferString(context, encoding2, initialSize, 16);
        buffer.appendAsStringOrAny(a);
        buffer.catWithCodeRange(b2.bl, b2.cr);
        buffer.catWithCodeRange(c.bl, c.cr);
        return buffer;
    }

    public static RubyString buildString(ThreadContext context, ByteListAndCodeRange a, IRubyObject b2, IRubyObject c, Encoding encoding2, int initialSize) {
        RubyString buffer = BuildDynamicStringSite.createBufferFromStaticString(context, initialSize, a);
        buffer.appendAsStringOrAny(b2);
        buffer.appendAsStringOrAny(c);
        return buffer;
    }

    public static RubyString buildString(ThreadContext context, ByteListAndCodeRange a, IRubyObject b2, ByteListAndCodeRange c, Encoding encoding2, int initialSize) {
        RubyString buffer = BuildDynamicStringSite.createBufferFromStaticString(context, initialSize, a);
        buffer.appendAsStringOrAny(b2);
        buffer.catWithCodeRange(c.bl, c.cr);
        return buffer;
    }

    public static RubyString buildString(ThreadContext context, ByteListAndCodeRange a, ByteListAndCodeRange b2, IRubyObject c, Encoding encoding2, int initialSize) {
        RubyString buffer = BuildDynamicStringSite.createBufferFromStaticString(context, initialSize, a);
        buffer.catWithCodeRange(b2.bl, b2.cr);
        buffer.appendAsStringOrAny(c);
        return buffer;
    }

    public static RubyString buildString(ThreadContext context, ByteListAndCodeRange a, ByteListAndCodeRange b2, ByteListAndCodeRange c, Encoding encoding2, int initialSize) {
        RubyString buffer = BuildDynamicStringSite.createBufferFromStaticString(context, initialSize, a);
        buffer.catWithCodeRange(b2.bl, b2.cr);
        buffer.catWithCodeRange(c.bl, c.cr);
        return buffer;
    }

    public static RubyString buildString(ThreadContext context, IRubyObject a, IRubyObject b2, IRubyObject c, IRubyObject d, Encoding encoding2, int initialSize) {
        RubyString buffer = StringBootstrap.bufferString(context, encoding2, initialSize, 16);
        buffer.appendAsStringOrAny(a);
        buffer.appendAsStringOrAny(b2);
        buffer.appendAsStringOrAny(c);
        buffer.appendAsStringOrAny(d);
        return buffer;
    }

    public static RubyString buildString(ThreadContext context, IRubyObject a, IRubyObject b2, IRubyObject c, ByteListAndCodeRange d, Encoding encoding2, int initialSize) {
        RubyString buffer = StringBootstrap.bufferString(context, encoding2, initialSize, 16);
        buffer.appendAsStringOrAny(a);
        buffer.appendAsStringOrAny(b2);
        buffer.appendAsStringOrAny(c);
        buffer.catWithCodeRange(d.bl, d.cr);
        return buffer;
    }

    public static RubyString buildString(ThreadContext context, IRubyObject a, IRubyObject b2, ByteListAndCodeRange c, IRubyObject d, Encoding encoding2, int initialSize) {
        RubyString buffer = StringBootstrap.bufferString(context, encoding2, initialSize, 16);
        buffer.appendAsStringOrAny(a);
        buffer.appendAsStringOrAny(b2);
        buffer.catWithCodeRange(c.bl, c.cr);
        buffer.appendAsStringOrAny(d);
        return buffer;
    }

    public static RubyString buildString(ThreadContext context, IRubyObject a, IRubyObject b2, ByteListAndCodeRange c, ByteListAndCodeRange d, Encoding encoding2, int initialSize) {
        RubyString buffer = StringBootstrap.bufferString(context, encoding2, initialSize, 16);
        buffer.appendAsStringOrAny(a);
        buffer.appendAsStringOrAny(b2);
        buffer.catWithCodeRange(c.bl, c.cr);
        buffer.catWithCodeRange(d.bl, d.cr);
        return buffer;
    }

    public static RubyString buildString(ThreadContext context, IRubyObject a, ByteListAndCodeRange b2, IRubyObject c, IRubyObject d, Encoding encoding2, int initialSize) {
        RubyString buffer = StringBootstrap.bufferString(context, encoding2, initialSize, 16);
        buffer.appendAsStringOrAny(a);
        buffer.catWithCodeRange(b2.bl, b2.cr);
        buffer.appendAsStringOrAny(c);
        buffer.appendAsStringOrAny(d);
        return buffer;
    }

    public static RubyString buildString(ThreadContext context, IRubyObject a, ByteListAndCodeRange b2, IRubyObject c, ByteListAndCodeRange d, Encoding encoding2, int initialSize) {
        RubyString buffer = StringBootstrap.bufferString(context, encoding2, initialSize, 16);
        buffer.appendAsStringOrAny(a);
        buffer.catWithCodeRange(b2.bl, b2.cr);
        buffer.appendAsStringOrAny(c);
        buffer.catWithCodeRange(d.bl, d.cr);
        return buffer;
    }

    public static RubyString buildString(ThreadContext context, IRubyObject a, ByteListAndCodeRange b2, ByteListAndCodeRange c, IRubyObject d, Encoding encoding2, int initialSize) {
        RubyString buffer = StringBootstrap.bufferString(context, encoding2, initialSize, 16);
        buffer.appendAsStringOrAny(a);
        buffer.catWithCodeRange(b2.bl, b2.cr);
        buffer.catWithCodeRange(c.bl, c.cr);
        buffer.appendAsStringOrAny(d);
        return buffer;
    }

    public static RubyString buildString(ThreadContext context, IRubyObject a, ByteListAndCodeRange b2, ByteListAndCodeRange c, ByteListAndCodeRange d, Encoding encoding2, int initialSize) {
        RubyString buffer = StringBootstrap.bufferString(context, encoding2, initialSize, 16);
        buffer.appendAsStringOrAny(a);
        buffer.catWithCodeRange(b2.bl, b2.cr);
        buffer.catWithCodeRange(c.bl, c.cr);
        buffer.catWithCodeRange(d.bl, d.cr);
        return buffer;
    }

    public static RubyString buildString(ThreadContext context, ByteListAndCodeRange a, IRubyObject b2, IRubyObject c, IRubyObject d, Encoding encoding2, int initialSize) {
        RubyString buffer = BuildDynamicStringSite.createBufferFromStaticString(context, initialSize, a);
        buffer.appendAsStringOrAny(b2);
        buffer.appendAsStringOrAny(c);
        buffer.appendAsStringOrAny(d);
        return buffer;
    }

    public static RubyString buildString(ThreadContext context, ByteListAndCodeRange a, IRubyObject b2, IRubyObject c, ByteListAndCodeRange d, Encoding encoding2, int initialSize) {
        RubyString buffer = BuildDynamicStringSite.createBufferFromStaticString(context, initialSize, a);
        buffer.appendAsStringOrAny(b2);
        buffer.appendAsStringOrAny(c);
        buffer.catWithCodeRange(d.bl, d.cr);
        return buffer;
    }

    public static RubyString buildString(ThreadContext context, ByteListAndCodeRange a, IRubyObject b2, ByteListAndCodeRange c, IRubyObject d, Encoding encoding2, int initialSize) {
        RubyString buffer = BuildDynamicStringSite.createBufferFromStaticString(context, initialSize, a);
        buffer.appendAsStringOrAny(b2);
        buffer.catWithCodeRange(c.bl, c.cr);
        buffer.appendAsStringOrAny(d);
        return buffer;
    }

    public static RubyString buildString(ThreadContext context, ByteListAndCodeRange a, IRubyObject b2, ByteListAndCodeRange c, ByteListAndCodeRange d, Encoding encoding2, int initialSize) {
        RubyString buffer = BuildDynamicStringSite.createBufferFromStaticString(context, initialSize, a);
        buffer.appendAsStringOrAny(b2);
        buffer.catWithCodeRange(c.bl, c.cr);
        buffer.catWithCodeRange(d.bl, d.cr);
        return buffer;
    }

    public static RubyString buildString(ThreadContext context, ByteListAndCodeRange a, ByteListAndCodeRange b2, IRubyObject c, IRubyObject d, Encoding encoding2, int initialSize) {
        RubyString buffer = BuildDynamicStringSite.createBufferFromStaticString(context, initialSize, a);
        buffer.catWithCodeRange(b2.bl, b2.cr);
        buffer.appendAsStringOrAny(c);
        buffer.appendAsStringOrAny(d);
        return buffer;
    }

    public static RubyString buildString(ThreadContext context, ByteListAndCodeRange a, ByteListAndCodeRange b2, IRubyObject c, ByteListAndCodeRange d, Encoding encoding2, int initialSize) {
        RubyString buffer = BuildDynamicStringSite.createBufferFromStaticString(context, initialSize, a);
        buffer.catWithCodeRange(b2.bl, b2.cr);
        buffer.appendAsStringOrAny(c);
        buffer.catWithCodeRange(d.bl, d.cr);
        return buffer;
    }

    public static RubyString buildString(ThreadContext context, ByteListAndCodeRange a, ByteListAndCodeRange b2, ByteListAndCodeRange c, IRubyObject d, Encoding encoding2, int initialSize) {
        RubyString buffer = BuildDynamicStringSite.createBufferFromStaticString(context, initialSize, a);
        buffer.catWithCodeRange(b2.bl, b2.cr);
        buffer.catWithCodeRange(c.bl, c.cr);
        buffer.appendAsStringOrAny(d);
        return buffer;
    }

    public static RubyString buildString(ThreadContext context, ByteListAndCodeRange a, ByteListAndCodeRange b2, ByteListAndCodeRange c, ByteListAndCodeRange d, Encoding encoding2, int initialSize) {
        RubyString buffer = BuildDynamicStringSite.createBufferFromStaticString(context, initialSize, a);
        buffer.catWithCodeRange(b2.bl, b2.cr);
        buffer.catWithCodeRange(c.bl, c.cr);
        buffer.catWithCodeRange(d.bl, d.cr);
        return buffer;
    }

    public RubyString buildString2(ThreadContext context, Encoding encoding2, int initialSize) {
        return this.buildString2(context, null, null, null, null, encoding2, initialSize);
    }

    public RubyString buildString2(ThreadContext context, IRubyObject a, Encoding encoding2, int initialSize) {
        return this.buildString2(context, a, null, null, null, null, encoding2, initialSize);
    }

    public RubyString buildString2(ThreadContext context, IRubyObject a, IRubyObject b2, Encoding encoding2, int initialSize) {
        return this.buildString2(context, a, b2, null, null, null, encoding2, initialSize);
    }

    public RubyString buildString2(ThreadContext context, IRubyObject a, IRubyObject b2, IRubyObject c, Encoding encoding2, int initialSize) {
        return this.buildString2(context, a, b2, c, null, null, encoding2, initialSize);
    }

    public RubyString buildString2(ThreadContext context, IRubyObject a, IRubyObject b2, IRubyObject c, IRubyObject d, Encoding encoding2, int initialSize) {
        return this.buildString2(context, a, b2, c, d, null, encoding2, initialSize);
    }

    public RubyString buildString2(ThreadContext context, IRubyObject a, IRubyObject b2, IRubyObject c, IRubyObject d, IRubyObject e, Encoding encoding2, int initialSize) {
        int i2;
        RubyString buffer;
        long descriptor = this.descriptor;
        ByteListAndCodeRange[] strings = this.strings;
        if (BuildDynamicStringSite.isDynamicElement(descriptor, 0)) {
            buffer = StringBootstrap.bufferString(context, encoding2, initialSize, 16);
            i2 = 0;
        } else {
            buffer = BuildDynamicStringSite.createBufferFromStaticString(context, initialSize, strings[0]);
            i2 = 1;
        }
        int dynamicArg = 0;
        int elementCount = this.elementCount;
        while (i2 < elementCount) {
            if (BuildDynamicStringSite.isDynamicElement(descriptor, i2)) {
                IRubyObject dynamicElement = switch (dynamicArg++) {
                    case 0 -> a;
                    case 1 -> b2;
                    case 2 -> c;
                    case 3 -> d;
                    case 4 -> e;
                    default -> throw new RuntimeException("BUG: trying to use buildString2 with more than 5 dynamic args");
                };
                buffer.appendAsStringOrAny(dynamicElement);
            } else {
                ByteListAndCodeRange string2 = strings[i2];
                buffer.catWithCodeRange(string2.bl, string2.cr);
            }
            ++i2;
        }
        if (this.frozen) {
            buffer.freeze(context);
        } else if (this.chilled) {
            buffer.chill();
        }
        return buffer;
    }

    private static RubyString createBufferFromStaticString(ThreadContext context, int initialSize, ByteListAndCodeRange firstString) {
        ByteList firstStringByteList = firstString.bl;
        int firstStringCR = firstString.cr;
        byte[] bufferArray = Arrays.copyOfRange(firstStringByteList.unsafeBytes(), firstStringByteList.begin(), initialSize);
        ByteList bufferByteList = new ByteList(bufferArray, 0, firstStringByteList.realSize(), firstStringByteList.getEncoding(), false);
        RubyString buffer = RubyString.newString(context.runtime, bufferByteList, firstStringCR);
        return buffer;
    }

    private static boolean isDynamicElement(long descriptor, int i2) {
        return (descriptor & (long)(1 << i2)) == 0L;
    }

    public RubyString buildString(ThreadContext context, IRubyObject ... values2) {
        RubyString buffer = StringBootstrap.bufferString(context, this.encoding, this.initialSize, 16);
        int valueIdx = 0;
        for (int i2 = 0; i2 < this.elementCount; ++i2) {
            if ((this.descriptor & (long)(1 << i2)) != 0L) {
                buffer.catWithCodeRange(this.strings[i2].bl, this.strings[i2].cr);
                continue;
            }
            buffer.appendAsStringOrAny(values2[valueIdx++]);
        }
        if (this.frozen) {
            buffer.freeze(context);
        } else if (this.chilled) {
            buffer.chill();
        }
        return buffer;
    }

    record ByteListAndCodeRange(ByteList bl, int cr) {
    }
}

