/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime.invokedynamic;

import com.headius.invokebinder.Binder;
import java.lang.invoke.CallSite;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.invoke.SwitchPoint;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyFloat;
import org.jruby.RubyNumeric;
import org.jruby.api.Convert;
import org.jruby.ir.targets.indy.Bootstrap;
import org.jruby.ir.targets.simple.NormalInvokeSite;
import org.jruby.runtime.CallType;
import org.jruby.runtime.MethodIndex;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.callsite.CacheEntry;
import org.jruby.runtime.invokedynamic.InvokeDynamicSupport;
import org.jruby.runtime.invokedynamic.JRubyCallSite;
import org.jruby.util.CodegenUtils;
import org.jruby.util.JavaNameMangler;
import org.jruby.util.StringSupport;
import org.jruby.util.cli.Options;
import org.jruby.util.log.Logger;
import org.jruby.util.log.LoggerFactory;
import org.objectweb.asm.Handle;

public class MathLinker {
    private static final Logger LOG = LoggerFactory.getLogger(MathLinker.class);
    public static final MethodHandles.Lookup LOOKUP = MethodHandles.lookup();
    public static final Handle FIXNUM_OPERATOR_BOOTSTRAP = new Handle(6, CodegenUtils.p(MathLinker.class), "fixnumOperatorBootstrap", Bootstrap.BOOTSTRAP_LONG_STRING_INT_SIG, false);
    public static final Handle FLOAT_OPERATOR_BOOTSTRAP = new Handle(6, CodegenUtils.p(MathLinker.class), "floatOperatorBootstrap", Bootstrap.BOOTSTRAP_DOUBLE_STRING_INT_SIG, false);
    private static final boolean LOG_BINDING;
    public static final MethodHandle FIXNUM_TEST;
    public static final MethodHandle FLOAT_TEST;
    public static final MethodHandle FIXNUM_OPERATOR;
    public static final MethodHandle FLOAT_OPERATOR;
    private static final CallType[] CALL_TYPES;
    private static final int[] ARG_2_TO_0;
    public static final MethodHandle FLOAT_TEST_ARG_2_TO_0;
    public static final MethodHandle FIXNUM_TEST_ARG_2_TO_0;

    public static CallSite fixnumOperatorBootstrap(MethodHandles.Lookup lookup, String name2, MethodType type2, long value2, int callType, String file2, int line) throws NoSuchMethodException, IllegalAccessException {
        String operator = JavaNameMangler.demangleMethodName(StringSupport.split(name2, ':').get(1));
        JRubyCallSite site = new JRubyCallSite(lookup, type2, CALL_TYPES[callType], file2, line, operator);
        MethodHandle target2 = FIXNUM_OPERATOR;
        target2 = MethodHandles.insertArguments(target2, 3, site, value2);
        site.setTarget(target2);
        return site;
    }

    public static CallSite floatOperatorBootstrap(MethodHandles.Lookup lookup, String name2, MethodType type2, double value2, int callType, String file2, int line) throws NoSuchMethodException, IllegalAccessException {
        String operator = JavaNameMangler.demangleMethodName(StringSupport.split(name2, ':').get(1));
        JRubyCallSite site = new JRubyCallSite(lookup, type2, CALL_TYPES[callType], file2, line, operator);
        MethodHandle target2 = FLOAT_OPERATOR;
        target2 = MethodHandles.insertArguments(target2, 3, site, value2);
        site.setTarget(target2);
        return site;
    }

    public static IRubyObject fixnumOperator(ThreadContext context, IRubyObject caller2, IRubyObject self2, JRubyCallSite site, long value2) throws Throwable {
        Ruby runtime2 = context.runtime;
        String operator = site.name;
        MethodHandle target2 = null;
        MethodType fallbackType = site.type().appendParameterTypes(IRubyObject.class);
        NormalInvokeSite normalSite = NormalInvokeSite.newSite(LOOKUP, site.name, fallbackType, false, 0, site.file(), site.line());
        RubyClass classFixnum = runtime2.getFixnum();
        SwitchPoint switchPoint = (SwitchPoint)classFixnum.getInvalidator().getData();
        MethodHandle fallback = Binder.from((MethodType)site.type()).append(IRubyObject.class, (Object)Convert.asFixnum(context, value2)).invoke(((CallSite)normalSite).dynamicInvoker());
        CacheEntry entry = MathLinker.searchWithCache(operator, caller2, self2.getMetaClass(), site);
        if (!(self2 instanceof RubyFixnum) || entry == null || !entry.method.isBuiltin()) {
            target2 = fallback;
            site.setTarget(target2);
            if (LOG_BINDING) {
                LOG.debug(site.name + "\tFixnum operation at site #" + site.siteID + " (" + site.file() + ":" + site.line() + ") bound to normal invocation", new Object[0]);
            }
        } else {
            String opMethod = MethodIndex.getFastFixnumOpsMethod(operator);
            String name2 = "fixnum_" + opMethod;
            if (operator.equals("+") || operator.equals("-")) {
                MethodType type2 = MethodType.methodType(IRubyObject.class, ThreadContext.class, IRubyObject.class, IRubyObject.class);
                if (value2 == 1L) {
                    name2 = name2 + "_one";
                    target2 = MethodHandles.lookup().findStatic(MathLinker.class, name2, type2);
                } else if (value2 == 2L) {
                    name2 = name2 + "_two";
                    target2 = MethodHandles.lookup().findStatic(MathLinker.class, name2, type2);
                }
            }
            if (target2 == null) {
                target2 = MathLinker.findTargetImpl(name2, IRubyObject.class, value2);
            }
            target2 = MethodHandles.guardWithTest(FIXNUM_TEST_ARG_2_TO_0, target2, fallback);
            target2 = switchPoint.guardWithTest(target2, fallback);
            site.setTarget(target2);
            if (LOG_BINDING) {
                LOG.debug(name2 + "\tFixnum operation at site #" + site.siteID + " (" + site.file() + ":" + site.line() + ") bound directly", new Object[0]);
            }
        }
        return (IRubyObject)target2.invokeWithArguments(context, caller2, self2);
    }

    static boolean fixnumTest(IRubyObject self2) {
        return self2 instanceof RubyFixnum;
    }

    static IRubyObject fixnumOperatorFail(ThreadContext context, IRubyObject caller2, IRubyObject self2, JRubyCallSite site, RubyFixnum value2) throws Throwable {
        return MathLinker.callMethod(context, caller2, self2, site, value2);
    }

    public static IRubyObject fixnum_op_plus(ThreadContext context, IRubyObject caller2, IRubyObject self2, long value2) throws Throwable {
        return ((RubyFixnum)self2).op_plus(context, value2);
    }

    public static IRubyObject fixnum_op_minus(ThreadContext context, IRubyObject caller2, IRubyObject self2, long value2) throws Throwable {
        return ((RubyFixnum)self2).op_minus(context, value2);
    }

    public static IRubyObject fixnum_op_mul(ThreadContext context, IRubyObject caller2, IRubyObject self2, long value2) throws Throwable {
        return ((RubyFixnum)self2).op_mul(context, value2);
    }

    public static IRubyObject fixnum_op_mod(ThreadContext context, IRubyObject caller2, IRubyObject self2, long value2) throws Throwable {
        return ((RubyFixnum)self2).op_mod(context, value2);
    }

    public static IRubyObject fixnum_op_div(ThreadContext context, IRubyObject caller2, IRubyObject self2, long value2) throws Throwable {
        return ((RubyFixnum)self2).op_div(context, value2);
    }

    public static IRubyObject fixnum_op_equal(ThreadContext context, IRubyObject caller2, IRubyObject self2, long value2) throws Throwable {
        return ((RubyFixnum)self2).op_equal(context, value2);
    }

    public static IRubyObject fixnum_op_not_equal(ThreadContext context, IRubyObject caller2, IRubyObject self2, long value2) throws Throwable {
        return ((RubyFixnum)self2).op_not_equal(context, value2);
    }

    public static IRubyObject fixnum_op_lt(ThreadContext context, IRubyObject caller2, IRubyObject self2, long value2) throws Throwable {
        return ((RubyFixnum)self2).op_lt(context, value2);
    }

    public static IRubyObject fixnum_op_le(ThreadContext context, IRubyObject caller2, IRubyObject self2, long value2) throws Throwable {
        return ((RubyFixnum)self2).op_le(context, value2);
    }

    public static IRubyObject fixnum_op_gt(ThreadContext context, IRubyObject caller2, IRubyObject self2, long value2) throws Throwable {
        return ((RubyFixnum)self2).op_gt(context, value2);
    }

    public static IRubyObject fixnum_op_ge(ThreadContext context, IRubyObject caller2, IRubyObject self2, long value2) throws Throwable {
        return ((RubyFixnum)self2).op_ge(context, value2);
    }

    public static IRubyObject fixnum_op_cmp(ThreadContext context, IRubyObject caller2, IRubyObject self2, long value2) throws Throwable {
        return ((RubyFixnum)self2).op_cmp(context, value2);
    }

    public static IRubyObject fixnum_op_and(ThreadContext context, IRubyObject caller2, IRubyObject self2, long value2) throws Throwable {
        return ((RubyFixnum)self2).op_and(context, value2);
    }

    public static IRubyObject fixnum_op_or(ThreadContext context, IRubyObject caller2, IRubyObject self2, long value2) throws Throwable {
        return ((RubyFixnum)self2).op_or(context, value2);
    }

    public static IRubyObject fixnum_op_xor(ThreadContext context, IRubyObject caller2, IRubyObject self2, long value2) throws Throwable {
        return ((RubyFixnum)self2).op_xor(context, value2);
    }

    public static IRubyObject fixnum_op_rshift(ThreadContext context, IRubyObject caller2, IRubyObject self2, long value2) throws Throwable {
        return ((RubyFixnum)self2).op_rshift(context, value2);
    }

    public static IRubyObject fixnum_op_lshift(ThreadContext context, IRubyObject caller2, IRubyObject self2, long value2) throws Throwable {
        return ((RubyFixnum)self2).op_lshift(context, value2);
    }

    public static IRubyObject fixnum_op_plus_one(ThreadContext context, IRubyObject caller2, IRubyObject self2) throws Throwable {
        return ((RubyFixnum)self2).op_plus_one(context);
    }

    public static IRubyObject fixnum_op_minus_one(ThreadContext context, IRubyObject caller2, IRubyObject self2) throws Throwable {
        return ((RubyFixnum)self2).op_minus_one(context);
    }

    public static IRubyObject fixnum_op_plus_two(ThreadContext context, IRubyObject caller2, IRubyObject self2) throws Throwable {
        return ((RubyFixnum)self2).op_plus_two(context);
    }

    public static IRubyObject fixnum_op_minus_two(ThreadContext context, IRubyObject caller2, IRubyObject self2) throws Throwable {
        return ((RubyFixnum)self2).op_minus_two(context);
    }

    public static IRubyObject floatOperator(ThreadContext context, IRubyObject caller2, IRubyObject self2, JRubyCallSite site, double value2) throws Throwable {
        MethodHandle target2;
        Ruby runtime2 = context.runtime;
        String operator = site.name;
        MethodType fallbackType = site.type().appendParameterTypes(IRubyObject.class);
        NormalInvokeSite normalSite = NormalInvokeSite.newSite(LOOKUP, site.name, fallbackType, false, 0, site.file(), site.line());
        MethodHandle fallback = Binder.from((MethodType)site.type()).append(IRubyObject.class, (Object)runtime2.newFloat(value2)).invoke(((CallSite)normalSite).dynamicInvoker());
        RubyClass classFloat = runtime2.getFloat();
        SwitchPoint switchPoint = (SwitchPoint)classFloat.getInvalidator().getData();
        CacheEntry entry = MathLinker.searchWithCache(operator, caller2, self2.getMetaClass(), site);
        if (!(self2 instanceof RubyFloat) || entry == null || !entry.method.isBuiltin()) {
            target2 = fallback;
            site.setTarget(target2);
            if (LOG_BINDING) {
                LOG.debug(site.name + "\tFloat operation at site #" + site.siteID + " (" + site.file() + ":" + site.line() + ") bound to normal invocation", new Object[0]);
            }
        } else {
            String opMethod = MethodIndex.getFastFloatOpsMethod(operator);
            String name2 = "float_" + opMethod;
            target2 = MathLinker.findTargetImpl(name2, IRubyObject.class, value2);
            target2 = MethodHandles.guardWithTest(FLOAT_TEST_ARG_2_TO_0, target2, fallback);
            target2 = switchPoint.guardWithTest(target2, fallback);
            site.setTarget(target2);
            if (LOG_BINDING) {
                LOG.debug(name2 + "\tFloat operation at site #" + site.siteID + " (" + site.file() + ":" + site.line() + ") bound directly", new Object[0]);
            }
        }
        return (IRubyObject)target2.invokeWithArguments(context, caller2, self2);
    }

    static boolean floatTest(IRubyObject self2) {
        return self2 instanceof RubyFloat;
    }

    public static IRubyObject float_op_plus(ThreadContext context, IRubyObject caller2, IRubyObject self2, double value2) throws Throwable {
        return ((RubyFloat)self2).op_plus(context, value2);
    }

    public static IRubyObject float_op_minus(ThreadContext context, IRubyObject caller2, IRubyObject self2, double value2) throws Throwable {
        return ((RubyFloat)self2).op_minus(context, value2);
    }

    public static IRubyObject float_op_mul(ThreadContext context, IRubyObject caller2, IRubyObject self2, double value2) throws Throwable {
        return ((RubyFloat)self2).op_mul(context, value2);
    }

    public static IRubyObject float_op_mod(ThreadContext context, IRubyObject caller2, IRubyObject self2, double value2) throws Throwable {
        return ((RubyFloat)self2).op_mod(context, value2);
    }

    public static IRubyObject float_op_div(ThreadContext context, IRubyObject caller2, IRubyObject self2, double value2) throws Throwable {
        return ((RubyFloat)self2).op_div(context, value2);
    }

    public static IRubyObject float_op_equal(ThreadContext context, IRubyObject caller2, IRubyObject self2, double value2) throws Throwable {
        return ((RubyFloat)self2).op_equal(context, value2);
    }

    public static IRubyObject float_op_lt(ThreadContext context, IRubyObject caller2, IRubyObject self2, double value2) throws Throwable {
        return ((RubyFloat)self2).op_lt(context, value2);
    }

    public static IRubyObject float_op_le(ThreadContext context, IRubyObject caller2, IRubyObject self2, double value2) throws Throwable {
        return ((RubyFloat)self2).op_le(context, value2);
    }

    public static IRubyObject float_op_gt(ThreadContext context, IRubyObject caller2, IRubyObject self2, double value2) throws Throwable {
        return ((RubyFloat)self2).op_gt(context, value2);
    }

    public static IRubyObject float_op_ge(ThreadContext context, IRubyObject caller2, IRubyObject self2, double value2) throws Throwable {
        return ((RubyFloat)self2).op_ge(context, value2);
    }

    public static IRubyObject float_op_cmp(ThreadContext context, IRubyObject caller2, IRubyObject self2, double value2) throws Throwable {
        return ((RubyFloat)self2).op_cmp(context, value2);
    }

    private static MethodHandle findTargetImpl(String name2, Class<?> returnType, long value2) throws NoSuchMethodException, IllegalAccessException {
        MethodType type2 = MethodType.methodType(returnType, ThreadContext.class, IRubyObject.class, IRubyObject.class);
        type2 = type2.insertParameterTypes(3, Long.TYPE);
        MethodHandle target2 = MethodHandles.lookup().findStatic(MathLinker.class, name2, type2);
        return MethodHandles.insertArguments(target2, 3, value2);
    }

    private static MethodHandle findTargetImpl(String name2, Class<?> returnType, double value2) throws NoSuchMethodException, IllegalAccessException {
        MethodType type2 = MethodType.methodType(returnType, ThreadContext.class, IRubyObject.class, IRubyObject.class);
        type2 = type2.insertParameterTypes(3, Double.TYPE);
        MethodHandle target2 = MethodHandles.lookup().findStatic(MathLinker.class, name2, type2);
        return MethodHandles.insertArguments(target2, 3, value2);
    }

    private static IRubyObject callMethod(ThreadContext context, IRubyObject caller2, IRubyObject self2, JRubyCallSite site, RubyNumeric value2) {
        String operator = site.name;
        RubyClass selfClass = InvokeDynamicSupport.pollAndGetClass(context, self2);
        CacheEntry entry = MathLinker.searchWithCache(operator, caller2, selfClass, site);
        if (entry == null) {
            return InvokeDynamicSupport.callMethodMissing(CacheEntry.NULL_CACHE, site.callType, context, self2, operator, value2);
        }
        return entry.method.call(context, self2, entry.sourceModule, operator, value2);
    }

    private static CacheEntry searchWithCache(String operator, IRubyObject caller2, RubyClass selfClass, JRubyCallSite site) {
        CacheEntry entry = site.entry;
        if (!entry.typeOk(selfClass)) {
            entry = selfClass.searchWithCache(operator);
            if (InvokeDynamicSupport.methodMissing(entry, site.callType, operator, caller2)) {
                return null;
            }
            site.entry = entry;
        }
        return entry;
    }

    static {
        if (((Boolean)Options.INVOKEDYNAMIC_LOG_BINDING.load()).booleanValue()) {
            LOG.setDebugEnable(true);
        }
        LOG_BINDING = LOG.isDebugEnabled();
        FIXNUM_TEST = Binder.from((MethodType)MethodType.methodType(Boolean.TYPE, IRubyObject.class)).invokeStaticQuiet(MethodHandles.lookup(), MathLinker.class, "fixnumTest");
        FLOAT_TEST = Binder.from((MethodType)MethodType.methodType(Boolean.TYPE, IRubyObject.class)).invokeStaticQuiet(MethodHandles.lookup(), MathLinker.class, "floatTest");
        FIXNUM_OPERATOR = Binder.from((MethodType)MethodType.methodType(IRubyObject.class, ThreadContext.class, IRubyObject.class, IRubyObject.class, JRubyCallSite.class, Long.TYPE)).invokeStaticQuiet(MethodHandles.lookup(), MathLinker.class, "fixnumOperator");
        FLOAT_OPERATOR = Binder.from((MethodType)MethodType.methodType(IRubyObject.class, ThreadContext.class, IRubyObject.class, IRubyObject.class, JRubyCallSite.class, Double.TYPE)).invokeStaticQuiet(MethodHandles.lookup(), MathLinker.class, "floatOperator");
        CALL_TYPES = CallType.values();
        ARG_2_TO_0 = new int[]{2};
        FLOAT_TEST_ARG_2_TO_0 = MethodHandles.permuteArguments(FLOAT_TEST, MethodType.methodType(Boolean.TYPE, ThreadContext.class, IRubyObject.class, IRubyObject.class), ARG_2_TO_0);
        FIXNUM_TEST_ARG_2_TO_0 = MethodHandles.permuteArguments(FIXNUM_TEST, MethodType.methodType(Boolean.TYPE, ThreadContext.class, IRubyObject.class, IRubyObject.class), ARG_2_TO_0);
    }
}

