/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.common;

import java.util.EnumSet;
import java.util.Set;
import org.joni.WarnCallback;
import org.jruby.Ruby;
import org.jruby.RubyHash;
import org.jruby.RubyModule;
import org.jruby.RubyString;
import org.jruby.RubySymbol;
import org.jruby.anno.JRubyMethod;
import org.jruby.ast.util.ArgsUtil;
import org.jruby.common.IRubyWarnings;
import org.jruby.runtime.JavaSites;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.backtrace.RubyStackTraceElement;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.RubyStringBuilder;
import org.jruby.util.TypeConverter;

public class RubyWarnings
implements IRubyWarnings,
WarnCallback {
    private final Ruby runtime;
    private final Set<IRubyWarnings.ID> oncelers = EnumSet.allOf(IRubyWarnings.ID.class);

    public RubyWarnings(Ruby runtime2) {
        this.runtime = runtime2;
    }

    public static RubyModule createWarningModule(Ruby runtime2) {
        RubyModule warning = runtime2.defineModule("Warning");
        warning.defineAnnotatedMethods(RubyWarnings.class);
        warning.extend_object(warning);
        return warning;
    }

    public void warn(String message2) {
        this.warn(IRubyWarnings.ID.MISCELLANEOUS, message2);
    }

    @Override
    public Ruby getRuntime() {
        return this.runtime;
    }

    @Override
    public boolean isVerbose() {
        return this.runtime.isVerbose();
    }

    @Override
    public void warn(IRubyWarnings.ID id2, String fileName, int lineNumber, String message2) {
        this.warn(fileName, lineNumber, message2);
    }

    public void warn(String fileName, int lineNumber, String message2) {
        if (!this.runtime.warningsEnabled()) {
            return;
        }
        String buffer = fileName + ':' + (lineNumber + 1) + ": warning: " + message2 + '\n';
        RubyString errorString = this.runtime.newString(buffer);
        RubyWarnings.writeWarningDyncall(this.runtime.getCurrentContext(), errorString);
    }

    public static void writeWarningDyncall(ThreadContext context, RubyString errorString) {
        RubyModule warning = context.runtime.getWarning();
        RubyWarnings.sites((ThreadContext)context).warn.call(context, (IRubyObject)warning, (IRubyObject)warning, (IRubyObject)errorString);
    }

    public static void writeWarningToError(ThreadContext context, RubyString errorString) {
        Ruby runtime2 = context.runtime;
        IRubyObject errorStream = runtime2.getGlobalVariables().get("$stderr");
        RubyModule warning = runtime2.getWarning();
        RubyWarnings.sites((ThreadContext)context).write.call(context, (IRubyObject)warning, errorStream, (IRubyObject)errorString);
    }

    public static IRubyObject warnWithCategory(ThreadContext context, IRubyObject errorString, IRubyObject category) {
        Ruby runtime2 = context.runtime;
        RubySymbol cat = (RubySymbol)TypeConverter.convertToType(category, runtime2.getSymbol(), "to_sym");
        if (runtime2.getWarningCategories().contains((Object)Category.fromId(cat.idString()))) {
            RubyWarnings.warn(context, null, errorString);
        }
        return context.nil;
    }

    @Override
    public void warn(IRubyWarnings.ID id2, String message2) {
        int line;
        String file2;
        if (!this.runtime.warningsEnabled()) {
            return;
        }
        RubyStackTraceElement stack = this.runtime.getCurrentContext().getSingleBacktrace();
        if (stack == null) {
            file2 = "(unknown)";
            line = 0;
        } else {
            file2 = stack.getFileName();
            line = stack.getLineNumber();
        }
        this.warn(id2, file2, line - 1, message2);
    }

    public void warn(String filename2, String message2) {
        if (!this.runtime.warningsEnabled()) {
            return;
        }
        RubyString errorString = this.runtime.newString(filename2 + ": " + message2 + '\n');
        RubyWarnings.writeWarningDyncall(this.runtime.getCurrentContext(), errorString);
    }

    public void warnExperimental(String filename2, int line, String message2) {
        if (this.runtime.getWarningCategories().contains((Object)Category.EXPERIMENTAL)) {
            this.warn(IRubyWarnings.ID.MISCELLANEOUS, filename2, line, message2);
        }
    }

    public void warnDeprecated(String name2) {
        if (this.runtime.getWarningCategories().contains((Object)Category.DEPRECATED)) {
            this.warn(IRubyWarnings.ID.MISCELLANEOUS, "" + name2 + " is deprecated");
        }
    }

    public void warnDeprecatedAlternate(String name2, String alternate) {
        if (this.runtime.getWarningCategories().contains((Object)Category.DEPRECATED)) {
            this.warn(IRubyWarnings.ID.MISCELLANEOUS, name2 + " is deprecated; use " + alternate + " instead");
        }
    }

    public void warnDeprecatedForRemoval(String name2, String version) {
        if (this.runtime.getWarningCategories().contains((Object)Category.DEPRECATED)) {
            this.warn(IRubyWarnings.ID.MISCELLANEOUS, name2 + " is deprecated and will be removed in Ruby " + version);
        }
    }

    public void warnOnce(IRubyWarnings.ID id2, String message2) {
        if (!this.runtime.warningsEnabled()) {
            return;
        }
        if (this.oncelers.contains((Object)id2)) {
            return;
        }
        this.oncelers.add(id2);
        this.warn(id2, message2);
    }

    public void warning(String message2) {
        if (!this.isVerbose()) {
            return;
        }
        if (!this.runtime.warningsEnabled()) {
            return;
        }
        this.warning(IRubyWarnings.ID.MISCELLANEOUS, message2);
    }

    @Override
    public void warning(IRubyWarnings.ID id2, String message2) {
        if (!this.runtime.warningsEnabled() || !this.runtime.isVerbose()) {
            return;
        }
        RubyWarnings.writeWarning(this.runtime, id2, message2);
    }

    private static void writeWarning(Ruby runtime2, IRubyWarnings.ID id2, String message2) {
        int line;
        String file2;
        RubyStackTraceElement stack = runtime2.getCurrentContext().getSingleBacktrace();
        if (stack == null) {
            file2 = "(unknown)";
            line = -1;
        } else {
            file2 = stack.getFileName();
            line = stack.getLineNumber();
        }
        runtime2.getWarnings().warning(id2, file2, line, message2);
    }

    @Override
    public void warning(IRubyWarnings.ID id2, String fileName, int lineNumber, String message2) {
        this.warning(fileName, lineNumber, message2);
    }

    public void warning(String fileName, int lineNumber, String message2) {
        if (!this.runtime.warningsEnabled() || !this.runtime.isVerbose()) {
            return;
        }
        this.warn(fileName, lineNumber, message2);
    }

    @JRubyMethod(name={"[]"})
    public static IRubyObject op_aref(ThreadContext context, IRubyObject self2, IRubyObject arg2) {
        Ruby runtime2 = context.runtime;
        TypeConverter.checkType(context, arg2, runtime2.getSymbol());
        String categoryId = ((RubySymbol)arg2).idString();
        Category category = Category.fromId(categoryId);
        if (category == null) {
            throw runtime2.newArgumentError(RubyStringBuilder.str(runtime2, "unknown category: ", arg2));
        }
        return runtime2.newBoolean(runtime2.getWarningCategories().contains((Object)category));
    }

    @JRubyMethod(name={"[]="})
    public static IRubyObject op_aset(ThreadContext context, IRubyObject self2, IRubyObject arg2, IRubyObject flag) {
        Ruby runtime2 = context.runtime;
        TypeConverter.checkType(context, arg2, runtime2.getSymbol());
        String categoryId = ((RubySymbol)arg2).idString();
        Category category = Category.fromId(categoryId);
        if (category != null) {
            if (flag.isTrue()) {
                runtime2.getWarningCategories().add(category);
            } else {
                runtime2.getWarningCategories().remove((Object)category);
            }
        } else {
            throw runtime2.newArgumentError(RubyStringBuilder.str(runtime2, "unknown category: ", arg2));
        }
        return flag;
    }

    public static IRubyObject warn(ThreadContext context, IRubyObject recv2, IRubyObject arg2) {
        Ruby runtime2 = context.runtime;
        TypeConverter.checkType(context, arg2, runtime2.getString());
        RubyString str = (RubyString)arg2;
        str.verifyAsciiCompatible();
        RubyWarnings.writeWarningToError(runtime2.getCurrentContext(), str);
        return context.nil;
    }

    @JRubyMethod(required=1, optional=1)
    public static IRubyObject warn(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        if (args2.length > 1) {
            IRubyObject opts = TypeConverter.checkHashType(context.runtime, args2[1]);
            IRubyObject ret = ArgsUtil.extractKeywordArg(context, (RubyHash)opts, "category");
            if (ret.isNil()) {
                return RubyWarnings.warn(context, recv2, args2[0]);
            }
            return RubyWarnings.warnWithCategory(context, args2[0], ret);
        }
        return RubyWarnings.warn(context, recv2, args2[0]);
    }

    private static JavaSites.WarningSites sites(ThreadContext context) {
        return context.sites.Warning;
    }

    @Override
    @Deprecated
    public void warn(IRubyWarnings.ID id2, String fileName, String message2) {
        if (!this.runtime.warningsEnabled()) {
            return;
        }
        IRubyObject errorStream = this.runtime.getGlobalVariables().get("$stderr");
        String buffer = fileName + " warning: " + message2 + '\n';
        errorStream.callMethod(this.runtime.getCurrentContext(), "write", this.runtime.newString(buffer));
    }

    public static enum Category {
        EXPERIMENTAL("experimental"),
        DEPRECATED("deprecated");

        private String id;

        private Category(String id2) {
            this.id = id2;
        }

        public static Category fromId(String id2) {
            switch (id2) {
                case "experimental": {
                    return EXPERIMENTAL;
                }
                case "deprecated": {
                    return DEPRECATED;
                }
            }
            return null;
        }
    }
}

