/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.targets;

import com.headius.invokebinder.Signature;
import java.lang.invoke.MethodType;
import org.jruby.RubyModule;
import org.jruby.compiler.impl.SkinnyMethodAdapter;
import org.jruby.ir.instructions.ClosureAcceptingInstr;
import org.jruby.ir.operands.NullBlock;
import org.jruby.ir.runtime.IRRuntimeHelpers;
import org.jruby.ir.targets.ArgumentsCompiler;
import org.jruby.ir.targets.BlockCompiler;
import org.jruby.ir.targets.BranchCompiler;
import org.jruby.ir.targets.BytecodeMode;
import org.jruby.ir.targets.CheckpointCompiler;
import org.jruby.ir.targets.ClassData;
import org.jruby.ir.targets.ConstantCompiler;
import org.jruby.ir.targets.DynamicValueCompiler;
import org.jruby.ir.targets.GlobalVariableCompiler;
import org.jruby.ir.targets.InstanceVariableCompiler;
import org.jruby.ir.targets.InvocationCompiler;
import org.jruby.ir.targets.ValueCompiler;
import org.jruby.ir.targets.YieldCompiler;
import org.jruby.ir.targets.indy.IndyArgumentsCompiler;
import org.jruby.ir.targets.indy.IndyBlockCompiler;
import org.jruby.ir.targets.indy.IndyBranchCompiler;
import org.jruby.ir.targets.indy.IndyCheckpointCompiler;
import org.jruby.ir.targets.indy.IndyConstantCompiler;
import org.jruby.ir.targets.indy.IndyDynamicValueCompiler;
import org.jruby.ir.targets.indy.IndyGlobalVariableCompiler;
import org.jruby.ir.targets.indy.IndyInstanceVariableCompiler;
import org.jruby.ir.targets.indy.IndyInvocationCompiler;
import org.jruby.ir.targets.indy.IndyValueCompiler;
import org.jruby.ir.targets.indy.IndyYieldCompiler;
import org.jruby.ir.targets.simple.NormalArgumentsCompiler;
import org.jruby.ir.targets.simple.NormalBlockCompiler;
import org.jruby.ir.targets.simple.NormalBranchCompiler;
import org.jruby.ir.targets.simple.NormalCheckpointCompiler;
import org.jruby.ir.targets.simple.NormalConstantCompiler;
import org.jruby.ir.targets.simple.NormalDynamicValueCompiler;
import org.jruby.ir.targets.simple.NormalGlobalVariableCompiler;
import org.jruby.ir.targets.simple.NormalInstanceVariableCompiler;
import org.jruby.ir.targets.simple.NormalInvocationCompiler;
import org.jruby.ir.targets.simple.NormalValueCompiler;
import org.jruby.ir.targets.simple.NormalYieldCompiler;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.Binding;
import org.jruby.runtime.Block;
import org.jruby.runtime.Frame;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.CodegenUtils;
import org.jruby.util.JavaNameMangler;
import org.jruby.util.collections.IntHashMap;
import org.objectweb.asm.Handle;
import org.objectweb.asm.Label;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.Method;

public class IRBytecodeAdapter {
    public static final int MAX_ARGUMENTS = 250;
    public SkinnyMethodAdapter adapter;
    private int variableCount = 0;
    private final IntHashMap<Type> variableTypes = new IntHashMap();
    private final IntHashMap<String> variableNames = new IntHashMap();
    protected final Signature signature;
    protected final ClassData classData;
    protected final ValueCompiler valueCompiler;
    protected final DynamicValueCompiler dynamicValueCompiler;
    protected final InvocationCompiler invocationCompiler;
    protected final BranchCompiler branchCompiler;
    protected final CheckpointCompiler checkpointCompiler;
    protected final ConstantCompiler constantCompiler;
    protected final InstanceVariableCompiler instanceVariableCompiler;
    protected final GlobalVariableCompiler globalVariableCompiler;
    protected final YieldCompiler yieldCompiler;
    protected final BlockCompiler blockCompiler;
    protected final ArgumentsCompiler argumentsCompiler;
    public int ipc = 0;
    private int lastLine = -1;

    public IRBytecodeAdapter(BytecodeMode bytecodeMode, SkinnyMethodAdapter adapter, Signature signature, ClassData classData) {
        this.adapter = adapter;
        this.signature = signature;
        this.classData = classData;
        switch (bytecodeMode) {
            case INDY: {
                this.valueCompiler = new IndyValueCompiler(this);
                this.dynamicValueCompiler = new IndyDynamicValueCompiler(this);
                this.invocationCompiler = new IndyInvocationCompiler(this);
                this.branchCompiler = new IndyBranchCompiler(this);
                this.checkpointCompiler = new IndyCheckpointCompiler(this);
                this.instanceVariableCompiler = new IndyInstanceVariableCompiler(this);
                this.globalVariableCompiler = new IndyGlobalVariableCompiler(this);
                this.yieldCompiler = new IndyYieldCompiler(this);
                this.blockCompiler = new IndyBlockCompiler(this);
                this.argumentsCompiler = new IndyArgumentsCompiler(this);
                this.constantCompiler = new IndyConstantCompiler(this);
                break;
            }
            case MIXED: {
                this.valueCompiler = new IndyValueCompiler(this);
                this.dynamicValueCompiler = new NormalDynamicValueCompiler(this);
                this.invocationCompiler = new NormalInvocationCompiler(this);
                this.branchCompiler = new NormalBranchCompiler(this);
                this.checkpointCompiler = new NormalCheckpointCompiler(this);
                this.instanceVariableCompiler = new NormalInstanceVariableCompiler(this);
                this.globalVariableCompiler = new IndyGlobalVariableCompiler(this);
                this.yieldCompiler = new IndyYieldCompiler(this);
                this.blockCompiler = new IndyBlockCompiler(this);
                this.argumentsCompiler = new NormalArgumentsCompiler(this);
                this.constantCompiler = new IndyConstantCompiler(this);
                break;
            }
            case AOT: {
                this.valueCompiler = new NormalValueCompiler(this);
                this.dynamicValueCompiler = new NormalDynamicValueCompiler(this);
                this.invocationCompiler = new NormalInvocationCompiler(this);
                this.branchCompiler = new NormalBranchCompiler(this);
                this.checkpointCompiler = new NormalCheckpointCompiler(this);
                this.instanceVariableCompiler = new NormalInstanceVariableCompiler(this);
                this.globalVariableCompiler = new NormalGlobalVariableCompiler(this);
                this.yieldCompiler = new NormalYieldCompiler(this);
                this.blockCompiler = new NormalBlockCompiler(this);
                this.argumentsCompiler = new NormalArgumentsCompiler(this);
                this.constantCompiler = new NormalConstantCompiler(this);
                break;
            }
            default: {
                throw new RuntimeException("unknown compile mode: " + (Object)((Object)bytecodeMode));
            }
        }
    }

    public ValueCompiler getValueCompiler() {
        return this.valueCompiler;
    }

    public DynamicValueCompiler getDynamicValueCompiler() {
        return this.dynamicValueCompiler;
    }

    public InvocationCompiler getInvocationCompiler() {
        return this.invocationCompiler;
    }

    public BranchCompiler getBranchCompiler() {
        return this.branchCompiler;
    }

    public CheckpointCompiler getCheckpointCompiler() {
        return this.checkpointCompiler;
    }

    public ConstantCompiler getConstantCompiler() {
        return this.constantCompiler;
    }

    public InstanceVariableCompiler getInstanceVariableCompiler() {
        return this.instanceVariableCompiler;
    }

    public GlobalVariableCompiler getGlobalVariableCompiler() {
        return this.globalVariableCompiler;
    }

    public YieldCompiler getYieldCompiler() {
        return this.yieldCompiler;
    }

    public BlockCompiler getBlockCompiler() {
        return this.blockCompiler;
    }

    public ArgumentsCompiler getArgumentsCompiler() {
        return this.argumentsCompiler;
    }

    public static void buildArrayFromLocals(SkinnyMethodAdapter adapter2, int base, int arity2) {
        int j;
        if (arity2 == 0) {
            adapter2.getstatic(CodegenUtils.p(IRubyObject.class), "NULL_ARRAY", CodegenUtils.ci(IRubyObject[].class));
            return;
        }
        adapter2.pushInt(arity2);
        adapter2.invokestatic(CodegenUtils.p(Helpers.class), "anewarrayIRubyObjects", CodegenUtils.sig(IRubyObject[].class, Integer.TYPE));
        for (int i2 = 0; i2 < arity2; i2 += j) {
            for (j = 0; i2 + j < arity2 && j < 10; ++j) {
                adapter2.aload(base + i2 + j);
            }
            adapter2.pushInt(i2);
            adapter2.invokestatic(CodegenUtils.p(Helpers.class), "aastoreIRubyObjects", CodegenUtils.sig(IRubyObject[].class, CodegenUtils.params(IRubyObject[].class, IRubyObject.class, j, Integer.TYPE)));
        }
    }

    public String getUniqueSiteName(String name2) {
        return "invokeOther" + this.getClassData().cacheFieldCount.getAndIncrement() + ":" + JavaNameMangler.mangleMethodName(name2);
    }

    public ClassData getClassData() {
        return this.classData;
    }

    public void startMethod() {
        this.adapter.start();
    }

    public void endMethod() {
        this.adapter.end(new Runnable(){

            @Override
            public void run() {
                for (IntHashMap.Entry entry : IRBytecodeAdapter.this.variableTypes.entrySet()) {
                    int i2 = entry.getKey();
                    String name2 = (String)IRBytecodeAdapter.this.variableNames.get(i2);
                    IRBytecodeAdapter.this.adapter.local(i2, name2, (Type)entry.getValue());
                }
            }
        });
    }

    public void loadLocal(int i2) {
        this.adapter.aload(i2);
    }

    public void loadContext() {
        this.adapter.aload(this.signature.argOffset("context"));
    }

    public void loadSelfBlock() {
        int selfBlockOffset = this.signature.argOffset("selfBlock");
        if (selfBlockOffset == -1) {
            this.adapter.aconst_null();
        } else {
            this.adapter.aload(selfBlockOffset);
        }
    }

    public void loadStaticScope() {
        this.adapter.aload(this.signature.argOffset("scope"));
    }

    public void loadSelf() {
        this.adapter.aload(this.signature.argOffset("self"));
    }

    public void loadArgs() {
        this.adapter.aload(this.signature.argOffset("args"));
    }

    public void loadBlock() {
        this.adapter.aload(this.signature.argOffset("blockArg"));
    }

    public void loadFrameClass() {
        int superNameOffset = this.signature.argOffset("superName");
        if (superNameOffset == -1) {
            this.loadSelfBlock();
            this.adapter.invokevirtual(CodegenUtils.p(Block.class), "getBinding", CodegenUtils.sig(Binding.class, new Class[0]));
            this.adapter.invokevirtual(CodegenUtils.p(Binding.class), "getFrame", CodegenUtils.sig(Frame.class, new Class[0]));
            this.adapter.invokevirtual(CodegenUtils.p(Frame.class), "getKlazz", CodegenUtils.sig(RubyModule.class, new Class[0]));
        } else {
            this.adapter.aload(this.signature.argCount() - 2);
        }
    }

    public void loadFrameName() {
        int superNameOffset = this.signature.argOffset("superName");
        if (superNameOffset == -1) {
            this.loadSelfBlock();
            this.adapter.invokevirtual(CodegenUtils.p(Block.class), "getBinding", CodegenUtils.sig(Binding.class, new Class[0]));
            this.adapter.invokevirtual(CodegenUtils.p(Binding.class), "getMethod", CodegenUtils.sig(String.class, new Class[0]));
        } else {
            this.adapter.aload(superNameOffset);
        }
    }

    public void storeSelf() {
        this.adapter.astore(this.signature.argOffset("self"));
    }

    public void storeArgs() {
        this.adapter.astore(this.signature.argOffset("args"));
    }

    public void storeLocal(int i2) {
        this.adapter.astore(i2);
    }

    public void invokeVirtual(Type type2, Method method2) {
        this.adapter.invokevirtual(type2.getInternalName(), method2.getName(), method2.getDescriptor());
    }

    public void invokeStatic(Type type2, Method method2) {
        this.adapter.invokestatic(type2.getInternalName(), method2.getName(), method2.getDescriptor());
    }

    public void invokeHelper(String name2, String sig) {
        this.adapter.invokestatic(CodegenUtils.p(Helpers.class), name2, sig);
    }

    public void invokeHelper(String name2, Class ... x) {
        this.adapter.invokestatic(CodegenUtils.p(Helpers.class), name2, CodegenUtils.sig(x));
    }

    public void invokeIRHelper(String name2, String sig) {
        this.adapter.invokestatic(CodegenUtils.p(IRRuntimeHelpers.class), name2, sig);
    }

    public void goTo(Label label2) {
        this.adapter.go_to(label2);
    }

    public void pushHandle(Handle handle) {
        this.adapter.getMethodVisitor().visitLdcInsn((Object)handle);
    }

    public void mark(Label label2) {
        this.adapter.label(label2);
    }

    public void returnValue() {
        this.adapter.areturn();
    }

    public int newLocal(String name2, Type type2) {
        int index2 = this.variableCount++;
        if (type2 == Type.DOUBLE_TYPE || type2 == Type.LONG_TYPE) {
            ++this.variableCount;
        }
        this.variableTypes.put(index2, type2);
        this.variableNames.put(index2, name2);
        return index2;
    }

    public Label newLabel() {
        return new Label();
    }

    public void getStaticScope(String field) {
        this.adapter.getstatic(this.classData.clsName, field, CodegenUtils.ci(StaticScope.class));
        this.adapter.dup();
        Label after = this.newLabel();
        this.adapter.ifnonnull(after);
        this.adapter.pop();
        this.adapter.ldc(this.classData.visitor.staticScopeDescriptorMap.get(field));
        this.loadStaticScope();
        this.invokeHelper("restoreScope", StaticScope.class, String.class, StaticScope.class);
        this.adapter.dup();
        this.adapter.putstatic(this.classData.clsName, field, CodegenUtils.ci(StaticScope.class));
        this.adapter.label(after);
    }

    public void outline(String name2, MethodType type2, Runnable body) {
        SkinnyMethodAdapter oldAdapter = this.adapter;
        this.adapter = new SkinnyMethodAdapter(oldAdapter.getClassVisitor(), 4106, name2, CodegenUtils.sig(type2), null, null);
        body.run();
        this.adapter.end();
        this.adapter = oldAdapter;
    }

    public void updateLineNumber(int lineNumber) {
        this.lastLine = lineNumber + 1;
        this.adapter.line(this.lastLine);
    }

    public int getLastLine() {
        return this.lastLine;
    }

    public static enum BlockPassType {
        NONE(false, false),
        GIVEN(true, false),
        LITERAL(true, true);

        private final boolean given;
        private final boolean literal;

        private BlockPassType(boolean given, boolean literal) {
            this.given = given;
            this.literal = literal;
        }

        public boolean given() {
            return this.given;
        }

        public boolean literal() {
            return this.literal;
        }

        public static BlockPassType fromIR(ClosureAcceptingInstr callInstr) {
            return callInstr.getClosureArg() != NullBlock.INSTANCE ? (callInstr.hasLiteralClosure() ? LITERAL : GIVEN) : NONE;
        }
    }
}

