/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.concurrent.locks.ReentrantLock;
import org.jcodings.Encoding;
import org.jcodings.specific.ASCIIEncoding;
import org.jcodings.specific.USASCIIEncoding;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyEncoding;
import org.jruby.RubyFixnum;
import org.jruby.RubyModule;
import org.jruby.RubyObject;
import org.jruby.RubyProc;
import org.jruby.RubyRegexp;
import org.jruby.RubyString;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.ast.util.ArgsUtil;
import org.jruby.compiler.Constantizable;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.ArgumentDescriptor;
import org.jruby.runtime.Block;
import org.jruby.runtime.CallSite;
import org.jruby.runtime.CallType;
import org.jruby.runtime.ClassIndex;
import org.jruby.runtime.ContextAwareBlockBody;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.JavaSites;
import org.jruby.runtime.MethodIndex;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.Signature;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.callsite.RefinedCachingCallSite;
import org.jruby.runtime.encoding.EncodingCapable;
import org.jruby.runtime.encoding.MarshalEncoding;
import org.jruby.runtime.marshal.UnmarshalStream;
import org.jruby.runtime.opto.OptoFactory;
import org.jruby.util.ByteList;
import org.jruby.util.IdUtil;
import org.jruby.util.PerlHash;
import org.jruby.util.RubyStringBuilder;
import org.jruby.util.SipHashInline;
import org.jruby.util.StringSupport;
import org.jruby.util.SymbolNameType;
import org.jruby.util.TypeConverter;

@JRubyClass(name={"Symbol"}, include={"Enumerable"})
public class RubySymbol
extends RubyObject
implements MarshalEncoding,
EncodingCapable,
Constantizable {
    @Deprecated
    public static final long symbolHashSeedK0 = 5238926673095087190L;
    private final String symbol;
    private final int id;
    private final ByteList symbolBytes;
    private final int hashCode;
    private String decodedString;
    private RubyString rubyString;
    private transient Object constant;
    private SymbolNameType type;

    private RubySymbol(Ruby runtime2, String internedSymbol, ByteList symbolBytes) {
        super(runtime2, runtime2.getSymbol(), false);
        assert (internedSymbol == internedSymbol.intern()) : internedSymbol + " is not interned";
        this.symbol = internedSymbol;
        if (symbolBytes.getEncoding() != USASCIIEncoding.INSTANCE && StringSupport.codeRangeScan(symbolBytes.getEncoding(), symbolBytes) == 16) {
            symbolBytes = symbolBytes.dup();
            symbolBytes.setEncoding((Encoding)USASCIIEncoding.INSTANCE);
        }
        this.symbolBytes = symbolBytes;
        this.id = runtime2.allocSymbolId();
        long k0 = Helpers.hashStart(runtime2, this.id);
        long hash2 = runtime2.isSiphashEnabled() ? SipHashInline.hash24(k0, 0L, symbolBytes.getUnsafeBytes(), symbolBytes.getBegin(), symbolBytes.getRealSize()) : PerlHash.hash(k0, symbolBytes.getUnsafeBytes(), symbolBytes.getBegin(), symbolBytes.getRealSize());
        this.hashCode = (int)hash2;
        this.type = IdUtil.determineSymbolNameType(runtime2, symbolBytes);
        this.setFrozen(true);
    }

    private RubySymbol(Ruby runtime2, String internedSymbol) {
        this(runtime2, internedSymbol, RubySymbol.symbolBytesFromString(runtime2, internedSymbol));
    }

    public static RubyClass createSymbolClass(Ruby runtime2) {
        RubyClass symbolClass = runtime2.defineClass("Symbol", runtime2.getObject(), ObjectAllocator.NOT_ALLOCATABLE_ALLOCATOR);
        RubyClass symbolMetaClass = symbolClass.getMetaClass();
        symbolClass.setClassIndex(ClassIndex.SYMBOL);
        symbolClass.setReifiedClass(RubySymbol.class);
        symbolClass.kindOf = new RubyModule.JavaClassKindOf(RubySymbol.class);
        symbolClass.defineAnnotatedMethods(RubySymbol.class);
        symbolMetaClass.undefineMethod("new");
        symbolClass.includeModule(runtime2.getComparable());
        return symbolClass;
    }

    @Override
    public ClassIndex getNativeClassIndex() {
        return ClassIndex.SYMBOL;
    }

    @Override
    public final String asJavaString() {
        return this.symbol;
    }

    public String idString() {
        return this.symbol;
    }

    @Override
    public final String toString() {
        String decoded = this.decodedString;
        if (decoded == null) {
            this.decodedString = decoded = RubyEncoding.decodeRaw(this.getBytes());
        }
        return decoded;
    }

    public final ByteList getBytes() {
        return this.symbolBytes;
    }

    public RubySymbol asWriter() {
        ByteList bytes2 = this.getBytes();
        ByteList dup2 = bytes2.dup(bytes2.length() + 1);
        dup2.append((byte)61);
        return RubySymbol.newIDSymbol(this.metaClass.runtime, dup2);
    }

    public RubySymbol asInstanceVariable() {
        ByteList bytes2 = this.getBytes();
        ByteList dup2 = new ByteList(bytes2.length() + 1);
        dup2.setEncoding(ByteList.safeEncoding(bytes2.getEncoding()));
        dup2.append((byte)64);
        dup2.append(bytes2);
        return RubySymbol.newIDSymbol(this.metaClass.runtime, dup2);
    }

    public static RubySymbol retrieveIDSymbol(IRubyObject name2) {
        return name2 instanceof RubySymbol ? (RubySymbol)name2 : RubySymbol.newIDSymbol(name2.getRuntime(), name2.convertToString().getByteList());
    }

    public static RubySymbol retrieveIDSymbol(IRubyObject name2, ObjBooleanConsumer<RubySymbol> handler) {
        if (name2 instanceof RubySymbol) {
            RubySymbol sym = (RubySymbol)name2;
            handler.accept(sym, false);
            return sym;
        }
        return RubySymbol.newIDSymbol(name2.getRuntime(), name2.convertToString().getByteList(), handler);
    }

    public void associateEncoding(Encoding encoding2) {
        this.symbolBytes.setEncoding(encoding2);
    }

    @Override
    public final boolean eql(IRubyObject other) {
        return other == this;
    }

    public boolean validConstantName() {
        return this.type == SymbolNameType.CONST;
    }

    public boolean validInstanceVariableName() {
        return this.type == SymbolNameType.INSTANCE;
    }

    public boolean validClassVariableName() {
        return this.type == SymbolNameType.CLASS;
    }

    public boolean validLocalVariableName() {
        return this.type == SymbolNameType.LOCAL && !"nil".equals(this.idString());
    }

    @Override
    public boolean isImmediate() {
        return true;
    }

    @Override
    public RubyClass getSingletonClass() {
        throw this.getRuntime().newTypeError("can't define singleton");
    }

    public static RubySymbol getSymbolLong(Ruby runtime2, long id2) {
        return runtime2.getSymbolTable().lookup(id2);
    }

    @Deprecated
    public static RubySymbol newSymbol(Ruby runtime2, IRubyObject name2) {
        if (name2 instanceof RubySymbol) {
            return runtime2.getSymbolTable().getSymbol(((RubySymbol)name2).getBytes(), false);
        }
        if (name2 instanceof RubyString) {
            return runtime2.getSymbolTable().getSymbol(((RubyString)name2).getByteList(), false);
        }
        return RubySymbol.newSymbol(runtime2, name2.asString().getByteList());
    }

    public static RubySymbol newHardSymbol(Ruby runtime2, IRubyObject name2) {
        if (name2 instanceof RubySymbol) {
            return runtime2.getSymbolTable().getSymbol(((RubySymbol)name2).getBytes(), true);
        }
        if (name2 instanceof RubyString) {
            return runtime2.getSymbolTable().getSymbol(((RubyString)name2).getByteList(), true);
        }
        return RubySymbol.newSymbol(runtime2, name2.asString().getByteList());
    }

    public static RubySymbol newSymbol(Ruby runtime2, String name2) {
        return runtime2.getSymbolTable().getSymbol(name2, false);
    }

    public static RubySymbol newSymbol(Ruby runtime2, ByteList bytes2) {
        return runtime2.getSymbolTable().getSymbol(bytes2, false);
    }

    public static RubySymbol newHardSymbol(Ruby runtime2, ByteList bytes2) {
        return runtime2.getSymbolTable().getSymbol(bytes2, true);
    }

    public static RubySymbol newHardSymbol(Ruby runtime2, ByteList bytes2, ObjBooleanConsumer<RubySymbol> handler) {
        return runtime2.getSymbolTable().getSymbol(bytes2, handler, true);
    }

    public static RubySymbol newHardSymbol(Ruby runtime2, String name2) {
        return runtime2.getSymbolTable().getSymbol(name2, true);
    }

    public static RubySymbol newSymbol(Ruby runtime2, ByteList bytes2, ObjBooleanConsumer<RubySymbol> handler) {
        return runtime2.getSymbolTable().getSymbol(bytes2, handler, false);
    }

    public static RubySymbol newIDSymbol(Ruby runtime2, ByteList bytes2) {
        return RubySymbol.newHardSymbol(runtime2, bytes2);
    }

    public static RubySymbol newIDSymbol(Ruby runtime2, ByteList bytes2, ObjBooleanConsumer<RubySymbol> handler) {
        return RubySymbol.newHardSymbol(runtime2, bytes2, handler);
    }

    public static RubySymbol newConstantSymbol(Ruby runtime2, IRubyObject fqn, ByteList bytes2) {
        if (bytes2.length() == 0) {
            throw runtime2.newNameError(RubyStringBuilder.str(runtime2, "wrong constant name ", RubyStringBuilder.ids(runtime2, fqn)), runtime2.newSymbol(""));
        }
        RubySymbol symbol = runtime2.newSymbol(bytes2);
        if (!symbol.validConstantName()) {
            throw runtime2.newNameError(RubyStringBuilder.str(runtime2, "wrong constant name ", RubyStringBuilder.ids(runtime2, fqn)), symbol);
        }
        return symbol;
    }

    public static RubySymbol newSymbol(Ruby runtime2, String name2, Encoding encoding2) {
        RubySymbol newSymbol = runtime2.getSymbolTable().getSymbol(RubyString.encodeBytelist(name2, encoding2));
        return newSymbol;
    }

    public static RubySymbol newHardSymbol(Ruby runtime2, String name2, Encoding encoding2) {
        RubySymbol newSymbol = runtime2.getSymbolTable().getSymbol(RubyString.encodeBytelist(name2, encoding2));
        return newSymbol;
    }

    @Override
    public Object constant() {
        return this.constant == null ? (this.constant = OptoFactory.newConstantWrapper(IRubyObject.class, this)) : this.constant;
    }

    @Override
    public IRubyObject inspect() {
        return this.inspect(this.metaClass.runtime);
    }

    @JRubyMethod(name={"inspect"})
    public IRubyObject inspect(ThreadContext context) {
        return this.inspect(context.runtime);
    }

    final RubyString inspect(Ruby runtime2) {
        Encoding resenc = runtime2.getDefaultInternalEncoding();
        if (resenc == null) {
            resenc = runtime2.getDefaultExternalEncoding();
        }
        RubyString str = RubyString.newString(runtime2, this.getBytes());
        if (!this.isPrintable(runtime2) || !resenc.equals((Object)this.getBytes().getEncoding()) && !str.isAsciiOnly() || !RubySymbol.isSymbolName(this.symbol)) {
            str = str.inspect(runtime2);
        }
        ByteList result2 = new ByteList(str.getByteList().getRealSize() + 1);
        result2.setEncoding(str.getEncoding());
        result2.append((byte)58);
        result2.append(str.getByteList());
        return RubyString.newString(runtime2, result2);
    }

    @Deprecated
    public IRubyObject inspect19(ThreadContext context) {
        return this.inspect(context);
    }

    @Override
    public IRubyObject to_s() {
        return this.to_s(this.metaClass.runtime);
    }

    @JRubyMethod(name={"to_s"})
    public IRubyObject to_s(ThreadContext context) {
        return this.to_s(context.runtime);
    }

    final RubyString to_s(Ruby runtime2) {
        return RubyString.newStringShared(runtime2, this.getBytes());
    }

    @JRubyMethod(name={"name"})
    public IRubyObject name(ThreadContext context) {
        if (this.rubyString == null) {
            this.rubyString = RubyString.newStringShared(context.runtime, this.getBytes());
            this.rubyString.setFrozen(true);
        }
        return this.rubyString;
    }

    public IRubyObject id2name() {
        return this.to_s(this.metaClass.runtime);
    }

    @JRubyMethod
    public IRubyObject id2name(ThreadContext context) {
        return this.to_s(context);
    }

    @Override
    public RubyString asString() {
        return this.to_s(this.metaClass.runtime);
    }

    @Override
    @JRubyMethod(name={"==="})
    public IRubyObject op_eqq(ThreadContext context, IRubyObject other) {
        return RubyBoolean.newBoolean(context, this == other);
    }

    @Override
    @JRubyMethod(name={"=="})
    public IRubyObject op_equal(ThreadContext context, IRubyObject other) {
        return RubyBoolean.newBoolean(context, this == other);
    }

    @Override
    @Deprecated
    public RubyFixnum hash() {
        return this.metaClass.runtime.newFixnum(this.hashCode());
    }

    @JRubyMethod
    public RubyFixnum hash(ThreadContext context) {
        return context.runtime.newFixnum(this.hashCode());
    }

    @Override
    public int hashCode() {
        return this.hashCode;
    }

    public int getId() {
        return this.id;
    }

    @Override
    public boolean equals(Object other) {
        return other == this;
    }

    @Override
    public int compareTo(IRubyObject that) {
        if (that instanceof RubySymbol) {
            return this.symbol.compareTo(((RubySymbol)that).symbol);
        }
        return 0;
    }

    @JRubyMethod(name={"to_sym", "intern"})
    public IRubyObject to_sym() {
        return this;
    }

    @Deprecated
    public IRubyObject to_sym19() {
        return this;
    }

    private RubyString newShared(Ruby runtime2) {
        return RubyString.newStringShared(runtime2, this.symbolBytes);
    }

    @JRubyMethod(name={"succ", "next"})
    public IRubyObject succ(ThreadContext context) {
        Ruby runtime2 = context.runtime;
        return RubySymbol.newSymbol(runtime2, this.newShared(runtime2).succ(context).asString().getByteList());
    }

    @Override
    @JRubyMethod(name={"<=>"})
    public IRubyObject op_cmp(ThreadContext context, IRubyObject other) {
        Ruby runtime2 = context.runtime;
        return !(other instanceof RubySymbol) ? context.nil : this.newShared(runtime2).op_cmp(context, ((RubySymbol)other).newShared(runtime2));
    }

    @JRubyMethod
    public IRubyObject casecmp(ThreadContext context, IRubyObject other) {
        Ruby runtime2 = context.runtime;
        return !(other instanceof RubySymbol) ? context.nil : this.newShared(runtime2).casecmp(context, ((RubySymbol)other).newShared(runtime2));
    }

    @JRubyMethod(name={"casecmp?"})
    public IRubyObject casecmp_p(ThreadContext context, IRubyObject other) {
        Ruby runtime2 = context.runtime;
        return !(other instanceof RubySymbol) ? context.nil : this.newShared(runtime2).casecmp_p(context, ((RubySymbol)other).newShared(runtime2));
    }

    @Override
    @JRubyMethod(name={"=~"})
    public IRubyObject op_match(ThreadContext context, IRubyObject other) {
        return this.newShared(context.runtime).op_match(context, other);
    }

    @JRubyMethod(name={"match"})
    public IRubyObject match_m(ThreadContext context, IRubyObject other, Block block) {
        return this.newShared(context.runtime).match19(context, other, block);
    }

    @JRubyMethod(name={"match"})
    public IRubyObject match_m(ThreadContext context, IRubyObject other, IRubyObject pos2, Block block) {
        return this.newShared(context.runtime).match19(context, other, pos2, block);
    }

    @JRubyMethod(name={"match"}, required=1, rest=true, checkArity=false)
    public IRubyObject match_m(ThreadContext context, IRubyObject[] args2, Block block) {
        return this.newShared(context.runtime).match19(context, args2, block);
    }

    @JRubyMethod(name={"match?"})
    public IRubyObject match_p(ThreadContext context, IRubyObject other) {
        return this.newShared(context.runtime).match_p(context, other);
    }

    @JRubyMethod(name={"match?"})
    public IRubyObject match_p(ThreadContext context, IRubyObject other, IRubyObject pos2) {
        return this.newShared(context.runtime).match_p(context, other, pos2);
    }

    @JRubyMethod(name={"[]", "slice"})
    public IRubyObject op_aref(ThreadContext context, IRubyObject arg2) {
        return this.newShared(context.runtime).op_aref(context, arg2);
    }

    @JRubyMethod(name={"[]", "slice"})
    public IRubyObject op_aref(ThreadContext context, IRubyObject arg1, IRubyObject arg2) {
        return this.newShared(context.runtime).op_aref(context, arg1, arg2);
    }

    @JRubyMethod(name={"length", "size"})
    public IRubyObject length() {
        Ruby runtime2 = this.metaClass.runtime;
        return RubyFixnum.newFixnum(runtime2, this.newShared(runtime2).strLength());
    }

    @JRubyMethod(name={"empty?"})
    public IRubyObject empty_p(ThreadContext context) {
        return this.newShared(context.runtime).empty_p(context);
    }

    @JRubyMethod(name={"start_with?"})
    public IRubyObject start_with_p(ThreadContext context) {
        return context.fals;
    }

    @JRubyMethod(name={"start_with?"})
    public IRubyObject start_with_p(ThreadContext context, IRubyObject arg2) {
        if (arg2 instanceof RubyRegexp) {
            return ((RubyRegexp)arg2).startsWith(context, this.to_s(context.runtime)) ? context.tru : context.fals;
        }
        return this.to_s(context.runtime).startsWith(arg2.convertToString()) ? context.tru : context.fals;
    }

    @JRubyMethod(name={"start_with?"}, rest=true)
    public IRubyObject start_with_p(ThreadContext context, IRubyObject[] args2) {
        for (int i2 = 0; i2 < args2.length; ++i2) {
            if (!this.start_with_p(context, args2[i2]).isTrue()) continue;
            return context.tru;
        }
        return context.fals;
    }

    @JRubyMethod(name={"end_with?"})
    public IRubyObject end_with_p(ThreadContext context) {
        return context.fals;
    }

    @JRubyMethod(name={"end_with?"})
    public IRubyObject end_with_p(ThreadContext context, IRubyObject arg2) {
        return this.to_s(context.runtime).endWith(arg2) ? context.tru : context.fals;
    }

    @JRubyMethod(name={"end_with?"}, rest=true)
    public IRubyObject end_with_p(ThreadContext context, IRubyObject[] args2) {
        RubyString str = this.to_s(context.runtime);
        for (int i2 = 0; i2 < args2.length; ++i2) {
            if (!str.endWith(args2[i2])) continue;
            return context.tru;
        }
        return context.fals;
    }

    @JRubyMethod
    public IRubyObject upcase(ThreadContext context) {
        Ruby runtime2 = context.runtime;
        return RubySymbol.newSymbol(runtime2, this.newShared(runtime2).upcase(context).getByteList());
    }

    @JRubyMethod
    public IRubyObject upcase(ThreadContext context, IRubyObject arg2) {
        Ruby runtime2 = context.runtime;
        return RubySymbol.newSymbol(runtime2, this.newShared(runtime2).upcase(context, arg2).getByteList());
    }

    @JRubyMethod
    public IRubyObject upcase(ThreadContext context, IRubyObject arg0, IRubyObject arg1) {
        Ruby runtime2 = context.runtime;
        return RubySymbol.newSymbol(runtime2, this.newShared(runtime2).upcase(context, arg0, arg1).getByteList());
    }

    @JRubyMethod
    public IRubyObject downcase(ThreadContext context) {
        Ruby runtime2 = context.runtime;
        return RubySymbol.newSymbol(runtime2, this.newShared(runtime2).downcase(context).getByteList());
    }

    @JRubyMethod
    public IRubyObject downcase(ThreadContext context, IRubyObject arg2) {
        Ruby runtime2 = context.runtime;
        return RubySymbol.newSymbol(runtime2, this.newShared(runtime2).downcase(context, arg2).getByteList());
    }

    @JRubyMethod
    public IRubyObject downcase(ThreadContext context, IRubyObject arg0, IRubyObject arg1) {
        Ruby runtime2 = context.runtime;
        return RubySymbol.newSymbol(runtime2, this.newShared(runtime2).downcase(context, arg0, arg1).getByteList());
    }

    @JRubyMethod
    public IRubyObject swapcase(ThreadContext context) {
        Ruby runtime2 = context.runtime;
        return RubySymbol.newSymbol(runtime2, this.newShared(runtime2).swapcase(context).getByteList());
    }

    @JRubyMethod
    public IRubyObject swapcase(ThreadContext context, IRubyObject arg2) {
        Ruby runtime2 = context.runtime;
        return RubySymbol.newSymbol(runtime2, this.newShared(runtime2).swapcase(context, arg2).getByteList());
    }

    @JRubyMethod
    public IRubyObject swapcase(ThreadContext context, IRubyObject arg0, IRubyObject arg1) {
        Ruby runtime2 = context.runtime;
        return RubySymbol.newSymbol(runtime2, this.newShared(runtime2).swapcase(context, arg0, arg1).getByteList());
    }

    @JRubyMethod
    public IRubyObject capitalize(ThreadContext context) {
        Ruby runtime2 = context.runtime;
        return RubySymbol.newSymbol(runtime2, this.newShared(runtime2).capitalize(context).getByteList());
    }

    @JRubyMethod
    public IRubyObject capitalize(ThreadContext context, IRubyObject arg2) {
        Ruby runtime2 = context.runtime;
        return RubySymbol.newSymbol(runtime2, this.newShared(runtime2).capitalize(context, arg2).getByteList());
    }

    @JRubyMethod
    public IRubyObject capitalize(ThreadContext context, IRubyObject arg0, IRubyObject arg1) {
        Ruby runtime2 = context.runtime;
        return RubySymbol.newSymbol(runtime2, this.newShared(runtime2).capitalize(context, arg0, arg1).getByteList());
    }

    @JRubyMethod
    public IRubyObject encoding(ThreadContext context) {
        return context.runtime.getEncodingService().getEncoding(this.getEncoding());
    }

    @JRubyMethod
    public IRubyObject to_proc(ThreadContext context) {
        SymbolProcBody body = new SymbolProcBody(context.runtime, this.symbol);
        return RubyProc.newProc(context.runtime, new Block(body, Block.NULL_BLOCK.getBinding()), Block.Type.LAMBDA);
    }

    public IRubyObject toRefinedProc(ThreadContext context, StaticScope scope) {
        SymbolProcBody body = new SymbolProcBody(context.runtime, this.symbol, scope);
        return RubyProc.newProc(context.runtime, new Block(body, Block.NULL_BLOCK.getBinding()), Block.Type.LAMBDA);
    }

    private static boolean isIdentStart(char c) {
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c == '_' || c >= '\u0080';
    }

    private static boolean isIdentChar(char c) {
        return c >= 'a' && c <= 'z' || c >= '0' && c <= '9' || c >= 'A' && c <= 'Z' || c == '_' || c >= '\u0080';
    }

    private static boolean isIdentifier(String s2) {
        if (s2.isEmpty() || !RubySymbol.isIdentStart(s2.charAt(0))) {
            return false;
        }
        for (int i2 = 1; i2 < s2.length(); ++i2) {
            if (RubySymbol.isIdentChar(s2.charAt(i2))) continue;
            return false;
        }
        return true;
    }

    private static boolean isSpecialGlobalName(String s2) {
        if (s2.isEmpty()) {
            return false;
        }
        int length2 = s2.length();
        switch (s2.charAt(0)) {
            case '!': 
            case '\"': 
            case '$': 
            case '&': 
            case '\'': 
            case '*': 
            case '+': 
            case ',': 
            case '.': 
            case '/': 
            case '0': 
            case ':': 
            case ';': 
            case '<': 
            case '=': 
            case '>': 
            case '?': 
            case '@': 
            case '\\': 
            case '`': 
            case '~': {
                return length2 == 1;
            }
            case '-': {
                return length2 == 1 || length2 == 2 && RubySymbol.isIdentChar(s2.charAt(1));
            }
        }
        for (int i2 = 0; i2 < length2; ++i2) {
            if (Character.isDigit(s2.charAt(i2))) continue;
            return false;
        }
        return true;
    }

    private boolean isPrintable(Ruby runtime2) {
        int c;
        int p2;
        ByteList symbolBytes = this.getBytes();
        int end2 = p2 + symbolBytes.getRealSize();
        byte[] bytes2 = symbolBytes.getUnsafeBytes();
        Encoding enc = symbolBytes.getEncoding();
        for (p2 = symbolBytes.getBegin(); p2 < end2; p2 += StringSupport.codeLength(enc, c)) {
            c = StringSupport.codePoint(runtime2, enc, bytes2, p2, end2);
            if (enc.isPrint(c)) continue;
            return false;
        }
        return true;
    }

    private static boolean isSymbolName(String str) {
        if (str == null || str.isEmpty()) {
            return false;
        }
        int length2 = str.length();
        char c = str.charAt(0);
        return RubySymbol.isSymbolNameCommon(str, c, length2) || c == '!' && (length2 == 1 || length2 == 2 && (str.charAt(1) == '~' || str.charAt(1) == '=')) || RubySymbol.isSymbolLocal(str, c, length2);
    }

    private static boolean isSymbolNameCommon(String str, char first2, int length2) {
        switch (first2) {
            case '$': {
                if (length2 > 1 && RubySymbol.isSpecialGlobalName(str.substring(1))) {
                    return true;
                }
                return RubySymbol.isIdentifier(str.substring(1));
            }
            case '@': {
                int offset2 = 1;
                if (length2 >= 2 && str.charAt(1) == '@') {
                    ++offset2;
                }
                return RubySymbol.isIdentifier(str.substring(offset2));
            }
            case '<': {
                return length2 == 1 || length2 == 2 && (str.equals("<<") || str.equals("<=")) || length2 == 3 && str.equals("<=>");
            }
            case '>': {
                return length2 == 1 || length2 == 2 && (str.equals(">>") || str.equals(">="));
            }
            case '=': {
                return length2 == 2 && (str.equals("==") || str.equals("=~")) || length2 == 3 && str.equals("===");
            }
            case '*': {
                return length2 == 1 || length2 == 2 && str.equals("**");
            }
            case '+': {
                return length2 == 1 || length2 == 2 && str.equals("+@");
            }
            case '-': {
                return length2 == 1 || length2 == 2 && str.equals("-@");
            }
            case '%': 
            case '&': 
            case '/': 
            case '^': 
            case '`': 
            case '|': 
            case '~': {
                return length2 == 1;
            }
            case '[': {
                return str.equals("[]") || str.equals("[]=");
            }
        }
        return false;
    }

    private static boolean isSymbolLocal(String str, char first2, int length2) {
        char d;
        int last2;
        if (!RubySymbol.isIdentStart(first2)) {
            return false;
        }
        boolean localID = RubySymbol.isIdentStart(first2);
        for (last2 = 1; last2 < length2 && RubySymbol.isIdentChar(d = str.charAt(last2)); ++last2) {
        }
        if (last2 == length2) {
            return true;
        }
        if (localID && last2 == length2 - 1) {
            d = str.charAt(last2);
            return d == '!' || d == '?' || d == '=';
        }
        return false;
    }

    @JRubyMethod(meta=true)
    public static IRubyObject all_symbols(ThreadContext context, IRubyObject recv2) {
        return context.runtime.getSymbolTable().all_symbols();
    }

    @Deprecated
    public static IRubyObject all_symbols(IRubyObject recv2) {
        return recv2.getRuntime().getSymbolTable().all_symbols();
    }

    public static RubySymbol unmarshalFrom(UnmarshalStream input, UnmarshalStream.MarshalState state2) throws IOException {
        ByteList byteList = input.unmarshalString();
        byteList.setEncoding((Encoding)ASCIIEncoding.INSTANCE);
        RubySymbol result2 = RubySymbol.newSymbol(input.getRuntime(), byteList, (RubySymbol sym, boolean newSym) -> {
            if (state2 != null && state2.isIvarWaiting()) {
                try {
                    input.unmarshalInt();
                    IRubyObject value2 = input.unmarshalObject();
                    Encoding enc = input.symbolToEncoding((RubySymbol)sym, value2);
                    if (enc == null) {
                        throw new RuntimeException("BUG: No encoding found in marshal stream");
                    }
                    if (newSym) {
                        sym.setEncoding(enc);
                    }
                    state2.setIvarWaiting(false);
                }
                catch (Throwable t) {
                    Helpers.throwException(t);
                }
            }
        });
        return result2;
    }

    @Override
    public <T> T toJava(Class<T> target2) {
        if (target2 == String.class || target2 == CharSequence.class) {
            return target2.cast(this.symbol);
        }
        return super.toJava(target2);
    }

    public static ByteList symbolBytesFromString(Ruby runtime2, String internedSymbol) {
        return new ByteList(ByteList.plain(internedSymbol), (Encoding)USASCIIEncoding.INSTANCE, false);
    }

    @Override
    public Encoding getEncoding() {
        return this.getBytes().getEncoding();
    }

    @Override
    public void setEncoding(Encoding e) {
        this.getBytes().setEncoding(e);
        this.type = IdUtil.determineSymbolNameType(this.getRuntime(), this.getBytes());
    }

    private static int javaStringHashCode(String str) {
        return str.hashCode();
    }

    public static int javaStringHashCode(ByteList iso8859) {
        int h = 0;
        int begin2 = iso8859.begin();
        int end2 = begin2 + iso8859.realSize();
        byte[] bytes2 = iso8859.unsafeBytes();
        for (int i2 = begin2; i2 < end2; ++i2) {
            int v = bytes2[i2] & 0xFF;
            h = 31 * h + v;
        }
        return h;
    }

    @Override
    public Class getJavaClass() {
        return String.class;
    }

    @Override
    public boolean shouldMarshalEncoding() {
        Encoding enc = this.getMarshalEncoding();
        return enc != USASCIIEncoding.INSTANCE && enc != ASCIIEncoding.INSTANCE;
    }

    @Override
    public Encoding getMarshalEncoding() {
        return this.getBytes().getEncoding();
    }

    public static String objectToSymbolString(IRubyObject object) {
        if (object instanceof RubySymbol) {
            return ((RubySymbol)object).idString();
        }
        if (object instanceof RubyString) {
            return ((RubyString)object).getByteList().toString();
        }
        return object.convertToString().getByteList().toString();
    }

    @Deprecated
    public static String checkID(IRubyObject object) {
        return RubySymbol.idStringFromObject(object.getRuntime().getCurrentContext(), object);
    }

    public static String idStringFromObject(ThreadContext context, IRubyObject object) {
        IRubyObject symOrStr = RubySymbol.prepareID(object.getRuntime().getCurrentContext(), object);
        if (symOrStr instanceof RubySymbol) {
            return ((RubySymbol)symOrStr).idString();
        }
        return ((RubyString)symOrStr).getByteList().toString();
    }

    public static RubySymbol idSymbolFromObject(ThreadContext context, IRubyObject object) {
        IRubyObject symOrStr = RubySymbol.prepareID(context, object);
        if (symOrStr instanceof RubySymbol) {
            return (RubySymbol)symOrStr;
        }
        return RubySymbol.newSymbol(context.runtime, ((RubyString)symOrStr).getByteList());
    }

    public static IRubyObject prepareID(ThreadContext context, IRubyObject object) {
        if (object instanceof RubySymbol || object instanceof RubyString) {
            return object;
        }
        Ruby runtime2 = context.runtime;
        IRubyObject tmp = TypeConverter.checkStringType(context, RubySymbol.sites((ThreadContext)context).to_str_checked, object);
        if (tmp.isNil()) {
            throw runtime2.newTypeError(RubyStringBuilder.str(runtime2, "", object, " is not a symbol nor a string"));
        }
        return tmp;
    }

    private static JavaSites.SymbolSites sites(ThreadContext context) {
        return context.sites.Symbol;
    }

    @Override
    @Deprecated
    public IRubyObject taint(ThreadContext context) {
        return this;
    }

    public static final class SymbolProcBody
    extends ContextAwareBlockBody {
        private final CallSite site;
        private final String id;

        public SymbolProcBody(Ruby runtime2, String id2) {
            super(runtime2.getStaticScopeFactory().getDummyScope(), Signature.OPTIONAL);
            this.site = MethodIndex.getFunctionalCallSite(id2);
            this.id = id2;
        }

        public SymbolProcBody(Ruby runtime2, String id2, StaticScope scope) {
            super(scope, Signature.OPTIONAL);
            this.site = new RefinedCachingCallSite(id2, scope, CallType.FUNCTIONAL);
            this.id = id2;
        }

        private IRubyObject yieldInner(ThreadContext context, RubyArray array2, Block blockArg) {
            if (array2.isEmpty()) {
                throw context.runtime.newArgumentError("no receiver given");
            }
            IRubyObject self2 = array2.shift(context);
            return this.site.call(context, self2, self2, array2.toJavaArray(), blockArg);
        }

        @Override
        public IRubyObject yield(ThreadContext context, Block block, IRubyObject[] args2, IRubyObject self2, Block blockArg) {
            return this.yieldInner(context, RubyArray.newArrayMayCopy(context.runtime, args2), blockArg);
        }

        @Override
        public IRubyObject yield(ThreadContext context, Block block, IRubyObject value2, Block blockArg) {
            return this.yieldInner(context, ArgsUtil.convertToRubyArray(context.runtime, value2, false), blockArg);
        }

        @Override
        protected IRubyObject doYield(ThreadContext context, Block block, IRubyObject value2) {
            return this.yieldInner(context, ArgsUtil.convertToRubyArray(context.runtime, value2, false), Block.NULL_BLOCK);
        }

        @Override
        protected IRubyObject doYield(ThreadContext context, Block block, IRubyObject[] args2, IRubyObject self2) {
            if (args2.length == 1) {
                return this.yieldSpecific(context, Block.NULL_BLOCK, args2[0]);
            }
            return this.yieldInner(context, RubyArray.newArrayMayCopy(context.runtime, args2), Block.NULL_BLOCK);
        }

        @Override
        public IRubyObject yieldSpecific(ThreadContext context, Block block, IRubyObject arg0) {
            return this.site.call(context, arg0, arg0);
        }

        @Override
        public IRubyObject yieldSpecific(ThreadContext context, Block block, IRubyObject arg0, IRubyObject arg1) {
            return this.site.call(context, arg0, arg0, arg1);
        }

        @Override
        public IRubyObject yieldSpecific(ThreadContext context, Block block, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2) {
            return this.site.call(context, arg0, arg0, arg1, arg2);
        }

        @Override
        public String getFile() {
            return this.site.methodName;
        }

        @Override
        public int getLine() {
            return -1;
        }

        public String getId() {
            return this.id;
        }

        @Override
        public ArgumentDescriptor[] getArgumentDescriptors() {
            return ArgumentDescriptor.SYMBOL_PROC;
        }
    }

    public static final class SymbolTable {
        static final int DEFAULT_INITIAL_CAPACITY = 1024;
        static final int MAXIMUM_CAPACITY = 65536;
        static final float DEFAULT_LOAD_FACTOR = 0.75f;
        private final ReentrantLock tableLock = new ReentrantLock();
        private volatile SymbolEntry[] symbolTable;
        private int size;
        private int threshold;
        private final float loadFactor;
        private final Ruby runtime;

        public SymbolTable(Ruby runtime2) {
            this.runtime = runtime2;
            this.loadFactor = 0.75f;
            this.reset();
        }

        public RubySymbol getSymbol(String name2) {
            return this.getSymbol(name2, false);
        }

        public RubySymbol getSymbol(String name2, boolean hard) {
            int hash2 = RubySymbol.javaStringHashCode(name2);
            RubySymbol symbol = null;
            SymbolEntry e = SymbolTable.getEntryFromTable(this.symbolTable, hash2);
            while (e != null) {
                if (SymbolTable.isSymbolMatch(name2, hash2, e)) {
                    if (hard) {
                        e.setHardReference();
                    }
                    symbol = (RubySymbol)e.symbol.get();
                    break;
                }
                e = e.next;
            }
            if (symbol == null) {
                symbol = this.createSymbol(name2, RubySymbol.symbolBytesFromString(this.runtime, name2), hash2, hard);
            }
            return symbol;
        }

        public RubySymbol getSymbol(ByteList bytes2) {
            return this.getSymbol(bytes2, false);
        }

        public RubySymbol getSymbol(ByteList bytes2, boolean hard) {
            int hash2 = RubySymbol.javaStringHashCode(bytes2);
            RubySymbol symbol = this.findSymbol(bytes2, hash2, hard);
            if (symbol == null) {
                bytes2 = bytes2.dup();
                symbol = this.createSymbol(RubyEncoding.decodeRaw(bytes2), bytes2, hash2, hard);
            }
            return symbol;
        }

        public RubySymbol getSymbol(ByteList bytes2, ObjBooleanConsumer<RubySymbol> handler, boolean hard) {
            int hash2 = RubySymbol.javaStringHashCode(bytes2);
            RubySymbol symbol = this.findSymbol(bytes2, hash2, hard);
            if (symbol == null) {
                bytes2 = bytes2.dup();
                return this.createSymbol(RubyEncoding.decodeRaw(bytes2), bytes2, handler, hash2, hard);
            }
            handler.accept(symbol, false);
            return symbol;
        }

        private RubySymbol findSymbol(ByteList bytes2, int hash2, boolean hard) {
            RubySymbol symbol = null;
            SymbolEntry e = SymbolTable.getEntryFromTable(this.symbolTable, hash2);
            while (e != null) {
                if (SymbolTable.isSymbolMatch(bytes2, hash2, e)) {
                    if (hard) {
                        e.setHardReference();
                    }
                    symbol = (RubySymbol)e.symbol.get();
                    break;
                }
                e = e.next;
            }
            return symbol;
        }

        public RubySymbol fastGetSymbol(String internedName) {
            return this.fastGetSymbol(internedName, false);
        }

        public RubySymbol fastGetSymbol(String internedName, boolean hard) {
            RubySymbol symbol = null;
            int hash2 = RubySymbol.javaStringHashCode(internedName);
            SymbolEntry e = SymbolTable.getEntryFromTable(this.symbolTable, hash2);
            while (e != null) {
                if (SymbolTable.isSymbolMatch(internedName, hash2, e)) {
                    if (hard) {
                        e.setHardReference();
                    }
                    symbol = (RubySymbol)e.symbol.get();
                    break;
                }
                e = e.next;
            }
            if (symbol == null) {
                symbol = this.fastCreateSymbol(internedName, hard);
            }
            return symbol;
        }

        private static SymbolEntry getEntryFromTable(SymbolEntry[] table, int hash2) {
            return table[SymbolTable.getIndex(hash2, table)];
        }

        private static boolean isSymbolMatch(String name2, int hash2, SymbolEntry entry) {
            return hash2 == entry.hash && name2.equals(entry.name);
        }

        private static boolean isSymbolMatch(ByteList bytes2, int hash2, SymbolEntry entry) {
            return hash2 == entry.hash && bytes2.equals(entry.bytes);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private RubySymbol createSymbol(String name2, ByteList value2, int hash2, boolean hard) {
            ReentrantLock lock2 = this.tableLock;
            lock2.lock();
            try {
                SymbolEntry[] table = this.getTableForCreate();
                int index2 = SymbolTable.getIndex(hash2, table);
                RubySymbol symbol = this.lookupSymbol(name2, table, hash2, index2);
                if (symbol == null) {
                    String internedName = name2.intern();
                    symbol = new RubySymbol(this.runtime, internedName, value2);
                    this.storeSymbol(value2, hash2, hard, table, index2, symbol, internedName);
                }
                RubySymbol rubySymbol = symbol;
                return rubySymbol;
            }
            finally {
                lock2.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private RubySymbol createSymbol(String name2, ByteList value2, ObjBooleanConsumer<RubySymbol> handler, int hash2, boolean hard) {
            ReentrantLock lock2 = this.tableLock;
            lock2.lock();
            try {
                SymbolEntry[] table = this.getTableForCreate();
                int index2 = SymbolTable.getIndex(hash2, table);
                RubySymbol symbol = this.lookupSymbol(name2, table, hash2, index2);
                if (symbol == null) {
                    String internedName = name2.intern();
                    symbol = new RubySymbol(this.runtime, internedName, value2);
                    handler.accept(symbol, true);
                    this.storeSymbol(value2, hash2, hard, table, index2, symbol, internedName);
                } else {
                    handler.accept(symbol, false);
                }
                RubySymbol rubySymbol = symbol;
                return rubySymbol;
            }
            finally {
                lock2.unlock();
            }
        }

        private void storeSymbol(ByteList value2, int hash2, boolean hard, SymbolEntry[] table, int index2, RubySymbol symbol, String internedName) {
            table[index2] = new SymbolEntry(hash2, internedName, value2, symbol, table[index2], hard);
            ++this.size;
            this.symbolTable = table;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private RubySymbol fastCreateSymbol(String internedName, boolean hard) {
            ReentrantLock lock2 = this.tableLock;
            lock2.lock();
            try {
                SymbolEntry[] table = this.getTableForCreate();
                int hash2 = internedName.hashCode();
                int index2 = SymbolTable.getIndex(hash2, table);
                RubySymbol symbol = this.lookupSymbolByString(internedName, table, index2);
                if (symbol == null) {
                    symbol = new RubySymbol(this.runtime, internedName);
                    this.storeSymbol(symbol.getBytes(), hash2, hard, table, index2, symbol, internedName);
                }
                RubySymbol rubySymbol = symbol;
                return rubySymbol;
            }
            finally {
                lock2.unlock();
            }
        }

        private static int getIndex(int hash2, SymbolEntry[] table) {
            return hash2 & table.length - 1;
        }

        private SymbolEntry[] getTableForCreate() {
            return this.size > this.threshold ? this.rehash() : this.symbolTable;
        }

        private RubySymbol lookupSymbol(String name2, SymbolEntry[] table, int hash2, int index2) {
            RubySymbol symbol = null;
            SymbolEntry last2 = null;
            SymbolEntry curr = table[index2];
            while (curr != null) {
                block6: {
                    RubySymbol localSymbol;
                    block5: {
                        localSymbol = (RubySymbol)curr.symbol.get();
                        if (localSymbol != null) break block5;
                        this.removeDeadEntry(table, index2, last2, curr);
                        if (hash2 != curr.hash || !name2.equals(curr.name)) break block6;
                    }
                    last2 = curr;
                    if (hash2 == curr.hash && name2.equals(curr.name)) {
                        symbol = localSymbol;
                        break;
                    }
                }
                curr = curr.next;
            }
            return symbol;
        }

        private RubySymbol lookupSymbolByString(String internedName, SymbolEntry[] table, int index2) {
            RubySymbol symbol = null;
            SymbolEntry last2 = null;
            SymbolEntry curr = table[index2];
            while (curr != null) {
                block6: {
                    RubySymbol localSymbol;
                    block5: {
                        localSymbol = (RubySymbol)curr.symbol.get();
                        if (localSymbol != null) break block5;
                        this.removeDeadEntry(table, index2, last2, curr);
                        if (internedName != curr.name) break block6;
                    }
                    last2 = curr;
                    if (internedName == curr.name) {
                        symbol = localSymbol;
                        break;
                    }
                }
                curr = curr.next;
            }
            return symbol;
        }

        private void removeDeadEntry(SymbolEntry[] table, int index2, SymbolEntry last2, SymbolEntry e) {
            if (last2 == null) {
                table[index2] = e.next;
            } else {
                last2.next = e.next;
            }
            --this.size;
        }

        public RubySymbol lookup(long id2) {
            SymbolEntry[] table = this.symbolTable;
            int i2 = table.length;
            while (--i2 >= 0) {
                SymbolEntry e = table[i2];
                while (e != null) {
                    RubySymbol symbol = (RubySymbol)e.symbol.get();
                    if (symbol != null && id2 == (long)symbol.id) {
                        return symbol;
                    }
                    e = e.next;
                }
            }
            return null;
        }

        public RubyArray all_symbols() {
            SymbolEntry[] table = this.symbolTable;
            RubyArray array2 = this.runtime.newArray(this.size);
            int i2 = table.length;
            while (--i2 >= 0) {
                SymbolEntry e = table[i2];
                while (e != null) {
                    RubySymbol symbol = (RubySymbol)e.symbol.get();
                    if (symbol != null) {
                        array2.append(symbol);
                    }
                    e = e.next;
                }
            }
            return array2;
        }

        public int size() {
            return this.size;
        }

        public void clear() {
            this.reset();
        }

        private void reset() {
            this.threshold = 768;
            this.symbolTable = new SymbolEntry[1024];
        }

        private SymbolEntry[] rehash() {
            SymbolEntry[] oldTable = this.symbolTable;
            int oldCapacity = oldTable.length;
            if (oldCapacity >= 65536) {
                return oldTable;
            }
            int newCapacity = oldCapacity << 1;
            SymbolEntry[] newTable = new SymbolEntry[newCapacity];
            this.threshold = (int)((float)newCapacity * this.loadFactor);
            int sizeMask = newCapacity - 1;
            int i2 = oldCapacity;
            while (--i2 >= 0) {
                int k;
                SymbolEntry e = oldTable[i2];
                if (e == null) continue;
                SymbolEntry next2 = e.next;
                int idx = e.hash & sizeMask;
                if (next2 == null) {
                    newTable[idx] = e;
                    continue;
                }
                SymbolEntry lastRun = e;
                int lastIdx = idx;
                SymbolEntry last2 = next2;
                while (last2 != null) {
                    k = last2.hash & sizeMask;
                    if (k != lastIdx) {
                        lastIdx = k;
                        lastRun = last2;
                    }
                    last2 = last2.next;
                }
                newTable[lastIdx] = lastRun;
                SymbolEntry p2 = e;
                while (p2 != lastRun) {
                    k = p2.hash & sizeMask;
                    SymbolEntry n = newTable[k];
                    newTable[k] = new SymbolEntry(p2.hash, p2.name, p2.bytes, (RubySymbol)p2.symbol.get(), n, p2.hardReference != null);
                    p2 = p2.next;
                }
            }
            this.symbolTable = newTable;
            return newTable;
        }

        @Deprecated
        public RubySymbol lookup(String name2) {
            int hash2 = name2.hashCode();
            SymbolEntry[] table = this.symbolTable;
            RubySymbol symbol = null;
            SymbolEntry e = table[SymbolTable.getIndex(hash2, table)];
            while (!(e == null || hash2 == e.hash && name2.equals(e.name) && (symbol = (RubySymbol)e.symbol.get()) != null)) {
                e = e.next;
            }
            return symbol;
        }

        @Deprecated
        public void store(RubySymbol symbol) {
            throw new UnsupportedOperationException();
        }

        static final class SymbolEntry {
            final int hash;
            final String name;
            final ByteList bytes;
            final WeakReference<RubySymbol> symbol;
            RubySymbol hardReference;
            SymbolEntry next;

            SymbolEntry(int hash2, String name2, ByteList bytes2, RubySymbol symbol, SymbolEntry next2, boolean hard) {
                this.hash = hash2;
                this.name = name2;
                this.bytes = bytes2;
                this.symbol = new WeakReference<RubySymbol>(symbol);
                this.next = next2;
                if (hard) {
                    this.hardReference = symbol;
                }
            }

            public void setHardReference() {
                if (this.hardReference == null) {
                    this.hardReference = (RubySymbol)this.symbol.get();
                }
            }
        }
    }

    @FunctionalInterface
    public static interface ObjBooleanConsumer<T> {
        public void accept(T var1, boolean var2);
    }
}

