/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.management;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.jruby.Ruby;
import org.jruby.management.ParserStatsMBean;
import org.jruby.parser.ParserManager;
import org.jruby.util.cli.Options;

public class ParserStats
implements ParserStatsMBean {
    private final AtomicLong totalIRBuildTime = new AtomicLong(0L);
    private final AtomicLong totalParseTime = new AtomicLong(0L);
    private final AtomicLong totalPrismDeserializingTime = new AtomicLong(0L);
    private final AtomicLong totalPrismCParseSerializingTime = new AtomicLong(0L);
    private final AtomicLong totalPrismSerializedBytes = new AtomicLong(0L);
    private final AtomicLong totalParsedBytes = new AtomicLong(0L);
    private final AtomicInteger totalEvalParses = new AtomicInteger(0);
    private final AtomicInteger totalLoadParses = new AtomicInteger(0);
    private final AtomicInteger totalJRubyModuleParses = new AtomicInteger(0);

    public ParserStats(Ruby ruby) {
    }

    public void addParseTime(long time) {
        this.totalParseTime.addAndGet(time);
    }

    public void addParsedBytes(int bytes2) {
        this.totalParsedBytes.addAndGet(bytes2);
    }

    public void addEvalParse() {
        this.totalEvalParses.incrementAndGet();
    }

    public void addLoadParse() {
        this.totalLoadParses.incrementAndGet();
    }

    public void addJRubyModuleParse() {
        this.totalJRubyModuleParses.incrementAndGet();
    }

    @Override
    public double getTotalParseTime() {
        return (double)this.totalParseTime.get() / 1.0E9;
    }

    @Override
    public long getTotalParsedBytes() {
        return this.totalParsedBytes.get();
    }

    public long getTotalPrismSerializedBytes() {
        return this.totalPrismSerializedBytes.get();
    }

    public double getPrismCParseSerializeTime() {
        return (double)this.totalPrismCParseSerializingTime.get() / 1.0E9;
    }

    public double getPrismDeserializingTime() {
        return (double)this.totalPrismDeserializingTime.get() / 1.0E9;
    }

    @Override
    public double getParseTimePerKB() {
        long totalBytes = this.getTotalParsedBytes();
        if (totalBytes == 0L) {
            return 0.0;
        }
        return this.getTotalParseTime() / ((double)totalBytes / 1000.0);
    }

    @Override
    public int getNumberOfEvalParses() {
        return this.totalEvalParses.get();
    }

    @Override
    public int getNumberOfLoadParses() {
        return this.totalLoadParses.get();
    }

    public void addPrismTimeDeserializing(long time) {
        this.totalPrismDeserializingTime.addAndGet(time);
    }

    public void addPrismSerializedBytes(int length2) {
        this.totalPrismSerializedBytes.addAndGet(length2);
    }

    public void addPrismTimeCParseSerialize(long time) {
        this.totalPrismCParseSerializingTime.addAndGet(time);
    }

    public void printParserStatistics() {
        System.err.println("--------------------------------------------------------------------------------");
        System.err.println("Parser Statistics:");
        System.err.println("  Generic:");
        System.err.println("    parser type: " + (ParserManager.PARSER_WASM ? "Prism(wasm)" : ((Boolean)Options.PARSER_PRISM.load() != false ? "Prism(C)" : "Legacy")));
        System.err.println("    bytes processed: " + this.getTotalParsedBytes());
        System.err.println("    files parsed: " + this.getNumberOfLoadParses());
        System.err.println("    evals parsed: " + this.getNumberOfEvalParses());
        System.err.println("    time spent parsing(s): " + this.getTotalParseTime());
        System.err.println("    time spend parsing + building: " + (this.getTotalParseTime() + this.getIRBuildTime()));
        if (((Boolean)Options.PARSER_PRISM.load()).booleanValue()) {
            System.err.println("  Prism:");
            System.err.println("    time C parse+serialize: " + this.getPrismCParseSerializeTime());
            System.err.println("    time deserializing: " + this.getPrismDeserializingTime());
            System.err.println("    serialized bytes: " + this.getTotalPrismSerializedBytes());
            System.err.println("    serialized to source ratio: x" + (float)this.getTotalPrismSerializedBytes() / (float)this.getTotalParsedBytes());
        }
        System.err.println("  IRBuild:");
        System.err.println("    build time: " + this.getIRBuildTime());
    }

    private double getIRBuildTime() {
        return (double)this.totalIRBuildTime.get() / 1.0E9;
    }

    public void addIRBuildTime(long time) {
        this.totalIRBuildTime.addAndGet(time);
    }
}

