/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.etc;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicBoolean;
import jnr.constants.Constant;
import jnr.constants.ConstantSet;
import jnr.constants.platform.Confstr;
import jnr.constants.platform.Errno;
import jnr.constants.platform.Pathconf;
import jnr.constants.platform.Sysconf;
import jnr.posix.Group;
import jnr.posix.POSIX;
import jnr.posix.Passwd;
import jnr.posix.util.Platform;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyFixnum;
import org.jruby.RubyHash;
import org.jruby.RubyIO;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.RubyString;
import org.jruby.RubyStruct;
import org.jruby.anno.JRubyMethod;
import org.jruby.anno.JRubyModule;
import org.jruby.common.IRubyWarnings;
import org.jruby.exceptions.RaiseException;
import org.jruby.ext.rbconfig.RbConfigLibrary;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;
import org.jruby.util.SafePropertyAccessor;
import org.jruby.util.io.OpenFile;

@JRubyModule(name={"Etc"})
public class RubyEtc {
    private static final AtomicBoolean iteratingPasswd = new AtomicBoolean(false);

    public static RubyModule createEtcModule(Ruby runtime2) {
        RubyModule etcModule = runtime2.defineModule("Etc");
        runtime2.setEtc(etcModule);
        etcModule.defineAnnotatedMethods(RubyEtc.class);
        runtime2.getIO().defineAnnotatedMethods(IOExt.class);
        if (!Platform.IS_WINDOWS) {
            String name2;
            for (Constant c : ConstantSet.getConstantSet((String)"Sysconf")) {
                name2 = c.name().substring(1);
                etcModule.setConstant(name2, runtime2.newFixnum(c.intValue()));
            }
            for (Constant c : ConstantSet.getConstantSet((String)"Confstr")) {
                name2 = c.name().substring(1);
                etcModule.setConstant(name2, runtime2.newFixnum(c.intValue()));
            }
            for (Constant c : ConstantSet.getConstantSet((String)"Pathconf")) {
                name2 = c.name().substring(1);
                etcModule.setConstant(name2, runtime2.newFixnum(c.intValue()));
            }
        }
        RubyEtc.definePasswdStruct(runtime2);
        RubyEtc.defineGroupStruct(runtime2);
        return etcModule;
    }

    private static void definePasswdStruct(Ruby runtime2) {
        IRubyObject[] args2 = new IRubyObject[]{runtime2.newString("Passwd"), runtime2.newSymbol("name"), runtime2.newSymbol("passwd"), runtime2.newSymbol("uid"), runtime2.newSymbol("gid"), runtime2.newSymbol("gecos"), runtime2.newSymbol("dir"), runtime2.newSymbol("shell"), runtime2.newSymbol("change"), runtime2.newSymbol("uclass"), runtime2.newSymbol("expire")};
        runtime2.setPasswdStruct(RubyStruct.newInstance(runtime2.getStructClass(), args2, Block.NULL_BLOCK));
        runtime2.getEtc().defineConstant("Passwd", runtime2.getPasswdStruct());
    }

    private static void defineGroupStruct(Ruby runtime2) {
        IRubyObject[] args2 = new IRubyObject[]{runtime2.newString("Group"), runtime2.newSymbol("name"), runtime2.newSymbol("passwd"), runtime2.newSymbol("gid"), runtime2.newSymbol("mem")};
        runtime2.setGroupStruct(RubyStruct.newInstance(runtime2.getStructClass(), args2, Block.NULL_BLOCK));
        runtime2.getEtc().defineConstant("Group", runtime2.getGroupStruct());
    }

    private static IRubyObject setupPasswd(Ruby runtime2, Passwd passwd2) {
        IRubyObject[] args2 = new IRubyObject[]{runtime2.newString(passwd2.getLoginName()), runtime2.newString(passwd2.getPassword()), runtime2.newFixnum(passwd2.getUID()), runtime2.newFixnum(passwd2.getGID()), runtime2.newString(passwd2.getGECOS()), runtime2.newString(passwd2.getHome()), runtime2.newString(passwd2.getShell()), runtime2.newFixnum(passwd2.getPasswdChangeTime()), runtime2.newString(passwd2.getAccessClass()), runtime2.newFixnum(passwd2.getExpire())};
        return RubyStruct.newStruct(runtime2.getPasswdStruct(), args2, Block.NULL_BLOCK);
    }

    private static IRubyObject setupGroup(Ruby runtime2, Group group2) {
        IRubyObject[] args2 = new IRubyObject[]{runtime2.newString(group2.getName()), runtime2.newString(group2.getPassword()), runtime2.newFixnum(group2.getGID()), RubyEtc.intoStringArray(runtime2, group2.getMembers())};
        return RubyStruct.newStruct(runtime2.getGroupStruct(), args2, Block.NULL_BLOCK);
    }

    private static IRubyObject intoStringArray(Ruby runtime2, String[] members2) {
        IRubyObject[] arr = new IRubyObject[members2.length];
        for (int i2 = 0; i2 < arr.length; ++i2) {
            arr[i2] = runtime2.newString(members2[i2]);
        }
        return RubyArray.newArrayMayCopy(runtime2, arr);
    }

    @JRubyMethod(required=1, module=true)
    public static synchronized IRubyObject sysconf(ThreadContext context, IRubyObject recv2, IRubyObject arg2) {
        Ruby runtime2 = context.runtime;
        Sysconf name2 = Sysconf.valueOf((long)RubyNumeric.num2long(arg2));
        POSIX posix = runtime2.getPosix();
        posix.errno(0);
        long ret = posix.sysconf(name2);
        if (ret == -1L) {
            int errno2 = posix.errno();
            if (errno2 == Errno.ENOENT.intValue() || errno2 == 0) {
                return context.nil;
            }
            if (errno2 == Errno.EOPNOTSUPP.intValue()) {
                throw runtime2.newNotImplementedError("sysconf() function is unimplemented on this machine");
            }
            throw runtime2.newErrnoFromLastPOSIXErrno();
        }
        return RubyFixnum.newFixnum(runtime2, ret);
    }

    @JRubyMethod(required=1, module=true)
    public static synchronized IRubyObject confstr(ThreadContext context, IRubyObject recv2, IRubyObject arg2) {
        ByteBuffer buf;
        Confstr name2 = Confstr.valueOf((long)RubyNumeric.num2long(arg2));
        POSIX posix = context.runtime.getPosix();
        int n = posix.confstr(name2, null, 0);
        int ret = -1;
        if (n > 0) {
            buf = ByteBuffer.allocate(n);
            ret = posix.confstr(name2, buf, n);
        } else {
            buf = ByteBuffer.allocate(0);
        }
        if (ret == -1) {
            if (posix.errno() == 0) {
                return context.runtime.getNil();
            }
            if (posix.errno() == Errno.EOPNOTSUPP.intValue()) {
                throw context.runtime.newNotImplementedError("confstr() function is unimplemented on this machine");
            }
            throw context.runtime.newErrnoFromLastPOSIXErrno();
        }
        buf.flip();
        ByteList bytes2 = new ByteList(buf.array(), 0, n - 1);
        return RubyString.newString(context.runtime, bytes2);
    }

    @JRubyMethod(optional=1, module=true)
    public static synchronized IRubyObject getpwuid(IRubyObject recv2, IRubyObject[] args2) {
        Ruby runtime2 = recv2.getRuntime();
        POSIX posix = runtime2.getPosix();
        IRubyObject oldExc = runtime2.getGlobalVariables().get("$!");
        try {
            int uid2 = args2.length == 0 ? posix.getuid() : RubyNumeric.fix2int(args2[0]);
            Passwd pwd = posix.getpwuid(uid2);
            if (pwd == null) {
                if (Platform.IS_WINDOWS) {
                    return recv2.getRuntime().getNil();
                }
                throw runtime2.newArgumentError("can't find user for " + uid2);
            }
            return RubyEtc.setupPasswd(runtime2, pwd);
        }
        catch (RaiseException re) {
            if (runtime2.getNotImplementedError().isInstance(re.getException())) {
                runtime2.getGlobalVariables().set("$!", oldExc);
                return runtime2.getNil();
            }
            throw re;
        }
        catch (Exception e) {
            if (runtime2.getDebug().isTrue()) {
                runtime2.getWarnings().warn(IRubyWarnings.ID.NOT_IMPLEMENTED, "Etc.getpwuid is not supported by JRuby on this platform");
            }
            return runtime2.getNil();
        }
    }

    @JRubyMethod(required=1, module=true)
    public static synchronized IRubyObject getpwnam(IRubyObject recv2, IRubyObject name2) {
        Ruby runtime2 = recv2.getRuntime();
        String nam = name2.convertToString().toString();
        try {
            Passwd pwd = runtime2.getPosix().getpwnam(nam);
            if (pwd == null) {
                if (Platform.IS_WINDOWS) {
                    return runtime2.getNil();
                }
                throw runtime2.newArgumentError("can't find user for " + nam);
            }
            return RubyEtc.setupPasswd(recv2.getRuntime(), pwd);
        }
        catch (RaiseException e) {
            throw e;
        }
        catch (Exception e) {
            if (runtime2.getDebug().isTrue()) {
                runtime2.getWarnings().warn(IRubyWarnings.ID.NOT_IMPLEMENTED, "Etc.getpwnam is not supported by JRuby on this platform");
            }
            return runtime2.getNil();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(module=true)
    public static synchronized IRubyObject passwd(IRubyObject recv2, Block block) {
        Ruby runtime2 = recv2.getRuntime();
        POSIX posix = runtime2.getPosix();
        try {
            Passwd pw;
            posix.getpwent();
            if (block.isGiven()) {
                ThreadContext context = runtime2.getCurrentContext();
                if (!iteratingPasswd.compareAndSet(false, true)) {
                    throw runtime2.newRuntimeError("parallel passwd iteration");
                }
                posix.setpwent();
                try {
                    Passwd pw2;
                    while ((pw2 = posix.getpwent()) != null) {
                        block.yield(context, RubyEtc.setupPasswd(runtime2, pw2));
                    }
                }
                finally {
                    posix.endpwent();
                    iteratingPasswd.set(false);
                }
            }
            if ((pw = posix.getpwent()) != null) {
                return RubyEtc.setupPasswd(runtime2, pw);
            }
            return runtime2.getNil();
        }
        catch (Exception e) {
            if (runtime2.getDebug().isTrue()) {
                runtime2.getWarnings().warn(IRubyWarnings.ID.NOT_IMPLEMENTED, "Etc.passwd is not supported by JRuby on this platform");
            }
            return runtime2.getNil();
        }
    }

    @JRubyMethod(module=true)
    public static synchronized IRubyObject getlogin(IRubyObject recv2) {
        Ruby runtime2 = recv2.getRuntime();
        try {
            String login = runtime2.getPosix().getlogin();
            if (login != null) {
                return runtime2.newString(login);
            }
            login = System.getenv("USER");
            if (login != null) {
                return runtime2.newString(login);
            }
            return runtime2.getNil();
        }
        catch (Exception e) {
            return runtime2.newString(System.getProperty("user.name"));
        }
    }

    @JRubyMethod(module=true)
    public static synchronized IRubyObject endpwent(IRubyObject recv2) {
        Ruby runtime2;
        block2: {
            runtime2 = recv2.getRuntime();
            try {
                runtime2.getPosix().endpwent();
            }
            catch (Exception e) {
                if (!runtime2.getDebug().isTrue()) break block2;
                runtime2.getWarnings().warn(IRubyWarnings.ID.NOT_IMPLEMENTED, "Etc.endpwent is not supported by JRuby on this platform");
            }
        }
        return runtime2.getNil();
    }

    @JRubyMethod(module=true)
    public static synchronized IRubyObject setpwent(IRubyObject recv2) {
        Ruby runtime2;
        block2: {
            runtime2 = recv2.getRuntime();
            try {
                runtime2.getPosix().setpwent();
            }
            catch (Exception e) {
                if (!runtime2.getDebug().isTrue()) break block2;
                runtime2.getWarnings().warn(IRubyWarnings.ID.NOT_IMPLEMENTED, "Etc.setpwent is not supported by JRuby on this platform");
            }
        }
        return runtime2.getNil();
    }

    @JRubyMethod(module=true)
    public static synchronized IRubyObject getpwent(IRubyObject recv2) {
        Ruby runtime2 = recv2.getRuntime();
        try {
            Passwd passwd2 = runtime2.getPosix().getpwent();
            if (passwd2 != null) {
                return RubyEtc.setupPasswd(runtime2, passwd2);
            }
            return runtime2.getNil();
        }
        catch (Exception e) {
            if (runtime2.getDebug().isTrue()) {
                runtime2.getWarnings().warn(IRubyWarnings.ID.NOT_IMPLEMENTED, "Etc.getpwent is not supported by JRuby on this platform");
            }
            return runtime2.getNil();
        }
    }

    @JRubyMethod(required=1, module=true)
    public static synchronized IRubyObject getgrnam(IRubyObject recv2, IRubyObject name2) {
        Ruby runtime2 = recv2.getRuntime();
        String nam = name2.convertToString().toString();
        try {
            Group grp = runtime2.getPosix().getgrnam(nam);
            if (grp == null) {
                if (Platform.IS_WINDOWS) {
                    return runtime2.getNil();
                }
                throw runtime2.newArgumentError("can't find group for " + nam);
            }
            return RubyEtc.setupGroup(runtime2, grp);
        }
        catch (RaiseException e) {
            throw e;
        }
        catch (Exception e) {
            if (runtime2.getDebug().isTrue()) {
                runtime2.getWarnings().warn(IRubyWarnings.ID.NOT_IMPLEMENTED, "Etc.getgrnam is not supported by JRuby on this platform");
            }
            return runtime2.getNil();
        }
    }

    @JRubyMethod(optional=1, module=true)
    public static synchronized IRubyObject getgrgid(IRubyObject recv2, IRubyObject[] args2) {
        Ruby runtime2 = recv2.getRuntime();
        POSIX posix = runtime2.getPosix();
        try {
            int gid2 = args2.length == 0 ? posix.getgid() : RubyNumeric.fix2int(args2[0]);
            Group gr = posix.getgrgid(gid2);
            if (gr == null) {
                if (Platform.IS_WINDOWS) {
                    return runtime2.getNil();
                }
                throw runtime2.newArgumentError("can't find group for " + gid2);
            }
            return RubyEtc.setupGroup(runtime2, gr);
        }
        catch (RaiseException re) {
            throw re;
        }
        catch (Exception e) {
            if (runtime2.getDebug().isTrue()) {
                runtime2.getWarnings().warn(IRubyWarnings.ID.NOT_IMPLEMENTED, "Etc.getgrgid is not supported by JRuby on this platform");
            }
            return runtime2.getNil();
        }
    }

    @JRubyMethod(module=true)
    public static synchronized IRubyObject endgrent(IRubyObject recv2) {
        Ruby runtime2;
        block2: {
            runtime2 = recv2.getRuntime();
            try {
                runtime2.getPosix().endgrent();
            }
            catch (Exception e) {
                if (!runtime2.getDebug().isTrue()) break block2;
                runtime2.getWarnings().warn(IRubyWarnings.ID.NOT_IMPLEMENTED, "Etc.engrent is not supported by JRuby on this platform");
            }
        }
        return runtime2.getNil();
    }

    @JRubyMethod(module=true)
    public static synchronized IRubyObject setgrent(IRubyObject recv2) {
        Ruby runtime2;
        block2: {
            runtime2 = recv2.getRuntime();
            try {
                runtime2.getPosix().setgrent();
            }
            catch (Exception e) {
                if (!runtime2.getDebug().isTrue()) break block2;
                runtime2.getWarnings().warn(IRubyWarnings.ID.NOT_IMPLEMENTED, "Etc.setgrent is not supported by JRuby on this platform");
            }
        }
        return runtime2.getNil();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(module=true)
    public static synchronized IRubyObject group(IRubyObject recv2, Block block) {
        POSIX posix;
        Ruby runtime2;
        block10: {
            runtime2 = recv2.getRuntime();
            posix = runtime2.getPosix();
            try {
                posix.getgrent();
            }
            catch (Exception e) {
                if (!runtime2.getDebug().isTrue()) break block10;
                runtime2.getWarnings().warn(IRubyWarnings.ID.NOT_IMPLEMENTED, "Etc.group is not supported by JRuby on this platform");
            }
        }
        if (block.isGiven()) {
            Boolean blocking = (Boolean)recv2.getInternalVariables().getInternalVariable("group_blocking");
            if (blocking != null && blocking.booleanValue()) {
                throw runtime2.newRuntimeError("parallel group iteration");
            }
            try {
                Group gr;
                recv2.getInternalVariables().setInternalVariable("group_blocking", true);
                ThreadContext context = runtime2.getCurrentContext();
                posix.setgrent();
                while ((gr = posix.getgrent()) != null) {
                    block.yield(context, RubyEtc.setupGroup(runtime2, gr));
                }
            }
            finally {
                posix.endgrent();
                recv2.getInternalVariables().setInternalVariable("group_blocking", false);
            }
        } else {
            Group gr = posix.getgrent();
            if (gr != null) {
                return RubyEtc.setupGroup(runtime2, gr);
            }
            return runtime2.getNil();
        }
        return runtime2.getNil();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(module=true)
    public static synchronized IRubyObject getgrent(IRubyObject recv2) {
        Ruby runtime2 = recv2.getRuntime();
        try {
            Class<RubyEtc> clazz = RubyEtc.class;
            synchronized (RubyEtc.class) {
                Group gr = runtime2.getPosix().getgrent();
                // ** MonitorExit[var3_2] (shouldn't be in output)
                if (gr != null) {
                    return RubyEtc.setupGroup(recv2.getRuntime(), gr);
                }
                return runtime2.getNil();
            }
        }
        catch (Exception e) {
            if (runtime2.getDebug().isTrue()) {
                runtime2.getWarnings().warn(IRubyWarnings.ID.NOT_IMPLEMENTED, "Etc.getgrent is not supported by JRuby on this platform");
            }
            return runtime2.getNil();
        }
    }

    @JRubyMethod(module=true)
    public static synchronized IRubyObject systmpdir(ThreadContext context, IRubyObject recv2) {
        String commonAppData;
        Ruby runtime2 = context.getRuntime();
        ByteList tmp = ByteList.create(System.getProperty("java.io.tmpdir"));
        if (Platform.IS_WINDOWS && (commonAppData = System.getenv("CSIDL_COMMON_APPDATA")) != null) {
            tmp = ByteList.create(commonAppData);
        }
        RubyString ret = RubyString.newString(runtime2, tmp, runtime2.getDefaultExternalEncoding());
        return ret;
    }

    @JRubyMethod(module=true)
    public static synchronized IRubyObject sysconfdir(ThreadContext context, IRubyObject recv2) {
        String localAppData;
        Ruby runtime2 = context.getRuntime();
        ByteList tmp = ByteList.create(RbConfigLibrary.getSysConfDir(runtime2));
        if (Platform.IS_WINDOWS && (localAppData = System.getenv("CSIDL_LOCAL_APPDATA")) != null) {
            tmp = ByteList.create(localAppData);
        }
        RubyString ret = RubyString.newString(runtime2, tmp, runtime2.getDefaultExternalEncoding());
        return ret;
    }

    @JRubyMethod(module=true)
    public static synchronized IRubyObject nprocessors(ThreadContext context, IRubyObject recv2) {
        int nprocs = Runtime.getRuntime().availableProcessors();
        return RubyFixnum.newFixnum(context.getRuntime(), nprocs);
    }

    @JRubyMethod(module=true)
    public static synchronized IRubyObject uname(ThreadContext context, IRubyObject self2) {
        Ruby runtime2 = context.runtime;
        RubyHash uname2 = RubyHash.newHash(runtime2);
        uname2.op_aset(context, runtime2.newSymbol("sysname"), runtime2.newString(SafePropertyAccessor.getProperty("os.name", "unknown")));
        try {
            uname2.op_aset(context, runtime2.newSymbol("nodename"), runtime2.newString(InetAddress.getLocalHost().getHostName()));
        }
        catch (UnknownHostException uhe) {
            uname2.op_aset(context, runtime2.newSymbol("nodename"), runtime2.newString("unknown"));
        }
        uname2.put(runtime2.newSymbol("release"), runtime2.newString("unknown"));
        uname2.put(runtime2.newSymbol("version"), runtime2.newString(SafePropertyAccessor.getProperty("os.version")));
        uname2.put(runtime2.newSymbol("machine"), runtime2.newString(SafePropertyAccessor.getProperty("os.arch")));
        return uname2;
    }

    public static class IOExt {
        @JRubyMethod(required=1)
        public static synchronized IRubyObject pathconf(ThreadContext context, IRubyObject recv2, IRubyObject arg2) {
            Pathconf name2 = Pathconf.valueOf((long)RubyNumeric.num2long(arg2));
            RubyIO io2 = (RubyIO)recv2;
            OpenFile fptr = io2.getOpenFileChecked();
            POSIX posix = context.runtime.getPosix();
            long ret = posix.fpathconf(fptr.getFileno(), name2);
            if (ret == -1L) {
                if (posix.errno() == 0) {
                    return context.runtime.getNil();
                }
                if (posix.errno() == Errno.EOPNOTSUPP.intValue()) {
                    throw context.runtime.newNotImplementedError("pathconf() function is unimplemented on this machine");
                }
                throw context.runtime.newErrnoFromLastPOSIXErrno();
            }
            return context.runtime.newFixnum(ret);
        }
    }
}

