/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jruby.CompatVersion;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBignum;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyFloat;
import org.jruby.RubyInteger;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyConstant;
import org.jruby.anno.JRubyMethod;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.SafeDoubleParser;

@JRubyClass(name={"BigDecimal"}, parent="Numeric")
public class RubyBigDecimal
extends RubyNumeric {
    private static final ObjectAllocator BIGDECIMAL_ALLOCATOR = new ObjectAllocator(){

        public IRubyObject allocate(Ruby runtime2, RubyClass klass) {
            return new RubyBigDecimal(runtime2, klass);
        }
    };
    @JRubyConstant
    public static final int ROUND_DOWN = 1;
    @JRubyConstant
    public static final int ROUND_CEILING = 2;
    @JRubyConstant
    public static final int ROUND_UP = 0;
    @JRubyConstant
    public static final int ROUND_HALF_DOWN = 5;
    @JRubyConstant
    public static final int ROUND_HALF_EVEN = 6;
    @JRubyConstant
    public static final int ROUND_HALF_UP = 4;
    @JRubyConstant
    public static final int ROUND_FLOOR = 3;
    @JRubyConstant
    public static final int SIGN_POSITIVE_INFINITE = 3;
    @JRubyConstant
    public static final int EXCEPTION_OVERFLOW = 8;
    @JRubyConstant
    public static final int SIGN_POSITIVE_ZERO = 1;
    @JRubyConstant
    public static final int EXCEPTION_ALL = 255;
    @JRubyConstant
    public static final int SIGN_NEGATIVE_FINITE = -2;
    @JRubyConstant
    public static final int EXCEPTION_UNDERFLOW = 4;
    @JRubyConstant
    public static final int SIGN_NaN = 0;
    @JRubyConstant
    public static final int BASE = 10000;
    @JRubyConstant
    public static final int ROUND_MODE = 256;
    @JRubyConstant
    public static final int SIGN_POSITIVE_FINITE = 2;
    @JRubyConstant
    public static final int EXCEPTION_INFINITY = 1;
    @JRubyConstant
    public static final int SIGN_NEGATIVE_INFINITE = -3;
    @JRubyConstant
    public static final int EXCEPTION_ZERODIVIDE = 1;
    @JRubyConstant
    public static final int SIGN_NEGATIVE_ZERO = -1;
    @JRubyConstant
    public static final int EXCEPTION_NaN = 2;
    private static final BigDecimal TWO = new BigDecimal(2);
    private static final double SQRT_10 = 3.1622776601683795;
    private boolean isNaN = false;
    private int infinitySign = 0;
    private int zeroSign = 0;
    private BigDecimal value;
    private static final Pattern INFINITY_PATTERN = Pattern.compile("^([+-])?Infinity$");
    private static final Pattern NUMBER_PATTERN = Pattern.compile("^([+-]?\\d*\\.?\\d*([eE][+-]?)?\\d*).*");

    public static RubyClass createBigDecimal(Ruby runtime2) {
        RubyClass result2 = runtime2.defineClass("BigDecimal", runtime2.getNumeric(), BIGDECIMAL_ALLOCATOR);
        runtime2.getKernel().defineAnnotatedMethods(BigDecimalKernelMethods.class);
        result2.setInternalModuleVariable("vpPrecLimit", RubyFixnum.zero(runtime2));
        result2.setInternalModuleVariable("vpExceptionMode", RubyFixnum.zero(runtime2));
        result2.setInternalModuleVariable("vpRoundingMode", runtime2.newFixnum(4));
        result2.defineAnnotatedMethods(RubyBigDecimal.class);
        result2.defineAnnotatedConstants(RubyBigDecimal.class);
        return result2;
    }

    public BigDecimal getValue() {
        return this.value;
    }

    public RubyBigDecimal(Ruby runtime2, RubyClass klass) {
        super(runtime2, klass);
    }

    public RubyBigDecimal(Ruby runtime2, BigDecimal value2) {
        super(runtime2, runtime2.fastGetClass("BigDecimal"));
        this.value = value2;
    }

    public static RubyBigDecimal newBigDecimal(IRubyObject recv2, IRubyObject[] args2, Block unusedBlock) {
        return RubyBigDecimal.newInstance(recv2.getRuntime().fastGetClass("BigDecimal"), args2);
    }

    @JRubyMethod(name={"ver"}, meta=true)
    public static IRubyObject ver(IRubyObject recv2) {
        return recv2.getRuntime().newString("1.0.1");
    }

    @JRubyMethod(name={"_dump"}, optional=1)
    public IRubyObject dump(IRubyObject[] args2, Block unusedBlock) {
        RubyString precision = RubyString.newUnicodeString(this.getRuntime(), "0:");
        return precision.append(this.asString());
    }

    @JRubyMethod(name={"_load"}, required=1, meta=true)
    public static RubyBigDecimal load(IRubyObject recv2, IRubyObject from, Block block) {
        RubyBigDecimal rubyBigDecimal = (RubyBigDecimal)((RubyClass)recv2).allocate();
        String precisionAndValue = from.convertToString().asJavaString();
        String value2 = precisionAndValue.substring(precisionAndValue.indexOf(":") + 1);
        rubyBigDecimal.value = new BigDecimal(value2);
        return rubyBigDecimal;
    }

    @JRubyMethod(name={"double_fig"}, meta=true)
    public static IRubyObject double_fig(IRubyObject recv2) {
        return recv2.getRuntime().newFixnum(20);
    }

    @JRubyMethod(name={"limit"}, optional=1, meta=true)
    public static IRubyObject limit(IRubyObject recv2, IRubyObject[] args2) {
        IRubyObject arg2;
        Ruby runtime2 = recv2.getRuntime();
        RubyModule c = (RubyModule)recv2;
        IRubyObject nCur = c.searchInternalModuleVariable("vpPrecLimit");
        if (args2.length > 0 && !(arg2 = args2[0]).isNil()) {
            if (!(arg2 instanceof RubyFixnum)) {
                throw runtime2.newTypeError(arg2, runtime2.getFixnum());
            }
            if (0L > ((RubyFixnum)arg2).getLongValue()) {
                throw runtime2.newArgumentError("argument must be positive");
            }
            c.setInternalModuleVariable("vpPrecLimit", arg2);
        }
        return nCur;
    }

    @JRubyMethod(name={"mode"}, required=1, optional=1, meta=true)
    public static IRubyObject mode(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        long EXCEPTION_ALL;
        Ruby runtime2 = recv2.getRuntime();
        RubyClass clazz = runtime2.fastGetClass("BigDecimal");
        RubyModule c = (RubyModule)recv2;
        args2 = Arity.scanArgs(runtime2, args2, 1, 1);
        IRubyObject mode2 = args2[0];
        IRubyObject value2 = args2[1];
        if (!(mode2 instanceof RubyFixnum)) {
            throw runtime2.newTypeError("wrong argument type " + mode2.getMetaClass() + " (expected Fixnum)");
        }
        long longMode = ((RubyFixnum)mode2).getLongValue();
        if ((longMode & (EXCEPTION_ALL = ((RubyFixnum)clazz.fastGetConstant("EXCEPTION_ALL")).getLongValue())) != 0L) {
            RubyFixnum EXCEPTION_OVERFLOW;
            RubyFixnum EXCEPTION_UNDERFLOW;
            RubyFixnum EXCEPTION_NaN;
            if (value2.isNil()) {
                return c.searchInternalModuleVariable("vpExceptionMode");
            }
            if (!value2.isNil() && !(value2 instanceof RubyBoolean)) {
                throw runtime2.newTypeError("second argument must be true or false");
            }
            RubyFixnum currentExceptionMode = (RubyFixnum)c.searchInternalModuleVariable("vpExceptionMode");
            RubyFixnum newExceptionMode = new RubyFixnum(runtime2, currentExceptionMode.getLongValue());
            RubyFixnum EXCEPTION_INFINITY = (RubyFixnum)clazz.fastGetConstant("EXCEPTION_INFINITY");
            if ((longMode & EXCEPTION_INFINITY.getLongValue()) != 0L) {
                RubyFixnum rubyFixnum = newExceptionMode = value2.isTrue() ? (RubyFixnum)currentExceptionMode.callCoerced(context, "|", EXCEPTION_INFINITY) : (RubyFixnum)currentExceptionMode.callCoerced(context, "&", new RubyFixnum(runtime2, EXCEPTION_INFINITY.getLongValue() ^ 0xFFFFFFFFFFFFFFFFL));
            }
            if ((longMode & (EXCEPTION_NaN = (RubyFixnum)clazz.fastGetConstant("EXCEPTION_NaN")).getLongValue()) != 0L) {
                RubyFixnum rubyFixnum = newExceptionMode = value2.isTrue() ? (RubyFixnum)currentExceptionMode.callCoerced(context, "|", EXCEPTION_NaN) : (RubyFixnum)currentExceptionMode.callCoerced(context, "&", new RubyFixnum(runtime2, EXCEPTION_NaN.getLongValue() ^ 0xFFFFFFFFFFFFFFFFL));
            }
            if ((longMode & (EXCEPTION_UNDERFLOW = (RubyFixnum)clazz.fastGetConstant("EXCEPTION_UNDERFLOW")).getLongValue()) != 0L) {
                RubyFixnum rubyFixnum = newExceptionMode = value2.isTrue() ? (RubyFixnum)currentExceptionMode.callCoerced(context, "|", EXCEPTION_UNDERFLOW) : (RubyFixnum)currentExceptionMode.callCoerced(context, "&", new RubyFixnum(runtime2, EXCEPTION_UNDERFLOW.getLongValue() ^ 0xFFFFFFFFFFFFFFFFL));
            }
            if ((longMode & (EXCEPTION_OVERFLOW = (RubyFixnum)clazz.fastGetConstant("EXCEPTION_OVERFLOW")).getLongValue()) != 0L) {
                newExceptionMode = value2.isTrue() ? (RubyFixnum)currentExceptionMode.callCoerced(context, "|", EXCEPTION_OVERFLOW) : (RubyFixnum)currentExceptionMode.callCoerced(context, "&", new RubyFixnum(runtime2, EXCEPTION_OVERFLOW.getLongValue() ^ 0xFFFFFFFFFFFFFFFFL));
            }
            c.setInternalModuleVariable("vpExceptionMode", newExceptionMode);
            return newExceptionMode;
        }
        long ROUND_MODE = ((RubyFixnum)clazz.fastGetConstant("ROUND_MODE")).getLongValue();
        if (longMode == ROUND_MODE) {
            if (value2.isNil()) {
                return c.searchInternalModuleVariable("vpRoundingMode");
            }
            if (!(value2 instanceof RubyFixnum)) {
                throw runtime2.newTypeError("wrong argument type " + mode2.getMetaClass() + " (expected Fixnum)");
            }
            RubyFixnum roundingMode = (RubyFixnum)value2;
            if (roundingMode != clazz.fastGetConstant("ROUND_UP") && roundingMode != clazz.fastGetConstant("ROUND_DOWN") && roundingMode != clazz.fastGetConstant("ROUND_FLOOR") && roundingMode != clazz.fastGetConstant("ROUND_CEILING") && roundingMode != clazz.fastGetConstant("ROUND_HALF_UP") && roundingMode != clazz.fastGetConstant("ROUND_HALF_DOWN") && roundingMode != clazz.fastGetConstant("ROUND_HALF_EVEN")) {
                throw runtime2.newTypeError("invalid rounding mode");
            }
            c.setInternalModuleVariable("vpRoundingMode", roundingMode);
            return c.searchInternalModuleVariable("vpRoundingMode");
        }
        throw runtime2.newTypeError("first argument for BigDecimal#mode invalid");
    }

    private RoundingMode getRoundingMode(Ruby runtime2) {
        RubyFixnum roundingMode = (RubyFixnum)runtime2.fastGetClass("BigDecimal").searchInternalModuleVariable("vpRoundingMode");
        return RoundingMode.valueOf((int)roundingMode.getLongValue());
    }

    private static boolean isNaNExceptionMode(Ruby runtime2) {
        RubyFixnum currentExceptionMode = (RubyFixnum)runtime2.fastGetClass("BigDecimal").searchInternalModuleVariable("vpExceptionMode");
        RubyFixnum EXCEPTION_NaN = (RubyFixnum)runtime2.fastGetClass("BigDecimal").fastGetConstant("EXCEPTION_NaN");
        return (currentExceptionMode.getLongValue() & EXCEPTION_NaN.getLongValue()) != 0L;
    }

    private static boolean isInfinityExceptionMode(Ruby runtime2) {
        RubyFixnum currentExceptionMode = (RubyFixnum)runtime2.fastGetClass("BigDecimal").searchInternalModuleVariable("vpExceptionMode");
        RubyFixnum EXCEPTION_INFINITY = (RubyFixnum)runtime2.fastGetClass("BigDecimal").fastGetConstant("EXCEPTION_INFINITY");
        return (currentExceptionMode.getLongValue() & EXCEPTION_INFINITY.getLongValue()) != 0L;
    }

    private static boolean isOverflowExceptionMode(Ruby runtime2) {
        RubyFixnum currentExceptionMode = (RubyFixnum)runtime2.fastGetClass("BigDecimal").searchInternalModuleVariable("vpExceptionMode");
        RubyFixnum EXCEPTION_OVERFLOW = (RubyFixnum)runtime2.fastGetClass("BigDecimal").fastGetConstant("EXCEPTION_OVERFLOW");
        return (currentExceptionMode.getLongValue() & EXCEPTION_OVERFLOW.getLongValue()) != 0L;
    }

    private static RubyBigDecimal getVpValue(IRubyObject v, boolean must) {
        if (v instanceof RubyBigDecimal) {
            return (RubyBigDecimal)v;
        }
        if (v instanceof RubyFixnum || v instanceof RubyBignum) {
            String s2 = v.toString();
            return RubyBigDecimal.newInstance(v.getRuntime().fastGetClass("BigDecimal"), new IRubyObject[]{v.getRuntime().newString(s2)});
        }
        if (must) {
            String err;
            if (v.isImmediate()) {
                ThreadContext context = v.getRuntime().getCurrentContext();
                err = RubyObject.inspect(context, v).toString();
            } else {
                err = v.getMetaClass().getBaseName();
            }
            throw v.getRuntime().newTypeError(err + " can't be coerced into BigDecimal");
        }
        return null;
    }

    @JRubyMethod(name={"induced_from"}, required=1, meta=true)
    public static IRubyObject induced_from(IRubyObject recv2, IRubyObject arg2) {
        return RubyBigDecimal.getVpValue(arg2, true);
    }

    @JRubyMethod(name={"new"}, required=1, optional=1, meta=true)
    public static RubyBigDecimal newInstance(IRubyObject recv2, IRubyObject[] args2) {
        BigDecimal decimal;
        Ruby runtime2 = recv2.getRuntime();
        if (args2.length == 0) {
            decimal = new BigDecimal(0);
        } else {
            String strValue = args2[0].convertToString().toString();
            if ("NaN".equals(strValue = strValue.trim())) {
                return RubyBigDecimal.newNaN(runtime2);
            }
            Matcher m = INFINITY_PATTERN.matcher(strValue);
            if (m.matches()) {
                int sign2 = 1;
                String signGroup = m.group(1);
                if ("-".equals(signGroup)) {
                    sign2 = -1;
                }
                return RubyBigDecimal.newInfinity(runtime2, sign2);
            }
            strValue = strValue.replaceFirst("[dD]", "E");
            strValue = strValue.replaceAll("_", "");
            strValue = NUMBER_PATTERN.matcher(strValue).replaceFirst("$1");
            try {
                decimal = new BigDecimal(strValue);
            }
            catch (NumberFormatException e) {
                if (RubyBigDecimal.isOverflowExceptionMode(runtime2)) {
                    throw runtime2.newFloatDomainError("exponent overflow");
                }
                decimal = new BigDecimal(0);
            }
            if (decimal.signum() == 0) {
                if (strValue.matches("^\\s*-.*")) {
                    return RubyBigDecimal.newZero(runtime2, -1);
                }
                return RubyBigDecimal.newZero(runtime2, 1);
            }
        }
        return new RubyBigDecimal(runtime2, decimal);
    }

    private static RubyBigDecimal newZero(Ruby runtime2, int sign2) {
        RubyBigDecimal rbd = new RubyBigDecimal(runtime2, BigDecimal.ZERO);
        rbd.zeroSign = sign2 < 0 ? -1 : 1;
        return rbd;
    }

    private static RubyBigDecimal newNaN(Ruby runtime2) {
        if (RubyBigDecimal.isNaNExceptionMode(runtime2)) {
            throw runtime2.newFloatDomainError("Computation results to 'NaN'(Not a Number)");
        }
        RubyBigDecimal rbd = new RubyBigDecimal(runtime2, BigDecimal.ZERO);
        rbd.isNaN = true;
        return rbd;
    }

    private static RubyBigDecimal newInfinity(Ruby runtime2, int sign2) {
        RubyBigDecimal rbd = new RubyBigDecimal(runtime2, BigDecimal.ZERO);
        if (RubyBigDecimal.isInfinityExceptionMode(runtime2)) {
            throw runtime2.newFloatDomainError("Computation results to 'Infinity'");
        }
        rbd.infinitySign = sign2 < 0 ? -1 : 1;
        return rbd;
    }

    private RubyBigDecimal setResult() {
        return this.setResult(0);
    }

    private RubyBigDecimal setResult(int scale) {
        int prec2 = RubyFixnum.fix2int(this.getRuntime().fastGetClass("BigDecimal").searchInternalModuleVariable("vpPrecLimit"));
        int prec22 = Math.max(scale, prec2);
        if (prec22 > 0 && this.value.scale() > prec22 - this.getExponent()) {
            this.value = this.value.setScale(prec22 - this.getExponent(), 4);
        }
        return this;
    }

    @JRubyMethod(name={"hash"})
    public RubyFixnum hash() {
        return this.getRuntime().newFixnum(this.value.hashCode());
    }

    @JRubyMethod(name={"%", "modulo"}, required=1)
    public IRubyObject op_mod(ThreadContext context, IRubyObject arg2) {
        Ruby runtime2 = context.getRuntime();
        if (this.isInfinity() || this.isNaN()) {
            return RubyBigDecimal.newNaN(runtime2);
        }
        RubyBigDecimal val = RubyBigDecimal.getVpValue(arg2, false);
        if (val == null) {
            return this.callCoerced(context, "%", arg2, true);
        }
        if (val.isInfinity() || val.isNaN() || val.isZero()) {
            return RubyBigDecimal.newNaN(runtime2);
        }
        BigDecimal modulo2 = this.value.remainder(val.value);
        if (modulo2.signum() * val.value.signum() < 0) {
            modulo2 = modulo2.add(val.value);
        }
        return new RubyBigDecimal(runtime2, modulo2).setResult();
    }

    @JRubyMethod(name={"remainder"}, required=1)
    public IRubyObject remainder(ThreadContext context, IRubyObject arg2) {
        Ruby runtime2 = context.getRuntime();
        if (this.isInfinity() || this.isNaN()) {
            return RubyBigDecimal.newNaN(runtime2);
        }
        RubyBigDecimal val = RubyBigDecimal.getVpValue(arg2, false);
        if (val == null) {
            return this.callCoerced(context, "remainder", arg2, true);
        }
        if (val.isInfinity() || val.isNaN() || val.isZero()) {
            return RubyBigDecimal.newNaN(runtime2);
        }
        return new RubyBigDecimal(runtime2, this.value.remainder(val.value)).setResult();
    }

    @JRubyMethod(name={"*"}, required=1)
    public IRubyObject op_mul(ThreadContext context, IRubyObject arg2) {
        return this.mult2(context, arg2, this.getRuntime().fastGetClass("BigDecimal").searchInternalModuleVariable("vpPrecLimit"));
    }

    @JRubyMethod(name={"mult"}, required=2)
    public IRubyObject mult2(ThreadContext context, IRubyObject b, IRubyObject n) {
        Ruby runtime2 = context.getRuntime();
        RubyBigDecimal val = RubyBigDecimal.getVpValue(b, false);
        if (val == null) {
            return this.callCoerced(context, "*", b);
        }
        int digits = RubyNumeric.fix2int(n);
        if (this.isNaN() || val.isNaN()) {
            return RubyBigDecimal.newNaN(runtime2);
        }
        if (this.isInfinity() && val.isZero() || this.isZero() && val.isInfinity()) {
            return RubyBigDecimal.newNaN(runtime2);
        }
        if (this.isZero() || val.isZero()) {
            int sign1 = this.isZero() ? this.zeroSign : this.value.signum();
            int sign2 = val.isZero() ? val.zeroSign : val.value.signum();
            return RubyBigDecimal.newZero(runtime2, sign1 * sign2);
        }
        if (this.isInfinity() || val.isInfinity()) {
            int sign1 = this.isInfinity() ? this.infinitySign : this.value.signum();
            int sign2 = val.isInfinity() ? val.infinitySign : val.value.signum();
            return RubyBigDecimal.newInfinity(runtime2, sign1 * sign2);
        }
        BigDecimal res = this.value.multiply(val.value);
        if (res.precision() > digits) {
            res = res.round(new MathContext(digits, RoundingMode.HALF_UP));
        }
        return new RubyBigDecimal(runtime2, res).setResult();
    }

    @JRubyMethod(name={"**", "power"}, required=1)
    public IRubyObject op_pow(IRubyObject arg2) {
        if (!(arg2 instanceof RubyFixnum)) {
            throw this.getRuntime().newTypeError("wrong argument type " + arg2.getMetaClass() + " (expected Fixnum)");
        }
        if (this.isNaN() || this.isInfinity()) {
            return RubyBigDecimal.newNaN(this.getRuntime());
        }
        int times2 = RubyNumeric.fix2int(arg2.convertToInteger());
        if (times2 < 0) {
            if (this.isZero()) {
                return RubyBigDecimal.newInfinity(this.getRuntime(), this.value.signum());
            }
            int precision = (-times2 + 4) * (this.getAllDigits().length() + 4);
            return new RubyBigDecimal(this.getRuntime(), this.value.pow(times2, new MathContext(precision, RoundingMode.HALF_UP)));
        }
        return new RubyBigDecimal(this.getRuntime(), this.value.pow(times2));
    }

    @JRubyMethod(name={"+"})
    public IRubyObject op_plus(ThreadContext context, IRubyObject b) {
        return this.addInternal(context, b, "add", this.getRuntime().fastGetClass("BigDecimal").searchInternalModuleVariable("vpPrecLimit"));
    }

    @JRubyMethod(name={"add"})
    public IRubyObject add2(ThreadContext context, IRubyObject b, IRubyObject digits) {
        return this.addInternal(context, b, "add", digits);
    }

    private IRubyObject addInternal(ThreadContext context, IRubyObject b, String op, IRubyObject digits) {
        Ruby runtime2 = context.getRuntime();
        int prec2 = this.getPositiveInt(context, digits);
        RubyBigDecimal val = RubyBigDecimal.getVpValue(b, false);
        if (val == null) {
            return this.callCoerced(context, "+", b, true);
        }
        RubyBigDecimal res = this.handleAddSpecialValues(val);
        if (res != null) {
            return res;
        }
        RoundingMode roundMode = this.getRoundingMode(runtime2);
        return new RubyBigDecimal(runtime2, this.value.add(val.value, new MathContext(prec2, roundMode)));
    }

    private int getPositiveInt(ThreadContext context, IRubyObject arg2) {
        Ruby runtime2 = context.getRuntime();
        if (arg2 instanceof RubyFixnum) {
            int value2 = RubyNumeric.fix2int(arg2);
            if (value2 < 0) {
                throw runtime2.newArgumentError("argument must be positive");
            }
            return value2;
        }
        throw runtime2.newTypeError(arg2, runtime2.getFixnum());
    }

    private RubyBigDecimal handleAddSpecialValues(RubyBigDecimal val) {
        int sign2;
        if (this.isNaN() || val.isNaN) {
            return RubyBigDecimal.newNaN(this.getRuntime());
        }
        if (this.infinitySign * val.infinitySign > 0) {
            return this.isInfinity() ? this : val;
        }
        if (this.infinitySign * val.infinitySign < 0) {
            return RubyBigDecimal.newNaN(this.getRuntime());
        }
        if (this.infinitySign * val.infinitySign == 0 && (sign2 = this.infinitySign + val.infinitySign) != 0) {
            return RubyBigDecimal.newInfinity(this.getRuntime(), sign2);
        }
        return null;
    }

    @JRubyMethod(name={"+@"})
    public IRubyObject op_uplus() {
        return this;
    }

    @JRubyMethod(name={"-"}, required=1)
    public IRubyObject op_minus(ThreadContext context, IRubyObject arg2) {
        RubyBigDecimal val = RubyBigDecimal.getVpValue(arg2, false);
        if (val == null) {
            return this.callCoerced(context, "-", arg2);
        }
        RubyBigDecimal res = this.handleMinusSpecialValues(val);
        if (res != null) {
            return res;
        }
        return new RubyBigDecimal(this.getRuntime(), this.value.subtract(val.value)).setResult();
    }

    @JRubyMethod(name={"sub"}, required=2)
    public IRubyObject sub2(ThreadContext context, IRubyObject b, IRubyObject n) {
        RubyBigDecimal val = RubyBigDecimal.getVpValue(b, false);
        if (val == null) {
            return this.callCoerced(context, "-", b);
        }
        RubyBigDecimal res = this.handleMinusSpecialValues(val);
        if (res != null) {
            return res;
        }
        return new RubyBigDecimal(this.getRuntime(), this.value.subtract(val.value)).setResult();
    }

    private RubyBigDecimal handleMinusSpecialValues(RubyBigDecimal val) {
        if (this.isNaN() || val.isNaN()) {
            return RubyBigDecimal.newNaN(this.getRuntime());
        }
        if (this.infinitySign * val.infinitySign > 0) {
            return RubyBigDecimal.newNaN(this.getRuntime());
        }
        if (this.infinitySign * val.infinitySign < 0) {
            return this;
        }
        if (this.infinitySign * val.infinitySign == 0) {
            if (this.isInfinity()) {
                return this;
            }
            if (val.isInfinity()) {
                return RubyBigDecimal.newInfinity(this.getRuntime(), val.infinitySign * -1);
            }
            int sign2 = this.infinitySign + val.infinitySign;
            if (sign2 != 0) {
                return RubyBigDecimal.newInfinity(this.getRuntime(), sign2);
            }
        }
        return null;
    }

    @JRubyMethod(name={"-@"})
    public IRubyObject op_uminus() {
        Ruby runtime2 = this.getRuntime();
        if (this.isNaN()) {
            return RubyBigDecimal.newNaN(runtime2);
        }
        if (this.isInfinity()) {
            return RubyBigDecimal.newInfinity(runtime2, -this.infinitySign);
        }
        if (this.isZero()) {
            return RubyBigDecimal.newZero(runtime2, -this.zeroSign);
        }
        return new RubyBigDecimal(this.getRuntime(), this.value.negate());
    }

    @JRubyMethod(name={"/", "quo"})
    public IRubyObject op_quo(ThreadContext context, IRubyObject other) {
        return this.op_div(context, other, this.getRuntime().newFixnum(200));
    }

    @JRubyMethod(name={"div"})
    public IRubyObject op_div(ThreadContext context, IRubyObject other) {
        RubyBigDecimal val = RubyBigDecimal.getVpValue(other, false);
        if (val == null) {
            return this.callCoerced(context, "div", other);
        }
        if (this.isNaN() || val.isZero() || val.isNaN()) {
            return RubyBigDecimal.newNaN(this.getRuntime());
        }
        if (this.isInfinity() || val.isInfinity()) {
            return RubyBigDecimal.newNaN(this.getRuntime());
        }
        return new RubyBigDecimal(this.getRuntime(), this.value.divideToIntegralValue(val.value)).setResult();
    }

    @JRubyMethod(name={"div"})
    public IRubyObject op_div(ThreadContext context, IRubyObject other, IRubyObject digits) {
        int scale = RubyNumeric.fix2int(digits);
        RubyBigDecimal val = RubyBigDecimal.getVpValue(other, false);
        if (val == null) {
            return this.callCoerced(context, "/", other);
        }
        if (this.isNaN() || this.isZero() && val.isZero() || val.isNaN()) {
            return RubyBigDecimal.newNaN(this.getRuntime());
        }
        if (val.isZero()) {
            int sign1 = this.isInfinity() ? this.infinitySign : this.value.signum();
            return RubyBigDecimal.newInfinity(this.getRuntime(), sign1 * val.zeroSign);
        }
        if (this.isInfinity() && !val.isInfinity()) {
            return RubyBigDecimal.newInfinity(this.getRuntime(), this.infinitySign * val.value.signum());
        }
        if (!this.isInfinity() && val.isInfinity()) {
            return RubyBigDecimal.newZero(this.getRuntime(), this.value.signum() * val.infinitySign);
        }
        if (this.isInfinity() && val.isInfinity()) {
            return RubyBigDecimal.newNaN(this.getRuntime());
        }
        if (scale == 0) {
            return this.op_quo(context, other);
        }
        int prec2 = Math.max(200, scale);
        return new RubyBigDecimal(this.getRuntime(), this.value.divide(val.value, new MathContext(prec2, RoundingMode.HALF_UP))).setResult(scale);
    }

    private IRubyObject cmp(ThreadContext context, IRubyObject r, char op) {
        int e = 0;
        RubyBigDecimal rb = RubyBigDecimal.getVpValue(r, false);
        if (rb == null) {
            IRubyObject ee = this.callCoerced(context, "<=>", r);
            if (ee.isNil()) {
                if (op == '*') {
                    return this.getRuntime().getNil();
                }
                if (op == '=' || this.isNaN()) {
                    return this.getRuntime().getFalse();
                }
                throw this.getRuntime().newArgumentError("nil could not be coerced into a BigDecmil");
            }
            e = RubyNumeric.fix2int(ee);
        } else {
            if (this.isNaN() | rb.isNaN()) {
                return op == '*' ? this.getRuntime().getNil() : this.getRuntime().getFalse();
            }
            e = this.infinitySign != 0 || rb.infinitySign != 0 ? this.infinitySign - rb.infinitySign : this.value.compareTo(rb.value);
        }
        switch (op) {
            case '*': {
                return this.getRuntime().newFixnum(e);
            }
            case '=': {
                return e == 0 ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
            }
            case '!': {
                return e != 0 ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
            }
            case 'G': {
                return e >= 0 ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
            }
            case '>': {
                return e > 0 ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
            }
            case 'L': {
                return e <= 0 ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
            }
            case '<': {
                return e < 0 ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
            }
        }
        return this.getRuntime().getNil();
    }

    @JRubyMethod(name={"<=>"}, required=1)
    public IRubyObject op_cmp(ThreadContext context, IRubyObject arg2) {
        return this.cmp(context, arg2, '*');
    }

    @JRubyMethod(name={"eql?", "==", "==="}, required=1)
    public IRubyObject eql_p(ThreadContext context, IRubyObject arg2) {
        return this.cmp(context, arg2, '=');
    }

    @JRubyMethod(name={"<"}, required=1)
    public IRubyObject op_lt(ThreadContext context, IRubyObject arg2) {
        return this.cmp(context, arg2, '<');
    }

    @JRubyMethod(name={"<="}, required=1)
    public IRubyObject op_le(ThreadContext context, IRubyObject arg2) {
        return this.cmp(context, arg2, 'L');
    }

    @JRubyMethod(name={">"}, required=1)
    public IRubyObject op_gt(ThreadContext context, IRubyObject arg2) {
        return this.cmp(context, arg2, '>');
    }

    @JRubyMethod(name={">="}, required=1)
    public IRubyObject op_ge(ThreadContext context, IRubyObject arg2) {
        return this.cmp(context, arg2, 'G');
    }

    @JRubyMethod(name={"abs"})
    public IRubyObject abs() {
        Ruby runtime2 = this.getRuntime();
        if (this.isNaN) {
            return RubyBigDecimal.newNaN(runtime2);
        }
        if (this.isInfinity()) {
            return RubyBigDecimal.newInfinity(runtime2, 1);
        }
        return new RubyBigDecimal(this.getRuntime(), this.value.abs()).setResult();
    }

    @JRubyMethod(name={"ceil"}, optional=1)
    public IRubyObject ceil(IRubyObject[] args2) {
        if (this.isNaN) {
            return RubyBigDecimal.newNaN(this.getRuntime());
        }
        if (this.isInfinity()) {
            return RubyBigDecimal.newInfinity(this.getRuntime(), this.infinitySign);
        }
        int n = 0;
        if (args2.length > 0) {
            n = RubyNumeric.fix2int(args2[0]);
        }
        if (this.value.scale() > n) {
            return new RubyBigDecimal(this.getRuntime(), this.value.setScale(n, RoundingMode.CEILING));
        }
        return this;
    }

    @JRubyMethod(name={"ceil"}, optional=1, compat=CompatVersion.RUBY1_9)
    public IRubyObject ceil19(IRubyObject[] args2) {
        this.checkFloatDomain();
        if (args2.length == 0) {
            BigInteger ceil2 = this.value.setScale(0, RoundingMode.CEILING).toBigInteger();
            if (ceil2.compareTo(BigInteger.valueOf(ceil2.intValue())) == 0) {
                return RubyInteger.int2fix(this.getRuntime(), ceil2.intValue());
            }
            return RubyBignum.newBignum(this.getRuntime(), ceil2);
        }
        return this.ceil(args2);
    }

    @JRubyMethod(name={"coerce"}, required=1)
    public IRubyObject coerce(IRubyObject other) {
        RubyArray obj = other instanceof RubyFloat ? this.getRuntime().newArray(other, this.to_f()) : this.getRuntime().newArray((IRubyObject)RubyBigDecimal.getVpValue(other, true), (IRubyObject)this);
        return obj;
    }

    public double getDoubleValue() {
        return SafeDoubleParser.doubleValue(this.value);
    }

    public long getLongValue() {
        return this.value.longValue();
    }

    public BigInteger getBigIntegerValue() {
        return this.value.toBigInteger();
    }

    public RubyNumeric multiplyWith(ThreadContext context, RubyInteger value2) {
        return (RubyNumeric)this.op_mul(context, value2);
    }

    public RubyNumeric multiplyWith(ThreadContext context, RubyFloat value2) {
        return (RubyNumeric)this.op_mul(context, value2);
    }

    public RubyNumeric multiplyWith(ThreadContext context, RubyBignum value2) {
        return (RubyNumeric)this.op_mul(context, value2);
    }

    @JRubyMethod(name={"divmod"}, required=1)
    public IRubyObject divmod(ThreadContext context, IRubyObject other) {
        Ruby runtime2 = context.getRuntime();
        if (this.isInfinity() || this.isNaN()) {
            return RubyArray.newArray(runtime2, RubyBigDecimal.newNaN(runtime2), RubyBigDecimal.newNaN(runtime2));
        }
        RubyBigDecimal val = RubyBigDecimal.getVpValue(other, false);
        if (val == null) {
            return this.callCoerced(context, "divmod", other, true);
        }
        if (val.isInfinity() || val.isNaN() || val.isZero()) {
            return RubyArray.newArray(runtime2, RubyBigDecimal.newNaN(runtime2), RubyBigDecimal.newNaN(runtime2));
        }
        BigDecimal[] divmod2 = this.value.divideAndRemainder(val.value);
        BigDecimal div2 = divmod2[0];
        BigDecimal mod = divmod2[1];
        if (mod.signum() * val.value.signum() < 0) {
            div2 = div2.subtract(BigDecimal.ONE);
            mod = mod.add(val.value);
        }
        return RubyArray.newArray(runtime2, new RubyBigDecimal(runtime2, div2), new RubyBigDecimal(runtime2, mod));
    }

    @JRubyMethod(name={"exponent"})
    public IRubyObject exponent() {
        return this.getRuntime().newFixnum(this.getExponent());
    }

    @JRubyMethod(name={"finite?"})
    public IRubyObject finite_p() {
        if (this.isNaN()) {
            return this.getRuntime().getFalse();
        }
        return this.getRuntime().newBoolean(!this.isInfinity());
    }

    @JRubyMethod(name={"floor"}, optional=1)
    public IRubyObject floor(IRubyObject[] args2) {
        if (this.isNaN) {
            return RubyBigDecimal.newNaN(this.getRuntime());
        }
        if (this.isInfinity()) {
            return RubyBigDecimal.newInfinity(this.getRuntime(), this.infinitySign);
        }
        int n = 0;
        if (args2.length > 0) {
            n = RubyNumeric.fix2int(args2[0]);
        }
        if (this.value.scale() > n) {
            return new RubyBigDecimal(this.getRuntime(), this.value.setScale(n, RoundingMode.FLOOR));
        }
        return this;
    }

    @JRubyMethod(name={"floor"}, optional=1, compat=CompatVersion.RUBY1_9)
    public IRubyObject floor19(IRubyObject[] args2) {
        if (this.isNaN || this.isInfinity()) {
            throw this.getRuntime().newFloatDomainError("Computation results to '" + this.to_s(args2).asJavaString() + "'");
        }
        return this.floor(args2);
    }

    @JRubyMethod(name={"frac"})
    public IRubyObject frac() {
        if (this.isNaN) {
            return RubyBigDecimal.newNaN(this.getRuntime());
        }
        if (this.isInfinity()) {
            return RubyBigDecimal.newInfinity(this.getRuntime(), this.infinitySign);
        }
        if (this.value.scale() > 0 && this.value.precision() < this.value.scale()) {
            return new RubyBigDecimal(this.getRuntime(), this.value);
        }
        BigDecimal val = this.value.subtract(((RubyBigDecimal)this.fix()).value);
        return new RubyBigDecimal(this.getRuntime(), val);
    }

    @JRubyMethod(name={"infinite?"})
    public IRubyObject infinite_p() {
        if (this.infinitySign == 0) {
            return this.getRuntime().getNil();
        }
        return this.getRuntime().newFixnum(this.infinitySign);
    }

    @JRubyMethod(name={"inspect"})
    public IRubyObject inspect(ThreadContext context) {
        StringBuilder val = new StringBuilder("#<BigDecimal:").append(Integer.toHexString(System.identityHashCode(this))).append(",");
        val.append("'").append(this.callMethod(context, "to_s")).append("'").append(",");
        val.append(this.getSignificantDigits().length()).append("(");
        int len = this.getAllDigits().length();
        int pow = len / 4;
        val.append((pow + 1) * 4).append(")").append(">");
        return this.getRuntime().newString(val.toString());
    }

    @JRubyMethod(name={"nan?"})
    public IRubyObject nan_p() {
        return this.getRuntime().newBoolean(this.isNaN);
    }

    @JRubyMethod(name={"nonzero?"})
    public IRubyObject nonzero_p() {
        return this.isZero() ? this.getRuntime().getNil() : this;
    }

    @JRubyMethod(name={"precs"})
    public IRubyObject precs() {
        Ruby runtime2 = this.getRuntime();
        IRubyObject[] array = new IRubyObject[2];
        array[0] = runtime2.newFixnum(this.getSignificantDigits().length());
        int len = this.getAllDigits().length();
        int pow = len / 4;
        array[1] = runtime2.newFixnum((pow + 1) * 4);
        return RubyArray.newArrayNoCopy(runtime2, array);
    }

    @Deprecated
    public IRubyObject round(IRubyObject[] args2) {
        return this.round(this.getRuntime().getCurrentContext(), args2);
    }

    @JRubyMethod(name={"round"}, optional=2)
    public IRubyObject round(ThreadContext context, IRubyObject[] args2) {
        RoundingMode mode2;
        int scale = args2.length > 0 ? RubyBigDecimal.num2int(args2[0]) : 0;
        RoundingMode roundingMode = mode2 = args2.length > 1 ? this.javaRoundingModeFromRubyRoundingMode(args2[1]) : this.getRoundingMode(context.runtime);
        if (scale < 0) {
            BigDecimal normalized = this.value.movePointRight(scale);
            BigDecimal rounded = normalized.setScale(0, mode2);
            return new RubyBigDecimal(this.getRuntime(), rounded.movePointLeft(scale));
        }
        return new RubyBigDecimal(this.getRuntime(), this.value.setScale(scale, mode2));
    }

    private RoundingMode javaRoundingModeFromRubyRoundingMode(IRubyObject arg2) {
        return RoundingMode.valueOf(RubyBigDecimal.num2int(arg2));
    }

    @JRubyMethod(name={"sign"})
    public IRubyObject sign() {
        if (this.isNaN()) {
            return this.getMetaClass().fastGetConstant("SIGN_NaN");
        }
        if (this.isInfinity()) {
            if (this.infinitySign < 0) {
                return this.getMetaClass().fastGetConstant("SIGN_NEGATIVE_INFINITE");
            }
            return this.getMetaClass().fastGetConstant("SIGN_POSITIVE_INFINITE");
        }
        if (this.isZero()) {
            if (this.zeroSign < 0) {
                return this.getMetaClass().fastGetConstant("SIGN_NEGATIVE_ZERO");
            }
            return this.getMetaClass().fastGetConstant("SIGN_POSITIVE_ZERO");
        }
        if (this.value.signum() < 0) {
            return this.getMetaClass().fastGetConstant("SIGN_NEGATIVE_FINITE");
        }
        return this.getMetaClass().fastGetConstant("SIGN_POSITIVE_FINITE");
    }

    @JRubyMethod(name={"split"})
    public RubyArray split() {
        RubyFixnum exp2;
        RubyString digits;
        Ruby runtime2 = this.getRuntime();
        IRubyObject[] array = new IRubyObject[4];
        RubyFixnum sign2 = this.isNaN ? RubyFixnum.zero(runtime2) : (this.isInfinity() ? runtime2.newFixnum(this.infinitySign) : (this.isZero() ? runtime2.newFixnum(this.zeroSign) : runtime2.newFixnum(this.value.signum())));
        array[0] = sign2;
        if (this.isNaN()) {
            digits = runtime2.newString("NaN");
            exp2 = RubyFixnum.zero(runtime2);
        } else if (this.isInfinity()) {
            digits = runtime2.newString("Infinity");
            exp2 = RubyFixnum.zero(runtime2);
        } else if (this.isZero()) {
            digits = runtime2.newString("0");
            exp2 = RubyFixnum.zero(runtime2);
        } else {
            digits = runtime2.newString(this.getSignificantDigits());
            exp2 = runtime2.newFixnum(this.getExponent());
        }
        array[1] = digits;
        array[3] = exp2;
        array[2] = runtime2.newFixnum(10);
        return RubyArray.newArrayNoCopy(runtime2, array);
    }

    private String getSignificantDigits() {
        BigDecimal val = this.value.abs().stripTrailingZeros();
        return val.unscaledValue().toString();
    }

    private String getAllDigits() {
        BigDecimal val = this.value.abs();
        return val.unscaledValue().toString();
    }

    private int getExponent() {
        if (this.isZero()) {
            return 0;
        }
        BigDecimal val = this.value.abs().stripTrailingZeros();
        return val.precision() - val.scale();
    }

    @JRubyMethod(name={"sqrt"}, required=1)
    public IRubyObject sqrt(IRubyObject arg2) {
        Ruby runtime2 = this.getRuntime();
        if (this.isNaN()) {
            throw runtime2.newFloatDomainError("(VpSqrt) SQRT(NaN value)");
        }
        if (this.isInfinity() && this.infinitySign < 0 || this.value.signum() < 0) {
            throw runtime2.newFloatDomainError("(VpSqrt) SQRT(negative value)");
        }
        if (this.isInfinity() && this.infinitySign > 0) {
            return RubyBigDecimal.newInfinity(runtime2, 1);
        }
        int n = RubyNumeric.fix2int(arg2);
        if (n < 0) {
            throw runtime2.newArgumentError("argument must be positive");
        }
        return new RubyBigDecimal(this.getRuntime(), RubyBigDecimal.bigSqrt(this.value, new MathContext(n += 4, RoundingMode.HALF_UP))).setResult();
    }

    @JRubyMethod(name={"to_f"})
    public IRubyObject to_f() {
        if (this.isNaN()) {
            return RubyFloat.newFloat(this.getRuntime(), Double.NaN);
        }
        if (this.isInfinity()) {
            return RubyFloat.newFloat(this.getRuntime(), this.infinitySign < 0 ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY);
        }
        if (this.isZero()) {
            return RubyFloat.newFloat(this.getRuntime(), this.zeroSign < 0 ? -0.0 : 0.0);
        }
        if (-this.value.scale() > 308) {
            switch (this.value.signum()) {
                case -1: {
                    return RubyFloat.newFloat(this.getRuntime(), Double.NEGATIVE_INFINITY);
                }
                case 0: {
                    return RubyFloat.newFloat(this.getRuntime(), 0.0);
                }
                case 1: {
                    return RubyFloat.newFloat(this.getRuntime(), Double.POSITIVE_INFINITY);
                }
            }
        }
        return RubyFloat.newFloat(this.getRuntime(), SafeDoubleParser.doubleValue(this.value));
    }

    @JRubyMethod(name={"to_i", "to_int"}, compat=CompatVersion.RUBY1_8)
    public IRubyObject to_int() {
        if (this.isNaN() || this.infinitySign != 0) {
            return this.getRuntime().getNil();
        }
        try {
            return RubyNumeric.int2fix(this.getRuntime(), this.value.longValueExact());
        }
        catch (ArithmeticException ae) {
            return RubyBignum.bignorm(this.getRuntime(), this.value.toBigInteger());
        }
    }

    @JRubyMethod(name={"to_i", "to_int"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject to_int19() {
        this.checkFloatDomain();
        return this.to_int();
    }

    private String removeTrailingZeroes(String in) {
        while (in.length() > 0 && in.charAt(in.length() - 1) == '0') {
            in = in.substring(0, in.length() - 1);
        }
        return in;
    }

    public static boolean formatHasLeadingPlus(String format) {
        return format.startsWith("+");
    }

    public static boolean formatHasLeadingSpace(String format) {
        return format.startsWith(" ");
    }

    public static boolean formatHasFloatingPointNotation(String format) {
        return format.endsWith("F");
    }

    public static int formatFractionalDigitGroups(String format) {
        int groups2 = 0;
        Pattern p2 = Pattern.compile("(\\+| )?(\\d+)(E|F)?");
        Matcher m = p2.matcher(format);
        if (m.matches()) {
            groups2 = Integer.parseInt(m.group(2));
        }
        return groups2;
    }

    private boolean hasArg(IRubyObject[] args2) {
        return args2.length != 0 && !args2[0].isNil();
    }

    private String format(IRubyObject[] args2) {
        return args2[0].toString();
    }

    private String firstArgument(IRubyObject[] args2) {
        if (this.hasArg(args2)) {
            return this.format(args2);
        }
        return null;
    }

    private boolean posSpace(String arg2) {
        if (null != arg2) {
            return RubyBigDecimal.formatHasLeadingSpace(arg2);
        }
        return false;
    }

    private boolean posSign(String arg2) {
        if (null != arg2) {
            return RubyBigDecimal.formatHasLeadingPlus(arg2) || this.posSpace(arg2);
        }
        return false;
    }

    private boolean asEngineering(String arg2) {
        if (null != arg2) {
            return !RubyBigDecimal.formatHasFloatingPointNotation(arg2);
        }
        return true;
    }

    private int groups(String arg2) {
        if (null != arg2) {
            return RubyBigDecimal.formatFractionalDigitGroups(arg2);
        }
        return 0;
    }

    private boolean isZero() {
        return !this.isNaN() && !this.isInfinity() && this.value.signum() == 0;
    }

    private boolean isNaN() {
        return this.isNaN;
    }

    private boolean isInfinity() {
        return this.infinitySign != 0;
    }

    private String unscaledValue() {
        return this.value.abs().unscaledValue().toString();
    }

    private IRubyObject engineeringValue(String arg2) {
        int exponent2 = this.getExponent();
        int signum = this.value.signum();
        StringBuilder build = new StringBuilder();
        build.append(signum == -1 ? "-" : (signum == 1 ? (this.posSign(arg2) ? (this.posSpace(arg2) ? " " : "+") : "") : ""));
        build.append("0.");
        if (0 == this.groups(arg2)) {
            String s2 = this.removeTrailingZeroes(this.unscaledValue());
            if ("".equals(s2)) {
                build.append("0");
            } else {
                build.append(s2);
            }
        } else {
            String sep = "";
            for (int index2 = 0; index2 < this.unscaledValue().length(); index2 += this.groups(arg2)) {
                int next2 = index2 + this.groups(arg2);
                if (next2 > this.unscaledValue().length()) {
                    next2 = this.unscaledValue().length();
                }
                build.append(sep).append(this.unscaledValue().substring(index2, next2));
                sep = " ";
            }
        }
        build.append("E").append(exponent2);
        return this.getRuntime().newString(build.toString());
    }

    private IRubyObject floatingPointValue(String arg2) {
        String[] values = this.value.abs().stripTrailingZeros().toPlainString().split("\\.");
        String whole = "0";
        if (values.length > 0) {
            whole = values[0];
        }
        String after = "0";
        if (values.length > 1) {
            after = values[1];
        }
        int signum = this.value.signum();
        StringBuilder build = new StringBuilder();
        build.append(signum == -1 ? "-" : (signum == 1 ? (this.posSign(arg2) ? (this.posSpace(arg2) ? " " : "+") : "") : ""));
        if (this.groups(arg2) == 0) {
            build.append(whole);
            if (null != after) {
                build.append(".").append(after);
            }
        } else {
            int next2;
            int index2;
            String sep = "";
            for (index2 = 0; index2 < whole.length(); index2 += this.groups(arg2)) {
                next2 = index2 + this.groups(arg2);
                if (next2 > whole.length()) {
                    next2 = whole.length();
                }
                build.append(sep).append(whole.substring(index2, next2));
                sep = " ";
            }
            if (null != after) {
                build.append(".");
                sep = "";
                for (index2 = 0; index2 < after.length(); index2 += this.groups(arg2)) {
                    next2 = index2 + this.groups(arg2);
                    if (next2 > after.length()) {
                        next2 = after.length();
                    }
                    build.append(sep).append(after.substring(index2, next2));
                    sep = " ";
                }
            }
        }
        return this.getRuntime().newString(build.toString());
    }

    @JRubyMethod(name={"to_s"}, optional=1)
    public IRubyObject to_s(IRubyObject[] args2) {
        String arg2 = this.firstArgument(args2);
        if (this.isNaN()) {
            return this.getRuntime().newString("NaN");
        }
        if (this.infinitySign != 0) {
            if (this.infinitySign == -1) {
                return this.getRuntime().newString("-Infinity");
            }
            return this.getRuntime().newString("Infinity");
        }
        if (this.isZero()) {
            String zero = "0.0";
            if (this.zeroSign < 0) {
                zero = "-" + zero;
            }
            return this.getRuntime().newString(zero);
        }
        if (this.asEngineering(arg2)) {
            return this.engineeringValue(arg2);
        }
        return this.floatingPointValue(arg2);
    }

    @JRubyMethod
    public IRubyObject fix() {
        return this.truncate(RubyFixnum.zero(this.getRuntime()));
    }

    @JRubyMethod
    public IRubyObject truncate() {
        return this.truncate(RubyFixnum.zero(this.getRuntime()));
    }

    @JRubyMethod
    public IRubyObject truncate(IRubyObject arg2) {
        if (this.isNaN) {
            return RubyBigDecimal.newNaN(this.getRuntime());
        }
        if (this.isInfinity()) {
            return RubyBigDecimal.newInfinity(this.getRuntime(), this.infinitySign);
        }
        int n = RubyNumeric.fix2int(arg2);
        int precision = this.value.precision() - this.value.scale() + n;
        if (precision > 0) {
            return new RubyBigDecimal(this.getRuntime(), this.value.round(new MathContext(precision, RoundingMode.DOWN)));
        }
        return new RubyBigDecimal(this.getRuntime(), BigDecimal.ZERO);
    }

    @JRubyMethod(name={"zero?"})
    public IRubyObject zero_p() {
        return this.getRuntime().newBoolean(this.isZero());
    }

    public static BigDecimal bigSqrt(BigDecimal squarD, MathContext rootMC) {
        int biLen;
        int sign2 = squarD.signum();
        if (sign2 == -1) {
            throw new ArithmeticException("Square root of a negative number: " + squarD);
        }
        if (sign2 == 0) {
            return squarD.round(rootMC);
        }
        int prec2 = rootMC.getPrecision();
        if (prec2 == 0) {
            throw new IllegalArgumentException("Most roots won't have infinite precision = 0");
        }
        int BITS = 62;
        int nInit = 16;
        MathContext nMC = new MathContext(18, RoundingMode.HALF_DOWN);
        BigDecimal x = null;
        BigDecimal e = null;
        BigDecimal v = null;
        BigDecimal g = null;
        BigInteger bi = squarD.unscaledValue();
        int shift2 = Math.max(0, biLen - BITS + ((biLen = bi.bitLength()) % 2 == 0 ? 0 : 1));
        bi = bi.shiftRight(shift2);
        double root = Math.sqrt(SafeDoubleParser.doubleValue(bi));
        BigDecimal halfBack = new BigDecimal(BigInteger.ONE.shiftLeft(shift2 / 2));
        int scale = squarD.scale();
        if (scale % 2 == 1) {
            root *= 3.1622776601683795;
        }
        scale = (int)Math.ceil((double)scale / 2.0);
        x = new BigDecimal(root, nMC);
        x = x.multiply(halfBack, nMC);
        if (scale != 0) {
            x = x.movePointLeft(scale);
        }
        if (prec2 < nInit) {
            return x.round(rootMC);
        }
        v = BigDecimal.ONE.divide(TWO.multiply(x), nMC);
        ArrayList<Integer> nPrecs = new ArrayList<Integer>();
        assert (nInit > 3) : "Never ending loop!";
        int m = prec2 + 1;
        while (m > nInit) {
            nPrecs.add(m);
            m = m / 2 + (m > 100 ? 1 : 2);
        }
        for (int i2 = nPrecs.size() - 1; i2 > -1; --i2) {
            nMC = new MathContext((Integer)nPrecs.get(i2), i2 % 2 == 1 ? RoundingMode.HALF_UP : RoundingMode.HALF_DOWN);
            e = squarD.subtract(x.multiply(x, nMC), nMC);
            if (i2 == 0) {
                x = x.add(e.multiply(v, rootMC), rootMC);
                break;
            }
            x = x.add(e.multiply(v, nMC));
            g = BigDecimal.ONE.subtract(TWO.multiply(x).multiply(v, nMC));
            v = v.add(g.multiply(v, nMC));
        }
        return x;
    }

    private void checkFloatDomain() {
        if (this.isNaN) {
            throw this.getRuntime().newFloatDomainError("NaN");
        }
        if (this.infinitySign != 0) {
            if (this.infinitySign == -1) {
                throw this.getRuntime().newFloatDomainError("-Infinity");
            }
            throw this.getRuntime().newFloatDomainError("Infinity");
        }
    }

    public static class BigDecimalKernelMethods {
        @JRubyMethod(name={"BigDecimal"}, rest=true, module=true, visibility=Visibility.PRIVATE)
        public static IRubyObject newBigDecimal(IRubyObject recv2, IRubyObject[] args2) {
            return RubyBigDecimal.newBigDecimal(recv2, args2, Block.NULL_BLOCK);
        }
    }
}

