/*
 * Decompiled with CFR 0.152.
 */
package com.headius.invokebinder.transform;

import com.headius.invokebinder.InvalidTransformException;
import com.headius.invokebinder.transform.Transform;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;

public class Spread
extends Transform {
    private final MethodType source;
    private final Class[] spreadTypes;

    public Spread(MethodType source2, Class ... spreadTypes) {
        this.source = source2;
        this.spreadTypes = spreadTypes;
    }

    @Override
    public MethodHandle up(MethodHandle target) {
        return MethodHandles.spreadInvoker(target.type(), target.type().parameterCount() - this.spreadTypes.length).bindTo(target);
    }

    @Override
    public MethodType down(MethodType type2) {
        int last2 = this.source.parameterCount() - 1;
        if (!this.source.parameterArray()[last2].isArray()) {
            throw new InvalidTransformException("trailing argument is not []: " + this.source);
        }
        type2 = type2.dropParameterTypes(last2, last2 + 1);
        return type2.appendParameterTypes(this.spreadTypes);
    }

    @Override
    public String toString() {
        return "spread " + this.source + " to " + this.down(this.source);
    }
}

