/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyObject;
import org.jruby.anno.JRubyMethod;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class RubyClassPathVariable
extends RubyObject {
    public static void createClassPathVariable(Ruby runtime) {
        RubyClassPathVariable self = new RubyClassPathVariable(runtime);
        runtime.getEnumerable().extend_object(self);
        runtime.defineReadonlyVariable("$CLASSPATH", self);
        self.getMetaClass().defineAnnotatedMethods(RubyClassPathVariable.class);
    }

    private RubyClassPathVariable(Ruby runtime) {
        super(runtime, runtime.getObject());
    }

    @Deprecated
    public IRubyObject append(IRubyObject obj) {
        return this.append(obj.getRuntime().getCurrentContext(), obj);
    }

    @JRubyMethod(name={"append", "<<"}, required=1)
    public IRubyObject append(ThreadContext context, IRubyObject obj) {
        IRubyObject[] paths = obj.respondsTo("to_a") ? ((RubyArray)obj.callMethod(context, "to_a")).toJavaArray() : context.runtime.newArray(obj).toJavaArray();
        for (IRubyObject path2 : paths) {
            String ss = path2.convertToString().toString();
            try {
                URL url = this.getURL(ss);
                this.getRuntime().getJRubyClassLoader().addURL(url);
            }
            catch (MalformedURLException mue) {
                throw this.getRuntime().newArgumentError(mue.getLocalizedMessage());
            }
        }
        return this;
    }

    private URL getURL(String target) throws MalformedURLException {
        try {
            return new URL(target);
        }
        catch (MalformedURLException e) {
            File f = new File(target);
            String path2 = target;
            if (f.exists() && f.isDirectory() && !path2.endsWith("/")) {
                path2 = path2 + "/";
            }
            return new URL("file", null, path2);
        }
    }

    @JRubyMethod(name={"size", "length"})
    public IRubyObject size() {
        return this.getRuntime().newFixnum(this.getRuntime().getJRubyClassLoader().getURLs().length);
    }

    @JRubyMethod
    public IRubyObject each(Block block) {
        URL[] urls = this.getRuntime().getJRubyClassLoader().getURLs();
        ThreadContext ctx = this.getRuntime().getCurrentContext();
        int j = urls.length;
        for (int i2 = 0; i2 < j; ++i2) {
            block.yield(ctx, this.getRuntime().newString(urls[i2].toString()));
        }
        return this.getRuntime().getNil();
    }

    @Override
    @JRubyMethod
    public IRubyObject to_s() {
        return this.callMethod(this.getRuntime().getCurrentContext(), "to_a").callMethod(this.getRuntime().getCurrentContext(), "to_s");
    }

    @Override
    @JRubyMethod(name={"inspect"})
    public IRubyObject inspect() {
        return this.callMethod(this.getRuntime().getCurrentContext(), "to_a").callMethod(this.getRuntime().getCurrentContext(), "inspect");
    }
}

