/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ast;

import java.util.List;
import org.jruby.Ruby;
import org.jruby.RubyFloat;
import org.jruby.ast.Node;
import org.jruby.ast.NodeType;
import org.jruby.ast.types.ILiteralNode;
import org.jruby.ast.visitor.NodeVisitor;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class FloatNode
extends Node
implements ILiteralNode {
    private double value;
    private RubyFloat flote;

    public FloatNode(ISourcePosition position, double value2) {
        super(position);
        this.value = value2;
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.FLOATNODE;
    }

    @Override
    public Object accept(NodeVisitor iVisitor) {
        return iVisitor.visitFloatNode(this);
    }

    public double getValue() {
        return this.value;
    }

    public void setValue(double value2) {
        if (this.flote != null) {
            this.flote = null;
        }
        this.value = value2;
    }

    public RubyFloat getFloat(Ruby runtime) {
        if (this.flote == null) {
            this.flote = RubyFloat.newFloat(runtime, this.value);
            return this.flote;
        }
        return this.flote;
    }

    @Override
    public List<Node> childNodes() {
        return EMPTY_LIST;
    }

    @Override
    public IRubyObject interpret(Ruby runtime, ThreadContext context, IRubyObject self, Block aBlock) {
        return this.getFloat(runtime);
    }
}

