/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.ffi;

import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.ext.ffi.DirectMemoryIO;
import org.jruby.ext.ffi.InvalidMemoryIO;

public class NullMemoryIO
extends InvalidMemoryIO
implements DirectMemoryIO {
    public NullMemoryIO(Ruby runtime) {
        super(runtime, "NULL pointer access");
    }

    @Override
    protected RubyClass getErrorClass(Ruby runtime) {
        return runtime.getModule("FFI").getClass("NullPointerError");
    }

    @Override
    public long getAddress() {
        return 0L;
    }

    @Override
    public boolean isNull() {
        return true;
    }

    @Override
    public final boolean isDirect() {
        return true;
    }

    public boolean equals(Object obj) {
        return obj instanceof DirectMemoryIO && ((DirectMemoryIO)obj).getAddress() == 0L;
    }

    public int hashCode() {
        return 0;
    }
}

