/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.ffi.jffi;

import com.kenai.jffi.PageManager;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jruby.Ruby;
import org.jruby.ext.ffi.DirectMemoryIO;
import org.jruby.ext.ffi.jffi.AllocatedNativeMemoryIO;
import org.jruby.ext.ffi.jffi.BoundedNativeMemoryIO;
import org.jruby.util.WeakReferenceReaper;

final class TransientNativeMemoryIO
extends BoundedNativeMemoryIO
implements DirectMemoryIO {
    private static final Map<Magazine, Boolean> referenceSet = new ConcurrentHashMap<Magazine, Boolean>();
    private static final ThreadLocal<Reference<Magazine>> currentMagazine = new ThreadLocal();
    private static final int PAGES_PER_MAGAZINE = 1;
    private final Object sentinel;

    static DirectMemoryIO allocateAligned(Ruby runtime, int size2, int align, boolean clear2) {
        long address2;
        Object sentinel;
        if (size2 > 1024) {
            return AllocatedNativeMemoryIO.allocateAligned(runtime, size2, align, clear2);
        }
        Reference<Magazine> magazineReference = currentMagazine.get();
        Magazine magazine = magazineReference != null ? magazineReference.get() : null;
        Object object = sentinel = magazine != null ? (Object)magazine.get() : null;
        if (sentinel == null || (address2 = magazine.allocate(size2, align)) == 0L) {
            long memory;
            PageManager pm = PageManager.getInstance();
            int pageCount = 1;
            while ((memory = pm.allocatePages(pageCount, 3)) == 0L || memory == -1L) {
                System.gc();
            }
            sentinel = new Object();
            magazine = new Magazine(sentinel, pm, memory, pageCount);
            referenceSet.put(magazine, Boolean.TRUE);
            currentMagazine.set(new SoftReference<Magazine>(magazine));
            address2 = magazine.allocate(size2, align);
        }
        return new TransientNativeMemoryIO(runtime, sentinel, address2, size2);
    }

    private TransientNativeMemoryIO(Ruby runtime, Object sentinel, long address2, int size2) {
        super(runtime, address2, size2);
        this.sentinel = sentinel;
    }

    private static long align(long offset2, long align) {
        return offset2 + align - 1L & (align - 1L ^ 0xFFFFFFFFFFFFFFFFL);
    }

    private static final class Magazine
    extends WeakReferenceReaper<Object>
    implements Runnable {
        private final PageManager pm;
        private final long page;
        private final long end;
        private final int pageCount;
        private long memory;

        Magazine(Object sentinel, PageManager pm, long page, int pageCount) {
            super(sentinel);
            this.pm = pm;
            this.memory = this.page = page;
            this.pageCount = pageCount;
            this.end = this.memory + pm.pageSize() * (long)pageCount;
        }

        long allocate(int size2, int align) {
            long address2 = TransientNativeMemoryIO.align(this.memory, align);
            if (address2 + (long)size2 <= this.end) {
                this.memory = address2 + (long)size2;
                return address2;
            }
            return 0L;
        }

        @Override
        public final void run() {
            this.pm.freePages(this.page, this.pageCount);
            referenceSet.remove(this);
        }
    }
}

