/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.dataflow.analyses;

import java.util.Collection;
import java.util.HashSet;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.jruby.ir.IRClosure;
import org.jruby.ir.IREvalScript;
import org.jruby.ir.IRScope;
import org.jruby.ir.Operation;
import org.jruby.ir.dataflow.DataFlowProblem;
import org.jruby.ir.dataflow.FlowGraphNode;
import org.jruby.ir.dataflow.analyses.LiveVariablesProblem;
import org.jruby.ir.dataflow.analyses.StoreLocalVarPlacementProblem;
import org.jruby.ir.instructions.BreakInstr;
import org.jruby.ir.instructions.CallBase;
import org.jruby.ir.instructions.Instr;
import org.jruby.ir.instructions.ResultInstr;
import org.jruby.ir.instructions.ReturnInstr;
import org.jruby.ir.instructions.StoreLocalVarInstr;
import org.jruby.ir.operands.ClosureLocalVariable;
import org.jruby.ir.operands.LocalVariable;
import org.jruby.ir.operands.Operand;
import org.jruby.ir.operands.TemporaryVariable;
import org.jruby.ir.operands.Variable;
import org.jruby.ir.operands.WrappedIRClosure;
import org.jruby.ir.representations.BasicBlock;
import org.jruby.ir.util.Edge;

public class StoreLocalVarPlacementNode
extends FlowGraphNode {
    Set<LocalVariable> inDirtyVars;
    Set<LocalVariable> outDirtyVars;

    public StoreLocalVarPlacementNode(DataFlowProblem prob, BasicBlock n) {
        super(prob, n);
    }

    @Override
    public void init() {
        this.outDirtyVars = new HashSet<LocalVariable>();
        if (this.getBB().isRescueEntry()) {
            this.inDirtyVars = new HashSet<LocalVariable>();
        }
    }

    @Override
    public void buildDataFlowVars(Instr i2) {
    }

    @Override
    public void initSolnForNode() {
        if (!this.getBB().isRescueEntry()) {
            this.inDirtyVars = new HashSet<LocalVariable>();
        }
    }

    @Override
    public void compute_MEET(Edge e, BasicBlock source2, FlowGraphNode pred2) {
        StoreLocalVarPlacementNode n = (StoreLocalVarPlacementNode)pred2;
        if (!source2.isRescueEntry()) {
            this.inDirtyVars.addAll(n.outDirtyVars);
        }
    }

    @Override
    public boolean applyTransferFunction() {
        IRScope scope = this.problem.getScope();
        boolean scopeBindingHasEscaped = scope.bindingHasEscaped();
        StoreLocalVarPlacementNode rescueNode = (StoreLocalVarPlacementNode)this.getNonExitBBExceptionTargetNode();
        HashSet<LocalVariable> dirtyVars = new HashSet<LocalVariable>(this.inDirtyVars);
        for (Instr i2 : this.basicBlock.getInstrs()) {
            Variable v;
            if (i2 instanceof CallBase) {
                CallBase call2 = (CallBase)i2;
                Operand o = call2.getClosureArg(null);
                if (o != null && o instanceof WrappedIRClosure) {
                    IRClosure cl = ((WrappedIRClosure)o).getClosure();
                    boolean spillAllVars = scopeBindingHasEscaped || call2.targetRequiresCallersBinding();
                    HashSet<LocalVariable> newDirtyVars = new HashSet<LocalVariable>(dirtyVars);
                    for (LocalVariable v2 : dirtyVars) {
                        if (!spillAllVars && !cl.usesLocalVariable(v2) && !cl.definesLocalVariable(v2)) continue;
                        newDirtyVars.remove(v2);
                    }
                    dirtyVars = newDirtyVars;
                } else if (scopeBindingHasEscaped || call2.targetRequiresCallersBinding()) {
                    dirtyVars.clear();
                } else {
                    HashSet<LocalVariable> newDirtyVars = new HashSet<LocalVariable>(dirtyVars);
                    for (LocalVariable v3 : dirtyVars) {
                        if (!(v3 instanceof ClosureLocalVariable) || ((ClosureLocalVariable)v3).definingScope == scope) continue;
                        newDirtyVars.remove(v3);
                    }
                    dirtyVars = newDirtyVars;
                }
            }
            if (scopeBindingHasEscaped && i2.getOperation() == Operation.PUT_GLOBAL_VAR) {
                dirtyVars.clear();
            }
            if (i2.canRaiseException() && rescueNode != null) {
                dirtyVars.clear();
            }
            if (i2 instanceof ResultInstr && (v = ((ResultInstr)((Object)i2)).getResult()) instanceof LocalVariable && !((LocalVariable)v).isSelf()) {
                dirtyVars.add((LocalVariable)v);
            }
            if (!i2.getOperation().isReturn()) continue;
            dirtyVars.clear();
        }
        if (((Object)this.outDirtyVars).equals(dirtyVars)) {
            return false;
        }
        this.outDirtyVars = dirtyVars;
        return true;
    }

    public String toString() {
        return "";
    }

    private TemporaryVariable getLocalVarReplacement(LocalVariable v, IRScope scope, Map<Operand, Operand> varRenameMap) {
        TemporaryVariable value2 = (TemporaryVariable)varRenameMap.get(v);
        if (value2 == null) {
            value2 = scope.getNewTemporaryVariable("%t_" + v.getName());
            varRenameMap.put(v, value2);
        }
        return value2;
    }

    private boolean addClosureExitStoreLocalVars(IRScope scope, ListIterator<Instr> instrs, Set<LocalVariable> dirtyVars, Map<Operand, Operand> varRenameMap) {
        boolean addedStores = false;
        boolean isEvalScript = scope instanceof IREvalScript;
        for (LocalVariable v : dirtyVars) {
            if (!isEvalScript && v instanceof ClosureLocalVariable && scope == ((ClosureLocalVariable)v).definingScope) continue;
            addedStores = true;
            instrs.add(new StoreLocalVarInstr(this.getLocalVarReplacement(v, scope, varRenameMap), scope, v));
        }
        return addedStores;
    }

    public boolean addStores(Map<Operand, Operand> varRenameMap, Set<LocalVariable> excTargetDirtyVars) {
        boolean amExitBB;
        StoreLocalVarPlacementProblem bsp = (StoreLocalVarPlacementProblem)this.problem;
        IRScope scope = bsp.getScope();
        boolean addedStores = false;
        boolean isClosure = scope instanceof IRClosure;
        boolean isEvalScript = scope instanceof IREvalScript;
        boolean scopeBindingHasEscaped = scope.bindingHasEscaped();
        ListIterator<Instr> instrs = this.basicBlock.getInstrs().listIterator();
        HashSet<LocalVariable> dirtyVars = new HashSet<LocalVariable>(this.inDirtyVars);
        StoreLocalVarPlacementNode rescueNode = (StoreLocalVarPlacementNode)this.getNonExitBBExceptionTargetNode();
        boolean bl = amExitBB = this.basicBlock == scope.cfg().getExitBB();
        if (amExitBB) {
            LiveVariablesProblem lvp = (LiveVariablesProblem)scope.getDataFlowSolution("Live Variables Analysis");
            Collection<LocalVariable> liveVars = lvp.getVarsLiveOnScopeExit();
            if (liveVars != null) {
                dirtyVars.retainAll(liveVars);
            } else {
                dirtyVars.clear();
            }
        }
        while (instrs.hasNext()) {
            Variable v;
            Instr i2 = instrs.next();
            if (i2 instanceof CallBase) {
                CallBase call2 = (CallBase)i2;
                Operand o = call2.getClosureArg(null);
                if (o != null && o instanceof WrappedIRClosure) {
                    IRClosure cl = ((WrappedIRClosure)o).getClosure();
                    instrs.previous();
                    boolean spillAllVars = scopeBindingHasEscaped || call2.targetRequiresCallersBinding();
                    HashSet<LocalVariable> newDirtyVars = new HashSet<LocalVariable>(dirtyVars);
                    for (LocalVariable v2 : dirtyVars) {
                        if (!spillAllVars && !cl.usesLocalVariable(v2) && !cl.definesLocalVariable(v2)) continue;
                        addedStores = true;
                        instrs.add(new StoreLocalVarInstr(this.getLocalVarReplacement(v2, scope, varRenameMap), scope, v2));
                        newDirtyVars.remove(v2);
                    }
                    dirtyVars = newDirtyVars;
                    instrs.next();
                } else if (scopeBindingHasEscaped || call2.targetRequiresCallersBinding()) {
                    instrs.previous();
                    for (LocalVariable v3 : dirtyVars) {
                        addedStores = true;
                        instrs.add(new StoreLocalVarInstr(this.getLocalVarReplacement(v3, scope, varRenameMap), scope, v3));
                    }
                    instrs.next();
                    dirtyVars.clear();
                } else {
                    instrs.previous();
                    HashSet<LocalVariable> newDirtyVars = new HashSet<LocalVariable>(dirtyVars);
                    for (LocalVariable v4 : dirtyVars) {
                        if (!(v4 instanceof ClosureLocalVariable) || ((ClosureLocalVariable)v4).definingScope == scope) continue;
                        addedStores = true;
                        instrs.add(new StoreLocalVarInstr(this.getLocalVarReplacement(v4, scope, varRenameMap), scope, v4));
                        newDirtyVars.remove(v4);
                    }
                    dirtyVars = newDirtyVars;
                    instrs.next();
                }
            } else if (isClosure && i2 instanceof ReturnInstr || i2 instanceof BreakInstr) {
                if (!amExitBB) {
                    LiveVariablesProblem lvp = (LiveVariablesProblem)scope.getDataFlowSolution("Live Variables Analysis");
                    Collection<LocalVariable> liveVars = lvp.getVarsLiveOnScopeExit();
                    if (liveVars != null) {
                        dirtyVars.retainAll(liveVars);
                    } else {
                        dirtyVars.clear();
                    }
                }
                instrs.previous();
                boolean f = this.addClosureExitStoreLocalVars(scope, instrs, dirtyVars, varRenameMap);
                addedStores = addedStores || f;
                instrs.next();
                dirtyVars.clear();
            }
            if (scopeBindingHasEscaped && i2.getOperation() == Operation.PUT_GLOBAL_VAR) {
                instrs.previous();
                for (LocalVariable v5 : dirtyVars) {
                    addedStores = true;
                    instrs.add(new StoreLocalVarInstr(this.getLocalVarReplacement(v5, scope, varRenameMap), scope, v5));
                }
                instrs.next();
                dirtyVars.clear();
            }
            if (i2.canRaiseException()) {
                if (rescueNode != null) {
                    instrs.previous();
                    for (LocalVariable v5 : dirtyVars) {
                        addedStores = true;
                        instrs.add(new StoreLocalVarInstr(this.getLocalVarReplacement(v5, scope, varRenameMap), scope, v5));
                    }
                    instrs.next();
                    dirtyVars.clear();
                } else if (excTargetDirtyVars != null) {
                    excTargetDirtyVars.addAll(dirtyVars);
                }
            }
            if (!(i2 instanceof ResultInstr) || !((v = ((ResultInstr)((Object)i2)).getResult()) instanceof LocalVariable) || ((LocalVariable)v).isSelf()) continue;
            LocalVariable lv = (LocalVariable)v;
            dirtyVars.add(lv);
            this.getLocalVarReplacement(lv, scope, varRenameMap);
        }
        if (amExitBB) {
            if (instrs.hasPrevious()) {
                instrs.previous();
            }
            boolean f = this.addClosureExitStoreLocalVars(scope, instrs, dirtyVars, varRenameMap);
            addedStores = addedStores || f;
        }
        return addedStores;
    }
}

