/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.operands;

import java.util.List;
import java.util.Map;
import org.jruby.ir.IRVisitor;
import org.jruby.ir.operands.CompoundString;
import org.jruby.ir.operands.Operand;
import org.jruby.ir.operands.Variable;
import org.jruby.ir.transformations.inlining.InlinerInfo;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class DynamicSymbol
extends Operand {
    private final CompoundString symbolName;

    public DynamicSymbol(CompoundString n) {
        this.symbolName = n;
    }

    public String toString() {
        return ":" + this.symbolName.toString();
    }

    @Override
    public Operand getSimplifiedOperand(Map<Operand, Operand> valueMap, boolean force) {
        CompoundString newSymbol = (CompoundString)this.symbolName.getSimplifiedOperand(valueMap, force);
        return this.symbolName == newSymbol ? this : new DynamicSymbol(newSymbol);
    }

    @Override
    public void addUsedVariables(List<Variable> l) {
        this.symbolName.addUsedVariables(l);
    }

    @Override
    public Operand cloneForInlining(InlinerInfo ii) {
        return this.symbolName.cloneForInlining(ii);
    }

    @Override
    public Object retrieve(ThreadContext context, IRubyObject self, DynamicScope currDynScope, Object[] temp) {
        return context.runtime.newSymbol(((IRubyObject)this.symbolName.retrieve(context, self, currDynScope, temp)).asJavaString());
    }

    @Override
    public void visit(IRVisitor visitor) {
        visitor.DynamicSymbol(this);
    }
}

