/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.operands;

import org.jruby.ir.IRVisitor;
import org.jruby.ir.operands.Variable;
import org.jruby.ir.transformations.inlining.InlinerInfo;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class LocalVariable
extends Variable {
    protected String name;
    protected int scopeDepth;
    protected int offset;

    public LocalVariable(String name2, int scopeDepth, int location) {
        this.name = name2;
        this.scopeDepth = scopeDepth;
        this.offset = location;
    }

    public int getScopeDepth() {
        return this.scopeDepth;
    }

    public int getLocation() {
        return this.offset;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.isSelf() ? this.name : this.name + "(" + this.scopeDepth + ":" + this.offset + ")";
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof LocalVariable)) {
            return false;
        }
        return this.name.equals(((LocalVariable)obj).name);
    }

    public int compareTo(Object arg0) {
        if (!(arg0 instanceof LocalVariable)) {
            return 0;
        }
        return this.name.compareTo(((LocalVariable)arg0).name);
    }

    public boolean isSelf() {
        return false;
    }

    @Override
    public Object retrieve(ThreadContext context, IRubyObject self, DynamicScope currDynScope, Object[] temp) {
        IRubyObject value2 = currDynScope.getValue(this.offset, this.scopeDepth);
        if (value2 == null) {
            value2 = context.nil;
        }
        return value2;
    }

    @Override
    public Variable cloneForCloningClosure(InlinerInfo ii) {
        return new LocalVariable(this.name, this.scopeDepth, this.offset);
    }

    public LocalVariable cloneForDepth(int n) {
        return new LocalVariable(this.name, n, this.offset);
    }

    @Override
    public void visit(IRVisitor visitor) {
        visitor.LocalVariable(this);
    }
}

