/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.representations;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.jruby.ir.IRClosure;
import org.jruby.ir.IRScope;
import org.jruby.ir.Operation;
import org.jruby.ir.instructions.BranchInstr;
import org.jruby.ir.instructions.CallBase;
import org.jruby.ir.instructions.ExceptionRegionEndMarkerInstr;
import org.jruby.ir.instructions.ExceptionRegionStartMarkerInstr;
import org.jruby.ir.instructions.Instr;
import org.jruby.ir.instructions.JumpIndirectInstr;
import org.jruby.ir.instructions.JumpInstr;
import org.jruby.ir.instructions.LabelInstr;
import org.jruby.ir.instructions.SetReturnAddressInstr;
import org.jruby.ir.instructions.ThrowExceptionInstr;
import org.jruby.ir.operands.Label;
import org.jruby.ir.operands.Operand;
import org.jruby.ir.operands.Variable;
import org.jruby.ir.operands.WrappedIRClosure;
import org.jruby.ir.representations.BasicBlock;
import org.jruby.ir.representations.ExceptionRegion;
import org.jruby.ir.transformations.inlining.InlinerInfo;
import org.jruby.ir.util.DirectedGraph;
import org.jruby.ir.util.Edge;
import org.jruby.util.log.Logger;
import org.jruby.util.log.LoggerFactory;

public class CFG {
    private static final Logger LOG = LoggerFactory.getLogger("CFG");
    private IRScope scope;
    private Map<Label, BasicBlock> bbMap;
    private Map<BasicBlock, BasicBlock> rescuerMap;
    private Map<BasicBlock, BasicBlock> ensurerMap;
    private List<ExceptionRegion> outermostERs;
    private BasicBlock entryBB;
    private BasicBlock exitBB;
    private BasicBlock globalEnsureBB;
    private DirectedGraph<BasicBlock> graph;
    private int nextBBId;
    LinkedList<BasicBlock> postOrderList;

    public CFG(IRScope scope) {
        this.scope = scope;
        this.graph = new DirectedGraph();
        this.bbMap = new HashMap<Label, BasicBlock>();
        this.rescuerMap = new HashMap<BasicBlock, BasicBlock>();
        this.ensurerMap = new HashMap<BasicBlock, BasicBlock>();
        this.outermostERs = new ArrayList<ExceptionRegion>();
        this.nextBBId = 0;
        this.exitBB = null;
        this.entryBB = null;
        this.globalEnsureBB = null;
        this.postOrderList = null;
    }

    public int getNextBBID() {
        ++this.nextBBId;
        return this.nextBBId;
    }

    public int getMaxNodeID() {
        return this.nextBBId;
    }

    public boolean bbIsProtected(BasicBlock b) {
        return this.getRescuerBBFor(b) != null;
    }

    public BasicBlock getBBForLabel(Label label) {
        return this.bbMap.get(label);
    }

    public BasicBlock getEnsurerBBFor(BasicBlock block) {
        return this.ensurerMap.get(block);
    }

    public BasicBlock getEntryBB() {
        return this.entryBB;
    }

    public BasicBlock getExitBB() {
        return this.exitBB;
    }

    public BasicBlock getGlobalEnsureBB() {
        return this.globalEnsureBB;
    }

    public List<ExceptionRegion> getOutermostExceptionRegions() {
        return this.outermostERs;
    }

    public LinkedList<BasicBlock> postOrderList() {
        if (this.postOrderList == null) {
            this.postOrderList = this.buildPostOrderList();
        }
        return this.postOrderList;
    }

    public ListIterator<BasicBlock> getPostOrderTraverser() {
        return this.postOrderList().listIterator();
    }

    public ListIterator<BasicBlock> getReversePostOrderTraverser() {
        return this.postOrderList().listIterator(this.size());
    }

    public void resetState() {
        this.postOrderList = null;
    }

    public IRScope getScope() {
        return this.scope;
    }

    public int size() {
        return this.graph.size();
    }

    public Collection<BasicBlock> getBasicBlocks() {
        return this.graph.allData();
    }

    public Collection<BasicBlock> getSortedBasicBlocks() {
        return this.graph.getInorderData();
    }

    public void addEdge(BasicBlock source2, BasicBlock destination, Object type2) {
        this.graph.vertexFor(source2).addEdgeTo(destination, type2);
    }

    public int inDegree(BasicBlock b) {
        return this.graph.findVertexFor(b).inDegree();
    }

    public int outDegree(BasicBlock b) {
        return this.graph.findVertexFor(b).outDegree();
    }

    public Iterable<BasicBlock> getIncomingSources(BasicBlock block) {
        return this.graph.findVertexFor(block).getIncomingSourcesData();
    }

    public Iterable<Edge<BasicBlock>> getIncomingEdges(BasicBlock block) {
        return this.graph.findVertexFor(block).getIncomingEdges();
    }

    public BasicBlock getIncomingSource(BasicBlock block) {
        return this.graph.findVertexFor(block).getIncomingSourceData();
    }

    public BasicBlock getIncomingSourceOfType(BasicBlock block, Object type2) {
        return this.graph.findVertexFor(block).getIncomingSourceDataOfType(type2);
    }

    public Edge<BasicBlock> getIncomingEdgeOfType(BasicBlock block, Object type2) {
        return this.graph.findVertexFor(block).getIncomingEdgeOfType(type2);
    }

    public Edge<BasicBlock> getOutgoingEdgeOfType(BasicBlock block, Object type2) {
        return this.graph.findVertexFor(block).getOutgoingEdgeOfType(type2);
    }

    public BasicBlock getOutgoingDestination(BasicBlock block) {
        return this.graph.findVertexFor(block).getOutgoingDestinationData();
    }

    public BasicBlock getOutgoingDestinationOfType(BasicBlock block, Object type2) {
        return this.graph.findVertexFor(block).getOutgoingDestinationDataOfType(type2);
    }

    public Iterable<BasicBlock> getOutgoingDestinations(BasicBlock block) {
        return this.graph.findVertexFor(block).getOutgoingDestinationsData();
    }

    public Iterable<BasicBlock> getOutgoingDestinationsOfType(BasicBlock block, Object type2) {
        return this.graph.findVertexFor(block).getOutgoingDestinationsDataOfType(type2);
    }

    public Iterable<BasicBlock> getOutgoingDestinationsNotOfType(BasicBlock block, Object type2) {
        return this.graph.findVertexFor(block).getOutgoingDestinationsDataNotOfType(type2);
    }

    public Set<Edge<BasicBlock>> getOutgoingEdges(BasicBlock block) {
        return this.graph.findVertexFor(block).getOutgoingEdges();
    }

    public Iterable<Edge<BasicBlock>> getOutgoingEdgesNotOfType(BasicBlock block, Object type2) {
        return this.graph.findVertexFor(block).getOutgoingEdgesNotOfType(type2);
    }

    public BasicBlock getRescuerBBFor(BasicBlock block) {
        return this.rescuerMap.get(block);
    }

    public void addGlobalEnsureBB(BasicBlock geb) {
        assert (this.globalEnsureBB == null) : "CFG for scope " + this.getScope() + " already has a global ensure block.";
        this.globalEnsureBB = geb;
        this.addEdge(geb, this.getExitBB(), (Object)EdgeType.EXIT);
        for (BasicBlock basicBlock : this.getBasicBlocks()) {
            if (basicBlock == geb || this.bbIsProtected(basicBlock)) continue;
            this.addEdge(basicBlock, geb, (Object)EdgeType.EXCEPTION);
            this.setRescuerBB(basicBlock, geb);
            this.setEnsurerBB(basicBlock, geb);
        }
    }

    public void setEnsurerBB(BasicBlock block, BasicBlock ensureBlock) {
        this.ensurerMap.put(block, ensureBlock);
    }

    public void setRescuerBB(BasicBlock block, BasicBlock exceptionBlock) {
        this.rescuerMap.put(block, exceptionBlock);
    }

    public DirectedGraph<BasicBlock> build(List<Instr> instrs) {
        BasicBlock firstBB;
        HashMap<Label, List<BasicBlock>> forwardRefs = new HashMap<Label, List<BasicBlock>>();
        HashMap<Variable, HashSet<Label>> retAddrMap = new HashMap<Variable, HashSet<Label>>();
        HashMap<Variable, BasicBlock> retAddrTargetMap = new HashMap<Variable, BasicBlock>();
        ArrayList<BasicBlock> returnBBs = new ArrayList<BasicBlock>();
        ArrayList<BasicBlock> exceptionBBs = new ArrayList<BasicBlock>();
        Stack<ExceptionRegion> nestedExceptionRegions = new Stack<ExceptionRegion>();
        ArrayList<ExceptionRegion> allExceptionRegions = new ArrayList<ExceptionRegion>();
        this.entryBB = this.createBB(nestedExceptionRegions);
        BasicBlock currBB = firstBB = this.createBB(nestedExceptionRegions);
        boolean bbEnded = false;
        boolean nextBBIsFallThrough = true;
        for (Instr i2 : instrs) {
            Operand closureArg;
            BasicBlock newBB;
            Operation iop = i2.getOperation();
            if (iop == Operation.LABEL) {
                Label l = ((LabelInstr)i2).label;
                newBB = this.createBB(l, nestedExceptionRegions);
                if (nextBBIsFallThrough) {
                    this.graph.addEdge(currBB, newBB, (Object)EdgeType.FALL_THROUGH);
                }
                currBB = newBB;
                bbEnded = false;
                nextBBIsFallThrough = true;
                List frefs = (List)forwardRefs.get(l);
                if (frefs != null) {
                    for (BasicBlock b : frefs) {
                        this.graph.addEdge(b, newBB, (Object)EdgeType.REGULAR);
                    }
                }
            } else if (bbEnded && iop != Operation.EXC_REGION_END) {
                newBB = this.createBB(nestedExceptionRegions);
                if (nextBBIsFallThrough) {
                    this.graph.addEdge(currBB, newBB, (Object)EdgeType.FALL_THROUGH);
                }
                currBB = newBB;
                bbEnded = false;
                nextBBIsFallThrough = true;
            }
            if (i2 instanceof ExceptionRegionStartMarkerInstr) {
                ExceptionRegionStartMarkerInstr ersmi = (ExceptionRegionStartMarkerInstr)i2;
                ExceptionRegion rr = new ExceptionRegion(ersmi.firstRescueBlockLabel, ersmi.ensureBlockLabel);
                rr.addBB(currBB);
                allExceptionRegions.add(rr);
                if (nestedExceptionRegions.empty()) {
                    this.outermostERs.add(rr);
                } else {
                    nestedExceptionRegions.peek().addNestedRegion(rr);
                }
                nestedExceptionRegions.push(rr);
            } else if (i2 instanceof ExceptionRegionEndMarkerInstr) {
                nestedExceptionRegions.pop().setEndBB(currBB);
            } else if (iop.endsBasicBlock()) {
                Label tgt;
                bbEnded = true;
                currBB.addInstr(i2);
                nextBBIsFallThrough = false;
                if (i2 instanceof BranchInstr) {
                    tgt = ((BranchInstr)i2).getJumpTarget();
                    nextBBIsFallThrough = true;
                } else if (i2 instanceof JumpInstr) {
                    tgt = ((JumpInstr)i2).getJumpTarget();
                } else if (iop.isReturn()) {
                    tgt = null;
                    returnBBs.add(currBB);
                } else if (i2 instanceof ThrowExceptionInstr) {
                    tgt = null;
                    exceptionBBs.add(currBB);
                } else if (i2 instanceof JumpIndirectInstr) {
                    tgt = null;
                    Set retAddrs = (Set)retAddrMap.get(((JumpIndirectInstr)i2).getJumpTarget());
                    for (Label l : retAddrs) {
                        this.addEdge(currBB, l, forwardRefs);
                    }
                    retAddrTargetMap.put(((JumpIndirectInstr)i2).getJumpTarget(), currBB);
                } else {
                    throw new RuntimeException("Unhandled case in CFG builder for basic block ending instr: " + i2);
                }
                if (tgt != null) {
                    this.addEdge(currBB, tgt, forwardRefs);
                }
            } else if (iop != Operation.LABEL) {
                currBB.addInstr(i2);
            }
            if (i2 instanceof SetReturnAddressInstr) {
                Variable v = ((SetReturnAddressInstr)i2).getResult();
                Label tgtLbl = ((SetReturnAddressInstr)i2).getReturnAddr();
                BasicBlock tgtBB = (BasicBlock)retAddrTargetMap.get(v);
                if (tgtBB != null) {
                    this.addEdge(tgtBB, tgtLbl, forwardRefs);
                    continue;
                }
                HashSet<Label> addrs = (HashSet<Label>)retAddrMap.get(v);
                if (addrs == null) {
                    addrs = new HashSet<Label>();
                    retAddrMap.put(v, addrs);
                }
                addrs.add(tgtLbl);
                continue;
            }
            if (!(i2 instanceof CallBase) || !((closureArg = ((CallBase)i2).getClosureArg(this.getScope().getManager().getNil())) instanceof WrappedIRClosure)) continue;
            ((WrappedIRClosure)closureArg).getClosure().buildCFG();
        }
        for (ExceptionRegion rr : allExceptionRegions) {
            BasicBlock firstRescueBB = this.bbMap.get(rr.getFirstRescueBlockLabel());
            firstRescueBB.markRescueEntryBB();
            rr.setFirstRescueBB(firstRescueBB);
            BasicBlock ensureBlockBB = rr.getEnsureBlockLabel() == null ? null : this.bbMap.get(rr.getEnsureBlockLabel());
            for (BasicBlock b : rr.getExclusiveBBs()) {
                this.rescuerMap.put(b, firstRescueBB);
                this.graph.addEdge(b, firstRescueBB, (Object)EdgeType.EXCEPTION);
                if (ensureBlockBB == null) continue;
                this.ensurerMap.put(b, ensureBlockBB);
                if (ensureBlockBB == firstRescueBB) continue;
                this.graph.addEdge(b, ensureBlockBB, (Object)EdgeType.EXCEPTION);
            }
        }
        this.buildExitBasicBlock(nestedExceptionRegions, firstBB, returnBBs, exceptionBBs, nextBBIsFallThrough, currBB, this.entryBB);
        this.optimize();
        return this.graph;
    }

    private void addEdge(BasicBlock src, Label targetLabel, Map<Label, List<BasicBlock>> forwardRefs) {
        BasicBlock target = this.bbMap.get(targetLabel);
        if (target != null) {
            this.graph.addEdge(src, target, (Object)EdgeType.REGULAR);
            return;
        }
        List<BasicBlock> forwardReferences = forwardRefs.get(targetLabel);
        if (forwardReferences == null) {
            forwardReferences = new ArrayList<BasicBlock>();
            forwardRefs.put(targetLabel, forwardReferences);
        }
        forwardReferences.add(src);
    }

    private BasicBlock buildExitBasicBlock(Stack<ExceptionRegion> nestedExceptionRegions, BasicBlock firstBB, List<BasicBlock> returnBBs, List<BasicBlock> exceptionBBs, boolean nextIsFallThrough, BasicBlock currBB, BasicBlock entryBB) {
        this.exitBB = this.createBB(nestedExceptionRegions);
        this.graph.addEdge(entryBB, this.exitBB, (Object)EdgeType.EXIT);
        this.graph.addEdge(entryBB, firstBB, (Object)EdgeType.FALL_THROUGH);
        for (BasicBlock rb : returnBBs) {
            this.graph.addEdge(rb, this.exitBB, (Object)EdgeType.EXIT);
        }
        for (BasicBlock rb : exceptionBBs) {
            this.graph.addEdge(rb, this.exitBB, (Object)EdgeType.EXIT);
        }
        if (nextIsFallThrough) {
            this.graph.addEdge(currBB, this.exitBB, (Object)EdgeType.EXIT);
        }
        return this.exitBB;
    }

    private BasicBlock createBB(Label label, Stack<ExceptionRegion> nestedExceptionRegions) {
        BasicBlock basicBlock = new BasicBlock(this, label);
        this.addBasicBlock(basicBlock);
        if (!nestedExceptionRegions.empty()) {
            nestedExceptionRegions.peek().addBB(basicBlock);
        }
        return basicBlock;
    }

    private BasicBlock createBB(Stack<ExceptionRegion> nestedExceptionRegions) {
        return this.createBB(this.scope.getNewLabel(), nestedExceptionRegions);
    }

    public void addBasicBlock(BasicBlock bb) {
        this.graph.vertexFor(bb);
        this.bbMap.put(bb.getLabel(), bb);
    }

    public void removeEdge(Edge edge) {
        this.graph.removeEdge(edge);
    }

    public void removeAllOutgoingEdgesForBB(BasicBlock b) {
        this.graph.findVertexFor(b).removeAllOutgoingEdges();
    }

    private void deleteOrphanedBlocks(DirectedGraph<BasicBlock> graph) {
        while (true) {
            BasicBlock bbToRemove = null;
            for (BasicBlock b : graph.allData()) {
                if (b == this.entryBB || !graph.findVertexFor(b).getIncomingEdges().isEmpty()) continue;
                bbToRemove = b;
                break;
            }
            if (bbToRemove == null) break;
            this.removeBB(bbToRemove);
        }
    }

    private boolean mergeBBs(BasicBlock a, BasicBlock b) {
        BasicBlock bR;
        BasicBlock aR = this.getRescuerBBFor(a);
        if (aR == (bR = this.getRescuerBBFor(b)) || a.isEmpty() || b.isEmpty()) {
            Instr lastInstr = a.getLastInstr();
            if (lastInstr instanceof JumpInstr) {
                a.removeInstr(lastInstr);
            }
            a.swallowBB(b);
            this.removeEdge(a, b);
            for (Edge<BasicBlock> e : this.getOutgoingEdges(b)) {
                this.addEdge(a, e.getDestination().getData(), e.getType());
            }
            this.removeBB(b);
            if (aR == null && bR != null) {
                this.setRescuerBB(a, bR);
                BasicBlock aE = this.getEnsurerBBFor(a);
                BasicBlock bE = this.getEnsurerBBFor(b);
                if (aE == null && bE != null) {
                    this.setRescuerBB(a, bE);
                }
            }
            return true;
        }
        return false;
    }

    public void removeBB(BasicBlock b) {
        this.graph.removeVertexFor(b);
        this.bbMap.remove(b.getLabel());
        this.rescuerMap.remove(b);
        this.ensurerMap.remove(b);
    }

    public void collapseStraightLineBBs() {
        ArrayList<BasicBlock> cfgBBs = new ArrayList<BasicBlock>();
        for (BasicBlock b : this.getBasicBlocks()) {
            cfgBBs.add(b);
        }
        HashSet<BasicBlock> mergedBBs = new HashSet<BasicBlock>();
        for (BasicBlock b : cfgBBs) {
            if (mergedBBs.contains(b) || this.outDegree(b) != 1) continue;
            for (Edge<BasicBlock> e : this.getOutgoingEdges(b)) {
                BasicBlock outB = e.getDestination().getData();
                if (e.getType() == EdgeType.EXCEPTION || this.inDegree(outB) != 1 || !this.mergeBBs(b, outB)) continue;
                mergedBBs.add(outB);
            }
        }
    }

    private void optimize() {
        ArrayList<Edge> toRemove = new ArrayList<Edge>();
        for (BasicBlock b : this.graph.allData()) {
            boolean noExceptions = true;
            for (Instr instr : b.getInstrs()) {
                if (!instr.canRaiseException()) continue;
                noExceptions = false;
                break;
            }
            if (!noExceptions) continue;
            for (Edge edge : this.graph.findVertexFor(b).getOutgoingEdgesOfType((Object)EdgeType.EXCEPTION)) {
                BasicBlock source2 = (BasicBlock)edge.getSource().getData();
                BasicBlock destination = (BasicBlock)edge.getDestination().getData();
                toRemove.add(edge);
                if (this.rescuerMap.get(source2) == destination) {
                    this.rescuerMap.remove(source2);
                }
                if (this.ensurerMap.get(source2) != destination) continue;
                this.ensurerMap.remove(source2);
            }
        }
        if (!toRemove.isEmpty()) {
            for (Edge edge : toRemove) {
                this.graph.removeEdge(edge);
            }
        }
        this.deleteOrphanedBlocks(this.graph);
        this.collapseStraightLineBBs();
    }

    public String toStringGraph() {
        return this.graph.toString();
    }

    public String toStringInstrs() {
        StringBuilder buf = new StringBuilder();
        for (BasicBlock b : this.getSortedBasicBlocks()) {
            buf.append(b.toStringInstrs());
        }
        buf.append("\n\n------ Rescue block map ------\n");
        for (BasicBlock bb : this.rescuerMap.keySet()) {
            buf.append("BB ").append(bb.getID()).append(" --> BB ").append(this.rescuerMap.get(bb).getID()).append("\n");
        }
        buf.append("\n\n------ Ensure block map ------\n");
        for (BasicBlock bb : this.ensurerMap.keySet()) {
            buf.append("BB ").append(bb.getID()).append(" --> BB ").append(this.ensurerMap.get(bb).getID()).append("\n");
        }
        List<IRClosure> closures = this.scope.getClosures();
        if (!closures.isEmpty()) {
            buf.append("\n\n------ Closures encountered in this scope ------\n");
            for (IRClosure c : closures) {
                buf.append(c.toStringBody());
            }
            buf.append("------------------------------------------------\n");
        }
        return buf.toString();
    }

    public void removeEdge(BasicBlock a, BasicBlock b) {
        this.graph.removeEdge(a, b);
    }

    private LinkedList<BasicBlock> buildPostOrderList() {
        BasicBlock root = this.getEntryBB();
        LinkedList<BasicBlock> list2 = new LinkedList<BasicBlock>();
        Stack<BasicBlock> stack = new Stack<BasicBlock>();
        BitSet visited = new BitSet(1 + this.getMaxNodeID());
        stack.push(root);
        visited.set(root.getID());
        while (!stack.empty()) {
            BasicBlock b = (BasicBlock)stack.peek();
            boolean allChildrenVisited = true;
            for (BasicBlock dst : this.getOutgoingDestinations(b)) {
                int dstID = dst.getID();
                if (visited.get(dstID)) continue;
                allChildrenVisited = false;
                if (this.graph.findVertexFor(dst).outDegree() == 0) {
                    list2.add(dst);
                } else {
                    stack.push(dst);
                }
                visited.set(dstID);
            }
            if (!allChildrenVisited) continue;
            stack.pop();
            list2.add(b);
        }
        for (BasicBlock b : this.getBasicBlocks()) {
            if (visited.get(b.getID())) continue;
            this.printError("BB " + b.getID() + " missing from po list!");
            break;
        }
        return list2;
    }

    public CFG cloneForCloningClosure(IRScope scope, InlinerInfo ii) {
        HashMap<BasicBlock, BasicBlock> cloneBBMap = new HashMap<BasicBlock, BasicBlock>();
        CFG clone = new CFG(scope);
        for (BasicBlock b : this.getBasicBlocks()) {
            BasicBlock bCloned = new BasicBlock(clone, b.getLabel().clone());
            for (Instr instr : b.getInstrs()) {
                Instr clonedInstr = instr.cloneForBlockCloning(ii);
                if (clonedInstr == null) continue;
                bCloned.addInstr(clonedInstr);
            }
            clone.addBasicBlock(bCloned);
            cloneBBMap.put(b, bCloned);
        }
        for (BasicBlock x : this.getBasicBlocks()) {
            BasicBlock rx = (BasicBlock)cloneBBMap.get(x);
            for (Edge edge : this.getOutgoingEdges(x)) {
                BasicBlock b = (BasicBlock)edge.getDestination().getData();
                clone.addEdge(rx, (BasicBlock)cloneBBMap.get(b), edge.getType());
            }
        }
        clone.entryBB = (BasicBlock)cloneBBMap.get(this.entryBB);
        clone.exitBB = (BasicBlock)cloneBBMap.get(this.exitBB);
        clone.outermostERs = null;
        for (BasicBlock b : this.rescuerMap.keySet()) {
            clone.rescuerMap.put((BasicBlock)cloneBBMap.get(b), (BasicBlock)cloneBBMap.get(this.rescuerMap.get(b)));
        }
        for (BasicBlock b : this.ensurerMap.keySet()) {
            clone.ensurerMap.put((BasicBlock)cloneBBMap.get(b), (BasicBlock)cloneBBMap.get(this.ensurerMap.get(b)));
        }
        return clone;
    }

    private void printError(String message2) {
        LOG.error(message2 + "\nGraph:\n" + this + "\nInstructions:\n" + this.toStringInstrs(), new Object[0]);
    }

    public static enum EdgeType {
        REGULAR,
        EXCEPTION,
        FALL_THROUGH,
        EXIT;

    }
}

