/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.instructions;

import java.util.Map;
import org.jruby.RubyModule;
import org.jruby.internal.runtime.methods.InterpretedIRMethod;
import org.jruby.ir.IRVisitor;
import org.jruby.ir.Operation;
import org.jruby.ir.instructions.Instr;
import org.jruby.ir.instructions.ResultInstr;
import org.jruby.ir.operands.Operand;
import org.jruby.ir.operands.Variable;
import org.jruby.ir.transformations.inlining.InlinerInfo;
import org.jruby.runtime.Block;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class ProcessModuleBodyInstr
extends Instr
implements ResultInstr {
    private Operand moduleBody;
    private Variable result;

    public ProcessModuleBodyInstr(Variable result2, Operand moduleBody) {
        super(Operation.PROCESS_MODULE_BODY);
        assert (result2 != null) : "ProcessModuleBodyInstr result is null";
        this.result = result2;
        this.moduleBody = moduleBody;
    }

    @Override
    public Operand[] getOperands() {
        return new Operand[]{this.moduleBody};
    }

    @Override
    public Variable getResult() {
        return this.result;
    }

    @Override
    public void updateResult(Variable v) {
        this.result = v;
    }

    @Override
    public void simplifyOperands(Map<Operand, Operand> valueMap, boolean force) {
        this.moduleBody = this.moduleBody.getSimplifiedOperand(valueMap, force);
    }

    @Override
    public String toString() {
        return super.toString() + "(" + this.moduleBody + ")";
    }

    @Override
    public Instr cloneForInlining(InlinerInfo ii) {
        return new ProcessModuleBodyInstr(ii.getRenamedVariable(this.result), this.moduleBody.cloneForInlining(ii));
    }

    @Override
    public Object interpret(ThreadContext context, DynamicScope currDynScope, IRubyObject self2, Object[] temp, Block block) {
        InterpretedIRMethod bodyMethod = (InterpretedIRMethod)this.moduleBody.retrieve(context, self2, currDynScope, temp);
        RubyModule implClass = bodyMethod.getImplementationClass();
        return bodyMethod.call(context, (IRubyObject)implClass, implClass, "", new IRubyObject[0], block);
    }

    @Override
    public void visit(IRVisitor visitor) {
        visitor.ProcessModuleBodyInstr(this);
    }

    public Operand getModuleBody() {
        return this.moduleBody;
    }
}

