/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.stringio;

import java.util.Arrays;
import org.jcodings.Encoding;
import org.jruby.CompatVersion;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyEnumerator;
import org.jruby.RubyFixnum;
import org.jruby.RubyIO;
import org.jruby.RubyKernel;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.anno.FrameField;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.java.addons.IOJavaAddons;
import org.jruby.runtime.Block;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.encoding.EncodingCapable;
import org.jruby.util.ByteList;
import org.jruby.util.StringSupport;
import org.jruby.util.TypeConverter;
import org.jruby.util.io.ModeFlags;
import org.jruby.util.io.Stream;

@JRubyClass(name={"StringIO"})
public class RubyStringIO
extends RubyObject
implements EncodingCapable {
    StringIOData ptr = new StringIOData();
    private static ObjectAllocator STRINGIO_ALLOCATOR = new ObjectAllocator(){

        @Override
        public IRubyObject allocate(Ruby runtime, RubyClass klass) {
            return new RubyStringIO(runtime, klass);
        }
    };
    public static final ByteList NEWLINE = ByteList.create("\n");

    public static RubyClass createStringIOClass(Ruby runtime) {
        RubyClass stringIOClass = runtime.defineClass("StringIO", runtime.getClass("Data"), STRINGIO_ALLOCATOR);
        stringIOClass.defineAnnotatedMethods(RubyStringIO.class);
        stringIOClass.includeModule(runtime.getEnumerable());
        if (runtime.getObject().isConstantDefined("Java")) {
            stringIOClass.defineAnnotatedMethods(IOJavaAddons.AnyIO.class);
        }
        return stringIOClass;
    }

    @Override
    public Encoding getEncoding() {
        return this.ptr.string.getEncoding();
    }

    @Override
    public void setEncoding(Encoding e) {
        this.ptr.string.setEncoding(e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(meta=true, rest=true)
    public static IRubyObject open(ThreadContext context, IRubyObject recv2, IRubyObject[] args2, Block block) {
        RubyStringIO strio;
        IRubyObject val = strio = (RubyStringIO)((RubyClass)recv2).newInstance(context, args2, Block.NULL_BLOCK);
        if (block.isGiven()) {
            try {
                val = block.yield(context, strio);
            }
            finally {
                strio.doFinalize();
            }
        }
        return val;
    }

    protected RubyStringIO(Ruby runtime, RubyClass klass) {
        super(runtime, klass);
    }

    private ModeFlags initializeModes(Object modeArgument) {
        Ruby runtime = this.getRuntime();
        if (modeArgument == null) {
            return RubyIO.newModeFlags(runtime, "r+");
        }
        if (modeArgument instanceof Long) {
            return RubyIO.newModeFlags(runtime, (Long)modeArgument);
        }
        return RubyIO.newModeFlags(runtime, (String)modeArgument);
    }

    @JRubyMethod(optional=2, visibility=Visibility.PRIVATE)
    public IRubyObject initialize(IRubyObject[] args2, Block unusedBlock) {
        ModeFlags flags;
        RubyString str;
        Ruby runtime = this.getRuntime();
        switch (args2.length) {
            case 0: {
                str = RubyString.newEmptyString(runtime);
                flags = this.initializeModes("r+");
                break;
            }
            case 1: {
                str = args2[0].convertToString();
                flags = this.initializeModes(str.isFrozen() ? "r" : "r+");
                break;
            }
            case 2: {
                str = args2[0].convertToString();
                Object modeArgument = args2[1] instanceof RubyFixnum ? Long.valueOf(RubyFixnum.fix2long(args2[1])) : args2[1].convertToString().toString();
                flags = this.initializeModes(modeArgument);
                if (!flags.isWritable() || !str.isFrozen()) break;
                throw runtime.newErrnoEACCESError("Permission denied");
            }
            default: {
                throw runtime.newArgumentError(args2.length, 2);
            }
        }
        this.ptr.string = str;
        this.ptr.modes = flags;
        this.setupModes();
        if (this.ptr.modes.isTruncate()) {
            this.ptr.string.modifyCheck();
            this.ptr.string.empty();
        }
        return this;
    }

    @Override
    @JRubyMethod(visibility=Visibility.PRIVATE)
    public IRubyObject initialize_copy(IRubyObject other) {
        RubyStringIO otherIO = (RubyStringIO)TypeConverter.convertToType(other, this.getRuntime().getClass("StringIO"), "to_strio");
        if (this == otherIO) {
            return this;
        }
        this.ptr = otherIO.ptr;
        if (otherIO.isTaint()) {
            this.setTaint(true);
        }
        return this;
    }

    @JRubyMethod(name={"<<"}, required=1)
    public IRubyObject append(ThreadContext context, IRubyObject arg2) {
        this.callMethod(context, "write", arg2);
        return this;
    }

    @JRubyMethod
    public IRubyObject binmode() {
        return this;
    }

    @JRubyMethod
    public IRubyObject close() {
        this.checkInitialized();
        this.checkOpen();
        this.ptr.closedRead = true;
        this.ptr.closedWrite = true;
        return this.getRuntime().getNil();
    }

    private void doFinalize() {
        this.ptr.closedRead = true;
        this.ptr.closedWrite = true;
        this.ptr.string = null;
    }

    @JRubyMethod(name={"closed?"})
    public IRubyObject closed_p() {
        this.checkInitialized();
        return this.getRuntime().newBoolean(this.ptr.closedRead && this.ptr.closedWrite);
    }

    @JRubyMethod
    public IRubyObject close_read() {
        this.checkReadable();
        this.ptr.closedRead = true;
        return this.getRuntime().getNil();
    }

    @JRubyMethod(name={"closed_read?"})
    public IRubyObject closed_read_p() {
        this.checkInitialized();
        return this.getRuntime().newBoolean(this.ptr.closedRead);
    }

    @JRubyMethod
    public IRubyObject close_write() {
        this.checkWritable();
        this.ptr.closedWrite = true;
        return this.getRuntime().getNil();
    }

    @JRubyMethod(name={"closed_write?"})
    public IRubyObject closed_write_p() {
        this.checkInitialized();
        return this.getRuntime().newBoolean(this.ptr.closedWrite);
    }

    public IRubyObject eachInternal(ThreadContext context, IRubyObject[] args2, Block block) {
        IRubyObject line = this.getsOnly(context, args2);
        while (!line.isNil()) {
            block.yield(context, line);
            line = this.getsOnly(context, args2);
        }
        return this;
    }

    @JRubyMethod(name={"each"}, optional=1, writes={FrameField.LASTLINE})
    public IRubyObject each(ThreadContext context, IRubyObject[] args2, Block block) {
        return block.isGiven() ? this.eachInternal(context, args2, block) : RubyEnumerator.enumeratorize(context.runtime, (IRubyObject)this, "each", args2);
    }

    @JRubyMethod(optional=1, compat=CompatVersion.RUBY1_8)
    public IRubyObject each_line(ThreadContext context, IRubyObject[] args2, Block block) {
        return block.isGiven() ? this.eachInternal(context, args2, block) : RubyEnumerator.enumeratorize(context.runtime, (IRubyObject)this, "each_line", args2);
    }

    @JRubyMethod(optional=1, compat=CompatVersion.RUBY1_8)
    public IRubyObject lines(ThreadContext context, IRubyObject[] args2, Block block) {
        return block.isGiven() ? this.each(context, args2, block) : RubyEnumerator.enumeratorize(context.runtime, (IRubyObject)this, "lines", args2);
    }

    public IRubyObject each_byte(ThreadContext context, Block block) {
        this.checkReadable();
        Ruby runtime = context.runtime;
        ByteList bytes2 = this.ptr.string.getByteList();
        while (this.ptr.pos < bytes2.length()) {
            block.yield(context, runtime.newFixnum(bytes2.get(this.ptr.pos++) & 0xFF));
        }
        return this;
    }

    @JRubyMethod(name={"each_byte"})
    public IRubyObject each_byte19(ThreadContext context, Block block) {
        return block.isGiven() ? this.each_byte(context, block) : RubyEnumerator.enumeratorize(context.runtime, this, "each_byte");
    }

    @JRubyMethod
    public IRubyObject bytes(ThreadContext context, Block block) {
        return block.isGiven() ? this.each_byte(context, block) : RubyEnumerator.enumeratorize(context.runtime, this, "bytes");
    }

    @JRubyMethod
    public IRubyObject each_char(ThreadContext context, Block block) {
        return block.isGiven() ? this.each_charInternal(context, block) : RubyEnumerator.enumeratorize(context.runtime, this, "each_char");
    }

    @JRubyMethod
    public IRubyObject chars(ThreadContext context, Block block) {
        return block.isGiven() ? this.each_charInternal(context, block) : RubyEnumerator.enumeratorize(context.runtime, this, "chars");
    }

    public IRubyObject each_charInternal(ThreadContext context, Block block) {
        Encoding enc;
        this.checkReadable();
        Ruby runtime = context.runtime;
        ByteList bytes2 = this.ptr.string.getByteList();
        int len = bytes2.getRealSize();
        int end2 = bytes2.getBegin() + len;
        Encoding encoding2 = enc = runtime.is1_9() ? bytes2.getEncoding() : runtime.getKCode().getEncoding();
        while (this.ptr.pos < len) {
            int pos2 = this.ptr.pos;
            int n = StringSupport.length(enc, bytes2.getUnsafeBytes(), pos2, end2);
            if (len < pos2 + n) {
                n = len - pos2;
            }
            this.ptr.pos += n;
            block.yield(context, this.ptr.string.makeShared19(runtime, pos2, n));
        }
        return this;
    }

    @JRubyMethod(name={"eof", "eof?"})
    public IRubyObject eof() {
        return this.getRuntime().newBoolean(this.isEOF());
    }

    private boolean isEOF() {
        return this.isEndOfString() || this.getRuntime().is1_8() && this.ptr.eof;
    }

    private boolean isEndOfString() {
        return this.ptr.pos >= this.ptr.string.getByteList().length();
    }

    @JRubyMethod(name={"fcntl"})
    public IRubyObject fcntl() {
        throw this.getRuntime().newNotImplementedError("fcntl not implemented");
    }

    @JRubyMethod(name={"fileno"})
    public IRubyObject fileno() {
        return this.getRuntime().getNil();
    }

    @JRubyMethod(name={"flush"})
    public IRubyObject flush() {
        return this;
    }

    @JRubyMethod(name={"fsync"})
    public IRubyObject fsync() {
        return RubyFixnum.zero(this.getRuntime());
    }

    @JRubyMethod(name={"getc", "getbyte"})
    public IRubyObject getc() {
        this.checkReadable();
        if (this.isEndOfString()) {
            return this.getRuntime().getNil();
        }
        return this.getRuntime().newFixnum(this.ptr.string.getByteList().get(this.ptr.pos++) & 0xFF);
    }

    private RubyString strioSubstr(Ruby runtime, int pos2, int len) {
        RubyString str = this.ptr.string;
        ByteList strByteList = str.getByteList();
        byte[] strBytes = strByteList.getUnsafeBytes();
        Encoding enc = str.getEncoding();
        int rlen = str.size() - pos2;
        if (len > rlen) {
            len = rlen;
        }
        if (len < 0) {
            len = 0;
        }
        if (len == 0) {
            return RubyString.newEmptyString(runtime);
        }
        return RubyString.newStringShared(runtime, strBytes, strByteList.getBegin() + pos2, len, enc);
    }

    private IRubyObject internalGets18(ThreadContext context, IRubyObject[] args2) {
        Ruby runtime = context.runtime;
        if (!this.isEndOfString() && !this.ptr.eof) {
            ByteList add3;
            int sepIndex;
            IRubyObject sepArg;
            boolean isParagraph = false;
            ByteList sep = ((RubyString)runtime.getGlobalVariables().get("$/")).getByteList();
            int limit2 = -1;
            IRubyObject iRubyObject = sepArg = args2.length > 0 ? args2[0] : null;
            if (sepArg != null) {
                if (sepArg.isNil()) {
                    int bytesAvailable = this.ptr.string.getByteList().getRealSize() - this.ptr.pos;
                    int bytesToUse = limit2 < 0 || limit2 >= bytesAvailable ? bytesAvailable : limit2;
                    bytesToUse += StringSupport.bytesToFixBrokenTrailingCharacter(this.ptr.string.getByteList(), bytesToUse);
                    ByteList buf = this.ptr.string.getByteList().makeShared(this.ptr.pos, bytesToUse);
                    this.ptr.pos += buf.getRealSize();
                    return this.makeString(runtime, buf);
                }
                sep = sepArg.convertToString().getByteList();
                if (sep.getRealSize() == 0) {
                    isParagraph = true;
                    sep = Stream.PARAGRAPH_SEPARATOR;
                }
            }
            ByteList ss = this.ptr.string.getByteList();
            if (isParagraph) {
                this.swallowLF(ss);
                if (this.ptr.pos == ss.getRealSize()) {
                    return runtime.getNil();
                }
            }
            if (-1 == (sepIndex = ss.indexOf(sep, this.ptr.pos))) {
                sepIndex = this.ptr.string.getByteList().getRealSize();
                add3 = ByteList.EMPTY_BYTELIST;
            } else {
                add3 = sep;
            }
            int bytes2 = sepIndex - this.ptr.pos;
            int bytesToUse = limit2 < 0 || limit2 >= bytes2 ? bytes2 : limit2;
            int bytesWithSep = sepIndex - this.ptr.pos + add3.getRealSize();
            int bytesToUseWithSep = limit2 < 0 || limit2 >= bytesWithSep ? bytesWithSep : limit2;
            ByteList line = new ByteList(bytesToUseWithSep);
            line.append(this.ptr.string.getByteList(), this.ptr.pos, bytesToUse);
            this.ptr.pos += bytesToUse;
            int sepBytesToUse = bytesToUseWithSep - bytesToUse;
            line.append(add3, 0, sepBytesToUse);
            this.ptr.pos += sepBytesToUse;
            if (sepBytesToUse >= add3.getRealSize()) {
                ++this.ptr.lineno;
            }
            return this.makeString(runtime, line);
        }
        return runtime.getNil();
    }

    private void swallowLF(ByteList list2) {
        while (this.ptr.pos < list2.getRealSize() && list2.get(this.ptr.pos) == 10) {
            ++this.ptr.pos;
        }
    }

    @JRubyMethod(name={"gets"}, optional=1, writes={FrameField.LASTLINE}, compat=CompatVersion.RUBY1_8)
    public IRubyObject gets(ThreadContext context, IRubyObject[] args2) {
        IRubyObject result2 = this.getsOnly(context, args2);
        context.setLastLine(result2);
        return result2;
    }

    public IRubyObject getsOnly(ThreadContext context, IRubyObject[] args2) {
        this.checkReadable();
        return this.internalGets18(context, args2);
    }

    @JRubyMethod(name={"tty?", "isatty"})
    public IRubyObject isatty() {
        return this.getRuntime().getFalse();
    }

    @JRubyMethod(name={"length", "size"})
    public IRubyObject length() {
        this.checkFinalized();
        return this.getRuntime().newFixnum(this.ptr.string.getByteList().length());
    }

    @JRubyMethod(name={"lineno"})
    public IRubyObject lineno() {
        return this.getRuntime().newFixnum(this.ptr.lineno);
    }

    @JRubyMethod(name={"lineno="}, required=1)
    public IRubyObject set_lineno(IRubyObject arg2) {
        this.ptr.lineno = RubyNumeric.fix2int(arg2);
        return this.getRuntime().getNil();
    }

    @JRubyMethod(name={"path"}, compat=CompatVersion.RUBY1_8)
    public IRubyObject path() {
        return this.getRuntime().getNil();
    }

    @JRubyMethod(name={"pid"})
    public IRubyObject pid() {
        return this.getRuntime().getNil();
    }

    @JRubyMethod(name={"pos", "tell"})
    public IRubyObject pos() {
        return this.getRuntime().newFixnum(this.ptr.pos);
    }

    @JRubyMethod(name={"pos="}, required=1)
    public IRubyObject set_pos(IRubyObject arg2) {
        this.ptr.pos = RubyNumeric.fix2int(arg2);
        if (this.ptr.pos < 0) {
            throw this.getRuntime().newErrnoEINVALError("Invalid argument");
        }
        if (this.getRuntime().is1_8() && !this.isEndOfString()) {
            this.ptr.eof = false;
        }
        return this.getRuntime().getNil();
    }

    @JRubyMethod(name={"print"}, rest=true)
    public IRubyObject print(ThreadContext context, IRubyObject[] args2) {
        Ruby runtime = context.runtime;
        if (args2.length != 0) {
            int j = args2.length;
            for (int i2 = 0; i2 < j; ++i2) {
                this.append(context, args2[i2]);
            }
        } else {
            IRubyObject arg2 = runtime.getGlobalVariables().get("$_");
            this.append(context, arg2.isNil() ? this.makeString(runtime, new ByteList(new byte[]{110, 105, 108})) : arg2);
        }
        IRubyObject sep = runtime.getGlobalVariables().get("$\\");
        if (!sep.isNil()) {
            this.append(context, sep);
        }
        return runtime.getNil();
    }

    @JRubyMethod(name={"printf"}, required=1, rest=true)
    public IRubyObject printf(ThreadContext context, IRubyObject[] args2) {
        this.append(context, RubyKernel.sprintf(context, this, args2));
        return this.getRuntime().getNil();
    }

    @JRubyMethod(name={"putc"}, required=1)
    public IRubyObject putc(IRubyObject obj) {
        this.checkWritable();
        byte c = RubyNumeric.num2chr(obj);
        this.checkFrozen();
        this.ptr.string.modify();
        ByteList bytes2 = this.ptr.string.getByteList();
        if (this.ptr.modes.isAppendable()) {
            this.ptr.pos = bytes2.length();
            bytes2.append(c);
        } else {
            if (this.isEndOfString()) {
                bytes2.length(this.ptr.pos + 1);
            }
            bytes2.set(this.ptr.pos, c);
            ++this.ptr.pos;
        }
        return obj;
    }

    /*
     * Enabled aggressive block sorting
     */
    @JRubyMethod(name={"puts"}, rest=true)
    public IRubyObject puts(ThreadContext context, IRubyObject[] args2) {
        this.checkWritable();
        if (args2.length == 0) {
            this.callMethod(context, "write", (IRubyObject)RubyString.newStringShared(this.getRuntime(), NEWLINE));
            return this.getRuntime().getNil();
        }
        int i2 = 0;
        while (true) {
            block8: {
                RubyString line;
                block5: {
                    block6: {
                        RubyArray arr;
                        block7: {
                            block4: {
                                if (i2 >= args2.length) {
                                    return this.getRuntime().getNil();
                                }
                                line = this.getRuntime().newString();
                                if (!args2[i2].isNil()) break block4;
                                line = this.getRuntime().newString("nil");
                                break block5;
                            }
                            IRubyObject tmp = args2[i2].checkArrayType();
                            if (tmp.isNil()) break block6;
                            arr = (RubyArray)tmp;
                            if (!this.getRuntime().isInspecting(arr)) break block7;
                            line = this.getRuntime().newString("[...]");
                            break block5;
                        }
                        this.inspectPuts(context, arr);
                        break block8;
                    }
                    line = args2[i2] instanceof RubyString ? (RubyString)args2[i2] : args2[i2].asString();
                }
                this.callMethod(context, "write", (IRubyObject)line);
                if (!line.getByteList().endsWith(NEWLINE)) {
                    this.callMethod(context, "write", (IRubyObject)RubyString.newStringShared(this.getRuntime(), NEWLINE));
                }
            }
            ++i2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IRubyObject inspectPuts(ThreadContext context, RubyArray array) {
        try {
            this.getRuntime().registerInspecting(array);
            IRubyObject iRubyObject = this.puts(context, array.toJavaArray());
            return iRubyObject;
        }
        finally {
            this.getRuntime().unregisterInspecting(array);
        }
    }

    private RubyString makeString(Ruby runtime, ByteList buf, boolean setEncoding) {
        RubyString str = RubyString.newString(runtime, buf);
        str.setTaint(true);
        return str;
    }

    private RubyString makeString(Ruby runtime, ByteList buf) {
        return this.makeString(runtime, buf, true);
    }

    @JRubyMethod(name={"read"}, optional=2)
    public IRubyObject read(ThreadContext context, IRubyObject[] args2) {
        return this.read18(args2);
    }

    private IRubyObject read18(IRubyObject[] args2) {
        this.checkReadable();
        ByteList buf = null;
        int length2 = 0;
        int oldLength = 0;
        RubyString originalString = null;
        switch (args2.length) {
            case 2: {
                originalString = args2[1].convertToString();
                originalString.modify();
                buf = originalString.getByteList();
            }
            case 1: {
                if (!args2[0].isNil()) {
                    oldLength = length2 = RubyNumeric.fix2int(args2[0]);
                    if (length2 < 0) {
                        throw this.getRuntime().newArgumentError("negative length " + length2 + " given");
                    }
                    if (length2 > 0 && this.isEndOfString()) {
                        this.ptr.eof = true;
                        if (buf != null) {
                            buf.setRealSize(0);
                        }
                        return this.getRuntime().getNil();
                    }
                    if (!this.ptr.eof) break;
                    if (buf != null) {
                        buf.setRealSize(0);
                    }
                    return this.getRuntime().getNil();
                }
            }
            case 0: {
                oldLength = -1;
                length2 = this.ptr.string.getByteList().length();
                if (length2 <= this.ptr.pos) {
                    this.ptr.eof = true;
                    if (buf == null) {
                        buf = new ByteList();
                    } else {
                        buf.setRealSize(0);
                    }
                    return this.makeString(this.getRuntime(), buf);
                }
                length2 -= this.ptr.pos;
                break;
            }
            default: {
                this.getRuntime().newArgumentError(args2.length, 0);
            }
        }
        if (buf == null) {
            int internalLength = this.ptr.string.getByteList().length();
            if (internalLength > 0) {
                if (internalLength >= this.ptr.pos + length2) {
                    buf = new ByteList(this.ptr.string.getByteList(), this.ptr.pos, length2);
                } else {
                    int rest2 = this.ptr.string.getByteList().length() - this.ptr.pos;
                    if (length2 > rest2) {
                        length2 = rest2;
                    }
                    buf = new ByteList(this.ptr.string.getByteList(), this.ptr.pos, length2);
                }
            }
        } else {
            byte[] target;
            int rest3 = this.ptr.string.getByteList().length() - this.ptr.pos;
            if (length2 > rest3) {
                length2 = rest3;
            }
            if ((target = buf.getUnsafeBytes()).length > length2) {
                System.arraycopy(this.ptr.string.getByteList().getUnsafeBytes(), this.ptr.pos, target, 0, length2);
                buf.setBegin(0);
                buf.setRealSize(length2);
            } else {
                target = new byte[length2];
                System.arraycopy(this.ptr.string.getByteList().getUnsafeBytes(), this.ptr.pos, target, 0, length2);
                buf.setBegin(0);
                buf.setRealSize(length2);
                buf.setUnsafeBytes(target);
            }
        }
        if (buf == null) {
            if (!this.ptr.eof) {
                buf = new ByteList();
            }
            length2 = 0;
        } else {
            length2 = buf.length();
            this.ptr.pos += length2;
        }
        if (oldLength < 0 || oldLength > length2) {
            this.ptr.eof = true;
        }
        return originalString != null ? originalString : this.makeString(this.getRuntime(), buf);
    }

    @JRubyMethod(name={"readchar", "readbyte"}, compat=CompatVersion.RUBY1_8)
    public IRubyObject readchar() {
        IRubyObject c = this.getc();
        if (c.isNil()) {
            throw this.getRuntime().newEOFError();
        }
        return c;
    }

    @JRubyMethod(name={"readline"}, optional=1, writes={FrameField.LASTLINE}, compat=CompatVersion.RUBY1_8)
    public IRubyObject readline18(ThreadContext context, IRubyObject[] args2) {
        IRubyObject line = this.gets(context, args2);
        if (line.isNil()) {
            throw this.getRuntime().newEOFError();
        }
        return line;
    }

    @JRubyMethod(name={"readlines"}, optional=1, compat=CompatVersion.RUBY1_8)
    public IRubyObject readlines(ThreadContext context, IRubyObject[] args2) {
        IRubyObject line;
        this.checkReadable();
        RubyArray ary = context.runtime.newArray();
        while (!this.isEOF() && !(line = this.internalGets18(context, args2)).isNil()) {
            ary.append(line);
        }
        return ary;
    }

    @JRubyMethod(name={"reopen"}, required=0, optional=2)
    public IRubyObject reopen(IRubyObject[] args2) {
        this.checkFrozen();
        if (args2.length == 1 && !(args2[0] instanceof RubyString)) {
            return this.initialize_copy(args2[0]);
        }
        this.doRewind();
        this.ptr.closedRead = false;
        this.ptr.closedWrite = false;
        return this.initialize(args2, Block.NULL_BLOCK);
    }

    @JRubyMethod(name={"rewind"})
    public IRubyObject rewind() {
        this.checkFrozen();
        this.doRewind();
        return RubyFixnum.zero(this.getRuntime());
    }

    private void doRewind() {
        this.ptr.pos = 0;
        this.ptr.eof = false;
        this.ptr.lineno = 0;
    }

    @Deprecated
    public IRubyObject seek(IRubyObject[] args2) {
        return this.seek(this.getRuntime().getCurrentContext(), args2);
    }

    @JRubyMethod(required=1, optional=1)
    public IRubyObject seek(ThreadContext context, IRubyObject[] args2) {
        this.checkFrozen();
        this.checkFinalized();
        int offset2 = RubyNumeric.num2int(args2[0]);
        IRubyObject whence = context.nil;
        if (args2.length > 1 && !args2[0].isNil()) {
            whence = args2[1];
        }
        this.checkOpen();
        switch (whence.isNil() ? 0 : RubyNumeric.num2int(whence)) {
            case 0: {
                break;
            }
            case 1: {
                offset2 += this.ptr.pos;
                break;
            }
            case 2: {
                offset2 += this.ptr.string.size();
                break;
            }
            default: {
                throw this.getRuntime().newErrnoEINVALError("invalid whence");
            }
        }
        if (offset2 < 0) {
            throw this.getRuntime().newErrnoEINVALError("invalid seek value");
        }
        this.ptr.pos = offset2;
        this.ptr.eof = false;
        return RubyFixnum.zero(this.getRuntime());
    }

    @JRubyMethod(name={"string="}, required=1)
    public IRubyObject set_string(IRubyObject arg2) {
        this.checkFrozen();
        RubyString str = arg2.convertToString();
        this.ptr.modes = ModeFlags.createModeFlags(str.isFrozen() ? ModeFlags.RDONLY : ModeFlags.RDWR);
        this.ptr.pos = 0;
        this.ptr.lineno = 0;
        this.ptr.string = str;
        return this.ptr.string;
    }

    @JRubyMethod(name={"sync="}, required=1)
    public IRubyObject set_sync(IRubyObject args2) {
        this.checkFrozen();
        return args2;
    }

    @JRubyMethod(name={"string"})
    public IRubyObject string() {
        if (this.ptr.string == null) {
            return this.getRuntime().getNil();
        }
        return this.ptr.string;
    }

    @JRubyMethod(name={"sync"})
    public IRubyObject sync() {
        return this.getRuntime().getTrue();
    }

    @JRubyMethod(name={"sysread"}, optional=2, compat=CompatVersion.RUBY1_8)
    public IRubyObject sysread18(IRubyObject[] args2) {
        return this.sysreadCommon(args2);
    }

    public IRubyObject sysread(IRubyObject[] args2) {
        return this.sysread18(args2);
    }

    private IRubyObject sysreadCommon(IRubyObject[] args2) {
        IRubyObject obj = this.read(args2);
        if (this.isEOF() && obj.isNil()) {
            throw this.getRuntime().newEOFError();
        }
        return obj;
    }

    @JRubyMethod(name={"truncate"}, required=1)
    public IRubyObject truncate(IRubyObject arg2) {
        this.checkWritable();
        int len = RubyFixnum.fix2int(arg2);
        if (len < 0) {
            throw this.getRuntime().newErrnoEINVALError("negative legnth");
        }
        this.ptr.string.modify();
        ByteList buf = this.ptr.string.getByteList();
        if (len < buf.length()) {
            Arrays.fill(buf.getUnsafeBytes(), len, buf.length(), (byte)0);
        }
        buf.length(len);
        return arg2;
    }

    @JRubyMethod(name={"ungetc"}, required=1, compat=CompatVersion.RUBY1_8)
    public IRubyObject ungetc(IRubyObject arg2) {
        this.checkReadable();
        int c = RubyNumeric.num2int(arg2);
        if (this.ptr.pos == 0) {
            return this.getRuntime().getNil();
        }
        this.ungetbyteCommon(c);
        return this.getRuntime().getNil();
    }

    private void ungetbyteCommon(int c) {
        this.ptr.string.modify();
        --this.ptr.pos;
        ByteList bytes2 = this.ptr.string.getByteList();
        if (this.isEndOfString()) {
            bytes2.length(this.ptr.pos + 1);
        }
        if (this.ptr.pos == -1) {
            bytes2.prepend((byte)c);
            this.ptr.pos = 0;
        } else {
            bytes2.set(this.ptr.pos, c);
        }
    }

    private void ungetbyteCommon(RubyString ungetBytes) {
        ByteList ungetByteList = ungetBytes.getByteList();
        int len = ungetByteList.getRealSize();
        int start2 = this.ptr.pos;
        if (len == 0) {
            return;
        }
        this.ptr.string.modify();
        start2 = len > this.ptr.pos ? 0 : this.ptr.pos - len;
        ByteList bytes2 = this.ptr.string.getByteList();
        if (this.isEndOfString()) {
            bytes2.length(Math.max(this.ptr.pos, len));
        }
        bytes2.replace(start2, this.ptr.pos - start2, ungetBytes.getByteList());
        this.ptr.pos = start2;
    }

    @JRubyMethod(name={"write", "write_nonblock", "syswrite"}, required=1)
    public IRubyObject write(ThreadContext context, IRubyObject arg2) {
        return context.runtime.newFixnum(this.writeInternal18(context, arg2));
    }

    private int writeInternal18(ThreadContext context, IRubyObject arg2) {
        this.checkWritable();
        RubyString val = arg2.asString();
        this.ptr.string.modify();
        if (this.ptr.modes.isAppendable()) {
            this.ptr.string.getByteList().append(val.getByteList());
            this.ptr.pos = this.ptr.string.getByteList().length();
        } else {
            int left2 = this.ptr.string.getByteList().length() - this.ptr.pos;
            this.ptr.string.getByteList().replace(this.ptr.pos, Math.min(val.getByteList().length(), left2), val.getByteList());
            this.ptr.pos += val.getByteList().length();
        }
        if (val.isTaint()) {
            this.ptr.string.setTaint(true);
        }
        return val.getByteList().length();
    }

    @Override
    public void checkFrozen() {
        super.checkFrozen();
        this.checkInitialized();
    }

    private void checkReadable() {
        this.checkFrozen();
        this.checkInitialized();
        if (this.ptr.closedRead || !this.ptr.modes.isReadable()) {
            throw this.getRuntime().newIOError("not opened for reading");
        }
    }

    private void checkWritable() {
        this.checkFrozen();
        this.checkInitialized();
        if (this.ptr.string.isFrozen()) {
            throw this.getRuntime().newIOError("not modifiable string");
        }
        if (this.ptr.closedWrite || !this.ptr.modes.isWritable()) {
            throw this.getRuntime().newIOError("not opened for writing");
        }
    }

    private void checkInitialized() {
        if (this.ptr.modes == null) {
            throw this.getRuntime().newIOError("uninitialized stream");
        }
    }

    private void checkFinalized() {
        if (this.ptr.string == null) {
            throw this.getRuntime().newIOError("not opened");
        }
    }

    private void checkOpen() {
        if (this.ptr.closedRead && this.ptr.closedWrite) {
            throw this.getRuntime().newIOError("closed stream");
        }
    }

    private void setupModes() {
        this.ptr.closedWrite = false;
        this.ptr.closedRead = false;
        if (this.ptr.modes.isReadOnly()) {
            this.ptr.closedWrite = true;
        }
        if (!this.ptr.modes.isReadable()) {
            this.ptr.closedRead = true;
        }
    }

    @Deprecated
    public IRubyObject read(IRubyObject[] args2) {
        return this.read18(args2);
    }

    static class StringIOData {
        int pos = 0;
        int lineno = 0;
        boolean eof = false;
        boolean closedRead = false;
        boolean closedWrite = false;
        ModeFlags modes;
        RubyString string;

        StringIOData() {
        }
    }
}

