/*
 * Decompiled with CFR 0.152.
 */
package jnr.ffi.provider;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Map;
import jnr.ffi.provider.Invoker;

public class NativeInvocationHandler
implements InvocationHandler {
    private volatile Map<Method, Invoker> fastLookupTable;
    private final Map<Method, Invoker> invokerMap;

    public NativeInvocationHandler(Map<Method, Invoker> invokers) {
        this.invokerMap = invokers;
        this.fastLookupTable = Collections.emptyMap();
    }

    @Override
    public Object invoke(Object self2, Method method2, Object[] argArray) throws Throwable {
        Invoker invoker = this.fastLookupTable.get(method2);
        return invoker != null ? invoker.invoke(self2, argArray) : this.lookupAndCacheInvoker(method2).invoke(self2, argArray);
    }

    private synchronized Invoker lookupAndCacheInvoker(Method method2) {
        Invoker invoker = this.fastLookupTable.get(method2);
        if (invoker != null) {
            return invoker;
        }
        IdentityHashMap<Method, Invoker> map = new IdentityHashMap<Method, Invoker>(this.fastLookupTable);
        invoker = this.invokerMap.get(method2);
        map.put(method2, invoker);
        if (invoker == null) {
            throw new UnsatisfiedLinkError("no invoker for native method " + method2.getName());
        }
        this.fastLookupTable = map;
        return invoker;
    }
}

