/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.instructions;

import java.util.Map;
import org.jruby.ir.IRScope;
import org.jruby.ir.IRVisitor;
import org.jruby.ir.Operation;
import org.jruby.ir.instructions.Instr;
import org.jruby.ir.instructions.ResultInstr;
import org.jruby.ir.operands.BooleanLiteral;
import org.jruby.ir.operands.Operand;
import org.jruby.ir.operands.Variable;
import org.jruby.ir.transformations.inlining.InlinerInfo;
import org.jruby.runtime.Block;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class NotInstr
extends Instr
implements ResultInstr {
    private Operand arg;
    private Variable result;

    public NotInstr(Variable result2, Operand arg2) {
        super(Operation.NOT);
        assert (result2 != null) : "NotInstr result is null";
        this.arg = arg2;
        this.result = result2;
    }

    @Override
    public Operand[] getOperands() {
        return new Operand[]{this.arg};
    }

    @Override
    public Variable getResult() {
        return this.result;
    }

    @Override
    public void updateResult(Variable v) {
        this.result = v;
    }

    @Override
    public void simplifyOperands(Map<Operand, Operand> valueMap, boolean force) {
        this.arg = this.arg.getSimplifiedOperand(valueMap, force);
    }

    @Override
    public String toString() {
        return super.toString() + "(" + this.arg + ")";
    }

    @Override
    public Instr cloneForInlining(InlinerInfo ii) {
        return new NotInstr(ii.getRenamedVariable(this.result), this.arg.cloneForInlining(ii));
    }

    private Operand flipLogical(IRScope scope, BooleanLiteral value2) {
        return value2.isTrue() ? scope.getManager().getFalse() : scope.getManager().getTrue();
    }

    @Override
    public Operand simplifyAndGetResult(IRScope scope, Map<Operand, Operand> valueMap) {
        this.simplifyOperands(valueMap, false);
        return this.arg instanceof BooleanLiteral ? this.flipLogical(scope, (BooleanLiteral)this.arg) : null;
    }

    @Override
    public Object interpret(ThreadContext context, DynamicScope currDynScope, IRubyObject self2, Object[] temp, Block block) {
        boolean not = !((IRubyObject)this.arg.retrieve(context, self2, currDynScope, temp)).isTrue();
        return context.runtime.newBoolean(not);
    }

    @Override
    public void visit(IRVisitor visitor) {
        visitor.NotInstr(this);
    }
}

