/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.coverage;

import java.util.Map;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyHash;
import org.jruby.RubyString;
import org.jruby.anno.JRubyMethod;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class CoverageModule {
    @JRubyMethod(module=true)
    public static IRubyObject start(ThreadContext context, IRubyObject self2) {
        Ruby runtime = context.runtime;
        if (!runtime.getCoverageData().isCoverageEnabled()) {
            runtime.getCoverageData().setCoverageEnabled(runtime, true);
        }
        return context.nil;
    }

    @JRubyMethod(module=true)
    public static IRubyObject result(ThreadContext context, IRubyObject self2) {
        Ruby runtime = context.runtime;
        if (!runtime.getCoverageData().isCoverageEnabled()) {
            throw runtime.newRuntimeError("coverage measurement is not enabled");
        }
        Map<String, int[]> coverage2 = runtime.getCoverageData().resetCoverage(runtime);
        RubyHash covHash = RubyHash.newHash(runtime);
        for (Map.Entry<String, int[]> entry : coverage2.entrySet()) {
            RubyArray ary = RubyArray.newArray(runtime, entry.getValue().length);
            for (int i2 = 0; i2 < entry.getValue().length; ++i2) {
                int integer = entry.getValue()[i2];
                ary.store(i2, integer == -1 ? context.nil : runtime.newFixnum(integer));
            }
            covHash.fastASetCheckString(runtime, RubyString.newString(runtime, entry.getKey()), ary);
        }
        return covHash;
    }
}

