/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util.io;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.Channel;
import java.nio.channels.IllegalBlockingModeException;
import java.nio.channels.Pipe;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.spi.SelectorProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyFixnum;
import org.jruby.RubyFloat;
import org.jruby.RubyIO;
import org.jruby.RubyThread;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.io.BadDescriptorException;
import org.jruby.util.io.SelectorFactory;

public class SelectBlob {
    private static final int READ_ACCEPT_OPS = 17;
    private static final int WRITE_CONNECT_OPS = 12;
    private static final int CANCELLED_OPS = 25;
    Ruby runtime;
    RubyArray readArray = null;
    int readSize = 0;
    RubyIO[] readIOs = null;
    boolean[] unselectableReads = null;
    boolean[] pendingReads = null;
    Boolean[] readBlocking = null;
    int selectedReads = 0;
    RubyArray writeArray = null;
    int writeSize = 0;
    RubyIO[] writeIOs = null;
    boolean[] unselectableWrites = null;
    Boolean[] writeBlocking = null;
    int selectedWrites = 0;
    Selector mainSelector = null;
    Map<SelectorProvider, Selector> selectors = Collections.emptyMap();
    Collection<ENXIOSelector> enxioSelectors = Collections.emptyList();
    RubyArray readResults = null;
    RubyArray writeResults = null;
    RubyArray errorResults = null;

    public IRubyObject goForIt(ThreadContext context, Ruby runtime, IRubyObject[] args2) {
        this.runtime = runtime;
        try {
            IRubyObject iRubyObject;
            long timeout2;
            this.processReads(runtime, args2, context);
            this.processWrites(runtime, args2, context);
            if (args2.length > 2 && !args2[2].isNil()) {
                SelectBlob.checkArrayType(runtime, args2[2]);
            }
            boolean has_timeout = args2.length > 3 && !args2[3].isNil();
            long l = timeout2 = !has_timeout ? 0L : SelectBlob.getTimeoutFromArg(args2[3], runtime);
            if (timeout2 < 0L) {
                throw runtime.newArgumentError("time interval must be positive");
            }
            if (args2[0].isNil() && args2[1].isNil() && args2[2].isNil()) {
                if (timeout2 > 0L) {
                    RubyThread thread2 = context.getThread();
                    long now = System.currentTimeMillis();
                    thread2.sleep(timeout2);
                    while (System.currentTimeMillis() < now + timeout2) {
                        thread2.sleep(1L);
                    }
                }
            } else {
                this.doSelect(runtime, has_timeout, timeout2);
                this.processSelectedKeys(runtime);
                this.processPendingAndUnselectable();
                this.tidyUp();
            }
            if (this.readResults == null && this.writeResults == null && this.errorResults == null) {
                iRubyObject = runtime.getNil();
                return iRubyObject;
            }
            iRubyObject = this.constructResults(runtime);
            return iRubyObject;
        }
        catch (BadDescriptorException e) {
            throw runtime.newErrnoEBADFError();
        }
        catch (IOException e) {
            throw runtime.newIOErrorFromException(e);
        }
        catch (InterruptedException ie) {
            throw runtime.newThreadError("select interrupted");
        }
        finally {
            for (Selector selector : this.selectors.values()) {
                try {
                    selector.close();
                }
                catch (Exception e) {}
            }
        }
    }

    private void processReads(Ruby runtime, IRubyObject[] args2, ThreadContext context) throws BadDescriptorException, IOException {
        if (!args2[0].isNil()) {
            SelectBlob.checkArrayType(runtime, args2[0]);
            this.readArray = (RubyArray)args2[0];
            this.readSize = this.readArray.size();
            if (this.readSize == 0) {
                this.readArray = null;
            } else {
                this.readIOs = new RubyIO[this.readSize];
                HashMap<Character, Integer> attachment = new HashMap<Character, Integer>(1);
                for (int i2 = 0; i2 < this.readSize; ++i2) {
                    RubyIO ioObj = this.saveReadIO(i2, context);
                    this.saveReadBlocking(ioObj, i2);
                    this.saveBufferedRead(ioObj, i2);
                    attachment.clear();
                    attachment.put(Character.valueOf('r'), i2);
                    this.trySelectRead(context, attachment, ioObj);
                }
            }
        }
    }

    private RubyIO saveReadIO(int i2, ThreadContext context) {
        RubyIO ioObj;
        IRubyObject obj = this.readArray.eltOk(i2);
        this.readIOs[i2] = ioObj = RubyIO.convertToIO(context, obj);
        return ioObj;
    }

    private void saveReadBlocking(RubyIO ioObj, int i2) {
        if (ioObj.getChannel() instanceof SelectableChannel) {
            this.getReadBlocking()[i2] = ((SelectableChannel)ioObj.getChannel()).isBlocking();
        }
    }

    private void saveBufferedRead(RubyIO ioObj, int i2) throws BadDescriptorException {
        if (ioObj.getOpenFile().getMainStreamSafe().readDataBuffered()) {
            this.getUnselectableReads()[i2] = true;
        }
    }

    private void trySelectRead(ThreadContext context, Map<Character, Integer> attachment, RubyIO ioObj) throws IOException {
        if (ioObj.getChannel() instanceof SelectableChannel && SelectBlob.registerSelect(context, this.getSelector(context, (SelectableChannel)ioObj.getChannel()), attachment, ioObj, 17)) {
            ++this.selectedReads;
            if (ioObj.writeDataBuffered()) {
                this.getPendingReads()[attachment.get((Object)Character.valueOf((char)'r')).intValue()] = true;
            }
        } else if ((ioObj.getOpenFile().getMode() & 1) != 0) {
            this.getUnselectableReads()[attachment.get((Object)Character.valueOf((char)'r')).intValue()] = true;
        }
    }

    private void processWrites(Ruby runtime, IRubyObject[] args2, ThreadContext context) throws IOException {
        if (args2.length > 1 && !args2[1].isNil()) {
            SelectBlob.checkArrayType(runtime, args2[1]);
            this.writeArray = (RubyArray)args2[1];
            this.writeSize = this.writeArray.size();
            if (this.writeArray.size() == 0) {
                this.writeArray = null;
            } else {
                this.writeIOs = new RubyIO[this.writeSize];
                HashMap<Character, Integer> attachment = new HashMap<Character, Integer>(1);
                for (int i2 = 0; i2 < this.writeSize; ++i2) {
                    RubyIO ioObj = this.saveWriteIO(i2, context);
                    this.saveWriteBlocking(ioObj, i2);
                    attachment.clear();
                    attachment.put(Character.valueOf('w'), i2);
                    this.trySelectWrite(context, attachment, ioObj);
                }
            }
        }
    }

    private RubyIO saveWriteIO(int i2, ThreadContext context) {
        RubyIO ioObj;
        IRubyObject obj = this.writeArray.eltOk(i2);
        this.writeIOs[i2] = ioObj = RubyIO.convertToIO(context, obj);
        return ioObj;
    }

    private void saveWriteBlocking(RubyIO ioObj, int i2) {
        if (ioObj.getChannel() instanceof SelectableChannel) {
            if (this.readBlocking != null) {
                int readIndex = this.fastSearch(this.readIOs, ioObj);
                if (readIndex == -1) {
                    this.getWriteBlocking()[i2] = ((SelectableChannel)ioObj.getChannel()).isBlocking();
                }
            } else {
                this.getWriteBlocking()[i2] = ((SelectableChannel)ioObj.getChannel()).isBlocking();
            }
        }
    }

    private void trySelectWrite(ThreadContext context, Map<Character, Integer> attachment, RubyIO ioObj) throws IOException {
        if (!(ioObj.getChannel() instanceof SelectableChannel) || !SelectBlob.registerSelect(context, this.getSelector(context, (SelectableChannel)ioObj.getChannel()), attachment, ioObj, 12)) {
            ++this.selectedReads;
            if ((ioObj.getOpenFile().getMode() & 2) != 0) {
                this.getUnselectableWrites()[attachment.get((Object)Character.valueOf((char)'w')).intValue()] = true;
            }
        }
    }

    private static long getTimeoutFromArg(IRubyObject timeArg, Ruby runtime) {
        long timeout2 = 0L;
        if (timeArg instanceof RubyFloat) {
            timeout2 = Math.round(((RubyFloat)timeArg).getDoubleValue() * 1000.0);
        } else if (timeArg instanceof RubyFixnum) {
            timeout2 = Math.round(((RubyFixnum)timeArg).getDoubleValue() * 1000.0);
        } else {
            throw runtime.newTypeError("can't convert " + timeArg.getMetaClass().getName() + " into time interval");
        }
        if (timeout2 < 0L) {
            throw runtime.newArgumentError("negative timeout given");
        }
        return timeout2;
    }

    private void doSelect(Ruby runtime, boolean has_timeout, long timeout2) throws IOException {
        if (this.mainSelector != null) {
            if (this.pendingReads == null && this.unselectableReads == null && this.unselectableWrites == null) {
                if (has_timeout && timeout2 == 0L) {
                    for (Selector selector : this.selectors.values()) {
                        selector.selectNow();
                    }
                } else {
                    ArrayList<Future<Object>> futures = new ArrayList<Future<Object>>(this.enxioSelectors.size());
                    for (ENXIOSelector eNXIOSelector : this.enxioSelectors) {
                        futures.add(runtime.getExecutor().submit(eNXIOSelector));
                    }
                    this.mainSelector.select(has_timeout ? timeout2 : 0L);
                    for (ENXIOSelector eNXIOSelector : this.enxioSelectors) {
                        eNXIOSelector.selector.wakeup();
                    }
                    for (Future future : futures) {
                        try {
                            future.get();
                        }
                        catch (InterruptedException iex) {
                        }
                        catch (ExecutionException eex) {
                            if (!(eex.getCause() instanceof IOException)) continue;
                            throw (IOException)eex.getCause();
                        }
                    }
                }
            } else {
                for (Selector selector : this.selectors.values()) {
                    selector.selectNow();
                }
            }
        }
        for (ENXIOSelector enxioSelector : this.enxioSelectors) {
            Pipe.SourceChannel sourceChannel = enxioSelector.pipe.source();
            SelectionKey key2 = sourceChannel.keyFor(this.mainSelector);
            if (key2 == null || !this.mainSelector.selectedKeys().contains(key2)) continue;
            this.mainSelector.selectedKeys().remove(key2);
            ByteBuffer buf = ByteBuffer.allocate(1);
            sourceChannel.read(buf);
        }
    }

    private static boolean ready(int ops, int mask) {
        return (ops & mask) != 0;
    }

    private static boolean readAcceptReady(int ops) {
        return SelectBlob.ready(ops, 17);
    }

    private static boolean writeConnectReady(int ops) {
        return SelectBlob.ready(ops, 12);
    }

    private static boolean cancelReady(int ops) {
        return SelectBlob.ready(ops, 25);
    }

    private static boolean writeReady(int ops) {
        return SelectBlob.ready(ops, 4);
    }

    private void processSelectedKeys(Ruby runtime) throws IOException {
        for (Selector selector : this.selectors.values()) {
            for (SelectionKey key2 : selector.selectedKeys()) {
                int readIoIndex = 0;
                int writeIoIndex = 0;
                try {
                    int interestAndReady = key2.interestOps() & key2.readyOps();
                    if (this.readArray != null && SelectBlob.readAcceptReady(interestAndReady)) {
                        readIoIndex = (Integer)((Map)key2.attachment()).get(Character.valueOf('r'));
                        this.getReadResults().append(this.readArray.eltOk(readIoIndex));
                        if (this.pendingReads != null) {
                            this.pendingReads[readIoIndex] = false;
                        }
                    }
                    if (this.writeArray == null || !SelectBlob.writeConnectReady(interestAndReady)) continue;
                    writeIoIndex = (Integer)((Map)key2.attachment()).get(Character.valueOf('w'));
                    this.getWriteResults().append(this.writeArray.eltOk(writeIoIndex));
                }
                catch (CancelledKeyException cke) {
                    int interest = key2.interestOps();
                    if (this.readArray != null && SelectBlob.cancelReady(interest)) {
                        if (this.pendingReads != null) {
                            this.pendingReads[readIoIndex] = false;
                        }
                        if (this.errorResults != null) {
                            this.errorResults = RubyArray.newArray(runtime, this.readArray.size() + this.writeArray.size());
                        }
                        if (this.fastSearch(this.errorResults.toJavaArrayUnsafe(), this.readIOs[readIoIndex]) == -1) {
                            this.getErrorResults().append(this.readArray.eltOk(readIoIndex));
                        }
                    }
                    if (this.writeArray == null || !SelectBlob.writeReady(interest) || this.fastSearch(this.errorResults.toJavaArrayUnsafe(), this.writeIOs[writeIoIndex]) != -1) continue;
                    this.errorResults.append(this.writeArray.eltOk(writeIoIndex));
                }
            }
        }
    }

    private void processPendingAndUnselectable() {
        int i2;
        if (this.pendingReads != null) {
            for (i2 = 0; i2 < this.pendingReads.length; ++i2) {
                if (!this.pendingReads[i2]) continue;
                this.getReadResults().append(this.readArray.eltOk(i2));
            }
        }
        if (this.unselectableReads != null) {
            for (i2 = 0; i2 < this.unselectableReads.length; ++i2) {
                if (!this.unselectableReads[i2]) continue;
                this.getReadResults().append(this.readArray.eltOk(i2));
            }
        }
        if (this.unselectableWrites != null) {
            for (i2 = 0; i2 < this.unselectableWrites.length; ++i2) {
                if (!this.unselectableWrites[i2]) continue;
                this.getWriteResults().append(this.writeArray.eltOk(i2));
            }
        }
    }

    private void tidyUp() throws IOException {
        for (Selector selector : this.selectors.values()) {
            selector.close();
        }
        for (ENXIOSelector enxioSelector : this.enxioSelectors) {
            enxioSelector.pipe.sink().close();
            enxioSelector.pipe.source().close();
        }
        if (this.readBlocking != null) {
            for (int i2 = 0; i2 < this.readBlocking.length; ++i2) {
                if (this.readBlocking[i2] == null) continue;
                try {
                    ((SelectableChannel)this.readIOs[i2].getChannel()).configureBlocking(this.readBlocking[i2]);
                    continue;
                }
                catch (IllegalBlockingModeException ibme) {
                    throw this.runtime.newConcurrencyError("can not set IO blocking after select; concurrent select detected?");
                }
            }
        }
        if (this.writeBlocking != null) {
            for (int i3 = 0; i3 < this.writeBlocking.length; ++i3) {
                if (this.writeBlocking[i3] == null) continue;
                try {
                    ((SelectableChannel)this.writeIOs[i3].getChannel()).configureBlocking(this.writeBlocking[i3]);
                    continue;
                }
                catch (IllegalBlockingModeException ibme) {
                    throw this.runtime.newConcurrencyError("can not set IO blocking after select; concurrent select detected?");
                }
            }
        }
    }

    private RubyArray getReadResults() {
        if (this.readResults == null) {
            this.readResults = RubyArray.newArray(this.runtime, this.readArray.size());
        }
        return this.readResults;
    }

    private RubyArray getWriteResults() {
        if (this.writeResults == null) {
            this.writeResults = RubyArray.newArray(this.runtime, this.writeArray.size());
        }
        return this.writeResults;
    }

    private RubyArray getErrorResults() {
        if (this.errorResults != null) {
            this.errorResults = RubyArray.newArray(this.runtime, this.readArray.size() + this.writeArray.size());
        }
        return this.errorResults;
    }

    private Selector getSelector(ThreadContext context, SelectableChannel channel) throws IOException {
        Selector selector = this.selectors.get(channel.provider());
        if (selector == null) {
            selector = SelectorFactory.openWithRetryFrom(context.runtime, channel.provider());
            if (this.selectors.isEmpty()) {
                this.selectors = new HashMap<SelectorProvider, Selector>();
            }
            this.selectors.put(channel.provider(), selector);
            if (!selector.provider().equals(SelectorProvider.provider())) {
                Pipe pipe2 = Pipe.open();
                ENXIOSelector enxioSelector = new ENXIOSelector(selector, pipe2);
                if (this.enxioSelectors.isEmpty()) {
                    this.enxioSelectors = new ArrayList<ENXIOSelector>();
                }
                this.enxioSelectors.add(enxioSelector);
                pipe2.source().configureBlocking(false);
                pipe2.source().register(this.getSelector(context, pipe2.source()), 1, enxioSelector);
            } else if (this.mainSelector == null) {
                this.mainSelector = selector;
            }
        }
        return selector;
    }

    private Boolean[] getReadBlocking() {
        if (this.readBlocking == null) {
            this.readBlocking = new Boolean[this.readSize];
        }
        return this.readBlocking;
    }

    private Boolean[] getWriteBlocking() {
        if (this.writeBlocking == null) {
            this.writeBlocking = new Boolean[this.writeSize];
        }
        return this.writeBlocking;
    }

    private boolean[] getUnselectableReads() {
        if (this.unselectableReads == null) {
            this.unselectableReads = new boolean[this.readSize];
        }
        return this.unselectableReads;
    }

    private boolean[] getUnselectableWrites() {
        if (this.unselectableWrites == null) {
            this.unselectableWrites = new boolean[this.writeSize];
        }
        return this.unselectableWrites;
    }

    private boolean[] getPendingReads() {
        if (this.pendingReads == null) {
            this.pendingReads = new boolean[this.readSize];
        }
        return this.pendingReads;
    }

    private IRubyObject constructResults(Ruby runtime) {
        return RubyArray.newArrayLight(runtime, this.readResults == null ? RubyArray.newEmptyArray(runtime) : this.readResults, this.writeResults == null ? RubyArray.newEmptyArray(runtime) : this.writeResults, this.errorResults == null ? RubyArray.newEmptyArray(runtime) : this.errorResults);
    }

    private int fastSearch(Object[] ary, Object obj) {
        for (int i2 = 0; i2 < ary.length; ++i2) {
            if (ary[i2] != obj) continue;
            return i2;
        }
        return -1;
    }

    private static void checkArrayType(Ruby runtime, IRubyObject obj) {
        if (!(obj instanceof RubyArray)) {
            throw runtime.newTypeError("wrong argument type " + obj.getMetaClass().getName() + " (expected Array)");
        }
    }

    private static boolean registerSelect(ThreadContext context, Selector selector, Map<Character, Integer> obj, RubyIO ioObj, int ops) throws IOException {
        Channel channel = ioObj.getChannel();
        if (channel == null || !(channel instanceof SelectableChannel)) {
            return false;
        }
        ((SelectableChannel)channel).configureBlocking(false);
        int real_ops = ((SelectableChannel)channel).validOps() & ops;
        SelectionKey key2 = ((SelectableChannel)channel).keyFor(selector);
        if (key2 == null) {
            HashMap<Character, Integer> attachment = new HashMap<Character, Integer>(1);
            attachment.putAll(obj);
            ((SelectableChannel)channel).register(selector, real_ops, attachment);
        } else {
            key2.interestOps(key2.interestOps() | real_ops);
            Map att = (Map)key2.attachment();
            att.putAll(obj);
            key2.attach(att);
        }
        return true;
    }

    private static final class ENXIOSelector
    implements Callable<Object> {
        private final Selector selector;
        private final Pipe pipe;

        private ENXIOSelector(Selector selector, Pipe pipe2) {
            this.selector = selector;
            this.pipe = pipe2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object call() throws Exception {
            try {
                this.selector.select();
            }
            finally {
                ByteBuffer buf = ByteBuffer.allocate(1);
                buf.put((byte)0);
                buf.flip();
                this.pipe.sink().write(buf);
            }
            return null;
        }
    }
}

