/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime;

import org.jruby.EvalType;
import org.jruby.RubyInstanceConfig;
import org.jruby.RubyModule;
import org.jruby.compiler.Compilable;
import org.jruby.ir.IRClosure;
import org.jruby.ir.IRScope;
import org.jruby.ir.interpreter.Interpreter;
import org.jruby.ir.interpreter.InterpreterContext;
import org.jruby.ir.runtime.IRRuntimeHelpers;
import org.jruby.runtime.ArgumentDescriptor;
import org.jruby.runtime.Binding;
import org.jruby.runtime.Block;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.Frame;
import org.jruby.runtime.IRBlockBody;
import org.jruby.runtime.Signature;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.cli.Options;
import org.jruby.util.log.Logger;
import org.jruby.util.log.LoggerFactory;

public class InterpretedIRBlockBody
extends IRBlockBody
implements Compilable<InterpreterContext> {
    private static final Logger LOG = LoggerFactory.getLogger("InterpretedIRBlockBody");
    protected boolean pushScope = true;
    protected boolean reuseParentScope = false;
    private boolean displayedCFG = false;
    private int callCount = 0;
    private InterpreterContext interpreterContext;

    public InterpretedIRBlockBody(IRClosure closure, Signature signature) {
        super(closure, signature);
        if (closure.getManager().getInstanceConfig().getCompileMode() != RubyInstanceConfig.CompileMode.OFF) {
            this.callCount = -1;
        }
    }

    @Override
    public void setCallCount(int callCount) {
        this.callCount = callCount;
    }

    @Override
    public void completeBuild(InterpreterContext interpreterContext) {
        this.interpreterContext = interpreterContext;
    }

    @Override
    public IRScope getIRScope() {
        return this.closure;
    }

    @Override
    public ArgumentDescriptor[] getArgumentDescriptors() {
        return this.closure.getArgumentDescriptors();
    }

    @Override
    public InterpreterContext ensureInstrsReady() {
        if (IRRuntimeHelpers.isDebug() && !this.displayedCFG) {
            LOG.info("Executing '" + this.closure + "' (pushScope=" + this.pushScope + ", reuseParentScope=" + this.reuseParentScope, new Object[0]);
            LOG.info(this.closure.debugOutput(), new Object[0]);
            this.displayedCFG = true;
        }
        if (this.interpreterContext == null) {
            this.interpreterContext = this.closure.getInterpreterContext();
        }
        return this.interpreterContext;
    }

    @Override
    public String getClassName(ThreadContext context) {
        return null;
    }

    @Override
    public String getName() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected IRubyObject commonYieldPath(ThreadContext context, IRubyObject[] args2, IRubyObject self2, Binding binding2, Block.Type type2, Block block) {
        if (this.callCount >= 0) {
            this.promoteToFullBuild(context);
        }
        Visibility oldVis = binding2.getFrame().getVisibility();
        Frame prevFrame = context.preYieldNoScope(binding2);
        if (self2 == null || this.evalType.get() == EvalType.BINDING_EVAL) {
            self2 = this.useBindingSelf(binding2);
        }
        InterpreterContext ic = this.ensureInstrsReady();
        DynamicScope actualScope = binding2.getDynamicScope();
        if (ic.pushNewDynScope()) {
            actualScope = DynamicScope.newDynamicScope(this.getStaticScope(), actualScope, (EvalType)((Object)this.evalType.get()));
            if (type2 == Block.Type.LAMBDA) {
                actualScope.setLambda(true);
            }
            context.pushScope(actualScope);
        } else if (ic.reuseParentDynScope()) {
            context.pushScope(actualScope);
        }
        this.evalType.set(EvalType.NONE);
        try {
            IRubyObject iRubyObject = Interpreter.INTERPRET_BLOCK(context, self2, ic, args2, binding2.getMethod(), block, type2);
            return iRubyObject;
        }
        finally {
            binding2.getFrame().setVisibility(oldVis);
            if (ic.popDynScope()) {
                context.postYield(binding2, prevFrame);
            } else {
                context.postYieldNoScope(prevFrame);
            }
        }
    }

    protected void promoteToFullBuild(ThreadContext context) {
        if (context.runtime.isBooting()) {
            return;
        }
        if (this.callCount++ >= Options.JIT_THRESHOLD.load()) {
            context.runtime.getJITCompiler().buildThresholdReached(context, this);
        }
    }

    @Override
    public RubyModule getImplementationClass() {
        return null;
    }
}

