/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime.backtrace;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Map;
import java.util.regex.Pattern;
import org.jruby.Ruby;
import org.jruby.runtime.backtrace.BacktraceElement;
import org.jruby.runtime.backtrace.FrameType;
import org.jruby.runtime.backtrace.RubyStackTraceElement;
import org.jruby.util.JavaNameMangler;

public class BacktraceData
implements Serializable {
    private RubyStackTraceElement[] backtraceElements;
    private final StackTraceElement[] javaTrace;
    private final BacktraceElement[] rubyTrace;
    private final boolean fullTrace;
    private final boolean maskNative;
    private final boolean includeNonFiltered;
    private final Pattern FILTER_CLASSES = Pattern.compile("^(org\\.jruby)|(sun\\.reflect)");
    public static final BacktraceData EMPTY = new BacktraceData(new StackTraceElement[0], new BacktraceElement[0], false, false, false);

    public BacktraceData(StackTraceElement[] javaTrace, BacktraceElement[] rubyTrace, boolean fullTrace, boolean maskNative, boolean includeNonFiltered) {
        this.javaTrace = javaTrace;
        this.rubyTrace = rubyTrace;
        this.fullTrace = fullTrace;
        this.includeNonFiltered = includeNonFiltered;
        this.maskNative = maskNative;
    }

    public RubyStackTraceElement[] getBacktrace(Ruby runtime) {
        if (this.backtraceElements == null) {
            this.backtraceElements = this.constructBacktrace(runtime.getBoundMethods());
        }
        return this.backtraceElements;
    }

    private RubyStackTraceElement[] constructBacktrace(Map<String, Map<String, String>> boundMethods) {
        ArrayList<RubyStackTraceElement> trace = new ArrayList<RubyStackTraceElement>(this.javaTrace.length);
        boolean dupFrame = false;
        String dupFrameName = null;
        int rubyFrameIndex = this.rubyTrace == null ? -1 : this.rubyTrace.length - 1;
        for (int i2 = 0; i2 < this.javaTrace.length; ++i2) {
            String decodedName;
            StackTraceElement element = this.javaTrace[i2];
            int line = element.getLineNumber();
            if (line == -1) continue;
            String className = element.getClassName();
            String methodName = element.getMethodName();
            String filename2 = element.getFileName();
            if (filename2 != null && !filename2.endsWith(".java") && (decodedName = JavaNameMangler.decodeMethodForBacktrace(methodName)) != null) {
                RubyStackTraceElement rubyElement = new RubyStackTraceElement(className, decodedName, filename2, line, false);
                if (this.maskNative && dupFrame) {
                    dupFrame = false;
                    trace.add(new RubyStackTraceElement(className, dupFrameName, filename2, line, false));
                }
                trace.add(rubyElement);
                continue;
            }
            String rubyName = null;
            if (this.fullTrace || (rubyName = BacktraceData.getBoundMethodName(boundMethods, className, methodName)) != null) {
                if (rubyName == null) {
                    rubyName = methodName;
                }
                filename2 = BacktraceData.packagedFilenameFromElement(filename2, className);
                if (this.maskNative) {
                    dupFrame = true;
                    dupFrameName = rubyName;
                    continue;
                }
                trace.add(new RubyStackTraceElement(className, rubyName, filename2, line, false));
                if (!this.fullTrace) continue;
            }
            if (rubyFrameIndex >= 0 && FrameType.INTERPRETED_CLASSES.contains(className) && FrameType.INTERPRETED_FRAMES.containsKey(methodName)) {
                BacktraceElement rubyFrame = this.rubyTrace[rubyFrameIndex--];
                FrameType frameType = FrameType.INTERPRETED_FRAMES.get(methodName);
                String newName = rubyFrame.method;
                switch (frameType) {
                    case METHOD: {
                        newName = rubyFrame.method;
                        break;
                    }
                    case BLOCK: {
                        newName = "block in " + rubyFrame.method;
                        break;
                    }
                    case CLASS: {
                        newName = "<class:" + rubyFrame.method + ">";
                        break;
                    }
                    case MODULE: {
                        newName = "<module:" + rubyFrame.method + ">";
                        break;
                    }
                    case METACLASS: {
                        newName = "singleton class";
                        break;
                    }
                    case ROOT: {
                        newName = "<top>";
                        break;
                    }
                    case EVAL: {
                        newName = "<eval>";
                    }
                }
                RubyStackTraceElement rubyElement = new RubyStackTraceElement("RUBY", newName, rubyFrame.filename, rubyFrame.line + 1, false);
                if (this.maskNative && dupFrame) {
                    dupFrame = false;
                    trace.add(new RubyStackTraceElement(rubyElement.getClassName(), dupFrameName, rubyElement.getFileName(), rubyElement.getLineNumber(), rubyElement.isBinding()));
                }
                trace.add(rubyElement);
                continue;
            }
            if (!this.includeNonFiltered || this.isFilteredClass(className)) continue;
            trace.add(new RubyStackTraceElement(className, methodName, BacktraceData.packagedFilenameFromElement(filename2, className), line, false));
        }
        RubyStackTraceElement[] rubyStackTrace = new RubyStackTraceElement[trace.size()];
        return trace.toArray(rubyStackTrace);
    }

    public static String getBoundMethodName(Map<String, Map<String, String>> boundMethods, String className, String methodName) {
        Map<String, String> javaToRuby = boundMethods.get(className);
        if (javaToRuby == null) {
            return null;
        }
        return javaToRuby.get(methodName);
    }

    private static String packagedFilenameFromElement(String filename2, String className) {
        if (filename2 == null) {
            filename2 = className.replaceAll("\\.", "/");
        } else {
            int lastDot = className.lastIndexOf(46);
            if (lastDot != -1) {
                filename2 = className.substring(0, lastDot + 1).replaceAll("\\.", "/") + filename2;
            }
        }
        return filename2;
    }

    private boolean isFilteredClass(String className) {
        return this.FILTER_CLASSES.matcher(className).find();
    }
}

